/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.util;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.ContainerViewBO;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.so.SDCInstanceSO;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.ua.AgentConnectionException;
import com.sybase.util.ds.uaf.SyUAFEntry;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

class ClusterNode {
    private String _node;
    private ICluster _cluster;
    private ServerBO _serverBO;
    private List<IServer> _instances;
    private List<Integer> _ports;
    private Integer _maxServerPort;
    private SDCClusterAgentProxy _agentProxy;
    private boolean _initialized;

    public ClusterNode(String string, ICluster iCluster, ServerBO serverBO) {
        this._node = string;
        this._cluster = iCluster;
        this._serverBO = serverBO;
        this._maxServerPort = new Integer(4999);
        this._instances = new ArrayList<IServer>();
        this._ports = new ArrayList<Integer>();
    }

    private void init() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        if (this._agentProxy != null) {
            try {
                Integer[] integerArray;
                for (Integer n : integerArray = this._agentProxy.getPortsInUse()) {
                    this.addPort(n);
                }
            }
            catch (AgentConnectionException agentConnectionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addInstance(IServer iServer) {
        void var3_6;
        String string2;
        String[] stringArray;
        if (this._instances.contains(iServer)) {
            return;
        }
        this._instances.add(iServer);
        if (this._agentProxy == null && (stringArray = (String[])ContainerViewBO.getSDCInstanceBO(this._serverBO, iServer.getName()).getSO()).isUAFMonitored()) {
            this._agentProxy = new SDCClusterAgentProxy(stringArray.getAgentConnection(), (SyUAFEntry)stringArray.getUAFInfo());
        }
        for (String string2 : stringArray = new String[]{iServer.getQueryPort(), iServer.getBackupServerPort(), iServer.getMonitorServerPort(), iServer.getXpServerPort()}) {
            if (ASEUtils.isNullOrEmpty(string2)) continue;
            this.addServerPort(Integer.parseInt(string2));
        }
        Object var3_4 = null;
        String string3 = null;
        if (!ASEUtils.isNullOrEmpty(this._cluster.getPrimaryInterconnect())) {
            String string4 = iServer.getPrimaryPortStart();
            string3 = iServer.getPrimaryProtocolEnd(this._cluster.getMaxInstances());
        }
        String string5 = null;
        string2 = null;
        if (!ASEUtils.isNullOrEmpty(this._cluster.getSecondaryInterconnect())) {
            string5 = iServer.getSecondaryPortStart();
            string2 = iServer.getSecondaryProtocolEnd(this._cluster.getMaxInstances());
        }
        String[][] stringArray2 = new String[2][2];
        stringArray2[0] = new String[]{var3_6, string3};
        stringArray2[1] = new String[]{string5, string2};
        for (String[] stringArray3 : stringArray2) {
            if (ASEUtils.isNullOrEmpty(stringArray3[0])) continue;
            Integer n = Integer.parseInt(stringArray3[0]);
            Integer n2 = !ASEUtils.isNullOrEmpty(stringArray3[1]) ? Integer.valueOf(Integer.parseInt(stringArray3[1])) : Integer.valueOf(65535);
            Integer n3 = n;
            while (n3 <= n2) {
                this.addPort(n3);
                Integer n4 = n3;
                Integer n5 = n3 = Integer.valueOf(n3 + 1);
            }
        }
    }

    public Integer[] discoveryUnusedTCPPorts(int n, boolean bl) throws AgentConnectionException, RemoteException {
        if (bl) {
            this.init();
        }
        Integer[] integerArray = Integer.valueOf(this._maxServerPort + 1);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = integerArray;
        while ((Integer)object < 65535 && arrayList.size() < n) {
            if (!this.portInUse((Integer)object)) {
                if (this._agentProxy == null || !bl) {
                    arrayList.add(object);
                } else if (!this._agentProxy.doesHostPortExistInInterface(this._cluster, this._node, (Integer)object)) {
                    arrayList.add(object);
                }
            }
            Integer[] integerArray2 = object;
            object = (Integer)object + 1;
            Integer n2 = object;
        }
        object = new Integer[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private void addServerPort(Integer n) {
        if (!this._ports.contains(n)) {
            this.addPort(n);
        }
    }

    private boolean portInUse(Integer n) {
        return this._ports.contains(n);
    }

    private void addPort(Integer n) {
        if (!this._ports.contains(n)) {
            this._ports.add(n);
        }
    }

    public String getNode() {
        return this._node;
    }

    public IServer[] getInstances() {
        IServer[] iServerArray = new IServer[this._instances.size()];
        this._instances.toArray(iServerArray);
        return iServerArray;
    }

    public SDCInstanceSO getSDCInstanceSO(IServer iServer) {
        return (SDCInstanceSO)ContainerViewBO.getSDCInstanceBO(this._serverBO, iServer.getName()).getSO();
    }

    public List<Integer> getPorts() {
        return this._ports;
    }
}

