/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.util;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.bo.wiz.SDCClusterWizard;
import com.sybase.aseplugin.so.SDCClusterSO;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.aseplugin.util.SDCClusterAgentUtils;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.JMXException;
import java.util.Map;
import javax.swing.JDialog;

public class DeviceValidator {
    public static final int RC_FILE_DEVICE_IS_OK = -1;
    public static final int RC_OK_IS_FILE_DEVICE = 0;
    public static final int RC_OK_IS_RAW_DEVICE = 1;
    public static final int RC_OK_IS_DEVICE_READABLE = 2;
    public static final int RC_OK_IS_DEVICE_WRITABLE = 3;
    public static final int RC_OK_IS_DIRECTORY = 4;
    public static final int RC_ERR_RAW_DEVICE_NOT_READABLE = 100;
    public static final int RC_ERR_RAW_DEVICE_NOT_WRITABLE = 101;
    public static final int RC_ERR_DEVICE_NOT_READABLE = 102;
    public static final int RC_ERR_DEVICE_NOT_WRITABLE = 103;
    public static final int RC_ERR_DEVICE_NOT_EXIST = 104;
    public static final int RC_ERR_DEVICE_FILE_ALREADY_EXISTS = 200;
    public static final int RC_ERR_IS_DIRECTORY = 201;
    public static final int RC_ERR_PARENT_DIR_NOT_EXIST = 202;
    public static final int RC_ERR_PARENT_DIRECTORY_NOT_WRITABLE = 203;
    public static final int RC_ERR_INVALID_ABSOLUTE_PATH = 204;
    public static final int RC_ERR_DIRECTORY_NOT_EXIST = 205;
    public static final int RC_ERR_IS_NOT_DIRECTORY = 206;
    public static final int RC_ERR_DIRECTORY_NOT_READABLE = 207;
    public static final int RC_ERR_DIRECTORY_NOT_WRITABLE = 208;
    public static final int RC_ERR_PARENT_DIRECTORY_NOT_READABLE = 209;
    public static final int RC_ERR_IS_NOT_FILE = 210;

    public static boolean mkdirs(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws AgentConnectionException {
        Boolean bl = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "mkdirs", new Object[]{string}, new String[]{"java.lang.String"});
        return bl;
    }

    public static int validateFileReadable(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws AgentConnectionException {
        if (!DeviceValidator.isAbsolutePath(sDCClusterAgentProxy, string)) {
            return 204;
        }
        boolean bl = sDCClusterAgentProxy.fileExists(string);
        if (!bl) {
            return 104;
        }
        if (!DeviceValidator.isFile(sDCClusterAgentProxy, string)) {
            return 210;
        }
        if (!DeviceValidator.isReadable(sDCClusterAgentProxy, string)) {
            return 102;
        }
        return 2;
    }

    public static boolean isFile(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws AgentConnectionException {
        Boolean bl = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "isFile", new Object[]{string}, new String[]{"java.lang.String"});
        return bl;
    }

    public static boolean isReadable(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws AgentConnectionException {
        Boolean bl = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canRead", new Object[]{string}, new String[]{"java.lang.String"});
        return bl;
    }

    public static int validateDirectoryPath(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws AgentConnectionException {
        if (!DeviceValidator.isAbsolutePath(sDCClusterAgentProxy, string)) {
            return 204;
        }
        boolean bl = sDCClusterAgentProxy.fileExists(string);
        if (bl) {
            Boolean bl2 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "isDirectory", new Object[]{string}, new String[]{"java.lang.String"});
            if (bl2.booleanValue()) {
                Boolean bl3 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canRead", new Object[]{string}, new String[]{"java.lang.String"});
                if (!bl3.booleanValue()) {
                    return 207;
                }
                Boolean bl4 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canWrite", new Object[]{string}, new String[]{"java.lang.String"});
                if (!bl4.booleanValue()) {
                    return 208;
                }
                return 4;
            }
            return 206;
        }
        return 205;
    }

    public static int validateDevicePath(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws AgentConnectionException {
        if (!DeviceValidator.isAbsolutePath(sDCClusterAgentProxy, string)) {
            return 204;
        }
        boolean bl = sDCClusterAgentProxy.fileExists(string);
        if (bl) {
            Boolean bl2 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "isFile", new Object[]{string}, new String[]{"java.lang.String"});
            if (bl2.booleanValue()) {
                return 200;
            }
            Boolean bl3 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "isDirectory", new Object[]{string}, new String[]{"java.lang.String"});
            if (bl3.booleanValue()) {
                return 201;
            }
            Boolean bl4 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canRead", new Object[]{string}, new String[]{"java.lang.String"});
            if (!bl4.booleanValue()) {
                return 100;
            }
            Boolean bl5 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canWrite", new Object[]{string}, new String[]{"java.lang.String"});
            if (!bl5.booleanValue()) {
                return 101;
            }
            return 1;
        }
        String string2 = (String)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "getParent", new Object[]{string}, new String[]{"java.lang.String"});
        if (string2 == null) {
            return 202;
        }
        boolean bl6 = sDCClusterAgentProxy.fileExists(string2);
        if (bl6) {
            Boolean bl7 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canWrite", new Object[]{string2}, new String[]{"java.lang.String"});
            if (!bl7.booleanValue()) {
                return 203;
            }
            Boolean bl8 = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canRead", new Object[]{string2}, new String[]{"java.lang.String"});
            if (!bl8.booleanValue()) {
                return 209;
            }
            return 0;
        }
        return 202;
    }

    public static boolean validateDevicePathOnAllNodes(String string, SDCClusterSO sDCClusterSO, Class clazz, JDialog jDialog) {
        for (Map.Entry entry : sDCClusterSO.getParticipatingAgents().entrySet()) {
            SDCClusterAgentProxy sDCClusterAgentProxy = (SDCClusterAgentProxy)entry.getValue();
            try {
                if (!DeviceValidator.isAbsolutePath(sDCClusterAgentProxy, string)) {
                    String string2 = SDCClusterAgentUtils.getNodeAddress(sDCClusterAgentProxy.getHost(), sDCClusterAgentProxy.getPort());
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_INVALID_ABSOLUTE_PATH"), string, string2);
                    Support.showError(null, clazz, jDialog, aSEMessageText.toString());
                    return false;
                }
                int n = DeviceValidator.validateDevicePath(sDCClusterAgentProxy, string);
                if (n == 0 || n == 1) continue;
                if (n == 202) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_PARENT_DIRECTORY_NOT_EXIST"), string, sDCClusterAgentProxy.getNodeName());
                    Support.showError(null, clazz, jDialog, aSEMessageText.toString());
                    return false;
                }
                if (n == 203) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_PARENT_DIRECTORY_NOT_WRITABLE"), string, sDCClusterAgentProxy.getNodeName());
                    Support.showError(null, clazz, jDialog, aSEMessageText.toString());
                    return false;
                }
                if (n == 200) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_ALREADY_EXISTS"), string, sDCClusterAgentProxy.getNodeName());
                    Support.showError(null, clazz, jDialog, aSEMessageText.toString());
                    return false;
                }
                if (n == 201) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_DEVICE_PATH_IS_DIRECTORY"), string, sDCClusterAgentProxy.getNodeName());
                    Support.showError(null, clazz, jDialog, aSEMessageText.toString());
                    return false;
                }
                if (n == 100) {
                    ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_RAW_DEVICE_NOT_READABLE"), string, sDCClusterAgentProxy.getNodeName());
                    Support.showError(null, clazz, jDialog, aSEMessageText.toString());
                    return false;
                }
                if (n != 101) continue;
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("ERROR_RAW_DEVICE_NOT_WRITABLE"), string, sDCClusterAgentProxy.getNodeName());
                Support.showError(null, clazz, jDialog, aSEMessageText.toString());
                return false;
            }
            catch (JMXException jMXException) {
                SDCClusterWizard.handleJMXException(jMXException, sDCClusterAgentProxy, clazz, jDialog);
                return false;
            }
            catch (Exception exception) {
                ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_TO_CHECK_PORTS"), exception.getMessage(), sDCClusterAgentProxy.getNodeName());
                Support.showError(null, clazz, jDialog, aSEMessageText.toString());
                return false;
            }
        }
        return true;
    }

    public static int isDevicePathReadable(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws AgentConnectionException {
        if (!sDCClusterAgentProxy.fileExists(string)) {
            return 104;
        }
        Boolean bl = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canRead", new Object[]{string}, new String[]{"java.lang.String"});
        if (bl.booleanValue()) {
            return 2;
        }
        return 102;
    }

    public static int isDevicePathWritable(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws AgentConnectionException {
        if (!sDCClusterAgentProxy.fileExists(string)) {
            return 104;
        }
        Boolean bl = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "canWrite", new Object[]{string}, new String[]{"java.lang.String"});
        if (bl.booleanValue()) {
            return 3;
        }
        return 103;
    }

    public static String getAbsolutePath(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws AgentConnectionException {
        if (sDCClusterAgentProxy == null || string == null || string.length() == 0) {
            return "";
        }
        return (String)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "getAbsolutePath", new Object[]{string}, new String[]{"java.lang.String"});
    }

    public static boolean isAbsolutePath(SDCClusterAgentProxy sDCClusterAgentProxy, String string) throws AgentConnectionException {
        if (sDCClusterAgentProxy == null || string == null || string.length() == 0) {
            return false;
        }
        Boolean bl = (Boolean)sDCClusterAgentProxy.invokeServiceMethod("FileTransferService", "isAbsolute", new Object[]{string}, new String[]{"java.lang.String"});
        return bl;
    }
}

