/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.util;

import com.sybase.aseplugin.util.BundleManager;
import java.sql.SQLException;
import java.text.MessageFormat;

public class JSMessageText
extends MessageFormat {
    public static final int DB_BASE_ERR = 11;
    private Object[] _arguments;
    private String _formatPattern;

    public static String getString(String string) {
        return BundleManager.instance().getString(string);
    }

    public JSMessageText(String string) {
        super(string);
        this._formatPattern = string;
        this._arguments = null;
    }

    public JSMessageText(String string, Object object) {
        super(string);
        this._formatPattern = string;
        Object[] objectArray = new Object[]{object};
        this.setArguments(objectArray);
    }

    public JSMessageText(String string, Object object, Object object2) {
        super(string);
        this._formatPattern = string;
        Object[] objectArray = new Object[]{object, object2};
        this.setArguments(objectArray);
    }

    public JSMessageText(String string, Object object, Object object2, Object object3) {
        super(string);
        this._formatPattern = string;
        Object[] objectArray = new Object[]{object, object2, object3};
        this.setArguments(objectArray);
    }

    public static String addSingleQuotes(String string) {
        return JSMessageText._quote(string, '\'', true, true);
    }

    public static String removeSingleQuotes(String string) {
        return JSMessageText._unquote(string, '\'', true, true);
    }

    private static String _quote(String string, char c, boolean bl, boolean bl2) {
        if (!(bl || string != null && string.indexOf(c) != -1)) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n * 2 + 2];
        int n2 = 0;
        if (bl) {
            cArray[n2++] = c;
        }
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            cArray[n2++] = c2;
            if (!bl2 || c2 != c) continue;
            cArray[n2++] = c;
        }
        if (bl) {
            cArray[n2++] = c;
        }
        return new String(cArray, 0, n2);
    }

    private static String _unquote(String string, char c, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (string == null || (n5 = string.length()) <= 1 || (n4 = string.indexOf(c)) == -1) {
            return string;
        }
        if (bl && n4 == 0 && (n3 = string.lastIndexOf(c)) == n5 - 1) {
            n2 = 1;
            n = n5 - 1;
        } else {
            n2 = 0;
            n = n5;
        }
        char[] cArray = new char[n - n2];
        int n6 = 0;
        for (int i = n2; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl2 && c2 == c && i < n - 1 && string.charAt(i + 1) == c) {
                cArray[n6++] = c;
                ++i;
                continue;
            }
            cArray[n6++] = c2;
        }
        return new String(cArray, 0, n6);
    }

    @Override
    public void applyPattern(String string) {
        this._formatPattern = string;
        super.applyPattern(string);
    }

    private void setArguments(Object[] objectArray) {
        this._arguments = objectArray;
    }

    public String toString() {
        if (this._arguments == null) {
            return this._formatPattern;
        }
        this.applyPattern(this._formatPattern.replaceAll("'", "''"));
        return this.format(this._arguments);
    }

    public static String toString(Throwable throwable) {
        return JSMessageText.toString(throwable, false);
    }

    public static String toString(Throwable throwable, boolean bl) {
        String string = "";
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            string = throwable2 instanceof SQLException ? string + JSMessageText.getSQLExceptionMessage((SQLException)throwable2, bl) : string + throwable2.getMessage() + '\n';
        }
        return string;
    }

    public static String getSQLExceptionMessage(SQLException sQLException) {
        return JSMessageText.getSQLExceptionMessage(sQLException, false);
    }

    public static String getSQLExceptionMessage(SQLException sQLException, boolean bl) {
        String string = "";
        String string2 = "";
        while (sQLException != null) {
            if (sQLException.getSQLState() == null || !bl) {
                string = string + string2 + sQLException.getMessage();
            }
            if ((sQLException = sQLException.getNextException()) == null || string.endsWith("\n")) continue;
            string2 = "\n";
        }
        return string;
    }
}

