/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.util;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.aseplugin.bo.ServerBO;
import com.sybase.aseplugin.util.ClusterNode;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.ua.AgentConnectionException;
import java.rmi.RemoteException;
import java.util.Hashtable;

public class PortsDiscoveryUtil {
    private ICluster _cluster;
    private Hashtable<String, ClusterNode> _nodeTable;
    private IServer[] _instances;
    private ServerBO _serverBO;

    public PortsDiscoveryUtil(ICluster iCluster, ServerBO serverBO) {
        this._cluster = iCluster;
        this._instances = this._cluster.getServersArray();
        this._serverBO = serverBO;
        this._nodeTable = new Hashtable();
        this.initModel();
    }

    private void initModel() {
        for (IServer iServer : this._instances) {
            this.addInstance(iServer);
        }
    }

    public void addInstance(IServer iServer) {
        ClusterNode clusterNode = this._nodeTable.get(iServer.getNode());
        if (clusterNode == null) {
            clusterNode = new ClusterNode(iServer.getNode(), this.getCluster(), this.getServerBO());
            this._nodeTable.put(iServer.getNode(), clusterNode);
        }
        clusterNode.addInstance(iServer);
    }

    public Hashtable<String, Integer[]> discoverPortsEachNode(int n) throws AgentConnectionException, RemoteException {
        return this.discoverPortsEachNode(n, true);
    }

    public Hashtable<String, Integer[]> discoverPortsEachNode(int n, boolean bl) throws AgentConnectionException, RemoteException {
        Hashtable<String, Integer[]> hashtable = new Hashtable<String, Integer[]>();
        for (ClusterNode clusterNode : this.getNodes()) {
            hashtable.put(clusterNode.getNode(), clusterNode.discoveryUnusedTCPPorts(n, bl));
        }
        return hashtable;
    }

    public Hashtable<String, Integer[]> discoverPortsForEachInstance(int n) throws AgentConnectionException, RemoteException {
        return this.discoverPortsForEachInstance(n, true);
    }

    public Hashtable<String, Integer[]> discoverPortsForEachInstance(int n, boolean bl) throws AgentConnectionException, RemoteException {
        Hashtable<String, Integer[]> hashtable = new Hashtable<String, Integer[]>();
        for (ClusterNode clusterNode : this.getNodes()) {
            IServer[] iServerArray = clusterNode.getInstances();
            Integer[] integerArray = clusterNode.discoveryUnusedTCPPorts(n * iServerArray.length, bl);
            if (integerArray == null || integerArray.length == 0) continue;
            int n2 = 0;
            for (IServer iServer : iServerArray) {
                Integer[] integerArray2 = new Integer[n];
                for (int i = 0; i < n; ++i) {
                    integerArray2[i] = integerArray[n2 * n + i];
                }
                hashtable.put(iServer.getName(), integerArray2);
                ++n2;
            }
        }
        return hashtable;
    }

    public Integer[] discoverPortsForInstance(IServer iServer, int n) throws AgentConnectionException, RemoteException {
        return this.discoverPortsForInstance(iServer, n, true);
    }

    public Hashtable<IServer, Integer[]> discoverPortsForInstance(IServer[] iServerArray, int n, boolean bl) throws AgentConnectionException, RemoteException {
        Hashtable<IServer, Integer[]> hashtable = new Hashtable<IServer, Integer[]>();
        for (IServer iServer : iServerArray) {
            for (ClusterNode clusterNode : this.getNodes()) {
                if (!clusterNode.getNode().equals(iServer.getNode())) continue;
                hashtable.put(iServer, clusterNode.discoveryUnusedTCPPorts(n, bl));
            }
        }
        return hashtable;
    }

    public Integer[] discoverPortsForInstance(IServer iServer, int n, boolean bl) throws AgentConnectionException, RemoteException {
        for (ClusterNode clusterNode : this.getNodes()) {
            if (!clusterNode.getNode().equals(iServer.getNode())) continue;
            return clusterNode.discoveryUnusedTCPPorts(n, bl);
        }
        return null;
    }

    public Hashtable<String, Integer[]> discoverPortsForEachAgent(Hashtable<String, SDCClusterAgentProxy> hashtable, int n, boolean bl) throws AgentConnectionException, RemoteException {
        Hashtable<String, Integer[]> hashtable2 = new Hashtable<String, Integer[]>();
        block0: for (SDCClusterAgentProxy sDCClusterAgentProxy : hashtable.values()) {
            if (this._nodeTable.containsKey(sDCClusterAgentProxy.getHost())) {
                for (ClusterNode clusterNode : this.getNodes()) {
                    if (!clusterNode.getNode().equals(sDCClusterAgentProxy.getHost())) continue;
                    hashtable2.put(clusterNode.getNode(), clusterNode.discoveryUnusedTCPPorts(n, bl));
                    continue block0;
                }
                continue;
            }
            hashtable2.put(sDCClusterAgentProxy.getHost(), sDCClusterAgentProxy.discoverUnusedTCPPorts(this._cluster, 5000, n, bl));
        }
        return hashtable2;
    }

    public IServer[] getInstances() {
        return this._instances;
    }

    public ICluster getCluster() {
        return this._cluster;
    }

    public ClusterNode[] getNodes() {
        ClusterNode[] clusterNodeArray = new ClusterNode[this._nodeTable.size()];
        this._nodeTable.values().toArray(clusterNodeArray);
        return clusterNodeArray;
    }

    public ServerBO getServerBO() {
        return this._serverBO;
    }
}

