/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.util;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.SDCClusterAgentUtils;
import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AgentConnectionFactory;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.AgentURL;
import com.sybase.ua.AuthenticationException;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.InvalidAgentURLException;
import com.sybase.ua.JMXException;
import com.sybase.ua.LoginModuleNotFoundException;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.ServiceInfo;
import com.sybase.ua.migration.MalformatVersionException;
import com.sybase.ua.migration.Version;
import com.sybase.ua.security.crypto.SecureObject;
import com.sybase.ua.service.AgentServiceException;
import com.sybase.ua.util.MessageListener;
import com.sybase.util.ds.uaf.SyUAF;
import com.sybase.util.ds.uaf.SyUAFEntry;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SDCClusterAgentProxy {
    public static final String ASE_CLUSTER_AGENT_PLUGIN_ID = "com.sybase.ase.cluster";
    public static final String ASE_CLUSTER_AGENT_PLUGIN_PLUGIN_VERSION_MIN = "15.0.1";
    public static final String SYBASE_HOME_SERVICE_ID = "SybaseHomeService";
    public static final String DEPLOYMENT_SERVICE_ID = "DeploymentService";
    public static final String PLUGIN_REGISTER_SERVICE_ID = "PluginRegisterService";
    public static final String FILE_TRANSFER_SERVICE_ID = "FileTransferService";
    public static final String ENVIRONMENT_DISCOVERY_SERVICE_ID = "EnvironmentDiscoveryService";
    public static final String SELF_DISCOVERY_SERVICE_ID = "SelfDiscoveryService";
    public static final String CLUSTER_AGENT_VERSION_MIN = "2.5.0";
    public static final int CLUSTER_AGENT_BUILD_NUMBER_MIN = 980;
    public static final String CLAP_CLUSTER_NAME_PROP = "clusterName";
    public static String DEFAULT_UAF_ADMIN = "uafadmin";
    private static SecureObject clapCryptPass = null;
    private SyUAFEntry uafEntry;
    private String host;
    private String port;
    private String username;
    private String encryptedPassword;
    private AgentConnection agentConnection;
    private String serverFileSeparator;
    private String agentHome;
    private AgentInfo agentInfo;
    private String sybaseHome;
    private String aseHome;
    private String interfacesFileHome;
    private String clusterCfgFile;
    private String environmentScript;
    private String startParameters;
    private String traceFlags;
    private boolean alreadyValidated = false;
    private List sybaseHomeList;
    private String[] localAddresses;

    public SDCClusterAgentProxy(SyUAFEntry syUAFEntry, String string, String string2) throws Exception {
        this.uafEntry = syUAFEntry;
        this.host = syUAFEntry.getAgentInfo().getHost();
        AgentURL agentURL = new AgentURL(syUAFEntry.getAgentURL());
        this.port = agentURL.getPort();
        this.username = string;
        this.encryptedPassword = ASEUtils.encryptPassword(string2);
    }

    public SDCClusterAgentProxy(String string, String string2, String string3, String string4) {
        this.host = string;
        this.port = string2;
        this.username = string3;
        this.encryptedPassword = ASEUtils.encryptPassword(string4);
    }

    public SDCClusterAgentProxy(AgentConnection agentConnection) {
        this.agentConnection = agentConnection;
    }

    public SDCClusterAgentProxy(AgentConnection agentConnection, SyUAFEntry syUAFEntry) {
        this.agentConnection = agentConnection;
        this.uafEntry = syUAFEntry;
    }

    public boolean isConnected() {
        if (this.agentConnection == null) {
            return false;
        }
        if (this.agentConnection.isTimedOut()) {
            return false;
        }
        return this.agentConnection.isConnected();
    }

    public synchronized void connect() throws AuthenticationException, AuthorizationException, InvalidAgentURLException, LoginModuleNotFoundException, JMXException, AgentConnectionException {
        if (this.isConnected()) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.agentConnection = AgentConnectionFactory.createAgentConnection((String)this.getAgentUrl());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        this.agentConnection.connect(this.username, ASEUtils.decryptPassword(this.encryptedPassword).toCharArray());
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.agentInfo = this.agentConnection.getAgentInfo();
        this.agentHome = this.agentInfo.getAgentHome();
        this.serverFileSeparator = this.retrieveServerFileSeparator();
    }

    public synchronized void reconnect() throws AuthenticationException, AuthorizationException, InvalidAgentURLException, LoginModuleNotFoundException, JMXException, AgentConnectionException {
        this.agentConnection = null;
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        if (this.agentConnection != null) {
            if (!this.isConnected()) {
                return;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                this.agentConnection.disconnect();
            }
            catch (Exception exception) {
                Support.addLogEntry(0, null, this.getClass(), exception.getMessage(), exception.toString());
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
                this.sybaseHomeList = null;
                this.localAddresses = null;
                this.agentConnection = null;
            }
        }
    }

    protected String retrieveServerFileSeparator() throws AgentConnectionException {
        String string = (String)this.getServiceProperty(ENVIRONMENT_DISCOVERY_SERVICE_ID, "fileSeparator");
        return string;
    }

    public boolean isSybaseHomeServiceAvailabe() {
        ServiceInfo serviceInfo = this.agentInfo.getServiceInfo(SYBASE_HOME_SERVICE_ID);
        return serviceInfo != null;
    }

    public boolean isDeploymentServiceAvailabe() throws AgentConnectionException {
        return this.isServiceAvailable(DEPLOYMENT_SERVICE_ID);
    }

    public boolean isServiceAvailable(String string) {
        ServiceInfo serviceInfo = this.agentInfo.getServiceInfo(string);
        return serviceInfo != null;
    }

    public boolean isPluginAvailable(String string, String string2) {
        List list = this.agentInfo.getPluginInfos(string, string2);
        return !list.isEmpty();
    }

    public List getSybaseHomeList() throws AgentConnectionException {
        if (this.sybaseHomeList != null && !this.sybaseHomeList.isEmpty()) {
            return this.sybaseHomeList;
        }
        this.sybaseHomeList = new ArrayList(1);
        String string = (String)this.getServiceProperty(SYBASE_HOME_SERVICE_ID, "sybaseHomeList");
        if (string == null || string.trim().equals("")) {
            return this.sybaseHomeList;
        }
        string = string.substring(1, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken(",");
            this.sybaseHomeList.add(string2);
        }
        return this.sybaseHomeList;
    }

    public String getASEHome(String string) throws AgentConnectionException {
        String[] stringArray = (String[])this.invokeServiceMethod(SYBASE_HOME_SERVICE_ID, "retrieveEnvironementVariablesASE", new Object[]{string}, new String[]{"java.lang.String"});
        String string2 = SDCClusterAgentUtils.getVariableValue(stringArray, "SYBASE_ASE");
        String string3 = string;
        string3 = string2 != null && !string2.trim().equals("") ? string3 + this.serverFileSeparator + string2 : string3 + this.serverFileSeparator + "ASE-15_0";
        return string3;
    }

    public Object getServiceProperty(String string, String string2) throws AgentConnectionException {
        if (!this.isConnected()) {
            this.connect();
        }
        return this.agentConnection.getAgentServiceProperty(string, string2);
    }

    public Object invokeServiceMethod(String string, String string2, Object[] objectArray, String[] stringArray) throws AgentConnectionException {
        if (!this.isConnected()) {
            this.connect();
        }
        return this.agentConnection.invokeAgentServiceMethod(string, string2, objectArray, stringArray);
    }

    public Object invokePluginMethod(String string, String string2, Object[] objectArray, String[] stringArray) throws AgentConnectionException {
        if (!this.isConnected()) {
            this.connect();
        }
        return this.agentConnection.invokeAgentPluginMethod(string, string2, objectArray, stringArray);
    }

    public Object getPluginAttributeValue(String string, String string2) throws AgentConnectionException {
        if (!this.isConnected()) {
            this.connect();
        }
        return this.agentConnection.getMBeanAttribute(string, string2);
    }

    public AgentConnection getAgentConnection() {
        return this.agentConnection;
    }

    public void startInstance(String string, String string2, String string3, MessageListener messageListener) throws AgentConnectionException {
        Object[] objectArray = new Object[]{string2, string3, messageListener};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
        if (Debug.isOn()) {
            Support.addLogEntry(2, null, this.getClass(), "invoking startInstance", "");
        }
        this.invokePluginMethod(string, "startInstance", objectArray, stringArray);
    }

    public boolean fileExists(String string) throws AgentConnectionException {
        Boolean bl = (Boolean)this.invokeServiceMethod(FILE_TRANSFER_SERVICE_ID, "exists", new Object[]{string}, new String[]{"java.lang.String"});
        return bl;
    }

    public String getParentFile(String string) throws AgentConnectionException {
        String string2 = (String)this.invokeServiceMethod(FILE_TRANSFER_SERVICE_ID, "getParent", new Object[]{string}, new String[]{"java.lang.String"});
        return string2;
    }

    public PluginInfo getFirstASEClustAgentPlugin() throws AgentConnectionException {
        PluginInfo pluginInfo = null;
        AgentInfo agentInfo = this.getAgentInfo();
        List list = agentInfo.getPluginInfos(ASE_CLUSTER_AGENT_PLUGIN_ID);
        if (list != null && list.size() > 0) {
            pluginInfo = (PluginInfo)list.get(0);
        }
        return pluginInfo;
    }

    public PluginInfo getASEClustAgentPlugin(String string) throws AgentConnectionException {
        this.reconnect();
        AgentInfo agentInfo = this.getAgentInfo();
        List list = agentInfo.getPluginInfos(ASE_CLUSTER_AGENT_PLUGIN_ID);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                PluginInfo pluginInfo = (PluginInfo)list.get(i);
                if (!pluginInfo.getDiscoveryProperty(CLAP_CLUSTER_NAME_PROP).equals(string)) continue;
                return pluginInfo;
            }
        }
        return null;
    }

    public String[] getLocalAddresses() throws AgentConnectionException {
        if (this.localAddresses != null) {
            return this.localAddresses;
        }
        this.localAddresses = (String[])this.invokeServiceMethod(ENVIRONMENT_DISCOVERY_SERVICE_ID, "getLocalAddresses", null, null);
        return this.localAddresses;
    }

    public boolean isPortAvailable(int n) throws AgentConnectionException {
        Boolean bl = (Boolean)this.invokeServiceMethod(ENVIRONMENT_DISCOVERY_SERVICE_ID, "isPortAvailable", new Object[]{new Integer(n)}, new String[]{"java.lang.Integer"});
        if (bl == null) {
            bl = new Boolean(false);
        }
        return bl;
    }

    public boolean isTCPPortAvailable(int n) throws AgentConnectionException {
        Boolean bl = (Boolean)this.invokeServiceMethod(ENVIRONMENT_DISCOVERY_SERVICE_ID, "isTCPPortAvailable", new Object[]{new Integer(n)}, new String[]{"java.lang.Integer"});
        if (bl == null) {
            bl = new Boolean(false);
        }
        return bl;
    }

    public boolean isUDPPPortAvailable(int n) throws AgentConnectionException {
        Boolean bl = (Boolean)this.invokeServiceMethod(ENVIRONMENT_DISCOVERY_SERVICE_ID, "isUDPPortAvailable", new Object[]{new Integer(n)}, new String[]{"java.lang.Integer"});
        if (bl == null) {
            bl = new Boolean(false);
        }
        return bl;
    }

    public Integer[] getPortsInUse() throws AgentConnectionException {
        Integer[] integerArray = (Integer[])this.invokeServiceMethod(ENVIRONMENT_DISCOVERY_SERVICE_ID, "getPortsInUse", null, null);
        if (integerArray == null) {
            integerArray = new Integer[]{};
        }
        return integerArray;
    }

    public Integer[] getTCPPortsInUse() throws AgentConnectionException {
        Integer[] integerArray = (Integer[])this.invokeServiceMethod(ENVIRONMENT_DISCOVERY_SERVICE_ID, "getTCPPortsInUse", null, null);
        if (integerArray == null) {
            integerArray = new Integer[]{};
        }
        return integerArray;
    }

    public Integer[] getUDPPortsInUse() throws AgentConnectionException {
        Integer[] integerArray = (Integer[])this.invokeServiceMethod(ENVIRONMENT_DISCOVERY_SERVICE_ID, "getUDPPortsInUse", null, null);
        if (integerArray == null) {
            integerArray = new Integer[]{};
        }
        return integerArray;
    }

    public Integer[] getPortsInUse(int n, int n2) throws AgentConnectionException {
        Integer[] integerArray = new Integer[]{};
        Integer[] integerArray2 = this.getPortsInUse();
        if (integerArray2 == null || integerArray2.length == 0) {
            return integerArray;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < integerArray2.length; ++i) {
            int n3 = integerArray2[i];
            if (n3 < n || n3 > n2) continue;
            arrayList.add(new Integer(n3));
        }
        integerArray = arrayList.toArray(new Integer[arrayList.size()]);
        return integerArray;
    }

    public Integer[] getUDPPortsInUse(int n, int n2) throws AgentConnectionException {
        Integer[] integerArray = new Integer[]{};
        Integer[] integerArray2 = this.getUDPPortsInUse();
        if (integerArray2 == null || integerArray2.length == 0) {
            return integerArray;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < integerArray2.length; ++i) {
            int n3 = integerArray2[i];
            if (n3 < n || n3 > n2) continue;
            arrayList.add(new Integer(n3));
        }
        integerArray = arrayList.toArray(new Integer[arrayList.size()]);
        return integerArray;
    }

    public Integer[] getTCPPortsInUse(int n, int n2) throws AgentConnectionException {
        Integer[] integerArray = new Integer[]{};
        Integer[] integerArray2 = this.getTCPPortsInUse();
        if (integerArray2 == null || integerArray2.length == 0) {
            return integerArray;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < integerArray2.length; ++i) {
            int n3 = integerArray2[i];
            if (n3 < n || n3 > n2) continue;
            arrayList.add(new Integer(n3));
        }
        integerArray = arrayList.toArray(new Integer[arrayList.size()]);
        return integerArray;
    }

    public boolean doesHostPortExistInInterface(ICluster iCluster, String string, int n) throws AgentConnectionException, RemoteException {
        Boolean bl = null;
        String string2 = iCluster.getInterfacesPath();
        Object[] objectArray = new Object[]{string2, string, String.valueOf(n)};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        bl = (Boolean)this.invokeAgentPluginMethod("doesHostPortExistInInterface", objectArray, stringArray);
        return bl == null ? false : bl;
    }

    public Integer[] discoverUnusedTCPPorts(ICluster iCluster, int n, int n2, boolean bl) throws AgentConnectionException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Integer[] integerArray = null;
        if (bl) {
            integerArray = this.getTCPPortsInUse(n, 65535);
        }
        boolean bl2 = false;
        for (int i = n; i < 65536 && arrayList.size() < n2; ++i) {
            try {
                if (bl && this.doesHostPortExistInInterface(iCluster, this.getHost(), i)) {
                    continue;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            bl2 = false;
            if (integerArray != null) {
                for (int j = 0; j < integerArray.length; ++j) {
                    if (i != integerArray[j]) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) continue;
            arrayList.add(i);
        }
        Integer[] integerArray2 = new Integer[n2];
        arrayList.toArray(integerArray2);
        return integerArray2;
    }

    public String getServerFileSeparator() {
        return this.serverFileSeparator;
    }

    public String getAgentHome() {
        return this.agentHome;
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public SyUAFEntry getUafEntry() {
        return this.uafEntry;
    }

    public synchronized void setUafEntry(SyUAFEntry syUAFEntry) {
        this.uafEntry = syUAFEntry;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getHostPort() {
        return SDCClusterAgentUtils.getNodeAddress(this.host, this.port);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return ASEUtils.decryptPassword(this.encryptedPassword);
    }

    public String getSybaseHome() {
        if (null == this.sybaseHome || this.sybaseHome.length() == 0) {
            try {
                List list = this.getSybaseHomeList();
                this.sybaseHome = null != list && !list.isEmpty() ? (String)list.get(0) : this.discoverySybaseHome();
            }
            catch (AgentConnectionException agentConnectionException) {
                // empty catch block
            }
        }
        return this.sybaseHome;
    }

    public synchronized void setSybaseHome(String string) {
        this.sybaseHome = string;
    }

    public String getAseHome() {
        if (null == this.aseHome || this.aseHome.trim().length() == 0) {
            try {
                this.aseHome = this.getASEHome(this.getSybaseHome());
            }
            catch (AgentConnectionException agentConnectionException) {
                // empty catch block
            }
        }
        return this.aseHome;
    }

    public synchronized void setAseHome(String string) {
        this.aseHome = string;
    }

    public synchronized boolean validateClusterAgent() throws AgentConnectionException, Exception {
        String string;
        int n;
        Version version;
        if (this.isAlreadyValidated()) {
            return true;
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if (!this.isConnected()) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_FAIL_CONNECT_AGENT"), this.host + ":" + this.port);
            throw new AgentConnectionException(aSEMessageText.toString());
        }
        String string2 = this.agentInfo.getVersion();
        Version version2 = Version.createVersion((String)string2);
        int n2 = version2.compare(version = Version.createVersion((String)CLUSTER_AGENT_VERSION_MIN));
        if (n2 < 0) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_INVALID_CLUSTER_AGENT_VERSION_NOT_MET"), this.host + ":" + this.port, string2, CLUSTER_AGENT_VERSION_MIN);
            throw new Exception(aSEMessageText.toString());
        }
        if (n2 == 0 && (n = Integer.parseInt(string = this.agentInfo.getBuildNumber())) < 980) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_INVALID_CLUSTER_AGENT_VERSION_NOT_MET"), this.host + ":" + this.port, string2 + "." + string, "2.5.0." + new Integer(980).toString());
            throw new Exception(aSEMessageText.toString());
        }
        boolean bl = false;
        try {
            bl = this.isSybaseHomeServiceAvailabe();
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_NOT_CLUSTER_AGENT_MISSING_SYBASE_HOME_SERVICE"), this.host + ":" + this.port);
            throw new Exception(aSEMessageText.toString());
        }
        if (!bl) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_NOT_CLUSTER_AGENT_MISSING_SYBASE_HOME_SERVICE"), this.host + ":" + this.port);
            throw new Exception(aSEMessageText.toString());
        }
        try {
            bl = this.isDeploymentServiceAvailabe();
        }
        catch (Exception exception) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_NOT_CLUSTER_AGENT_MISSING_DEPLYMENT_SERVICE"), this.host + ":" + this.port);
            throw new Exception(aSEMessageText.toString());
        }
        if (!bl) {
            ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_NOT_CLUSTER_AGENT_MISSING_DEPLYMENT_SERVICE"), this.host + ":" + this.port);
            throw new Exception(aSEMessageText.toString());
        }
        this.alreadyValidated = true;
        return bl;
    }

    public String discoverySybaseHome() throws AgentConnectionException {
        String string;
        String string2 = this.getAgentHome();
        if (string2.endsWith(string = this.getServerFileSeparator())) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String string3 = string2.substring(0, string2.lastIndexOf(string));
        return string3;
    }

    public void addSybaseHome(String string) throws AgentConnectionException {
        this.invokeServiceMethod(SYBASE_HOME_SERVICE_ID, "addSybaseHome", new Object[]{string}, new String[]{"java.lang.String"});
    }

    public boolean isAlreadyValidated() {
        return this.alreadyValidated;
    }

    public void setRevalidate() {
        this.alreadyValidated = false;
        if (this.isConnected()) {
            this.disconnect();
        }
    }

    public String getClusterConfigFile() {
        return this.clusterCfgFile;
    }

    public synchronized void setClusterConfigFile(String string) {
        this.clusterCfgFile = string;
    }

    public String getStartParameters() {
        return this.startParameters;
    }

    public synchronized void setStartParameters(String string) {
        this.startParameters = string;
    }

    public String getTraceFlags() {
        return this.traceFlags;
    }

    public synchronized void setTraceFlags(String string) {
        this.traceFlags = string;
    }

    public String getEnvironmentScript() {
        if (null == this.environmentScript || this.environmentScript.length() == 0) {
            this.environmentScript = this.getSybaseHome() + this.getServerFileSeparator() + "SYBASE.sh";
        }
        return this.environmentScript;
    }

    public synchronized void setEnvironmentScript(String string) {
        this.environmentScript = string;
    }

    public String getInterfacesFileHome() {
        if (null == this.interfacesFileHome || this.interfacesFileHome.trim().length() == 0) {
            this.interfacesFileHome = this.getSybaseHome();
        }
        return this.interfacesFileHome;
    }

    public synchronized void setInterfacesFileHome(String string) {
        this.interfacesFileHome = string;
    }

    public String getAgentUrl() {
        String string = null;
        if (this.uafEntry != null) {
            string = this.uafEntry.getAgentURL();
        } else if (this.isConnected()) {
            try {
                string = this.agentConnection.getAgentURLShortFormatAsString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null && this.host != null && this.port != null) {
            string = "rmi://" + this.host + ":" + this.port;
        }
        return string;
    }

    public synchronized void setUsername(String string) {
        this.username = string;
    }

    public synchronized void setPassword(String string) {
        this.encryptedPassword = ASEUtils.encryptPassword(string);
    }

    public String getNodeName() {
        return SDCClusterAgentUtils.getNodeAddress(this.host, this.port);
    }

    public void unregisterClusterAgent(PluginInfo pluginInfo) throws JMXException, AuthorizationException, AuthenticationException, LoginModuleNotFoundException, AgentConnectionException {
        if (!this.isConnected()) {
            this.connect();
        }
        if (this.agentConnection.isAgentServiceMethodAvailable(PLUGIN_REGISTER_SERVICE_ID, "unregisterPlugin")) {
            Object[] objectArray = new Object[]{pluginInfo.getId(), pluginInfo.getVersion(), new Integer(pluginInfo.getInstanceNumber())};
            String[] stringArray = new String[]{String.class.getName(), String.class.getName(), Integer.class.getName()};
            this.invokeServiceMethod(PLUGIN_REGISTER_SERVICE_ID, "unregisterPlugin", objectArray, stringArray);
        }
    }

    public void deleteDirectoryRecursively(String string) throws AgentConnectionException {
        if (!this.isConnected()) {
            this.connect();
        }
        if (this.agentConnection.isAgentServiceMethodAvailable(FILE_TRANSFER_SERVICE_ID, "deleteTree")) {
            Object[] objectArray = new Object[]{string};
            String[] stringArray = new String[]{"java.lang.String"};
            this.invokeServiceMethod(FILE_TRANSFER_SERVICE_ID, "deleteTree", objectArray, stringArray);
        }
    }

    public int deployPluginFromTemplate(String string, String string2, String string3, Properties properties, Boolean bl) throws AgentConnectionException, AgentServiceException {
        ASEMessageText aSEMessageText = null;
        if (!this.isDeploymentServiceAvailabe()) {
            aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_SERVICE_NOT_AVAILABLE"), DEPLOYMENT_SERVICE_ID, this.getNodeName());
            throw new AgentServiceException(aSEMessageText.toString());
        }
        String string4 = "createPluginFromTemplate";
        Object[] objectArray = new Object[]{string, string2, string3, properties, bl};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.util.Properties", "java.lang.Boolean"};
        Integer n = (Integer)this.invokeServiceMethod(DEPLOYMENT_SERVICE_ID, string4, objectArray, stringArray);
        return n;
    }

    public void refreshDiscoveryServers() throws AgentConnectionException, AgentServiceException {
        ASEMessageText aSEMessageText = null;
        if (!this.isServiceAvailable(SELF_DISCOVERY_SERVICE_ID)) {
            aSEMessageText = new ASEMessageText(ASEUtils.getString("SDC_ERROR_SERVICE_NOT_AVAILABLE"), SELF_DISCOVERY_SERVICE_ID, this.getNodeName());
            throw new AgentServiceException(aSEMessageText.toString());
        }
        String string = "updateLookupInfo";
        Object[] objectArray = new Object[]{};
        String[] stringArray = new String[]{};
        this.invokeServiceMethod(SELF_DISCOVERY_SERVICE_ID, string, objectArray, stringArray);
    }

    public String getTemplatePluginLatestVersion(String string, String string2) throws AgentConnectionException, MalformatVersionException {
        String string3 = null;
        String[] stringArray = (String[])this.invokeServiceMethod(DEPLOYMENT_SERVICE_ID, "getTemplatePluginIdVersions", null, null);
        Version version = Version.createVersion((String)"0.0.0");
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            Version version2;
            String string5 = string + "_";
            int n = stringArray[i].indexOf(string5);
            if (n != 0 || (version2 = Version.createVersion((String)(string4 = stringArray[i].substring(string5.length())))).compare(version) <= 0) continue;
            version = version2;
        }
        if (version.getVersionAsInteger() > 0) {
            string3 = version.toString();
        }
        return string3;
    }

    public boolean isConnectionValid() {
        if (!this.isConnected()) {
            return false;
        }
        boolean bl = true;
        try {
            String string = (String)this.getServiceProperty("Agent", "version");
            if (string == null) {
                bl = false;
            }
        }
        catch (AgentConnectionException agentConnectionException) {
            bl = false;
        }
        return bl;
    }

    public void deployAgentPlugin(ICluster iCluster) throws Exception {
        String string = "";
        int n = 0;
        this.reconnect();
        string = this.getTemplatePluginLatestVersion(ASE_CLUSTER_AGENT_PLUGIN_ID, ASE_CLUSTER_AGENT_PLUGIN_PLUGIN_VERSION_MIN);
        n = this.deployPluginFromTemplate(ASE_CLUSTER_AGENT_PLUGIN_ID, string, iCluster.getName(), this.getAgentPluginProperties(iCluster), new Boolean(true));
        this.uafEntry.setPluginVersion(string);
        this.uafEntry.setPluginInstanceNumber(n);
        this.getAgentConnection().reloadACLCache();
        this.refreshDiscoveryServers();
    }

    public Properties getAgentPluginProperties(ICluster iCluster) {
        Properties properties = new Properties();
        String string = this.getEnvironmentScript();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        properties.setProperty("ase.cluster.name", iCluster.getName());
        properties.setProperty("ase.installation.mode", iCluster.getInstallationMode());
        properties.setProperty("com.sybase.home", this.getSybaseHome());
        properties.setProperty("ase.home", this.getAseHome());
        properties.setProperty("ase.env.script.type", string2);
        properties.setProperty("ase.env.script", string);
        properties.setProperty("ase.password", "");
        properties.setProperty("ase.user", "sa");
        properties.setProperty("ase.quorum.device", iCluster.getQuorum());
        if (iCluster.isLDAPconfigured()) {
            properties.setProperty("use.ldap", String.valueOf(iCluster.isLDAPconfigured()));
        } else {
            properties.setProperty("ase.interfaces.path", this.sybaseHome);
        }
        String string3 = iCluster.getMasterDevice();
        if (null != string3 && string3.trim().length() > 0) {
            properties.setProperty("ase.master.device", String.valueOf(iCluster.getMasterDevice()));
        }
        return properties;
    }

    public void updateAgentPluginProperties(ICluster iCluster) throws Exception {
        String string;
        String string2 = iCluster.getQuorum();
        if (null != string2 && string2.trim().length() > 0) {
            this.agentConnection.setAgentPluginProperty(ASE_CLUSTER_AGENT_PLUGIN_ID, this.uafEntry.getPluginVersion(), this.uafEntry.getInstanceNumber(), "quorumDevice", (Object)iCluster.getQuorum());
        }
        if (null != (string = iCluster.getMasterDevice()) && string.trim().length() > 0) {
            this.agentConnection.setAgentPluginProperty(ASE_CLUSTER_AGENT_PLUGIN_ID, this.uafEntry.getPluginVersion(), this.uafEntry.getInstanceNumber(), "masterDevice", (Object)iCluster.getMasterDevice());
        }
        this.agentConnection.setAgentPluginProperty(ASE_CLUSTER_AGENT_PLUGIN_ID, this.uafEntry.getPluginVersion(), this.uafEntry.getInstanceNumber(), "sybaseHome", (Object)this.getSybaseHome());
        this.agentConnection.setAgentPluginProperty(ASE_CLUSTER_AGENT_PLUGIN_ID, this.uafEntry.getPluginVersion(), this.uafEntry.getInstanceNumber(), "aseHome", (Object)this.getAseHome());
        this.agentConnection.setAgentPluginProperty(ASE_CLUSTER_AGENT_PLUGIN_ID, this.uafEntry.getPluginVersion(), this.uafEntry.getInstanceNumber(), "envShell", (Object)this.getEnvironmentScript());
        if (iCluster.isLDAPconfigured()) {
            this.agentConnection.setAgentPluginProperty(ASE_CLUSTER_AGENT_PLUGIN_ID, this.uafEntry.getPluginVersion(), this.uafEntry.getInstanceNumber(), "useLDAP", (Object)"true");
        } else {
            this.agentConnection.setAgentPluginProperty(ASE_CLUSTER_AGENT_PLUGIN_ID, this.uafEntry.getPluginVersion(), this.uafEntry.getInstanceNumber(), "interfacesPath", (Object)this.getInterfacesFileHome());
        }
    }

    public void setPluginInterfacePath() throws AgentConnectionException, RemoteException {
        String string = this.getInterfacesFileHome();
        Object[] objectArray = new Object[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.invokeAgentPluginMethod("setInterfacesPath", objectArray, stringArray);
    }

    public void setPluginLDAP(String string) throws AgentConnectionException, RemoteException {
        String string2 = this.getInterfacesFileHome();
        Object[] objectArray = new Object[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.invokeAgentPluginMethod("setUseLDAP", objectArray, stringArray);
    }

    public Object invokeAgentPluginMethod(String string, String string2, Object[] objectArray, String[] stringArray) throws RemoteException, AgentConnectionException {
        PluginInfo pluginInfo = this.getASEClustAgentPlugin(string);
        pluginInfo = this.getASEClustAgentPlugin(string);
        return this.getAgentConnection().invokeAgentPluginMethod(SyUAF.SDC_PLUGIN_ID, pluginInfo.getVersion(), pluginInfo.getInstanceNumber(), string2, objectArray, stringArray);
    }

    public Object invokeAgentPluginMethod(String string, Object[] objectArray, String[] stringArray) throws RemoteException, AgentConnectionException {
        return this.getAgentConnection().invokeAgentPluginMethod(SyUAF.SDC_PLUGIN_ID, this.getUafEntry().getPluginVersion(), this.getUafEntry().getInstanceNumber(), string, objectArray, stringArray);
    }

    public static String getCLAPAdmin() {
        return DEFAULT_UAF_ADMIN;
    }

    public static SecureObject getCLAPCryptPass() {
        try {
            if (null == clapCryptPass) {
                clapCryptPass = new SecureObject((Serializable)new char[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clapCryptPass;
    }

    public boolean isVCSEnabled() {
        try {
            return (Boolean)this.invokeAgentPluginMethod("isVCSEnabled", null, null);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public List getVCSClusterInterconnects() {
        List list = new Vector();
        try {
            list = (List)this.invokeAgentPluginMethod("getClusterInterconnects", null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public boolean isManagedByVCS(String string) throws AgentConnectionException, RemoteException {
        Object[] objectArray = new Object[]{string, null};
        String[] stringArray = new String[]{"java.lang.String", "com.sybase.ua.util.MessageListener"};
        return (Boolean)this.invokeAgentPluginMethod("isManagedByVCS", objectArray, stringArray);
    }

    public String getLDAPSever() throws AgentConnectionException, RemoteException {
        Object[] objectArray = new Object[]{};
        String[] stringArray = new String[]{};
        return (String)this.invokeAgentPluginMethod("getLDAPServer", objectArray, stringArray);
    }

    public boolean doesEntriesExistInInterfaces(String string) throws AgentConnectionException, RemoteException {
        String string2 = this.getInterfacesFileHome();
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        Object[] objectArray = new Object[]{string2, vector, null};
        String[] stringArray = new String[]{"java.lang.String", "java.util.List", "com.sybase.ua.util.MessageListener"};
        Boolean[] booleanArray = (Boolean[])this.invokeAgentPluginMethod("doesEntriesExistInInterfaces", objectArray, stringArray);
        return booleanArray[0];
    }
}

