/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.util;

import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.util.Debug;
import com.sybase.aseplugin.util.SDCClusterAgentProxy;
import com.sybase.ua.AgentDiscovery;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.FastDiscoveryFilter;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.ServiceInfo;
import com.sybase.ua.discovery.DiscoveryException;
import com.sybase.util.ds.uaf.DiscoveryFilter;
import com.sybase.util.ds.uaf.DiscoverySetting;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import com.sybase.util.ds.uaf.SyUAFEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class SDCClusterAgentUtils {
    public static List discoverAgents(String string, String string2, String string3, FastDiscoveryFilter fastDiscoveryFilter) throws DiscoveryException {
        return SDCClusterAgentUtils.discoverAgents(string, string2, string3, fastDiscoveryFilter, true);
    }

    private static List discoverAgents(String string, String string2, String string3, FastDiscoveryFilter fastDiscoveryFilter, boolean bl) throws DiscoveryException {
        ArrayList<List> arrayList = new ArrayList<List>();
        AgentDiscovery agentDiscovery = new AgentDiscovery(string.toLowerCase(), string2, string3);
        agentDiscovery.discover((com.sybase.ua.DiscoveryFilter)fastDiscoveryFilter);
        String string4 = "com.sybase.ase.cluster";
        List list = agentDiscovery.getAgentInfos();
        for (AgentInfo agentInfo : list) {
            List list2;
            boolean bl2 = true;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ServiceInfo serviceInfo = agentInfo.getServiceInfo("RMIService");
            if (serviceInfo != null && (serviceInfo.getDiscoveryProperty("port") == null || serviceInfo.getDiscoveryProperty("port").equals(""))) {
                bl2 = false;
            }
            if (!bl2) continue;
            if (hashMap.get("host") == null || hashMap.get("host").toString().trim().equals("")) {
                hashMap.put("host", agentInfo.getHost());
            }
            if (hashMap.get("hostPorts") == null || hashMap.get("hostPorts").toString().trim().equals("")) {
                hashMap.put("hostPorts", agentInfo.getHost() + ":" + agentInfo.getRMIPort());
            }
            if (hashMap.get("OSArchitecture") == null || hashMap.get("OSArchitecture").toString().trim().equals("")) {
                hashMap.put("OSArchitecture", agentInfo.getOSArchitecture());
            }
            if (hashMap.get("OSName") == null || hashMap.get("OSName").toString().trim().equals("")) {
                hashMap.put("OSName", agentInfo.getOSName());
            }
            String string5 = "15.0.1";
            int n = 1;
            try {
                list2 = agentInfo.getPluginInfosWithLatestVersion(string4);
                if (!list2.isEmpty()) {
                    PluginInfo pluginInfo = (PluginInfo)list2.get(0);
                    string5 = pluginInfo.getVersion();
                    n = pluginInfo.getInstanceNumber();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            list2 = new SyUAFASEEntry(hashMap, string4, string5, n, agentInfo);
            if (bl && (!bl || !DiscoveryFilter.passFilters((String)"ASE", SyUAFASEEntry.class, (SyUAFEntry)list2))) continue;
            arrayList.add(list2);
        }
        return arrayList;
    }

    public static boolean clusterExists(String string, HashSet hashSet) {
        boolean bl = false;
        List list = DiscoverySetting.getDiscoverySettings();
        final String string2 = string;
        FastDiscoveryFilter fastDiscoveryFilter = new FastDiscoveryFilter(){

            public boolean acceptAgentPlugin(PluginInfo pluginInfo) {
                String string;
                return pluginInfo.getId().equals("com.sybase.ase.cluster") && (string = (String)pluginInfo.getDiscoveryProperty("clusterName")) != null && string.equals(string2);
            }
        };
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SDCClusterAgentUtils.class.getClassLoader());
        for (DiscoverySetting discoverySetting : list) {
            try {
                List list2 = SDCClusterAgentUtils.discoverAgents(discoverySetting.service, discoverySetting.host, discoverySetting.port, fastDiscoveryFilter);
                if (list2 == null || list2.isEmpty()) continue;
                bl = true;
                for (int i = 0; i < list2.size(); ++i) {
                    hashSet.add(((SyUAFASEEntry)list2.get(i)).getHostName());
                }
                break;
            }
            catch (DiscoveryException discoveryException) {
            }
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        return bl;
    }

    public static String getVariableValue(String[] stringArray, String string) {
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "=");
            String string3 = null;
            String string4 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if (string3 == null || !string3.equals(string)) continue;
            string2 = string4;
            break;
        }
        return string2;
    }

    public static String[] createClusterAgentPlugin(String string, SDCClusterAgentProxy sDCClusterAgentProxy) {
        String[] stringArray = new String[]{" "};
        Object[] objectArray = new Object[]{string};
        String[] stringArray2 = new String[]{"java.lang.String"};
        if (Debug.isOn()) {
            Support.addLogEntry(2, null, sDCClusterAgentProxy.getClass(), "Executing createClusterAgentPlugin: " + string, "");
        }
        try {
            stringArray = (String[])sDCClusterAgentProxy.invokeServiceMethod("DeploymentService", "createClusterAgentPlugin", objectArray, stringArray2);
        }
        catch (Exception exception) {
            Support.addLogEntry(0, null, sDCClusterAgentProxy.getClass(), exception.getMessage(), exception.toString());
        }
        return stringArray;
    }

    public static String getNodeAddress(String string, String string2) {
        String string3 = null;
        if (string != null) {
            string3 = string.trim();
        }
        if (string2 != null) {
            string3 = string3 + ":" + string2.trim();
        }
        return string3;
    }

    public static String[] getAgentNodePort(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf("(");
        if (n > 0) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1, string.length() - 1);
        } else {
            n = string.indexOf(":");
            if (n > 0) {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + 1);
            }
        }
        return stringArray;
    }

    public static String getAgentNodeName(String string) {
        String string2 = "";
        int n = string.indexOf(":");
        if (n > 0) {
            string2 = string.substring(0, n);
        } else {
            n = string.indexOf("(");
            if (n > 0) {
                string2 = string.substring(0, n);
            }
        }
        return string2;
    }

    public static String getAgentPort(String string) {
        String string2 = "";
        int n = string.indexOf(":");
        if (n > 0) {
            string2 = string.substring(n + 1);
        } else {
            n = string.indexOf("(");
            if (n > 0) {
                string2 = string.substring(n + 1, string.length() - 1);
            }
        }
        return string2;
    }

    private static String getPrefixHostName(String string) {
        int n = string.indexOf(".");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static boolean isSameHost(String string, String string2) {
        return SDCClusterAgentUtils.getPrefixHostName(string).equals(SDCClusterAgentUtils.getPrefixHostName(string2));
    }
}

