/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.util;

import com.sybase.aseplugin.ASEMessageText;
import com.sybase.aseplugin.ASEUtils;
import com.sybase.aseplugin.bo.Support;
import com.sybase.aseplugin.util.SDCMessageListenerCallback;
import com.sybase.ua.util.MessageListenerImpl;
import com.sybase.ua.util.xmlmessage.XMLMessage;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class SDCMessageListener
extends MessageListenerImpl {
    private transient SDCMessageListenerCallback callback;

    public SDCMessageListener(SDCMessageListenerCallback sDCMessageListenerCallback) {
        this.callback = sDCMessageListenerCallback;
        this.init();
    }

    protected void init() {
        try {
            UnicastRemoteObject.exportObject((Remote)((Object)this));
        }
        catch (RemoteException remoteException) {
            if (remoteException.getMessage() == null) {
                Support.addLogEntry(0, null, ((Object)((Object)this)).getClass(), "An error occured while setting up messaging with the UAF Cluster Agent Plugin.", "");
            }
            Support.addLogEntry(0, null, ((Object)((Object)this)).getClass(), remoteException.getMessage(), remoteException.toString());
        }
    }

    public static String getMessage(String string) {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString(string));
        return aSEMessageText.toString();
    }

    public static String getMessage(String string, Object object) {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString(string), object);
        return aSEMessageText.toString();
    }

    public static String getMessage(String string, Object object, Object object2) {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString(string), object, object2);
        return aSEMessageText.toString();
    }

    public static String getMessage(String string, Object object, Object object2, Object object3) {
        ASEMessageText aSEMessageText = new ASEMessageText(ASEUtils.getString(string), object, object2, object3);
        return aSEMessageText.toString();
    }

    public int onMessage(String string, String string2) throws RemoteException {
        XMLMessage xMLMessage = new XMLMessage(string);
        int n = 0;
        try {
            xMLMessage.decodeMessages(string2);
            Object[] objectArray = xMLMessage.getMessageEntries();
            n = objectArray.length;
            this.processMessages(objectArray);
        }
        catch (Exception exception) {
            Support.addLogEntry(0, null, ((Object)((Object)this)).getClass(), "The messages could not be translated:" + string2, exception.toString());
        }
        return n;
    }

    protected void processMessages(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2 = (Object[])objectArray[i];
                String string = (String)objectArray2[4];
                String string2 = (String)objectArray2[3];
                int n = Integer.parseInt(string2);
                if (this.callback == null) continue;
                this.callback.handleMessage(n, string);
            }
        }
    }

    public SDCMessageListenerCallback getCallback() {
        return this.callback;
    }
}

