/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.util;

import com.sybase.aseplugin.JSConstants;
import com.sybase.aseplugin.JSTConstants;
import com.sybase.aseplugin.util.JSMessageText;
import java.util.Calendar;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class Template2JobConvertor
implements JSConstants,
JSTConstants {
    private Properties templateProps;
    private String tableTemplateName;
    private String tableTemplateVersion;
    private String tableTemplateID;
    private Locale defaultLocale = Locale.getDefault();
    private int maxTmplOffset = 20;
    private int maxLineLen = 60;
    private String delimiter = " ";

    public Template2JobConvertor() {
        this.tableTemplateName = JSMessageText.getString("JST_SQL_COMMENT_UNKNOWN");
        this.tableTemplateVersion = JSMessageText.getString("JST_SQL_COMMENT_UNKNOWN");
        this.tableTemplateID = JSMessageText.getString("JST_SQL_COMMENT_UNKNOWN");
        if (this.defaultLocale.getLanguage().equals("zh") || this.defaultLocale.getLanguage().equals("ja")) {
            this.maxTmplOffset = 14;
            this.maxLineLen = 40;
            this.delimiter = "";
        }
    }

    public String convertTemplate(Properties properties, Vector vector, StringBuffer[] stringBufferArray, String string, String string2, String string3) {
        this.templateProps = properties;
        if (string != null) {
            this.tableTemplateName = string;
        }
        if (string2 != null) {
            this.tableTemplateVersion = string2;
        }
        if (string3 != null) {
            this.tableTemplateID = string3;
        }
        String string4 = this.createComments() + JST_LINE_SEPARATOR + Template2JobConvertor.createSQLDeclare(vector) + JST_LINE_SEPARATOR + Template2JobConvertor.createAssignments(vector, stringBufferArray) + JST_LINE_SEPARATOR + this.createJobCommand();
        return string4;
    }

    public String comments() {
        return this.createComments();
    }

    private String createComments() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append("------------------------------------------------------------");
        stringBuffer.append(SQL_COMMENT_STARTER);
        n = this.maxTmplOffset - JSMessageText.getString("JST_SQL_COMMENT_TMPL_NAME").length();
        stringBuffer.append(Template2JobConvertor.createIndent(2) + JSMessageText.getString("JST_SQL_COMMENT_TMPL_NAME"));
        if (this.tempProps("template.name").equals(this.tableTemplateName)) {
            stringBuffer.append(Template2JobConvertor.createIndent(n) + this.tableTemplateName);
        } else {
            stringBuffer.append(Template2JobConvertor.createIndent(n) + this.tableTemplateName);
            stringBuffer.append(SQL_COMMENT_STARTER);
            stringBuffer.append(Template2JobConvertor.createIndent(2) + JSMessageText.getString("JST_SQL_COMMENT_XML_TMPL_NAME"));
            stringBuffer.append(this.tempProps(Template2JobConvertor.createIndent(4) + "template.name"));
        }
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append(Template2JobConvertor.createIndent(2) + JSMessageText.getString("JST_SQL_COMMENT_TMPL_VERSION"));
        n = this.maxTmplOffset - JSMessageText.getString("JST_SQL_COMMENT_TMPL_VERSION").length();
        if (this.tempProps("template.version").equals(this.tableTemplateVersion)) {
            stringBuffer.append(Template2JobConvertor.createIndent(n) + this.tableTemplateVersion);
        } else {
            stringBuffer.append(Template2JobConvertor.createIndent(n) + this.tableTemplateVersion);
            stringBuffer.append(SQL_COMMENT_STARTER);
            stringBuffer.append(Template2JobConvertor.createIndent(2) + JSMessageText.getString("JST_SQL_COMMENT_TMPL_XML_VERSION"));
            stringBuffer.append(" " + this.tempProps("template.version"));
        }
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append(Template2JobConvertor.createIndent(2) + JSMessageText.getString("JST_SQL_COMMENT_TMPL_CREATOR"));
        n = this.maxTmplOffset - JSMessageText.getString("JST_SQL_COMMENT_TMPL_CREATOR").length();
        if (this.tempProps("template.creator") != null) {
            stringBuffer.append(Template2JobConvertor.createIndent(n) + this.tempProps("template.creator"));
        } else {
            stringBuffer.append(n + JSMessageText.getString("JST_SQL_COMMENT_UNKNOWN"));
        }
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append(Template2JobConvertor.createIndent(2) + JSMessageText.getString("JST_SQL_COMMENT_TMPL_TABLE_ID"));
        n = this.maxTmplOffset - JSMessageText.getString("JST_SQL_COMMENT_TMPL_TABLE_ID").length();
        stringBuffer.append(Template2JobConvertor.createIndent(n) + this.tableTemplateID);
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append(Template2JobConvertor.createIndent(2) + JSMessageText.getString("JST_SQL_COMMENT_TMPL_DATE"));
        n = this.maxTmplOffset - JSMessageText.getString("JST_SQL_COMMENT_TMPL_DATE").length();
        stringBuffer.append(Template2JobConvertor.createIndent(n) + this.tempProps("template.dateModified"));
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append(this.formatSQLComment(this.tempProps("template.documentation"), 2, this.delimiter, this.maxLineLen));
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append(this.formatSQLComment(JSMessageText.getString("JST_SQL_COMMENT_TMPL_SPROCS"), 2, " ", this.maxLineLen));
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append(this.formatSQLComment(this.tempProps("template.command.procsUsed"), 6, ", ", this.maxLineLen));
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append(this.formatSQLComment(JSMessageText.getString("JST_SQL_COMMENT_TMPL_SPROCS2"), 2, " ", this.maxLineLen));
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append("------------------------------------------------------------");
        return stringBuffer.toString();
    }

    public String tempProps(String string) {
        return this.templateProps.getProperty(string);
    }

    public static String getDateTimeString() {
        String string = Calendar.getInstance().get(1) + "\\" + (Calendar.getInstance().get(2) + 1) + "\\" + Calendar.getInstance().get(5) + "\\  " + Calendar.getInstance().get(10) + ":" + Calendar.getInstance().get(12) + ":" + Calendar.getInstance().get(13);
        return string;
    }

    public String declare(Vector vector) {
        return Template2JobConvertor.createSQLDeclare(vector);
    }

    private static String createSQLDeclare(Vector vector) {
        if (vector == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("declare     ");
        Object[] objectArray = vector.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = ((Properties)objectArray[i]).getProperty("template.parameter.name");
            String string2 = ((Properties)objectArray[i]).getProperty("template.parameter.tdsDataType");
            stringBuffer.append("@" + string + " " + string2);
            if (i + 1 == objectArray.length) {
                stringBuffer.append(JST_LINE_SEPARATOR + JST_LINE_SEPARATOR);
                continue;
            }
            stringBuffer.append(", " + JST_LINE_SEPARATOR + Template2JobConvertor.createIndent(12));
        }
        return stringBuffer.toString();
    }

    public String splitLines(String string, int n) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.length() < n) {
            return string.toString();
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(JST_LINE_SEPARATOR);
        int n5 = 0;
        int n6 = 0;
        while (n5 < n2) {
            if (string.charAt(n5) == ' ' && n6 < n) {
                n3 = n5;
            } else if (n6 >= n) {
                if (n4 > 0 && n3 > n4) {
                    stringBuffer.append(SQL_COMMENT_STARTER + string.substring(n4, n3));
                    n4 = ++n3;
                } else {
                    stringBuffer.append(SQL_COMMENT_STARTER + string.substring(n4, n5));
                    n4 = ++n5;
                }
                stringBuffer.append(JST_LINE_SEPARATOR);
                n6 = 0;
            }
            ++n5;
            ++n6;
        }
        if (n6 > 0) {
            stringBuffer.append(SQL_COMMENT_STARTER + string.substring(n4, n5));
        }
        System.out.println("Formatted String: " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public String newLine(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length() - 1 && string.charAt(i) == ' '; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString() + string2;
    }

    public String formatSQLComment(String string, int n, String string2, int n2) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string3 = Template2JobConvertor.createIndent(n);
        n2 -= 2;
        if (string.length() < (n2 -= n)) {
            return SQL_COMMENT_STARTER + string3 + string.toString();
        }
        int n3 = string.length();
        int n4 = 1;
        n4 = string2 == null || string2.equals("") ? 0 : string2.length();
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (n4 == 0 || string.indexOf(string2) < 0) {
            int n6;
            for (n6 = 0; n6 < n3; n6 += n2) {
                stringBuffer.append(SQL_COMMENT_STARTER + string3 + string.substring(n5, n6));
                n5 = n6;
            }
            if (n5 < n3) {
                if (n3 - n5 > n2) {
                    stringBuffer.append(SQL_COMMENT_STARTER + string3 + string.substring(n5, n6));
                    n5 = n6;
                }
                stringBuffer.append(SQL_COMMENT_STARTER + string3 + string.substring(n5, n3));
            }
        } else {
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 + n4 < n3 && (n9 = string.indexOf(string2, n7)) != -1) {
                n8 = n9 + n4;
                if (n8 - n5 <= n2) {
                    n7 = n8;
                    continue;
                }
                n8 = n7 > n5 ? n7 : n5 + n2;
                stringBuffer.append(SQL_COMMENT_STARTER + string3 + string.substring(n5, n8));
                n5 = n8;
                n9 = n8;
            }
            if (n5 < n3) {
                if (n3 - n5 > n2) {
                    System.out.println(string.substring(n5, n8));
                    stringBuffer.append(SQL_COMMENT_STARTER + string3 + string.substring(n5, n8));
                    n5 = n8;
                }
                stringBuffer.append(SQL_COMMENT_STARTER + string3 + string.substring(n5, n3));
            }
        }
        return stringBuffer.toString();
    }

    public String indentString(int n) {
        return Template2JobConvertor.createIndent(n);
    }

    private static String createIndent(int n) {
        if (n < 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public String assignments(Vector vector, StringBuffer[] stringBufferArray) {
        return Template2JobConvertor.createAssignments(vector, stringBufferArray);
    }

    private static String createAssignments(Vector vector, StringBuffer[] stringBufferArray) {
        if (vector == null || stringBufferArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select      ");
        Object[] objectArray = vector.toArray();
        int n = stringBufferArray.length;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = ((Properties)objectArray[i]).getProperty("template.parameter.name");
            String string2 = ((Properties)objectArray[i]).getProperty("template.parameter.tdsDataType");
            String string3 = "NULL";
            if (i < n) {
                string3 = stringBufferArray[i].toString();
            }
            stringBuffer.append("@" + string + " = ");
            if (string2.equalsIgnoreCase("int") || string2.equalsIgnoreCase("smallint") || string2.equalsIgnoreCase("float")) {
                if (string3.equals("")) {
                    stringBuffer.append("NULL");
                } else {
                    stringBuffer.append(string3);
                }
            } else if (string3.equals("NULL")) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append("'" + string3 + "'");
            }
            if (i + 1 == objectArray.length) {
                stringBuffer.append(JST_LINE_SEPARATOR + JST_LINE_SEPARATOR);
                continue;
            }
            stringBuffer.append(", " + JST_LINE_SEPARATOR + Template2JobConvertor.createIndent(12));
        }
        return stringBuffer.toString();
    }

    public String commandCoding() {
        return this.createJobCommand();
    }

    private String createJobCommand() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TEMPLATE_SQL_COMMENT_LINES);
        stringBuffer.append(this.formatSQLComment(this.tempProps("template.command.documentation"), 2, " ", this.maxLineLen));
        stringBuffer.append(SQL_COMMENT_STARTER);
        stringBuffer.append(this.formatSQLComment(JSMessageText.getString("JST_SQL_COMMENT_TMPL_COPIED"), 2, " ", this.maxLineLen));
        stringBuffer.append(TEMPLATE_SQL_COMMENT_LINES);
        stringBuffer.append(JST_LINE_SEPARATOR);
        stringBuffer.append(this.tempProps("template.command.text"));
        return stringBuffer.toString();
    }
}

