/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLUtility {
    private final String _indentStr = "    ";
    private int _indentLen = "    ".length();
    private String _encoding = "UTF-8";
    private Document _doc;
    private File _xmlFile;
    private boolean _validateXML = false;
    private boolean _traceThis = false;
    private int _traceLevel = 3;

    public XMLUtility() {
    }

    public XMLUtility(String string) {
        this(string, false);
    }

    public XMLUtility(String string, boolean bl) {
        this.traceEnter(this, "Constructor (fileName) ");
        this.setValidateXML(bl);
        if (this.isNormalPath(string)) {
            this._xmlFile = new File(string);
            this.traceLine("file path = " + this._xmlFile.getAbsolutePath(), 3);
            this.setXMLDocument(this.readXML());
            if (this._traceLevel > 2) {
                this.displayRawDocument();
            }
            if (this._traceLevel > 1) {
                this.displayFormattedDocument();
            }
        } else {
            System.out.println("The format of file path is not correct. Please specify the correct format of file path.");
        }
    }

    public XMLUtility(StringBuffer stringBuffer) {
        this(stringBuffer, false);
    }

    public XMLUtility(StringBuffer stringBuffer, boolean bl) {
        this.traceEnter(this, "Constructor (rawXML) ");
        this.setValidateXML(bl);
        this.setXMLDocument(this.buildDoc(stringBuffer.toString()));
        if (this._traceLevel > 2) {
            this.displayRawDocument();
        }
        if (this._traceLevel > 1) {
            this.displayFormattedDocument();
        }
    }

    public void displayFormattedDocument() {
        this.displayFormattedDocument(this._doc);
    }

    public Writer createXmlWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null || string.trim().equals("")) {
            string = this._encoding;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, string));
        return bufferedWriter;
    }

    public void displayFormattedDocument(Document document) {
        this.traceEnter(this, "displayFormattedDocument");
        if (this._xmlFile != null) {
            this.traceLine("----------------------Display Formatted XML Document from File [ " + this._xmlFile.getName() + " ]----------------------- ", 0);
        } else {
            this.traceLine("----------------------[ Display Formatted XML Document from Raw Text  ]----------------------- ", 0);
        }
        try {
            Format format = Format.getPrettyFormat();
            format.setIndent("    ");
            XMLOutputter xMLOutputter = new XMLOutputter(format);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            xMLOutputter.output(document, (OutputStream)byteArrayOutputStream);
            this.traceIt(byteArrayOutputStream.toString(), 0);
        }
        catch (IOException iOException) {
            this.traceError(this, "displayFormattedDocument", iOException.toString());
            System.out.println(iOException);
        }
        this.traceExit(this, "displayFormattedDocument");
        this.traceLine("---------------------- End of Display XML Document----------------------- ", 0);
    }

    public void displayRawDocument() {
        this.displayRawDocument(this._doc);
    }

    public void displayRawDocument(Document document) {
        this.traceEnter(this, "displayRawDocument");
        if (this._xmlFile != null) {
            this.traceLine("----------------------Display Raw XML Document from File [ " + this._xmlFile.getName() + " ]----------------------- ", 0);
        } else {
            this.traceLine("----------------------[ Display Raw XML Document from Raw Text  ]----------------------- ", 0);
        }
        try {
            Format format = Format.getRawFormat();
            XMLOutputter xMLOutputter = new XMLOutputter(format);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            xMLOutputter.output(document, (OutputStream)byteArrayOutputStream);
            this.traceIt(byteArrayOutputStream.toString(), 0);
        }
        catch (IOException iOException) {
            this.traceError(this, "displayRawDocument", iOException.toString());
            System.out.println(iOException);
        }
        this.traceLine("---------------------- End of Display XML Document ----------------------- ", 0);
        this.traceExit(this, "displayRawDocument");
    }

    public Document createPropsDocument(Properties properties, String string, String string2) {
        this.traceEnter(this, "createPropsDocument");
        DefaultJDOMFactory defaultJDOMFactory = new DefaultJDOMFactory();
        DocType docType = defaultJDOMFactory.docType(string, string2);
        Element element = defaultJDOMFactory.element(string);
        Document document = defaultJDOMFactory.document(element, docType);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = properties.getProperty(string3);
            Element element2 = new Element(string3).setText(string4);
            document.getRootElement().addContent((Content)element2);
        }
        this.traceExit(this, "createPropsDocument");
        return document;
    }

    public Properties searchXMLAndBuildProperties(String string, String string2, String string3) {
        Element element;
        this.traceEnter(this, "searchXMLAndBuildProperties");
        List list = this.getAllElementsByName(string);
        this.traceLine("Number of parentElements = " + list.size(), 3);
        Element element2 = null;
        for (int i = 0; i < list.size(); ++i) {
            this.traceLine("Checking Reference Element:  " + ((Element)list.get(i)).getName(), 3);
            element = this.getFirstElementByValue((Element)list.get(i), string2, string3);
            if (element == null) continue;
            this.traceLine("refValue found:  " + string3, 3);
            element2 = element;
            break;
        }
        Properties properties = new Properties();
        if (element2 != null && (element = element2.getParentElement()) != null) {
            properties = this.buildProperties(element);
        }
        this.traceExit(this, "searchXMLAndBuildProperties");
        return properties;
    }

    public Properties buildProperties() {
        this.traceEnter(this, "buildProperties");
        Element element = this._doc.getRootElement();
        this.traceExit(this, "buildProperties");
        return this.buildProperties(element);
    }

    public Properties buildProperties(Element element) {
        this.traceEnter(this, "buildProperties");
        Properties properties = new Properties();
        this.addProps(properties, element);
        this.traceLine("Number of Properties found = " + properties.size());
        this.displayPropValues(properties);
        this.traceExit(this, "buildProperties");
        return properties;
    }

    public void displayPropValues(Properties properties) {
        this.traceLine("---------------- Display Properties --------------- ", 3);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.traceLine(string + " = [" + string2 + "]", 3);
        }
        this.traceLine("------------ End of Display Properties ----------- ", 3);
    }

    private void addProps(Properties properties, Element element) {
        this.traceEnter(this, "addProps");
        this.traceLine(element.getName(), 3);
        List list = element.getChildren();
        this.addAttributeProps(properties, element);
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            this.addElementProps(properties, element2);
            List list2 = element2.getChildren();
            if (list2 == null || list2.size() <= 0) continue;
            this.traceLine(element2.getName() + "has children", 3);
            this.addProps(properties, element2);
        }
        this.traceExit(this, "addProps");
    }

    private void addAttributeProps(Properties properties, Element element) {
        this.traceEnter(this, "addAttributeProps");
        this.traceLine(element.getName(), 3);
        String string = "";
        String string2 = "";
        if (this.hasAttributes(element)) {
            this.traceLine(element.getName() + " has some attributes", 3);
            List list = element.getAttributes();
            this.traceLine(list.size() + " attributes are to be added to prop list", 3);
            for (int i = 0; i < list.size(); ++i) {
                Attribute attribute = (Attribute)list.get(i);
                string = this.buildPropName(element) + "." + attribute.getName();
                string2 = attribute.getValue().trim();
                properties.setProperty(string, string2);
            }
        }
    }

    private void addElementProps(Properties properties, Element element) {
        this.traceEnter(this, "addElementProps");
        this.traceLine(element.getName(), 3);
        this.traceTypeName(element);
        String string = "";
        String string2 = "";
        if (!element.getTextTrim().equals("")) {
            this.traceLine(element.getName() + " has some text", 3);
            this.traceLine(element.getName() + " = [" + element.getTextTrim() + "]", 3);
            string = this.buildPropName(element);
            string2 = element.getTextTrim();
            properties.setProperty(string, string2);
            this.traceLine("propName = " + string, 3);
            this.traceLine("propValue = [" + string2 + "]", 3);
        }
    }

    private void addParmProps(Properties properties, Element element) {
        this.traceEnter(this, "addParmProps");
        this.traceLine(element.getName(), 3);
        this.addAttributeProps(properties, element);
        this.addElementProps(properties, element);
        List list = element.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            if (element2.getName().equals("guiDataType")) {
                this.addAttributeProps(properties, element2);
                this.addElementProps(properties, element2);
                List list2 = element2.getChildren();
                Vector<String> vector = new Vector<String>();
                boolean bl = false;
                String string = "propName";
                for (int j = 0; j < list2.size(); ++j) {
                    Element element3 = (Element)list2.get(j);
                    if (element3.getName().trim().equals("choice")) {
                        vector.add(element3.getTextTrim());
                        if (j != 0) continue;
                        string = this.buildPropName(element3);
                        bl = true;
                        continue;
                    }
                    this.addParmProps(properties, element3);
                }
                if (!bl) continue;
                properties.put(string, vector);
                continue;
            }
            this.addParmProps(properties, element2);
        }
        this.traceExit(this, "addParmProps");
    }

    public Vector buildParmPropArray() {
        Vector<Properties> vector = new Vector<Properties>();
        List list = this.getAllElementsByName("parameter");
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            vector.add(this.buildParmProps(element));
        }
        return vector;
    }

    private Properties buildParmProps(Element element) {
        Properties properties = new Properties();
        this.addParmProps(properties, element);
        return properties;
    }

    private String buildPropName(Element element) {
        String string = "";
        string = element.isRootElement() ? element.getName() : this.buildPropName(element.getParentElement()) + "." + element.getName();
        return string;
    }

    private boolean hasAttributes(Element element) {
        this.traceLine(element.getAttributes().size() + " attributes have been found", 3);
        return element.getAttributes().size() > 0;
    }

    private void traceTypeName(Object object) {
        this.traceEnter(this, "traceTypeName");
        if (object instanceof Element) {
            this.traceLine(((Element)object).getName() + " is an element", 3);
        }
        if (object instanceof String) {
            this.traceLine(((Element)object).getName() + " is a String", 3);
        }
        if (object instanceof Text) {
            this.traceLine(((Element)object).getName() + " is a Text", 3);
        }
        if (object instanceof CDATA) {
            this.traceLine(((Element)object).getName() + " is a CDATA", 3);
        }
        this.traceExit(this, "traceTypeName");
    }

    public String[][] buildTableData(Element element) {
        int n;
        String[][] stringArray;
        int n2;
        this.traceEnter(this, "buildTableData");
        this.traceLine("getting all the row elements", 3);
        List list = element.getChildren("row");
        int n3 = list.size();
        this.traceLine("rows found = " + n3, 3);
        this.traceLine("getting all the col elements", 3);
        int n4 = 0;
        for (n2 = 0; n2 < list.size(); ++n2) {
            stringArray = this.getAllElementsByName((Element)list.get(n2), "col");
            if (stringArray.size() <= n4) continue;
            n4 = stringArray.size();
        }
        n2 = n4 + 1;
        this.traceLine("cols found = " + n2, 3);
        stringArray = new String[n3][n2];
        for (n = 0; n < list.size(); ++n) {
            this.traceLine("row = " + n, 3);
            List list2 = this.getAllElementsByName((Element)list.get(n), "index");
            stringArray[n][0] = ((Element)list2.get(0)).getTextTrim().trim();
            list2 = this.getAllElementsByName((Element)list.get(n), "col");
            for (int i = 0; i < list2.size(); ++i) {
                this.traceLine("column = " + i, 3);
                stringArray[n][i + 1] = ((Element)list2.get(i)).getTextTrim().trim();
            }
        }
        this.traceLine("----------------------Display Table Built ----------------------- ", 3);
        for (n = 0; n < stringArray.length; ++n) {
            this.traceIt("Row " + n + " = ", 3);
            for (int i = 0; i < n2; ++i) {
                this.traceIt(stringArray[n][i] + " ", 3);
            }
            this.traceLine("", 3);
        }
        this.traceLine("---------------------- End of Display Built----------------------- ", 3);
        this.traceExit(this, "buildTableData");
        return stringArray;
    }

    public Properties[] buildColumnMetaData(Element element) {
        this.traceEnter(this, "buildColumnMetaData");
        this.traceLine("getting all the row elements", 3);
        List list = element.getChildren("row");
        int n = list.size();
        this.traceLine("rows found = " + n, 3);
        this.traceLine("getting all the col elements", 3);
        List list2 = ((Element)list.get(0)).getChildren("col");
        int n2 = list2.size() + 1;
        this.traceLine("cols found = " + n2, 3);
        Properties[] propertiesArray = new Properties[n2];
        for (int i = 0; i < list.size(); ++i) {
            this.traceLine("row = " + i, 3);
            list2 = this.getAllElementsByName((Element)list.get(i), "col");
            for (int j = 0; j < list2.size(); ++j) {
                this.traceLine("column = " + j, 3);
                propertiesArray[j] = this.buildProperties((Element)list2.get(j));
            }
        }
        this.traceExit(this, "buildColumnMetaData");
        return propertiesArray;
    }

    public Element getFirstElementByName(String string) {
        this.traceEnter(this, "getFirstElementByName");
        this.traceEnter(this, "Name requested = " + string);
        Element element = this._doc.getRootElement();
        this.traceEnter(this, "root element = " + element.getName());
        Element element2 = this.getFirstElementByName(element, string);
        this.traceEnter(this, "found element = " + element2.getName());
        this.traceExit(this, "getFirstElementByName");
        return element2;
    }

    public Element getFirstElementByName(Element element, String string) {
        this.traceEnter(this, "getFirstElementByName");
        this.traceEnter(this, "search in element = " + element.getName());
        List list = element.getChildren(string, element.getNamespace());
        this.traceEnter(this, "list size = " + list.size());
        Element element2 = (Element)list.get(0);
        this.traceEnter(this, "found element = " + element2.getName());
        this.traceExit(this, "getFirstElementByName");
        return element2;
    }

    public Element getFirstElementByValue(String string, String string2) {
        this.traceEnter(this, "getFirstElementByValue");
        Element element = this._doc.getRootElement();
        this.traceExit(this, "getFirstElementByValue");
        return this.getFirstElementByValue(element, string, string2);
    }

    public Element getFirstElementByValue(Element element, String string, String string2) {
        this.traceEnter(this, "getFirstElementByValue");
        this.traceLine("Element Name = " + string, 3);
        this.traceLine("Element Value = " + string2, 3);
        Element element2 = null;
        List list = element.getChildren(string, element.getNamespace());
        this.traceLine("Number of Children = " + list.size(), 3);
        for (int i = 0; i < list.size(); ++i) {
            this.traceLine("Element = " + ((Element)list.get(i)).getName(), 3);
            this.traceLine("Value = " + ((Element)list.get(i)).getText(), 3);
            if (!((Element)list.get(i)).getText().trim().equalsIgnoreCase(string2.trim())) continue;
            this.traceLine("Found Element = " + ((Element)list.get(i)).getName(), 3);
            element2 = (Element)list.get(i);
            break;
        }
        this.traceExit(this, "getFirstElementByValue");
        return element2;
    }

    public List getAllElementsByName(String string) {
        this.traceEnter(this, "getAllElementsByName(str)");
        Element element = this._doc.getRootElement();
        return this.getAllElementsByName(element, string);
    }

    public List getAllElementsByName(Element element, String string) {
        this.traceEnter(this, "getAllElementsByName(Element, str)");
        this.traceLine("Document name = " + element.getName(), 3);
        this.traceLine("Looking for = " + string, 3);
        List list = element.getChildren(string, element.getNamespace());
        List<Element> list2 = new Vector();
        if (list.size() == 0) {
            this.traceLine("List Size = " + list.size(), 3);
            list = element.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                this.traceLine("Child found = [" + ((Element)list.get(i)).getName() + "]");
                if (!((Element)list.get(i)).getName().equals(string)) continue;
                list2.add((Element)list.get(i));
            }
        } else {
            list2 = list;
            return list2;
        }
        return list2;
    }

    public Document readXML() {
        return this.readXML(this._xmlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document readXML(File file) {
        this.traceEnter(this, "readXML");
        Document document = null;
        XMLUtility xMLUtility = this;
        synchronized (xMLUtility) {
            try {
                SAXBuilder sAXBuilder = new SAXBuilder(this._validateXML);
                document = sAXBuilder.build(file);
            }
            catch (JDOMException jDOMException) {
                this.traceError(this, "readXML", "Error reading " + file);
                this.traceError(this, "readXML", "Error message: " + jDOMException.getCause() + " " + jDOMException.getMessage());
            }
            catch (IOException iOException) {
                this.traceError(this, "readXML", "Error reading " + file);
                this.traceError(this, "readXML", "Error message: " + iOException.getCause() + " " + iOException.getMessage());
            }
        }
        this.traceExit(this, "readXML");
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document buildDoc(String string) {
        this.traceEnter(this, "buildDoc");
        Document document = null;
        XMLUtility xMLUtility = this;
        synchronized (xMLUtility) {
            try {
                SAXBuilder sAXBuilder = new SAXBuilder(this._validateXML);
                StringReader stringReader = new StringReader(string);
                document = sAXBuilder.build((Reader)stringReader);
            }
            catch (JDOMException jDOMException) {
                this.traceError(this, "readXML", "Error parsing raw XML");
                this.traceError(this, "readXML", "Error message: " + jDOMException.getCause() + " " + jDOMException.getMessage());
            }
            catch (IOException iOException) {
                this.traceError(this, "readXML", "Error parsing raw XML");
                this.traceError(this, "readXML", "Error message: " + iOException.getCause() + " " + iOException.getMessage());
            }
        }
        this.traceExit(this, "readXML");
        return document;
    }

    public void setValidateXML(boolean bl) {
        this._validateXML = bl;
    }

    public boolean getValidateXML() {
        return this._validateXML;
    }

    public Document getXMLDocument() {
        return this._doc;
    }

    public void setXMLDocument(Document document) {
        this._doc = document;
    }

    protected void traceEnter(Object object, String string) {
        if (this._traceThis) {
            System.out.println("Entering " + object.getClass().getName() + "." + string);
        }
    }

    protected void traceExit(Object object, String string) {
        if (this._traceThis) {
            System.out.println("Exiting " + object.getClass().getName() + "." + string);
        }
    }

    protected void traceError(Object object, String string, String string2) {
        if (this._traceThis) {
            System.out.println("Error in: " + object.getClass().getName() + "." + string + ": " + string2);
        }
    }

    protected void traceLine(String string, int n) {
        if (n <= this._traceLevel) {
            this.traceLine(string);
        }
    }

    protected void traceIt(String string, int n) {
        if (n <= this._traceLevel) {
            this.traceLine(string);
        }
    }

    protected void traceLine(String string) {
        if (this._traceThis) {
            System.out.println(string);
        }
    }

    protected void trace(String string) {
        if (this._traceThis) {
            System.out.print(string);
        }
    }

    public boolean isNormalPath(String string) {
        return string != null && string.length() > 0;
    }
}

