/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.aseplugin.util.ui;

import com.sybase.asa.ASASpinBox;
import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;

public class SpinBoxCellEditor
extends DefaultCellEditor
implements ASASpinBoxChangeListener {
    private static final long serialVersionUID = 1L;
    private ASASpinBox _spinBox = null;
    private Integer _cellData = null;
    private JTextField _textField = null;
    private ArrayList _spinBoxChangedListeners = new ArrayList();
    private boolean isInited = false;

    public SpinBoxCellEditor(ASASpinBox aSASpinBox) {
        this(aSASpinBox, new Integer(0));
    }

    public SpinBoxCellEditor(ASASpinBox aSASpinBox, Integer n) {
        super((JTextField)aSASpinBox.getTextField());
        this._spinBox = aSASpinBox;
        this.editorComponent = null;
        this._spinBox.setBorder(null);
        this._textField = this._spinBox.getTextField();
        this._textField.setHorizontalAlignment(2);
        this._textField.setBorder(BorderFactory.createEtchedBorder());
    }

    public void addASASpinBoxChangeListener(ASASpinBoxChangeListener aSASpinBoxChangeListener) {
        this._spinBoxChangedListeners.add(aSASpinBoxChangeListener);
    }

    public void removeASASpinBoxChangeListener(ASASpinBoxChangeListener aSASpinBoxChangeListener) {
        this._spinBoxChangedListeners.remove(aSASpinBoxChangeListener);
    }

    public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
        for (int i = 0; i < this._spinBoxChangedListeners.size(); ++i) {
            ((ASASpinBoxChangeListener)this._spinBoxChangedListeners.get(i)).valueChanged(aSASpinBoxChangeEvent);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this._cellData = (Integer)object;
        if (object == null) {
            this._cellData = new Integer(this._spinBox.getMinimum());
        }
        if (this._spinBox.getValue() != this._cellData.intValue()) {
            this._spinBox.setValue(this._cellData.intValue());
        }
        if (!this.isInited) {
            this._spinBox.addSpinBoxChangeListener((ASASpinBoxChangeListener)this);
            this.isInited = !this.isInited;
        }
        return this._spinBox;
    }

    @Override
    public Object getCellEditorValue() {
        return this._cellData;
    }

    public ASASpinBox getSpinBox() {
        return this._spinBox;
    }

    @Override
    public boolean stopCellEditing() {
        Integer n = null;
        if (this._textField.getText().equals("")) {
            n = new Integer(this._spinBox.getMinimum());
        } else {
            n = new Integer(this._textField.getText());
            if (n > this._spinBox.getMaximum()) {
                n = new Integer(this._spinBox.getMaximum());
            } else if (n < this._spinBox.getMinimum()) {
                n = new Integer(this._spinBox.getMinimum());
            }
        }
        if (!n.equals(this._cellData)) {
            this._cellData = n;
            this._spinBox.setValue(this._cellData.intValue());
        }
        boolean bl = super.stopCellEditing();
        if (this.isInited) {
            this._spinBox.removeSpinBoxChangeListener((ASASpinBoxChangeListener)this);
            this.isInited = !this.isInited;
        }
        return bl;
    }

    void releaseResources() {
        this._spinBox.releaseResources();
        this._spinBox = null;
        this._textField = null;
    }
}

