/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen;

import com.sybase.ddlgen.ConnectionPool;
import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.Initializer;
import com.sybase.ddlgen.Interpreter;
import com.sybase.ddlgen.ThreadPool;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.io.DDLFileWriter;
import com.sybase.ddlgen.io.PasswordConsole;
import java.io.IOException;

public class DDLGenerator {
    private String[] _args;
    private ThreadPool _threadPool = null;
    private ConnectionPool _connectionPool = null;
    private String _ddlString;
    private DDLGlobalParameters _ddlGlobalParameters;

    public DDLGenerator(String[] stringArray, boolean bl) throws DDLBaseException {
        this._args = stringArray;
        this._ddlGlobalParameters = new DDLGlobalParameters();
        if (this._ddlGlobalParameters == null) {
            throw new DDLBaseException("DG14", "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
        }
        this._ddlGlobalParameters.setPersistence(bl);
        if (bl) {
            this.initConnectionPool();
        }
    }

    public DDLGenerator(String[] stringArray) throws DDLBaseException {
        this._args = stringArray;
        this._ddlGlobalParameters = new DDLGlobalParameters();
        if (this._ddlGlobalParameters == null) {
            throw new DDLBaseException("DG1", "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
        }
    }

    public static void main(String[] stringArray) {
        DDLGenerator dDLGenerator = null;
        try {
            dDLGenerator = new DDLGenerator(stringArray);
            dDLGenerator._ddlGlobalParameters.setApplicationMode(false);
            dDLGenerator.generateDDL();
        }
        catch (DDLBaseException dDLBaseException) {
            new DDLBaseException("DG2", (Exception)dDLBaseException, "INTERNAL_ERROR", 1, dDLGenerator._ddlGlobalParameters);
        }
        System.exit(0);
    }

    public String generateDDL() throws DDLBaseException {
        Object object;
        this.initParams();
        this.checkParams();
        if (this._ddlGlobalParameters.getPassword() == null || this._ddlGlobalParameters.getPassword().equals("ext")) {
            this.promptUserForPassword();
        }
        this.createFileWriters();
        if (!this._ddlGlobalParameters.isPersistent()) {
            this.initConnectionPool();
        }
        this._threadPool = new ThreadPool(this._connectionPool, this._ddlGlobalParameters);
        try {
            object = (DDLBaseContainer)Class.forName("com.sybase.ddlgen.container." + this._ddlGlobalParameters.getObjectClassName(this._ddlGlobalParameters.getObjectType()) + "Container").newInstance();
            ((DDLBaseContainer)object).setType(this._ddlGlobalParameters.getObjectType());
            ((DDLBaseContainer)object).setDDLGlobalParameters(this._ddlGlobalParameters);
            ((DDLBaseContainer)object).load(this._threadPool);
        }
        catch (Exception exception) {
            throw new DDLBaseException("DG3", exception, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
        }
        while (this._ddlGlobalParameters.getDDLStatus() == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                throw new DDLBaseException("DG4", (Exception)interruptedException, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
            }
        }
        if (this._ddlGlobalParameters.getDDLStatus() == 2 || this._ddlGlobalParameters.getException() != null) {
            this._ddlGlobalParameters.setDDLStatus((byte)0);
            this._ddlGlobalParameters.setDDLString(null);
            object = this._ddlGlobalParameters.getException();
            if (object != null) {
                this._ddlGlobalParameters.setException(null);
                throw object;
            }
            throw new DDLBaseException("DG5", "INTERNAL_ERROR", this._ddlGlobalParameters.getDDLErrorString(), false, 1, this._ddlGlobalParameters);
        }
        object = this._ddlGlobalParameters.getDDLString();
        this._ddlGlobalParameters.setDDLStatus((byte)0);
        this._ddlGlobalParameters.setDDLString(null);
        DDLFileWriter dDLFileWriter = this._ddlGlobalParameters.getOutputWriter();
        if (dDLFileWriter == null) {
            if (!this._ddlGlobalParameters.getApplicationMode()) {
                System.out.print((String)object);
            }
        } else {
            dDLFileWriter.writeLine((String)object);
        }
        this.closeFileWriters();
        if (!this._ddlGlobalParameters.isPersistent()) {
            this.cleanConnectionPool();
        }
        this.cleanThreadPool();
        return object;
    }

    private void checkParams() {
        Interpreter.checkReqdParams(this._ddlGlobalParameters);
    }

    private void initParams() {
        Initializer.init(this._args, this._ddlGlobalParameters);
    }

    private void initConnectionPool() {
        this._connectionPool = new ConnectionPool(this._ddlGlobalParameters);
    }

    private void cleanThreadPool() {
        this._threadPool.clean();
        if (this._threadPool != null) {
            this._threadPool = null;
        }
    }

    private void cleanConnectionPool() {
        this._connectionPool.clean();
        if (this._connectionPool != null) {
            this._connectionPool = null;
        }
    }

    private void createFileWriters() {
        String string = this._ddlGlobalParameters.getOutputFileName();
        if (string != null) {
            try {
                this._ddlGlobalParameters.setOutputWriter(new DDLFileWriter(string, this._ddlGlobalParameters, this._args));
            }
            catch (IOException iOException) {
                new DDLBaseException("DG6", iOException, "FILE_WRITING_ERROR", 4, string, this._ddlGlobalParameters);
            }
        }
        string = null;
        string = this._ddlGlobalParameters.getErrorLogFileName();
        if (string != null) {
            try {
                this._ddlGlobalParameters.setErrorWriter(new DDLFileWriter(string, this._ddlGlobalParameters, this._args));
            }
            catch (IOException iOException) {
                new DDLBaseException("DG7", iOException, "FILE_WRITING_ERROR", 4, string, this._ddlGlobalParameters);
            }
        }
        string = null;
        string = this._ddlGlobalParameters.getProgressLogFileName();
        if (string != null) {
            try {
                this._ddlGlobalParameters.setProgressLogWriter(new DDLFileWriter(string, this._ddlGlobalParameters, this._args, true));
            }
            catch (IOException iOException) {
                new DDLBaseException("DG8", iOException, "FILE_WRITING_ERROR", 4, string, this._ddlGlobalParameters);
            }
        }
        string = null;
        try {
            String string2 = Initializer.getVersionString();
            int n = string2.indexOf("DEBUG");
            if (n != -1) {
                string = (string2 = string2.substring(n + 5).trim()).length() > 0 ? string2 : null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            try {
                this._ddlGlobalParameters.setDebugLogWriter(new DDLFileWriter(string, this._ddlGlobalParameters, this._args));
            }
            catch (IOException iOException) {
                new DDLBaseException("DG9", iOException, "FILE_WRITING_ERROR", 4, string, this._ddlGlobalParameters);
            }
        }
    }

    public final void setParams(String[] stringArray) {
        this._args = stringArray;
        this._ddlGlobalParameters.setIsUseDBAlreadyUsed(false);
    }

    public static String getVersion() throws Exception {
        return Initializer.getFullVersionString();
    }

    public void closeFileWriters() {
        DDLFileWriter dDLFileWriter = this._ddlGlobalParameters.getOutputWriter();
        if (dDLFileWriter != null) {
            try {
                dDLFileWriter.close();
            }
            catch (IOException iOException) {
                new DDLBaseException("DG10", iOException, "FILE_CLOSING_ERROR", 4, this._ddlGlobalParameters.getOutputFileName(), this._ddlGlobalParameters);
            }
        }
        if ((dDLFileWriter = this._ddlGlobalParameters.getErrorWriter()) != null) {
            try {
                dDLFileWriter.close();
            }
            catch (IOException iOException) {
                new DDLBaseException("DG11", iOException, "FILE_CLOSING_ERROR", 4, this._ddlGlobalParameters.getOutputFileName(), this._ddlGlobalParameters);
            }
        }
        if ((dDLFileWriter = this._ddlGlobalParameters.getProgressLogWriter()) != null) {
            try {
                dDLFileWriter.close();
            }
            catch (IOException iOException) {
                new DDLBaseException("DG12", iOException, "FILE_CLOSING_ERROR", 4, this._ddlGlobalParameters.getOutputFileName(), this._ddlGlobalParameters);
            }
        }
        if ((dDLFileWriter = this._ddlGlobalParameters.getDebugWriter()) != null) {
            try {
                dDLFileWriter.close();
            }
            catch (IOException iOException) {
                new DDLBaseException("DG13", iOException, "FILE_CLOSING_ERROR", 4, this._ddlGlobalParameters.getOutputFileName(), this._ddlGlobalParameters);
            }
        }
    }

    private void promptUserForPassword() {
        try {
            char[] cArray = PasswordConsole.readConsoleSecure(this._ddlGlobalParameters);
            this._ddlGlobalParameters.setPassword(new String(cArray));
        }
        catch (Exception exception) {
            new DDLBaseException("DG15", exception, 1, this._ddlGlobalParameters);
        }
    }

    protected void finalize() {
        this.cleanConnectionPool();
    }
}

