/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen;

import com.sybase.ddlgen.ConnectionPool;
import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.DDLThread;
import java.util.Vector;

public class ThreadPool {
    private ConnectionPool _connectionPoolRef;
    private boolean _status = true;
    private Vector _freeThreads;
    private boolean _freeAvailableThread = false;
    private int _threadsCreated = 0;
    private DDLGlobalParameters _ddlGlobalParameters;

    public ThreadPool(ConnectionPool connectionPool, DDLGlobalParameters dDLGlobalParameters) {
        this._connectionPoolRef = connectionPool;
        this._freeThreads = new Vector();
        this._ddlGlobalParameters = dDLGlobalParameters;
    }

    public synchronized DDLThread getFreeThread() {
        DDLThread dDLThread = null;
        try {
            if (this._freeThreads.size() == 0) {
                if (this._threadsCreated < DDLGlobalParameters.getMaxConnections()) {
                    this.createNewDDLThread();
                } else {
                    return null;
                }
            }
            dDLThread = (DDLThread)this._freeThreads.firstElement();
            this._freeThreads.removeElementAt(0);
        }
        catch (Exception exception) {
            new DDLBaseException("TP1", exception, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
        }
        return dDLThread;
    }

    public synchronized void depositFreeThread(DDLThread dDLThread) {
        if (this._freeThreads != null) {
            this._freeThreads.addElement(dDLThread);
            this._freeAvailableThread = true;
        } else {
            new DDLBaseException("TP2", "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
        }
    }

    private void createNewDDLThread() {
        DDLThread dDLThread = new DDLThread(this);
        dDLThread.start();
        this._freeThreads.addElement(dDLThread);
        ++this._threadsCreated;
    }

    public ConnectionPool getConnectionPool() {
        return this._connectionPoolRef;
    }

    public boolean getStatus() {
        return this._status;
    }

    public void setStatusComplete() {
        this._status = false;
    }

    public void clean() {
        this._status = false;
        try {
            for (int i = 0; i < this._freeThreads.size(); ++i) {
                this._freeThreads.setElementAt(null, i);
            }
        }
        catch (Exception exception) {
            new DDLBaseException("TP3", exception, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
        }
        if (this._freeThreads != null) {
            this._freeThreads.removeAllElements();
            this._freeThreads = null;
        }
    }

    protected DDLGlobalParameters getDDLGlobalParameters() {
        return this._ddlGlobalParameters;
    }
}

