/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.container;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.CacheItem;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class CacheContainer
extends DDLBaseContainer {
    private static final int ALL_CACHES = 0;
    private static final int GLOBAL_CACHES = 1;
    private static final int LOCAL_CACHES = 2;
    private static final int GLOBAL_CACHE = 3;
    private static final int LOCAL_CACHE = 4;
    private static final int IM_CACHES = 5;
    private static final int CACHE_COLUMN = 1;
    private static final int INSTANCE_COLUMN = 5;
    private static final String WILDCARD = "%";

    public CacheContainer(DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
    }

    public CacheContainer() {
    }

    private String getInstanceName(String string) {
        String string2 = "";
        int n = string.indexOf(".");
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private String getCacheName(String string) {
        String string2 = string;
        int n = string.indexOf(".");
        if (n > -1) {
            string2 = string.substring(n + 1, string.length());
        }
        return string2;
    }

    private int getCacheType() {
        int n = -1;
        ArrayList arrayList = this._ddlGlobalParameters.getExtendedObjectTypes();
        String string = this._ddlGlobalParameters.getObjectName();
        String string2 = this.getInstanceName(string);
        String string3 = this.getCacheName(string);
        if (arrayList.size() > 0) {
            if (arrayList.contains("OU") && string2.length() == 0 && string3.equals(WILDCARD)) {
                n = 1;
            } else if (arrayList.contains("OD") && string2.length() > 0 && (string3.equals(WILDCARD) || string2.equals(WILDCARD))) {
                n = 2;
            } else if (arrayList.contains("OI") && string3.equals(WILDCARD)) {
                n = 5;
            }
        } else if (string3.equals(WILDCARD) && string2.length() == 0) {
            n = 0;
        } else if (string2.length() > 0 && !string2.equals(WILDCARD)) {
            n = 4;
        } else if (string3.length() > 0 && !string3.equals(WILDCARD)) {
            n = 3;
        }
        return n;
    }

    @Override
    public void open(ASConnection aSConnection) {
        Object[] objectArray;
        Object object;
        int n;
        ASResultSet aSResultSet = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            aSResultSet = new ASResultSet(aSConnection);
            if (this._parent != null) {
                string2 = WILDCARD;
            } else {
                string = this._ddlGlobalParameters.getObjectName();
                string3 = CacheContainer.ignorePatternCharacters(this.getInstanceName(string));
                string2 = CacheContainer.ignorePatternCharacters(this.getCacheName(string));
            }
            if (aSResultSet != null) {
                n = this.getCacheType();
                object = Integer.toString(5) + "," + Integer.toString(1);
                objectArray = new String[]{string2, string3, object};
                switch (n) {
                    case 2: 
                    case 4: {
                        if (!aSConnection.isCluster()) break;
                        aSResultSet.open(ASQueryParser.parseQuery("select a.name, a.status, a.value, a.value4, c.name from master.dbo.sysconfigures a, master.dbo.sysinstances c where parent = 19 and config = parent and a.name like ''{0}'' and a.instanceid = c.id and c.name like ''{1}'' order by {2}", objectArray), "CACHE_SDC_GLOBAL_QUERY");
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (aSConnection.isCluster()) {
                            aSResultSet.open(ASQueryParser.parseQuery("select a.name, a.status, a.value, a.value4 from master.dbo.sysconfigures a where parent = 19 and config = parent and a.name like ''{0}'' and a.instanceid is null order by 1", objectArray), "CACHE_SDC_GLOBAL_QUERY");
                            break;
                        }
                        aSResultSet.open(ASQueryParser.parseQuery("select a.name, a.status, a.value, a.value4 from master.dbo.sysconfigures a where parent = 19 and config = parent and a.name like ''{0}'' order by 1", objectArray), "CACHE_NO_SDC_GLOBAL_QUERY");
                        break;
                    }
                    case 5: {
                        if (aSConnection.isCluster()) break;
                        aSResultSet.open(ASQueryParser.parseQuery("select a.name, a.status, a.value, a.value4 from master.dbo.sysconfigures a where parent = 19 and config = parent and a.name like ''{0}'' and a.status&196640=196640 order by 1", objectArray), "CACHE_NO_SDC_IM_QUERY");
                        break;
                    }
                    case 0: {
                        if (aSConnection.isCluster()) {
                            aSResultSet.open(ASQueryParser.parseQuery("select a.name, a.status, a.value, a.value4, null from master.dbo.sysconfigures a where parent = 19 and config = parent and a.instanceid is null union select a.name, a.status, a.value, a.value4, c.name from master.dbo.sysconfigures a, master.dbo.sysinstances c where parent = 19 and config = parent and a.instanceid = c.id", null), "CACHE_CTR_SDC_OPEN_QUERY");
                            break;
                        }
                        aSResultSet.open(ASQueryParser.parseQuery("select a.name, a.status, a.value, a.value4 from master.dbo.sysconfigures a where parent = 19 and config = parent order by 1", null), "CACHE_CTR_SDC_OPEN_QUERY");
                        break;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("C1", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("C2", exception, "INTERNAL_ERROR", 1);
        }
        n = 0;
        this._ddlGlobalParameters.setDatabaseName("master");
        try {
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                object = new CacheItem(stringArray, this);
                ++n;
                objectArray = this._threadPool.getFreeThread();
                if (objectArray != null) {
                    objectArray.setItem((DDLBaseItem)object);
                } else {
                    ((CacheItem)object).open(aSConnection);
                }
                this._children.addElement(object);
            }
            if (aSResultSet != null) {
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("C3", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("C4", exception, "INTERNAL_ERROR", 1);
        }
        if (n == 0 && this._parent == null) {
            new DDLBaseException("C5", "CACHE_NOT_FOUND_ERROR", 2, string2);
        }
        if (aSResultSet != null) {
            aSResultSet = null;
        }
        if (n > 0) {
            this.generateDDL();
        } else {
            this._ddlString = "";
            this.setThreadPoolStatus();
        }
    }
}

