/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.container;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.container.CompiledObjectContainer;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.container.DatabaseMetaContainer;
import com.sybase.ddlgen.container.Device;
import com.sybase.ddlgen.container.EncryptedKeyContainer;
import com.sybase.ddlgen.container.GroupContainer;
import com.sybase.ddlgen.container.SegmentContainer;
import com.sybase.ddlgen.container.UserContainer;
import com.sybase.ddlgen.container.UserDefinedDatatypeContainer;
import com.sybase.ddlgen.container.UserTableMetaContainer;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

public class DatabaseContainer
extends DDLBaseContainer {
    private final int DEV_NAME = 1;
    private final int DEV_SIZE = 2;
    private final int DEV_TYPE = 3;
    private final int LOG_DEVICE = 0;
    private final long DB_ATTR_SELECT_INTO = 4L;
    private final long DB_ATTR_TRUNC_LOG = 8L;
    private final long DB_ATTR_NO_CHECKPT = 16L;
    private final long DB_ATTR_DDL_IN_TRAN = 512L;
    private final long DB_ATTR_READ_ONLY = 1024L;
    private final long DB_ATTR_DBO_USE_ONLY = 2048L;
    private final long DB_ATTR_SINGLE_USER = 4096L;
    private final long DB_ATTR_ALLOW_NULLS = 8192L;
    private final long DB_ATTR_ABORT_TRAN = 1L;
    private final long DB_ATTR_NO_FREE_SPACE = 2L;
    private final long DB_ATTR_AUTO_IDENTITY = 4L;
    private final long DB_ATTR_IDENTITY_IN_NONUNIQUE_INDEX = 8L;
    private final long DB_ATTR_SCRATCH_DB = 0x1000000L;
    private final long DB_ATTR_WIDE_DOL_ROWS = 524288L;
    protected static final String ARCHIVEDB_STATUS3 = "4194304";
    protected static final short DB = 0;
    protected static final short TEMP_DB = 1;
    protected static final short ARCHIVE_DB = 2;
    protected static final short IM_DB = 3;
    protected static final short IM_TEMP_DB = 4;
    private short _dbType = 0;
    private String _ownerName;
    private long _status;
    private long _status2;
    private long _status3;
    private long _status4;
    private String _defaultRemoteLocation;
    public static final String DURABILITY_NO_RECOVERY_TEXT = "NO_RECOVERY";
    public static final String DURABILITY_SHUTDOWN_TEXT = "AT_SHUTDOWN";
    public static final String FULL_TEXT = "FULL";
    public static final String DMLLOGGING_MINIMAL_TEXT = "MINIMAL";
    public static final int DURABILITY_NO_RECOVERY = 6;
    public static final int DURABILITY_SHUTDOWN = 5;
    public static final int DURABILITY_FULL = 1;

    public DatabaseContainer(String[] stringArray, DDLBaseContainer dDLBaseContainer, DDLGlobalParameters dDLGlobalParameters) {
        this._parent = dDLBaseContainer;
        this._name = stringArray[0];
        this._ownerName = stringArray[1];
        this._defaultRemoteLocation = stringArray[5];
        this.setDDLGlobalParameters(dDLGlobalParameters);
        try {
            this._status = new Integer(stringArray[2]).longValue();
            this._status2 = new Integer(stringArray[3]).longValue();
            this._status3 = new Integer(stringArray[4]).longValue();
            this._status4 = new Integer(stringArray[6]).longValue();
        }
        catch (Exception exception) {
            new DDLBaseException("DB51", exception, "INTERNAL_ERROR", 1);
        }
    }

    public DatabaseContainer() {
        this._parent = null;
    }

    @Override
    public void open(ASConnection aSConnection) {
        ArrayList arrayList = this._ddlGlobalParameters.getFilters();
        ArrayList arrayList2 = this._ddlGlobalParameters.getExtendedObjectTypes();
        if ((arrayList.contains("PC") || arrayList.contains("%")) && arrayList2.contains("PN")) {
            new DDLBaseException("DB64", "PARTITION_CONFICT_ARGUMENT_ERROR", 0);
        }
        if (!(arrayList.contains("%") || this._dbType != 0 && this._dbType != 2 && this._dbType != 3)) {
            this.addChildren(aSConnection);
        }
        this._ddlString = this.getCreateDatabaseDDL(aSConnection);
        if (this._dbType == 1 || this._dbType == 4) {
            this._ddlString = this._ddlString + this.getTempDBGroupSQL(aSConnection);
            this._ddlString = this._ddlString + this.getTempDBBindingsSQL(aSConnection);
        }
        this.generateDDLs();
    }

    private String getRemoteLocation() {
        if (this._defaultRemoteLocation.equals("")) {
            return "";
        }
        return "sp_defaultloc '" + this._name + "', '" + this._defaultRemoteLocation + "'\n" + "go " + "\n\n";
    }

    public final String getIfExistsStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IF EXISTS (").append(ASQueryParser.parseQuery("SELECT 1 FROM sysdatabases WHERE name = ''{0}''", new String[]{this._name})).append(")\n\t").append(ASQueryParser.parseQuery("drop database {0}", new String[]{this._name})).append("\n\n").append("IF (@@error != 0)\n").append("BEGIN\n").append("\tPRINT \"Error CREATING database '" + this._name + "'\"\n").append("\tSELECT syb_quit()\n").append("END\ngo\n\n");
        return stringBuffer.toString();
    }

    private String getCreateDatabaseDDL(ASConnection aSConnection) {
        Object[] objectArray;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._dbType != 2 && (objectArray = aSConnection.executeSP_DDLGen("database", this._name)) != null && !objectArray.trim().equals("")) {
            return (String)objectArray + this.getDBOptions() + this.getRemoteLocation();
        }
        if (this._dbType == 0) {
            stringBuffer.append("\n-----------------------------------------------------------------------------\n-- DDL for ").append("Database '").append(this._name).append("'\n-----------------------------------------------------------------------------\n").append("print '<<<<< CREATING Database - ");
        } else if (this._dbType == 1) {
            stringBuffer.append("\n-----------------------------------------------------------------------------\n-- DDL for ").append("Temporary Database '").append(this._name).append("'\n-----------------------------------------------------------------------------\n").append("print '<<<<< CREATING Temporary Database - ");
        } else {
            stringBuffer.append("\n-----------------------------------------------------------------------------\n-- DDL for ").append("Archive Database '").append(this._name).append("'\n-----------------------------------------------------------------------------\n").append("print '<<<<< CREATING Archive Database - ");
        }
        stringBuffer.append(this._name).append(" >>>>>'\ngo\n\n");
        stringBuffer.append("use master\ngo\n\n");
        if (!this._ddlGlobalParameters.getFilters().contains("IE") && !this._ddlGlobalParameters.getFilters().contains("%")) {
            stringBuffer.append(this.getIfExistsStatement());
        }
        if (this._dbType == 0) {
            stringBuffer.append("create database ");
        } else if (this._dbType == 1) {
            stringBuffer.append("create temporary database ");
        } else {
            stringBuffer.append("create archive database ");
        }
        stringBuffer.append(this._name).append(" on");
        Vector<Device> vector = null;
        Vector<Device> vector2 = null;
        String string = "";
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            objectArray = new String[]{this._name};
            if (aSConnection.getServerVersion().compareTo("15") >= 0) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT d.name, convert(int, round((v.low * convert(float, u.size))/1048576, 0)), sign(u.segmap & (~4)) FROM master..sysusages u, master..spt_values v, master..sysdevices d WHERE u.dbid = db_id( ''{0}'' ) AND d.status & 2 = 2 AND v.type = ''E'' AND v.number = 1 and u.vdevno=d.vdevno", objectArray), "ATTRIBUTES_OF_DATABASE_QUERY");
            } else {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT d.name, convert(int, round((v.low * convert(float, u.size))/1048576, 0)), sign(u.segmap & (~4)) FROM master..sysusages u, master..spt_values v, master..sysdevices d WHERE d.low <= u.vstart and d.high >= u.size + u.vstart -1 AND u.dbid = db_id( ''{0}'' ) AND d.status & 2 = 2 AND v.type = ''E'' AND v.number = 1", objectArray), "ATTRIBUTES_OF_DATABASE_QUERY_PRE150");
            }
            String string2 = "";
            int n = 0;
            int n2 = -1;
            String string3 = "";
            string = "";
            vector2 = new Vector<Device>();
            vector = new Vector<Device>();
            while (aSResultSet.getNextRow()) {
                string2 = aSResultSet.getColumnString(1);
                n = aSResultSet.getColumnInt(2);
                if (aSResultSet.getColumnInt(3) == 0) {
                    n2 = this.findDeviceByName(string2, vector);
                    if (n2 != -1) {
                        ((Device)vector.elementAt(n2)).addSize(n);
                        continue;
                    }
                    vector.addElement(new Device(string2, n));
                    continue;
                }
                n2 = this.findDeviceByName(string2, vector2);
                if (n2 != -1) {
                    ((Device)vector2.elementAt(n2)).addSize(n);
                    continue;
                }
                vector2.addElement(new Device(string2, n));
            }
            for (int i = 0; i < vector2.size(); ++i) {
                Device device = (Device)vector2.elementAt(i);
                string3 = string3 + " " + device.getName() + " = " + device.getSize() + ",";
            }
            string3 = string3.substring(0, string3.length() - 1);
            stringBuffer.append(string3);
        }
        catch (SQLException sQLException) {
            new DDLBaseException("DB60", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("DB61", exception, "INTERNAL_ERROR", 1);
        }
        if (this._dbType == 2) {
            try {
                objectArray = new String[]{this._name};
                aSResultSet.open(ASQueryParser.parseQuery("SELECT a.char_value from master.dbo.sysattributes a, master.dbo.sysdatabases d where a.attribute = 0 and a.object = d.dbid and a.object_type = ''D''and d.name = ''{0}'' ", objectArray), "ARCHIVE_SCRATCH_DB");
                if (aSResultSet.getNextRow()) {
                    stringBuffer.append(" ").append("with").append(" ").append("SCRATCH_DATABASE").append(" = ").append(aSResultSet.getColumnString(1));
                }
            }
            catch (SQLException sQLException) {
                new DDLBaseException("DB62", (Exception)sQLException, 2, this._name);
            }
            catch (Exception exception) {
                new DDLBaseException("DB63", exception, "INTERNAL_ERROR", 1);
            }
            stringBuffer.append("\ngo\n\n");
        } else {
            try {
                if (!vector.isEmpty()) {
                    for (int i = 0; i < vector.size(); ++i) {
                        Device device = (Device)vector.elementAt(i);
                        string = string + " " + device.getName() + " = " + device.getSize() + ",";
                        if (this.findDeviceByName(device.getName(), vector2) == -1) continue;
                        bl = true;
                    }
                    string = string.substring(0, string.length() - 1);
                    stringBuffer.append("\nlog on");
                    stringBuffer.append(string);
                    if (bl) {
                        stringBuffer.append("\nwith override");
                    }
                }
                stringBuffer.append("\ngo\n\n");
                objectArray = new String[]{this._name};
                aSResultSet.open(ASQueryParser.parseQuery("SELECT char_value,object_type FROM master.dbo.sysattributes WHERE class=3 AND attribute=0 AND object= db_id(''{0}'')", objectArray), "CACHE_BINDINGS_OF_DATABASE_QUERY");
                if (aSResultSet.getNextRow()) {
                    stringBuffer.append("sp_bindcache '");
                    stringBuffer.append(aSResultSet.getColumnString(1));
                    stringBuffer.append("', '");
                    stringBuffer.append(this._name);
                    stringBuffer.append("'\ngo\n\n");
                }
                objectArray = new String[]{this._name};
                aSResultSet.open(ASQueryParser.parseQuery("select int_value from master.dbo.sysattributes where class=10 and attribute=6 and object_type=''D'' and object=db_id(''{0}'')", objectArray), "DB_RECOVERY_ORDER");
                if (aSResultSet.getNextRow()) {
                    stringBuffer.append("sp_dbrecovery_order ");
                    stringBuffer.append(this._name).append(", ");
                    stringBuffer.append(aSResultSet.getColumnString(1));
                    stringBuffer.append("\ngo\n\n");
                }
                objectArray = new String[]{this._name};
                aSResultSet.open(ASQueryParser.parseQuery("select int_value from {0}.dbo.sysattributes where object=object_id(''syslogs'') and object_type=''T'' and char_value=NULL", objectArray), "LOG_IO_SIZE_OF_DB");
                if (aSResultSet.getNextRow()) {
                    stringBuffer.append("use ").append(this._name);
                    stringBuffer.append("\ngo\n\n");
                    stringBuffer.append("sp_logiosize '");
                    stringBuffer.append(aSResultSet.getColumnString(1));
                    stringBuffer.append("'\ngo\n\n");
                }
                stringBuffer.append(this.getExpansionPolicy(aSConnection));
                this._ddlDepString = this.getDBOptions() + this.getRemoteLocation();
            }
            catch (SQLException sQLException) {
                new DDLBaseException("DB52", (Exception)sQLException, 2, this._name);
            }
            catch (Exception exception) {
                new DDLBaseException("DB53", exception, "INTERNAL_ERROR", 1);
            }
        }
        return stringBuffer.toString();
    }

    private String getDBOptions() {
        String string = "";
        if ((this._status & 4L) == 4L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'select into/bulkcopy', true\ngo\n\n";
        }
        if ((this._status & 8L) == 8L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'trunc log on chkpt', true\ngo\n\n";
        }
        if ((this._status & 0x10L) == 16L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'no chkpt on recovery', true\ngo\n\n";
        }
        if ((this._status & 0x200L) == 512L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'ddl in tran', true\ngo\n\n";
        }
        if ((this._status & 0x400L) == 1024L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'read only', true\ngo\n\n";
        }
        if ((this._status & 0x800L) == 2048L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'dbo use only', true\ngo\n\n";
        }
        if ((this._status & 0x1000L) == 4096L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'single user', true\ngo\n\n";
        }
        if ((this._status & 0x2000L) == 8192L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'allow nulls by default', true\ngo\n\n";
        }
        if ((this._status2 & 1L) == 1L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'abort tran on log full', true\ngo\n\n";
        }
        if ((this._status2 & 2L) == 2L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'no free space acctg', true\ngo\n\n";
        }
        if ((this._status2 & 4L) == 4L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'auto identity', true\ngo\n\n";
        }
        if ((this._status2 & 8L) == 8L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'identity in nonunique index', true\ngo\n\n";
        }
        if ((this._status3 & 0x1000000L) == 0x1000000L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'scratch database', true\ngo\n\n";
        }
        if ((this._status4 & 0x80000L) == 524288L) {
            string = string + "exec master.dbo.sp_dboption " + this._name + ", 'allow wide dol rows', true\ngo\n\n";
        }
        if (this._ownerName != null && !this._ownerName.equals("")) {
            string = "use " + this._name + "\ngo\n\nexec sp_changedbowner '" + this._ownerName + "', true \ngo\n\n" + string;
        }
        if (!string.equals("")) {
            string = string + "checkpoint\ngo\n\n";
        }
        return string;
    }

    private String getExpansionPolicy(ASConnection aSConnection) {
        if (aSConnection.getServerVersion().compareTo("12.5.1") < 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            aSResultSet.open("select char_value from master..sysattributes where class = 19 and attribute = 51 and object_type = 'DB' and object_cinfo = 'default' and object = 1", "SEGMENT_DEFAULT_GROW_QUERY");
            while (aSResultSet.getNextRow()) {
                stringBuffer.append(ASQueryParser.parseQuery("sp_dbextend ''modify'',''database'',''default'',null,''growby'',''{0}''", new String[]{aSResultSet.getColumnString(1)}));
                stringBuffer.append("\n").append("go ").append("\n\n");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("DB58", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("DB59", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    private void addChildren(ASConnection aSConnection) {
        DDLBaseContainer dDLBaseContainer;
        ArrayList arrayList = this._ddlGlobalParameters.getFilters();
        if (!arrayList.contains("SGM")) {
            dDLBaseContainer = new SegmentContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("SGM");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (!arrayList.contains("GRP")) {
            dDLBaseContainer = new GroupContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("GRP");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (!arrayList.contains("USR")) {
            dDLBaseContainer = new UserContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("USR");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (!arrayList.contains("R")) {
            dDLBaseContainer = new CompiledObjectContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("R");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (!arrayList.contains("D")) {
            dDLBaseContainer = new CompiledObjectContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("D");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (!arrayList.contains("UDD")) {
            dDLBaseContainer = new UserDefinedDatatypeContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("UDD");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (aSConnection.isEncryptionKeyApplicable() && !arrayList.contains("EK")) {
            dDLBaseContainer = new EncryptedKeyContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("EK");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (!arrayList.contains("U")) {
            dDLBaseContainer = new UserTableMetaContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("U");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (!arrayList.contains("V")) {
            dDLBaseContainer = new CompiledObjectContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("V");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (!arrayList.contains("P")) {
            dDLBaseContainer = new CompiledObjectContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("P");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (!arrayList.contains("XP")) {
            dDLBaseContainer = new CompiledObjectContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("XP");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
        if (!arrayList.contains("WS") && aSConnection.isUDWSApplicable()) {
            dDLBaseContainer = new CompiledObjectContainer(this, this._ddlGlobalParameters);
            dDLBaseContainer.setType("WS");
            dDLBaseContainer.load(((DatabaseMetaContainer)this._parent)._threadPool);
            this._children.addElement(dDLBaseContainer);
        }
    }

    private int findDeviceByName(String string, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Device device = (Device)vector.elementAt(i);
            if (!device.toString().equals(string)) continue;
            return i;
        }
        return -1;
    }

    protected void setDatabaseType(short s) {
        this._dbType = s;
    }

    protected short getDatabaseType() {
        return this._dbType;
    }

    private String getTempDBGroupSQL(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            aSResultSet.open(ASQueryParser.parseQuery("select a.object_cinfo, b.object_cinfo from master..sysattributes a, master..sysattributes b where a.class = 16 AND b.class = 16 AND a.object_type = ''D'' AND b.object_type = ''GR'' AND a.object_cinfo = ''{0}'' AND a.object = b.int_value order by 2", objectArray), "TEMP_DB_GROUP_QUERY");
            while (aSResultSet.getNextRow()) {
                stringBuffer.append("exec master.dbo.").append("sp_tempdb ").append("'").append("add").append("' ,");
                stringBuffer.append(" '").append(this._name).append("'").append(",");
                stringBuffer.append(" '").append(aSResultSet.getColumnsAsArray()[1].toString()).append("'");
                stringBuffer.append("\ngo\n\n");
            }
            if (aSResultSet != null) {
                aSResultSet.close();
                aSResultSet = null;
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("DB54", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("DB55", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    private String getTempDBBindingsSQL(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            aSResultSet.open(ASQueryParser.parseQuery("select a.object_cinfo from master.dbo.sysattributes a where a.class = 16  and a.char_value = ''{0}''  and a.object_type = ''AP'' ORDER BY 1", objectArray), "TEMP_DB_APPLICATIONS");
            while (aSResultSet.getNextRow()) {
                stringBuffer.append("exec master.dbo.").append("sp_tempdb ").append("'").append("bind").append("' ,");
                stringBuffer.append("'").append("ap").append("', ");
                stringBuffer.append(" '").append(aSResultSet.getColumnString(1)).append("'").append(", ");
                stringBuffer.append(" '").append("DB").append("'").append(", ");
                stringBuffer.append(" '").append(this._name).append("'");
                stringBuffer.append("\ngo\n\n");
            }
            if (aSResultSet != null) {
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("DB56", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("DB57", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }
}

