/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.container;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLThread;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.container.DatabaseContainer;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

public class DatabaseMetaContainer
extends DDLBaseContainer {
    private boolean _isTempDB;
    private boolean _isIMDB;
    private Vector _databases = new Vector();
    private Vector _tempDatabases = new Vector();
    private Vector _archiveDatabases = new Vector();
    private Vector _imDatabases = new Vector();
    private Vector _imTempDatabases = new Vector();
    private static final int DATABASE_COLUMN = 1;
    private static final int INSTANCE_COLUMN = 7;

    public DatabaseMetaContainer(DDLBaseContainer dDLBaseContainer) {
        this();
        this._parent = dDLBaseContainer;
    }

    public DatabaseMetaContainer() {
    }

    @Override
    public void open(ASConnection aSConnection) {
        DDLThread dDLThread;
        DatabaseContainer databaseContainer;
        int n;
        String string = this._ddlGlobalParameters.getObjectName();
        this._isTempDB = aSConnection.getServerVersion().compareTo("12.5.0.3") >= 0;
        boolean bl = this._isIMDB = !aSConnection.isCluster() && aSConnection.getServerVersion().compareTo("15.5") >= 0;
        if (!this._isTempDB && this._ddlGlobalParameters.getExtendedObjectTypes().size() > 0 && (this._ddlGlobalParameters.getExtendedObjectTypes().contains("OD") || this._ddlGlobalParameters.getExtendedObjectTypes().contains("OU") || this._ddlGlobalParameters.getExtendedObjectTypes().contains("OA"))) {
            new DDLBaseException("DB1", "INVALID_DB_EXTENDED_TYPE_WARNING", 4, this._ddlGlobalParameters.getExtendedObjectTypes().toString());
        }
        if (this._parent == null) {
            this.parseAndGetDatabases(string, aSConnection);
        } else {
            this._databases = null;
            this._tempDatabases = null;
        }
        for (n = 0; n < this._databases.size(); ++n) {
            databaseContainer = new DatabaseContainer((String[])this._databases.elementAt(n), this, this._ddlGlobalParameters);
            dDLThread = this._threadPool.getFreeThread();
            if (dDLThread != null) {
                dDLThread.setContainer(databaseContainer);
            } else {
                databaseContainer.open(aSConnection);
            }
            this._children.addElement(databaseContainer);
        }
        for (n = 0; n < this._tempDatabases.size(); ++n) {
            databaseContainer = new DatabaseContainer((String[])this._tempDatabases.elementAt(n), this, this._ddlGlobalParameters);
            databaseContainer.setDatabaseType((short)1);
            dDLThread = this._threadPool.getFreeThread();
            if (dDLThread != null) {
                dDLThread.setContainer(databaseContainer);
            } else {
                databaseContainer.open(aSConnection);
            }
            this._children.addElement(databaseContainer);
        }
        for (n = 0; n < this._archiveDatabases.size(); ++n) {
            databaseContainer = new DatabaseContainer((String[])this._archiveDatabases.elementAt(n), this, this._ddlGlobalParameters);
            databaseContainer.setDatabaseType((short)2);
            dDLThread = this._threadPool.getFreeThread();
            if (dDLThread != null) {
                dDLThread.setContainer(databaseContainer);
            } else {
                databaseContainer.open(aSConnection);
            }
            this._children.addElement(databaseContainer);
        }
        for (n = 0; n < this._imDatabases.size(); ++n) {
            databaseContainer = new DatabaseContainer((String[])this._imDatabases.elementAt(n), this, this._ddlGlobalParameters);
            databaseContainer.setDatabaseType((short)3);
            dDLThread = this._threadPool.getFreeThread();
            if (dDLThread != null) {
                dDLThread.setContainer(databaseContainer);
            } else {
                databaseContainer.open(aSConnection);
            }
            this._children.addElement(databaseContainer);
        }
        for (n = 0; n < this._imTempDatabases.size(); ++n) {
            databaseContainer = new DatabaseContainer((String[])this._imTempDatabases.elementAt(n), this, this._ddlGlobalParameters);
            databaseContainer.setDatabaseType((short)4);
            dDLThread = this._threadPool.getFreeThread();
            if (dDLThread != null) {
                dDLThread.setContainer(databaseContainer);
            } else {
                databaseContainer.open(aSConnection);
            }
            this._children.addElement(databaseContainer);
        }
        if (this._children.size() > 0) {
            this.generateDDLs();
        } else if (this._children.size() == 0 && this._parent == null) {
            this._ddlString = "";
            this.setThreadPoolStatus();
            this._ddlGlobalParameters.setDDLStatus((byte)1);
        } else {
            this._ddlString = "";
        }
    }

    private void parseAndGetDatabases(String string, ASConnection aSConnection) {
        if (string == null) {
            string = super.getDefaultDatabaseName(aSConnection);
        }
        String string2 = this.getDatabaseName(string);
        String string3 = this.getInstanceName(string);
        String string4 = Integer.toString(7) + "," + Integer.toString(1);
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{string2, string3, string4};
            if (this._isTempDB) {
                String string5;
                ArrayList arrayList = this._ddlGlobalParameters.getExtendedObjectTypes();
                if (arrayList.size() == 0 || arrayList.contains("%") || arrayList.contains("OU") || arrayList.contains("PN")) {
                    if (string3.length() == 0) {
                        string5 = "";
                        if (aSConnection.isCluster()) {
                            string5 = "SELECT name, suser_name(suid) as owner, isnull(status,0), isnull(status2,0), isnull(status3,0), def_remote_loc, isnull(status4,0) FROM master.dbo.sysdatabases WHERE name like ''{0}'' AND (status & 32) != 32 AND (status & 256) != 256AND name != ''tempdb'' AND status3 & 1073741824 != 1073741824 and status3 & 256 != 256 and status3 & 536870912 != 536870912 ORDER BY 1";
                            aSResultSet.open(ASQueryParser.parseQuery(string5, objectArray), "DATABASES_OF_LOGIN_QUERY+SDC_TEMP_DBS_FILTER+SDC_LOCAL_TEMPDBS_FILTER+ORDER_BY");
                        } else {
                            string5 = aSConnection.getServerVersion().compareTo("15") >= 0 ? "SELECT d.name, suser_name(d.suid) as owner, isnull(d.status,0), isnull(d.status2,0), isnull(d.status3,0), d.def_remote_loc, isnull(d.status4,0) FROM master.dbo.sysdatabases d, master.dbo.sysusages u, master.dbo.spt_values v, master.dbo.sysdevices e,master.dbo.syslogins l WHERE  d.name like ''{0}'' and (d.status & 32) != 32 AND (d.status & 256) != 256 AND d.name != ''tempdb'' AND d.status3 & 256 != 256 AND d.status3 & 4194304 != 4194304 AND d.suid = l.suid AND d.dbid = u.dbid AND e.status & 2 = 2 AND v.type = ''E'' AND v.number = 1 AND d.status4 & 4096 != 4096 GROUP BY d.name, l.name ORDER BY 1" : "SELECT d.name, suser_name(d.suid) as owner, isnull(d.status,0), isnull(d.status2,0), isnull(d.status3,0), d.def_remote_loc, isnull(d.status4,0) FROM master.dbo.sysdatabases d, master.dbo.sysusages u, master.dbo.spt_values v, master.dbo.sysdevices e,master.dbo.syslogins l WHERE  d.name like ''{0}'' and (d.status & 32) != 32 AND (d.status & 256) != 256 AND d.name != ''tempdb'' AND d.status3 & 256 != 256 AND d.status3 & 4194304 != 4194304 AND d.suid = l.suid AND d.dbid = u.dbid AND e.status & 2 = 2 AND v.type = ''E'' AND v.number = 1 GROUP BY d.name, l.name ORDER BY 1";
                            aSResultSet.open(ASQueryParser.parseQuery(string5, objectArray), "DBS_OPEN_QUERY_EXCLUDE+ORDER_BY");
                        }
                    } else if (string3.length() != 0 && arrayList != null && arrayList.size() > 0 && arrayList.contains("OU")) {
                        new DDLBaseException("DB6", "INVALID_EXTENDEDTYPE_FOR_LOCAL_TEMP_DB", 1);
                        return;
                    }
                    while (aSResultSet.getNextRow()) {
                        this._databases.addElement(aSResultSet.getColumnsAsArray());
                    }
                }
                if (arrayList.size() == 0 || arrayList.contains("%") || arrayList.contains("OD") || arrayList.contains("PN")) {
                    if (string3.length() == 0) {
                        string5 = "";
                        if (aSConnection.isCluster()) {
                            string5 = "SELECT name, suser_name(suid) as owner, isnull(status,0), isnull(status2,0), isnull(status3,0), def_remote_loc, isnull(status4,0) FROM master.dbo.sysdatabases WHERE name like ''{0}'' AND (status & 32) != 32 AND (status & 16) != 16 AND ((status3 & 1073741824 = 1073741824) OR (name = ''tempdb'') OR ((status2 & 16) != 16 AND status3 & 536870912 = 536870912) OR ((status2 & 16) != 16 and status3 & 256= 256))   ORDER BY 1";
                            aSResultSet.open(ASQueryParser.parseQuery(string5, objectArray), "SDC_TEMP_DBS_OPEN_QUERY+ORDER_BY");
                        } else {
                            string5 = "SELECT name, suser_name(suid) as owner, isnull(status,0), isnull(status2,0), isnull(status3,0), def_remote_loc, isnull(status4,0) FROM master.dbo.sysdatabases WHERE name like ''{0}'' AND ((isnull(status,0)) & 32) != 32 AND name = ''tempdb'' UNION SELECT name, suser_name(suid) as owner, isnull(status,0), isnull(status2,0), isnull(status3,0), def_remote_loc, isnull(status4,0) FROM master.dbo.sysdatabases WHERE name like ''{0}'' AND ((isnull(status, 0)) & 32) != 32 AND (isnull(status3,0)) & 256 = 256and (status4 & 4096 != 4096) ORDER BY 1";
                            aSResultSet.open(ASQueryParser.parseQuery(string5, objectArray), "TEMP_DBS_OPEN_QUERY+IM_TEMP_DBS_FILTER+ORDER_BY");
                        }
                    } else {
                        string5 = "";
                        if (aSConnection.isCluster()) {
                            string5 = "SELECT d.name, suser_name(d.suid) as owner, isnull(d.status,0), isnull(d.status2,0), isnull(d.status3,0), d.def_remote_loc, isnull(d.status4,0) FROM master.dbo.sysdatabases d, master.dbo.sysinstances c WHERE d.name like ''{0}'' AND (d.status & 32) != 32  AND d.instanceid = c.id ANd c.name like ''{1}'' order by {2} ";
                            aSResultSet.open(ASQueryParser.parseQuery(string5, objectArray), "SDC_LOCAL_TEMP_DBS_OPEN_QUERY");
                        } else {
                            new DDLBaseException("DB5", "INVALID_COMMAND_FOR_SDC", 1, this._ddlGlobalParameters.getHostName() + ":" + this._ddlGlobalParameters.getPortNumber());
                            return;
                        }
                    }
                    while (aSResultSet.getNextRow()) {
                        this._tempDatabases.addElement(aSResultSet.getColumnsAsArray());
                    }
                }
                if (string3.length() == 0 && (arrayList.size() == 0 || arrayList.contains("%") || arrayList.contains("OA"))) {
                    aSResultSet.open(ASQueryParser.parseQuery("SELECT name, suser_name(suid) as owner, isnull(status,0), isnull(status2,0), isnull(status3,0), def_remote_loc, isnull(status4,0) FROM master.dbo.sysdatabases WHERE name like ''{0}'' AND ((isnull(status,0)) & 32) != 32 AND (isnull(status3,0)) &  4194304 =  4194304 ORDER BY 1", objectArray), "ARCHIVE_DBS_OPEN_QUERY+ORDER_BY");
                    while (aSResultSet.getNextRow()) {
                        this._archiveDatabases.addElement(aSResultSet.getColumnsAsArray());
                    }
                }
                if (this._isIMDB) {
                    if (arrayList.size() == 0 || arrayList.contains("%") || arrayList.contains("OI") || arrayList.contains("PN")) {
                        aSResultSet.open(ASQueryParser.parseQuery("select d.name, suser_name(d.suid) as owner, isnull(d.status,0), isnull(d.status2,0), isnull(d.status3,0), d.def_remote_loc, isnull(d.status4,0) from master.dbo.sysdatabases d, master.dbo.sysusages u, master.dbo.spt_values v, master.dbo.sysdevices e, master.dbo.syslogins l where d.suid = l.suid and d.name != ''tempdb'' and (d.status & 32) != 32 and d.status3 & 256 != 256 and (d.status3 & 4194304) != 4194304 and d.dbid = u.dbid and e.vdevno = u.vdevno and e.status2 & 8 = 8 and v.type = ''E'' and v.number = 1 and d.name like ''{0}'' group by d.name, l.name ORDER BY 1", objectArray), "IM_DBS_OPEN_QUERY+ORDER_BY");
                        while (aSResultSet.getNextRow()) {
                            this._imDatabases.addElement(aSResultSet.getColumnsAsArray());
                        }
                    }
                    if (arrayList.size() == 0 || arrayList.contains("%") || arrayList.contains("OIT") || arrayList.contains("PN")) {
                        aSResultSet.open(ASQueryParser.parseQuery("select d.name, suser_name(d.suid) as owner, isnull(d.status,0), isnull(d.status2,0), isnull(d.status3,0), d.def_remote_loc, isnull(d.status4,0) from master.dbo.sysdatabases d, master.dbo.sysusages u, master.dbo.spt_values v, master.dbo.sysdevices e, master.dbo.syslogins l where d.suid = l.suid and (d.status3 & 256 = 256) and (d.status4 & 4096 = 4096) and d.dbid = u.dbid and e.vdevno = u.vdevno and v.type = ''E'' and v.number = 1 and d.name like ''{0}'' group by d.name, l.name ORDER BY 1", objectArray), "IM_TEMP_DB_OPEN_QUERY+ORDER_BY");
                        while (aSResultSet.getNextRow()) {
                            this._imTempDatabases.addElement(aSResultSet.getColumnsAsArray());
                        }
                    }
                }
            } else {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT name, suser_name(suid) as owner, isnull(status,0), isnull(status2,0), isnull(status3,0), def_remote_loc, isnull(status4,0) FROM master.dbo.sysdatabases WHERE name like ''{0}'' AND (status & 32) != 32 AND (status & 256) != 256", objectArray), "DATABASES_OF_LOGIN_QUERY");
                while (aSResultSet.getNextRow()) {
                    this._databases.addElement(aSResultSet.getColumnsAsArray());
                }
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("DB2", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("DB3", exception, "INTERNAL_ERROR", 1);
        }
        if (this._databases.size() == 0 && this._tempDatabases.size() == 0 && this._archiveDatabases.size() == 0 && this._imDatabases.size() == 0 && this._imTempDatabases.size() == 0 && this._parent == null) {
            new DDLBaseException("DB4", "DATABASE_NOT_FOUND_ERROR", 2, this._ddlGlobalParameters.getObjectName());
            return;
        }
    }

    private String getInstanceName(String string) {
        String string2 = "";
        int n = string.indexOf(".");
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private String getDatabaseName(String string) {
        String string2 = string;
        int n = string.indexOf(".");
        if (n > -1) {
            string2 = string.substring(n + 1, string.length());
        }
        return string2;
    }
}

