/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.container;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.container.CompiledObjectContainer;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.container.IndexContainer;
import com.sybase.ddlgen.container.LogicalKeyContainer;
import com.sybase.ddlgen.container.ReferentialIntegrityContainer;
import com.sybase.ddlgen.container.UserTableMetaContainer;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import com.sybase.ddlgen.util.Permission;
import java.sql.SQLException;
import java.util.ArrayList;

public class UserTableContainer
extends DDLBaseContainer {
    private int _status;
    private String _dbName;
    private String _tableID;
    private String _ownerName;
    private String _tableName;
    private String _tableType;
    private int _res_page_gap;
    private int _exp_row_size;
    private int _identity_gap;
    private String _segmentName;
    private int _max_rows_per_page;
    private int _fill_factor;
    private String _sBindings = "";
    private int _number_of_partitions;
    private int _indexStatus2;
    private int _sysstat3;
    private String _dependentKeys = "";
    private String _independentKeys = "";
    private boolean _bIsQuotedIdentifierOn = false;
    private boolean _bIsQuotedIdentifierOnKeys = false;
    private static final int CONST_UNICHARSIZE = 2;
    private static final int PROXY = 1024;
    private static final int NAME = 2;
    private static final int OWNER = 1;
    private static final int DBNAME = 0;
    private static final int STATUS = 3;
    private static final int SEGMENT = 4;
    private static final int FILL_FACTOR = 9;
    private static final int OBJECT_ID = 11;
    private static final int EXP_ROW_SIZE = 6;
    private static final int IDENTITY_GAP = 8;
    private static final int RESRVE_PAGE_GAP = 7;
    private static final int NO_OF_PARTITIONS = 10;
    private static final int MAX_ROWS_PER_PAGE = 5;
    private static final int INDEX_STATUS2 = 12;
    private static final int INSTRIG = 13;
    private static final int DELTRIG = 14;
    private static final int UPDTRIG = 15;
    private static final int SYSSTAT3 = 16;
    private static final String ATTR_COL_NAME = "name";
    private static final String ATTR_COL_TYPE = "type";
    private static final String ATTR_COL_SCALE = "scale";
    private static final String ATTR_COL_LENGTH = "col_length";
    private static final String ATTR_COL_STATUS = "status";
    private static final String ATTR_CHAR_LENGTH = "char_length";
    private static final String ATTR_COL_PRECISION = "prec";
    private static final String ATTR_COL_USERTYPE_ID = "type_id";
    private static final String ATTR_COL_OFFLINE_RULE = "offline_rule";
    private static final String ATTR_COL_OBJECT_STORAGE = "object_storage";
    private static final String ATTR_COL_OFFLINE_DEFAULT = "offline_default";
    private static final String ATTR_COL_INLINE_DEFAULT_ID = "inline_default";
    private static final String ATTR_COL_INLINE_RULE_ID = "inline_rule";
    private static final String ATTR_COL_STATUS2 = "status2";
    private static final String ATTR_COL_ENCRYPT_KEY = "encrkey_id";
    private static final String ATTR_COL_ENCRYPT_KEY_DB = "encrdb";
    private static final String ATTR_COL_COLID = "col_id";
    private static final String ATTR_COL_DD = "decrypt_text";
    public static String USEDB;
    public static String SETUSR;
    public String KEYS_OF_TABLE_QUERY;
    public static final int KEY_TYPE = 1;
    public static final int TABLE1_NAME = 2;
    public static final int TABLE2_NAME = 3;
    public static final int TABLE1_COL1 = 4;
    public static final int TABLE1_COL8 = 11;
    public static final int TABLE2_COL8 = 19;
    private static final int COL_STATUS2_COMPUTED_COL = 16;
    private static final int COL_STATUS2_DECRYPT_DEFAULT = 4096;
    private static final int O3_ROW_COMPRESSED = 4096;
    private static final int O3_PG_COMPRESSED = 8192;
    private static final int COL2_NOT_COMPRESSED = 131072;
    public static final String HASH = "hash";
    public static final String LIST = "list";
    public static final String RANGE = "range";
    public static final String ROUND_ROBIN = "roundrobin";
    private String _partitionStrategy = "";
    private StringBuffer _partitionColumns = new StringBuffer();
    private int _noPartitions;
    private StringBuffer _partitionSpec = new StringBuffer();
    private static final int PTN_ROW_COMPRESSED = 16;
    private static final int PTN_PG_COMPRESSED = 32;
    private static final int PTN_NOT_COMPRESSED = 128;
    private static final int COLUMN_LEVEL_LOB_NOT_COMPRESSED = 255;
    private boolean _partitionUserDefined = false;
    private boolean _includePartitionDefinition = false;
    private boolean _includeSysDefinePartition = false;
    private boolean _hasTriggers = false;
    private StringBuffer _cacheStrategyConstraints = new StringBuffer("");
    public static final int IDX_STATUS2_PREFETCH = 16;
    public static final int IDX_STATUS2_MRU = 32;
    private static final String DMLLOGGING = "dml_logging";
    private static final String FULL = "full";
    private static final String MINIMAL = "minimal";

    public UserTableContainer(String[] stringArray, DDLBaseContainer dDLBaseContainer, DDLGlobalParameters dDLGlobalParameters, ASConnection aSConnection) {
        this._parent = dDLBaseContainer;
        this._tableName = stringArray[2];
        this._ownerName = stringArray[1];
        this._dbName = stringArray[0];
        this._segmentName = stringArray[4];
        this._tableID = stringArray[11];
        this._name = this._dbName + "." + this._ownerName + "." + this.enQuoteToken(this._tableName);
        this.setDDLGlobalParameters(dDLGlobalParameters);
        try {
            this._status = Integer.parseInt(stringArray[3]);
            this._exp_row_size = Integer.parseInt(stringArray[6]);
            this._identity_gap = Integer.parseInt(stringArray[8]);
            this._res_page_gap = Integer.parseInt(stringArray[7]);
            this._max_rows_per_page = Integer.parseInt(stringArray[5]);
            this._fill_factor = Integer.parseInt(stringArray[9]);
            this._number_of_partitions = Integer.parseInt(stringArray[10]);
            this._indexStatus2 = Integer.parseInt(stringArray[12]);
            int n = Integer.parseInt(stringArray[13]);
            int n2 = Integer.parseInt(stringArray[14]);
            int n3 = Integer.parseInt(stringArray[15]);
            if (n != 0 || n2 != 0 || n3 != 0) {
                this._hasTriggers = true;
            }
            if (aSConnection.isIncrementalTransferApplicable()) {
                this._sysstat3 = Integer.parseInt(stringArray[16]);
            }
        }
        catch (Exception exception) {
            new DDLBaseException("U51", exception, "INTERNAL_ERROR", 1);
        }
    }

    public UserTableContainer() {
        this._parent = null;
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getOwnerName() {
        return this._ownerName;
    }

    public String getDBName() {
        return this._dbName;
    }

    public String getTableID() {
        return this._tableID;
    }

    private String getCreateTableDDL(ASConnection aSConnection) {
        if ((this._status & 0x400) == 1024) {
            return this.getCreateProxyTableDDL(aSConnection);
        }
        return this.getCreateNonProxyTableDDL(aSConnection);
    }

    public final String getIfExistsStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._dbName != null && !this._ddlGlobalParameters.getIsUseDBAlreadyInUse()) {
            stringBuffer.append(USEDB).append("\n").append("go ").append("\n\n");
            this._ddlGlobalParameters.setIsUseDBAlreadyUsed(true);
        }
        if (this._bIsQuotedIdentifierOn) {
            stringBuffer.append("set quoted_identifier on\ngo \n\n");
        }
        if (this._ownerName != null) {
            stringBuffer.append(SETUSR).append("\n").append("go ").append("\n\n");
        }
        String string = "";
        if (this._tableName.startsWith("\"")) {
            string = this._tableName.substring(1, this._tableName.length() - 1);
        }
        stringBuffer.append("IF EXISTS (").append(ASQueryParser.parseQuery("SELECT 1 FROM sysobjects o, sysusers u WHERE o.uid=u.uid AND o.name = ''{0}'' AND u.name = ''{1}'' AND o.type = ''{2}''", new String[]{string.length() != 0 ? string : this._tableName, this._ownerName, "U"})).append(")\n\t").append(ASQueryParser.parseQuery("drop table {0}", new String[]{this._tableName})).append("\n\n");
        if (this._bIsQuotedIdentifierOn) {
            stringBuffer.append("set quoted_identifier off\ngo \n\n");
        }
        stringBuffer.append("IF (@@error != 0)\n").append("BEGIN\n").append("\tPRINT 'Error CREATING table \"" + this.doubleQuotes(this._name, '\'') + "\"'\n").append("\tSELECT syb_quit()\n").append("END\ngo\n\n");
        return stringBuffer.toString();
    }

    private String getCreateNonProxyTableDDL(ASConnection aSConnection) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("\n-----------------------------------------------------------------------------\n-- DDL for ");
        this._tableType = "Table";
        stringBuffer2.append(this._tableType).append(" '").append(this._name).append("'\n-----------------------------------------------------------------------------\n").append("print '<<<<< CREATING Table - \"").append(this.doubleQuotes(this._name, '\'')).append("\" >>>>>'\ngo\n\n");
        if (!this._ddlGlobalParameters.getFilters().contains("IE") && !this._ddlGlobalParameters.getFilters().contains("%") && this._parent.getParent() == null) {
            stringBuffer2.append(this.getIfExistsStatement());
        } else {
            if (!this._ddlGlobalParameters.getIsUseDBAlreadyInUse()) {
                stringBuffer2.append(USEDB).append("\n").append("go ").append("\n\n");
                this._ddlGlobalParameters.setIsUseDBAlreadyUsed(true);
            }
            stringBuffer2.append(SETUSR).append("\n").append("go ").append("\n\n");
        }
        stringBuffer.append("create ").append("table ");
        stringBuffer.append(this.getCreateTableCommonDefinitionPart1(aSConnection));
        boolean bl = false;
        if ((this._status & 0x8000) == 32768) {
            stringBuffer.append("\nlock datarows\n");
            this._max_rows_per_page = 0;
        } else if ((this._status & 0x4000) == 16384) {
            stringBuffer.append("\nlock datapages\n");
            this._max_rows_per_page = 0;
        } else {
            stringBuffer.append("\nlock allpages\n");
            bl = true;
            this._exp_row_size = 0;
        }
        stringBuffer.append(this.getAttributes(this._max_rows_per_page, this._exp_row_size, this._res_page_gap, this._identity_gap, false));
        stringBuffer.append(this.getITAttribute(stringBuffer.toString()));
        if (aSConnection.isDMLLoggingApplicable()) {
            stringBuffer.append(this.getDMLLoggingAttribute(aSConnection, stringBuffer.toString()));
        }
        if (aSConnection.isDataCompressionApplicable()) {
            stringBuffer.append(this.getDataCompressionAttribute(aSConnection, stringBuffer.toString()));
            stringBuffer.append(this.getLOBColumnCompressionAttribute(aSConnection, stringBuffer.toString()));
        }
        stringBuffer.append(" on '" + this._segmentName + "'");
        if (this._includePartitionDefinition && aSConnection.isPartitionsApplicable() && !(string = this.getPartitionDDL()).equals("")) {
            stringBuffer.append("\n").append(string);
        }
        stringBuffer.append("\n").append("go ").append("\n\n");
        if (this._fill_factor != 0) {
            stringBuffer.append("sp_chgattribute '").append(this.enQuoteToken(this._tableName)).append("', 'fillfactor', ").append(this._fill_factor).append("\ngo\n\n");
        }
        if (!bl) {
            stringBuffer.append(this.getConcurrencyOptThreshold(aSConnection));
        }
        stringBuffer.append(this.getLockPromotion(aSConnection));
        stringBuffer2.append(this._bIsQuotedIdentifierOn ? "set quoted_identifier on\ngo \n\n" : "");
        stringBuffer.insert(0, stringBuffer2.toString());
        stringBuffer2 = null;
        stringBuffer.append(this.getCreateTableCommonDefinitionPart2(aSConnection));
        return stringBuffer.toString();
    }

    private String getPartitionDDL() {
        if (this._noPartitions == 1 && this._partitionStrategy.equals(ROUND_ROBIN) && this._partitionSpec.toString().equals("('default')")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("partition").append(" ").append("by").append(" ").append(this._partitionStrategy).append(this._partitionColumns);
        if (this._partitionUserDefined || this._partitionStrategy.equals(RANGE) || this._partitionStrategy.equals(LIST)) {
            stringBuffer.append(this._partitionSpec).append(" ");
        } else {
            if (!this._includeSysDefinePartition) {
                stringBuffer.append(" ").append(this._noPartitions);
            }
            if (this._partitionSpec.length() > 0) {
                if (!this._includeSysDefinePartition) {
                    stringBuffer.append(" ").append("on");
                }
                stringBuffer.append(" ").append(this._partitionSpec).append(" ");
            }
        }
        return stringBuffer.toString();
    }

    private String getConcurrencyOptThreshold(ASConnection aSConnection) {
        String string = "";
        int n = 15;
        try {
            int n2;
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableID};
            aSResultSet.open(ASQueryParser.parseQuery("select conopt_thld from {0}.dbo.systabstats where id = {1} and indid = 0", objectArray), "CONCURRENCY_OPT_THRESHOLD");
            if (aSResultSet.getNextRow() && (n2 = aSResultSet.getColumnInt(1)) != n) {
                string = "sp_chgattribute '" + this.enQuoteToken(this._tableName) + "', concurrency_opt_threshold, " + n2 + "\ngo\n\n";
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U52", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U53", exception, "INTERNAL_ERROR", 1);
        }
        return string;
    }

    private String getLockPromotion(ASConnection aSConnection) {
        String string = "";
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableID};
            aSResultSet.open(ASQueryParser.parseQuery("select  lwm = object_info1, hwm = object_info2, pct = object_info3, attribute from {0}.dbo.sysattributes where class = 5 and  object_type = ''T '' and  object = {1}", objectArray), "LOCK_PROMOTE");
            while (aSResultSet.getNextRow()) {
                int n = aSResultSet.getColumnInt(1);
                int n2 = aSResultSet.getColumnInt(2);
                int n3 = aSResultSet.getColumnInt(3);
                int n4 = aSResultSet.getColumnInt(4);
                if (n4 == 0) {
                    string = string + "sp_setpglockpromote 'table', '" + this.enQuoteToken(this._tableName) + "', " + n + ", " + n2 + ", " + n3 + "\ngo\n\n";
                    continue;
                }
                string = string + "sp_setrowlockpromote 'table', '" + this.enQuoteToken(this._tableName) + "', " + n + ", " + n2 + ", " + n3 + "\ngo\n\n";
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U54", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U55", exception, "INTERNAL_ERROR", 1);
        }
        return string;
    }

    private String getCreateProxyTableDDL(ASConnection aSConnection) {
        String string = "";
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("\n-----------------------------------------------------------------------------\n-- DDL for ");
        this._tableType = "Proxy Table ";
        stringBuffer2.append(this._tableType).append("'").append(this._name).append("'\n-----------------------------------------------------------------------------\n").append("print '<<<<< CREATING Proxy Table - \"");
        try {
            stringBuffer2.append(this.doubleQuotes(this._name, '\'')).append("\" >>>>>'\ngo\n\n");
            if (!this._ddlGlobalParameters.getFilters().contains("IE") && !this._ddlGlobalParameters.getFilters().contains("%") && this._parent.getParent() == null) {
                stringBuffer2.append(this.getIfExistsStatement());
            } else if (!this._ddlGlobalParameters.getIsUseDBAlreadyInUse()) {
                stringBuffer2.append(USEDB).append("\n").append("go ").append("\n\n");
                this._ddlGlobalParameters.setIsUseDBAlreadyUsed(true);
            }
            stringBuffer2.append(SETUSR).append("\n").append("go ").append("\n\n");
            boolean bl = false;
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableName};
            aSResultSet.open(ASQueryParser.parseQuery("SELECT CASE WHEN v.name=''rpc'' THEN ''procedure'' ELSE v.name END,a.char_value FROM {0}..sysattributes a,master.dbo.spt_values v WHERE object_cinfo=''{1}'' and object_type=''OD'' and a.class = 9 and a.attribute = 1\tand a.object_info2 = v.number and v.type = ''Y'' and v.name != ''view''", objectArray), "REMOTE_OBJECT_OF_PROXY_TABLE_QUERY");
            if (aSResultSet.getNextRow()) {
                string = aSResultSet.getColumnString(1);
                string2 = "'" + aSResultSet.getColumnString(2) + "'";
            }
            if ((this._status & 0x800) == 2048) {
                if (string.equals("directory") || string.equals("file")) {
                    stringBuffer.append("create ").append("proxy_table ").append(this.enQuoteToken(this._tableName)).append(" external ").append(string).append(" at ").append(string2).append("\n").append("go ").append("\n\n");
                    bl = true;
                } else {
                    stringBuffer.append("create ").append("existing ").append("table ");
                }
            } else {
                stringBuffer.append("create ").append("table ");
            }
            if (!bl) {
                stringBuffer.append(this.getCreateTableCommonDefinitionPart1(aSConnection));
                if (this._max_rows_per_page > 0) {
                    stringBuffer.append("\nwith max_rows_per_page = ").append(this._max_rows_per_page);
                }
                stringBuffer.append(" on '" + this._segmentName + "'");
                stringBuffer.append("\n  external ").append(string).append("\n  at ").append(string2).append("\n").append("go ").append("\n");
            }
            stringBuffer2.append(this._bIsQuotedIdentifierOn ? "set quoted_identifier on\ngo \n\n" : "");
            stringBuffer.insert(0, stringBuffer2.toString());
            stringBuffer2 = null;
            stringBuffer.append(this.getCreateTableCommonDefinitionPart2(aSConnection));
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U56", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U57", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    private String getCreateTableCommonDefinitionPart1(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            Object object;
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            stringBuffer.append(this.enQuoteToken(this._tableName));
            stringBuffer.append(" (\n");
            Object[] objectArray = new String[]{this._dbName, this._tableID};
            ASResultSet aSResultSet2 = new ASResultSet(aSConnection);
            if (aSConnection.isComputedColApplicable() && aSConnection.isEncryptionKeyApplicable()) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT name=case when valid_name(C.name, 255)=0 then ''\"'' + C.name + ''\"'' else C.name end, type = isnull(X.xtname, isnull(get_xtypename(C.xtype,C.xdbid), T.name)), col_length = C.length, prec = C.prec, scale = C.scale, status = C.status, type_id = T.usertype, column_id = C.id, inline_rule=C.domain, inline_default=C.cdefault, object_storage = case when (C.xstatus is null) then '''' when (C.xstatus & 1) = 1 then ''off row'' else ''in row'' end, offline_default = (SELECT U.name + ''.'' + CASE WHEN valid_name(O.name, 255)=0 THEN ''\"'' + O.name + ''\"'' ELSE O.name END FROM {0}.dbo.sysusers U, {0}.dbo.sysobjects O, {0}.dbo.sysprocedures P WHERE C.cdefault<>0 AND U.uid=O.uid AND O.id=C.cdefault AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id), offline_rule = (SELECT U.name + ''.'' + CASE WHEN valid_name(O.name, 255)=0 THEN ''\"'' + O.name + ''\"'' ELSE O.name END FROM {0}.dbo.sysusers U, {0}.dbo.sysobjects O,{0}.dbo.sysprocedures P WHERE C.domain<>0 AND U.uid=O.uid AND O.id=C.domain AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id), char_length = isnull(@@ncharsize,1), status2 = isnull(C.status2,0), encrkey_id = isnull(C.encrkeyid,0), encrdb = C.encrkeydb, col_id = C.colid FROM {0}.dbo.syscolumns C, {0}.dbo.systypes T, {0}.dbo.sysxtypes X WHERE C.id = {1} AND C.usertype *= T.usertype AND C.xtype *= X.xtid and (C.status3 is null or C.status3 & 1 != 1)ORDER BY colid", objectArray), "COLUMNS_OF_TABLE_COMPUTE_AND_ENCRYP_QUERY");
            } else if (aSConnection.isComputedColApplicable()) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT name=case when valid_name(C.name, 255)=0 then ''\"'' + C.name + ''\"'' else C.name end, type = isnull(X.xtname, isnull(get_xtypename(C.xtype,C.xdbid), T.name)), col_length = C.length, prec = C.prec, scale = C.scale, status = C.status, type_id = T.usertype, column_id = C.id, inline_rule=C.domain, inline_default=C.cdefault, object_storage = case when (C.xstatus is null) then '''' when (C.xstatus & 1) = 1 then ''off row'' else ''in row'' end, offline_default = (SELECT U.name + ''.'' + CASE WHEN valid_name(O.name, 255)=0 THEN ''\"'' + O.name + ''\"'' ELSE O.name END FROM {0}.dbo.sysusers U, {0}.dbo.sysobjects O, {0}.dbo.sysprocedures P WHERE C.cdefault<>0 AND U.uid=O.uid AND O.id=C.cdefault AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id), offline_rule = (SELECT U.name + ''.'' + CASE WHEN valid_name(O.name, 255)=0 THEN ''\"'' + O.name + ''\"'' ELSE O.name END FROM {0}.dbo.sysusers U, {0}.dbo.sysobjects O,{0}.dbo.sysprocedures P WHERE C.domain<>0 AND U.uid=O.uid AND O.id=C.domain AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id), char_length = isnull(@@ncharsize,1), status2 = isnull(C.status2,0) FROM {0}.dbo.syscolumns C, {0}.dbo.systypes T, {0}.dbo.sysxtypes X WHERE C.id = {1} AND C.usertype *= T.usertype AND C.xtype *= X.xtid and (C.status3 is null or C.status3 & 1 != 1)ORDER BY colid", objectArray), "COLUMNS_OF_TABLE_COMPUTE_QUERY");
            } else if (aSConnection.isEncryptionKeyApplicable()) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT name=case when valid_name(C.name)=0 then ''\"'' + C.name + ''\"'' else C.name end, type = isnull(X.xtname, isnull(get_xtypename(C.xtype,C.xdbid), T.name)), col_length = C.length, prec = C.prec, scale = C.scale, status = C.status, type_id = T.usertype, column_id = C.id, inline_rule=C.domain, inline_default=C.cdefault, object_storage = case when (C.xstatus is null) then '''' when (C.xstatus & 1) = 1 then ''off row'' else ''in row'' end,  offline_default = (SELECT U.name + ''.'' + CASE WHEN valid_name(O.name)=0 THEN ''\"'' + O.name + ''\"'' ELSE O.name END FROM {0}.dbo.sysusers U, {0}.dbo.sysobjects O, {0}.dbo.sysprocedures P WHERE C.cdefault<>0 AND U.uid=O.uid AND O.id=C.cdefault AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id),offline_rule = (SELECT U.name + ''.'' + CASE WHEN valid_name(O.name)=0 THEN ''\"'' + O.name + ''\"'' ELSE O.name END FROM {0}.dbo.sysusers U, {0}.dbo.sysobjects O,{0}.dbo.sysprocedures P WHERE C.domain<>0 AND U.uid=O.uid AND O.id=C.domain AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id),char_length = isnull(@@ncharsize,1),status2 = isnull(C.status2,0), encrkey_id = isnull(C.encrkeyid,0), encrdb = C.encrkeydb, col_id = C.colid  FROM {0}.dbo.syscolumns C, {0}.dbo.systypes T, {0}.dbo.sysxtypes X WHERE C.id = {1} AND C.usertype *= T.usertype AND C.xtype *= X.xtid ORDER BY colid", objectArray), "COLUMNS_OF_TABLE_ENCRYP_QUERY");
            } else if (aSConnection.getServerVersion().compareTo("12.0") >= 0) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT name = case when valid_name(C.name)=0 then ''\"'' + C.name + ''\"'' else C.name end, type = isnull(X.xtname, isnull(get_xtypename(C.xtype,C.xdbid), T.name)), col_length = C.length, prec = C.prec, scale = C.scale, status = C.status, type_id = T.usertype, column_id = C.id, inline_rule = C.domain, inline_default=C.cdefault, object_storage = case when (C.xstatus is null) then '''' when (C.xstatus & 1) = 1 then ''off row'' else ''in row'' end, offline_default = (SELECT U.name + ''.'' + CASE WHEN valid_name(O.name)=0 THEN ''\"'' + O.name + ''\"'' ELSE O.name END FROM {0}.dbo.sysusers U, {0}.dbo.sysobjects O, {0}.dbo.sysprocedures P WHERE C.cdefault<>0 AND U.uid=O.uid AND O.id=C.cdefault AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id), offline_rule = (SELECT U.name + ''.'' + CASE WHEN valid_name(O.name)=0 THEN ''\"'' + O.name + ''\"'' ELSE O.name END FROM {0}.dbo.sysusers U, {0}.dbo.sysobjects O,{0}.dbo.sysprocedures P WHERE C.domain<>0 AND U.uid=O.uid AND O.id=C.domain AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id), char_length =   isnull(@@ncharsize,1) FROM {0}.dbo.syscolumns C, {0}.dbo.systypes T, {0}.dbo.sysxtypes X WHERE C.id = {1} AND C.usertype *= T.usertype AND C.xtype *= X.xtid ORDER BY colid", objectArray), "COLUMNS_OF_TABLE_QUERY_12x");
            } else {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT name = case when valid_name(C.name)=0 then ''\"'' + C.name + ''\"'' else C.name end, type = T.name, col_length = C.length, prec = C.prec, scale = C.scale, status = C.status, type_id = T.usertype, column_id  = C.id, inline_rule=C.domain, inline_default=C.cdefault, offline_default = (SELECT U.name + ''.'' + CASE WHEN valid_name(O.name)=0 THEN ''\"'' + O.name + ''\"'' ELSE O.name END FROM {0}.dbo.sysusers U, {0}.dbo.sysobjects O, {0}.dbo.sysprocedures P WHERE C.cdefault<>0 AND U.uid=O.uid AND O.id=C.cdefault AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id), offline_rule = (SELECT U.name + ''.'' + CASE WHEN valid_name(O.name)=0 THEN ''\"'' + O.name + ''\"'' ELSE O.name END FROM {0}.dbo.sysusers U, {0}.dbo.sysobjects O,{0}.dbo.sysprocedures P WHERE C.domain<>0 AND U.uid=O.uid AND O.id=C.domain AND P.sequence = 0 AND P.status & 4096 != 4096 AND P.id = O.id), char_length = isnull(@@ncharsize,1) FROM {0}.dbo.syscolumns C, {0}.dbo.systypes T  WHERE C.id = {1} AND C.usertype *= T.usertype ORDER BY colid", objectArray), "COLUMNS_OF_TABLE_QUERY_1192");
            }
            while (aSResultSet.getNextRow()) {
                String string;
                stringBuffer.append("\t");
                stringBuffer.append(this.formatToken(this.enQuoteCol(aSResultSet.getColumnString(ATTR_COL_NAME))));
                stringBuffer.append(" ");
                object = aSConnection.getUnsignedIntType(aSResultSet.getColumnString(ATTR_COL_TYPE));
                n = 0;
                if ((aSConnection.isComputedColApplicable() || aSConnection.isEncryptionKeyApplicable()) && (string = aSResultSet.getColumnString(ATTR_COL_STATUS2)) != null && !string.equals("")) {
                    n = new Integer(aSResultSet.getColumnString(ATTR_COL_STATUS2));
                }
                if ((n & 0x10) != 16) {
                    int n2;
                    if (((String)object).equals("binary") || ((String)object).equals("char") || ((String)object).equals("varbinary") || ((String)object).equals("varchar") || ((String)object).equals("sysname")) {
                        object = (String)object + "(" + aSResultSet.getColumnString(ATTR_COL_LENGTH) + ")";
                    } else if (((String)object).equals("nchar") || ((String)object).equals("nvarchar")) {
                        int n3 = Integer.parseInt(aSResultSet.getColumnString(ATTR_COL_LENGTH));
                        n2 = Integer.parseInt(aSResultSet.getColumnString(ATTR_CHAR_LENGTH));
                        n2 = n2 == 0 ? 1 : n2;
                        object = (String)object + "(" + n3 / n2 + ")";
                    } else if (((String)object).equals("unichar") || ((String)object).equals("univarchar")) {
                        int n4 = Integer.parseInt(aSResultSet.getColumnString(ATTR_COL_LENGTH));
                        object = (String)object + "(" + n4 / 2 + ")";
                    } else if (((String)object).equals("float")) {
                        int n5 = new Integer(aSResultSet.getColumnString(ATTR_COL_LENGTH));
                        object = (String)object + "(" + n5 * 2 + ")";
                    }
                    if (!aSResultSet.getColumnString(ATTR_COL_PRECISION).equals("") && !aSResultSet.getColumnString(ATTR_COL_SCALE).equals("") && aSResultSet.getColumnInt(ATTR_COL_USERTYPE_ID) <= 100) {
                        object = (String)object + "(" + aSResultSet.getColumnString(ATTR_COL_PRECISION) + "," + aSResultSet.getColumnString(ATTR_COL_SCALE) + ") ";
                    }
                    stringBuffer.append(this.formatToken((String)object));
                    if (!aSResultSet.getColumnString(ATTR_COL_INLINE_DEFAULT_ID).equals("0")) {
                        stringBuffer.append(" ");
                        objectArray = new String[]{this._dbName, aSResultSet.getColumnString(ATTR_COL_INLINE_DEFAULT_ID)};
                        aSResultSet2.open(ASQueryParser.parseQuery("SELECT text FROM {0}.dbo.syscomments D,{0}.dbo.sysprocedures P WHERE D.id = {1} AND P.id = D.id AND P.sequence = 0 AND P.status & 4096 = 4096", objectArray), "INLINE_DEFAULT_OF_COLUMN");
                        while (aSResultSet2.getNextRow()) {
                            stringBuffer.append(aSResultSet2.getColumnString(1));
                        }
                        stringBuffer.append("\n");
                        aSResultSet2.close();
                    }
                    if ((aSResultSet.getColumnInt(ATTR_COL_STATUS) & 8) == 8) {
                        stringBuffer.append("      null");
                    } else if ((aSResultSet.getColumnInt(ATTR_COL_STATUS) & 0x80) == 128) {
                        stringBuffer.append("  identity");
                    } else {
                        stringBuffer.append("  not null");
                    }
                    if (aSConnection.getServerVersion().compareTo("12.0") >= 0 && !aSResultSet.getColumnString(ATTR_COL_OBJECT_STORAGE).equals("")) {
                        stringBuffer.append(" ");
                        stringBuffer.append(aSResultSet.getColumnString(ATTR_COL_OBJECT_STORAGE));
                    }
                    if (aSConnection.isInRowLOBApplicable() && (((String)object).equals("text") || ((String)object).equals("image") || ((String)object).equals("unitext"))) {
                        objectArray = new String[]{this._dbName, this._tableID, aSResultSet.getColumnString(ATTR_COL_NAME)};
                        string = ASQueryParser.parseQuery("SELECT inrowlen FROM {0}.dbo.syscolumns WHERE name = ''{2}'' and id = {1}", objectArray);
                        aSResultSet2.open(string, "INROW_OFFROW_OF_COLUMN");
                        while (aSResultSet2.getNextRow()) {
                            if (aSResultSet2.getColumnString(1) == null || aSResultSet2.getColumnString(1).length() == 0) continue;
                            if (((String)object).equals("unitext")) {
                                n2 = Integer.parseInt(aSResultSet2.getColumnString(1)) / 2;
                                stringBuffer.append(" in row (").append(String.valueOf(n2)).append(")");
                                continue;
                            }
                            stringBuffer.append(" in row (").append(aSResultSet2.getColumnString(1)).append(")");
                        }
                        aSResultSet2.close();
                    }
                    if (aSConnection.isEncryptionKeyApplicable() && !aSResultSet.getColumnString(ATTR_COL_ENCRYPT_KEY).equals("0")) {
                        stringBuffer.append(" ");
                        string = aSResultSet.getColumnString(ATTR_COL_ENCRYPT_KEY_DB);
                        if (string == null || string.equals("")) {
                            string = this._dbName;
                        }
                        objectArray = new String[]{string, aSResultSet.getColumnString(ATTR_COL_ENCRYPT_KEY)};
                        aSResultSet2.open(ASQueryParser.parseQuery("select keyname = o.name, owner = u.name from  {0}.dbo.sysobjects o,  {0}.dbo.sysusers u  where o.id  = {1}  and u.uid = o.uid", objectArray), "ENCRYPT_COL_ATTR");
                        if (aSResultSet2.getNextRow()) {
                            stringBuffer.append(" ").append("encrypt").append(" ").append("with").append(" ").append(string).append(".").append(aSResultSet2.getColumnString("owner")).append(".").append(aSResultSet2.getColumnString("keyname")).append(" ");
                        }
                        aSResultSet2.close();
                        if ((n & 0x1000) == 4096) {
                            objectArray = new String[]{string, this._tableID, aSResultSet.getColumnString(ATTR_COL_COLID)};
                            aSResultSet2.open(ASQueryParser.parseQuery("select decrypt_text = text  from {0}.dbo.syscomments where id = (select object from {0}.dbo.sysattributes where object_info1 = {1} and object_info2 = {2})", objectArray), "ENCRYP_COL_DEFAULT_VALUE");
                            if (aSResultSet2.getNextRow()) {
                                String string2 = aSResultSet2.getColumnString(ATTR_COL_DD).trim().toUpperCase();
                                String string3 = string2.substring(string2.indexOf("DECRYPT DEFAULT") + "DECRYPT DEFAULT".length(), string2.length());
                                stringBuffer.append("decrypt_default").append(" ").append(string3.trim()).append(" ");
                            }
                            aSResultSet2.close();
                        }
                    }
                    if (aSConnection.isDataCompressionApplicable()) {
                        objectArray = new String[]{this._dbName, this._tableID, aSResultSet.getColumnString(ATTR_COL_NAME)};
                        aSResultSet2.open(ASQueryParser.parseQuery("SELECT status2 from {0}.dbo.syscolumns where id = {1} and name = ''{2}'' and lobcomp_lvl = null", objectArray), "NOT_COMPRESSED_CLAUSE_OF_TABLE_QUERY");
                        while (aSResultSet2.getNextRow()) {
                            if ((aSResultSet2.getColumnInt(1) & 0x20000) != 131072) continue;
                            stringBuffer.append(" ").append("not compressed").append(" ");
                        }
                        aSResultSet2.close();
                        objectArray = new String[]{this._dbName, this._tableID, aSResultSet.getColumnString(ATTR_COL_NAME)};
                        aSResultSet2.open(ASQueryParser.parseQuery("select isnull(lobcomp_lvl, 0) from {0}.dbo.syscolumns where id = {1} and name = ''{2}'' ", objectArray), "COLUMN_LEVEL_LOB_COMPRESSION_CLAUSE_OF_TABLE_QUERY");
                        while (aSResultSet2.getNextRow()) {
                            int n6 = aSResultSet2.getColumnInt(1);
                            if (n6 == 0) continue;
                            if ((n6 & 0xFF) == 255) {
                                stringBuffer.append(" ").append("not compressed");
                                continue;
                            }
                            stringBuffer.append(" ").append("compressed").append(" = ").append(String.valueOf(n6));
                        }
                        aSResultSet2.close();
                    }
                    if (!aSResultSet.getColumnString(ATTR_COL_OFFLINE_DEFAULT).equals("") && aSResultSet.getColumnInt(ATTR_COL_USERTYPE_ID) <= 100) {
                        this._sBindings = this._sBindings + "\nsp_bindefault '" + aSResultSet.getColumnString(ATTR_COL_OFFLINE_DEFAULT) + "', '" + this._tableName + "." + this.unEnQuoteToken(aSResultSet.getColumnString(ATTR_COL_NAME)) + "'\n" + "go " + "\n";
                    }
                } else {
                    objectArray = new String[]{this._dbName, this._tableID, aSResultSet.getColumnString(ATTR_COL_NAME)};
                    string = ASQueryParser.parseQuery("SELECT text from {0}.dbo.syscomments where id  = (select computedcol from {0}.dbo.syscolumns where id = {1} and name = ''{2}'' ) ", objectArray);
                    aSResultSet2.open(ASQueryParser.parseQuery("SELECT text from {0}.dbo.syscomments where id  = (select computedcol from {0}.dbo.syscolumns where id = {1} and name = ''{2}'' ) ", objectArray), "COMPUTED_COL_EXPRESSION");
                    while (aSResultSet2.getNextRow()) {
                        stringBuffer.append(aSResultSet2.getColumnString(1));
                    }
                    aSResultSet2.close();
                    if (aSConnection.isDataCompressionApplicable()) {
                        objectArray = new String[]{this._dbName, this._tableID, aSResultSet.getColumnString(ATTR_COL_NAME)};
                        aSResultSet2.open(ASQueryParser.parseQuery("SELECT status2 from {0}.dbo.syscolumns where id = {1} and name = ''{2}'' and lobcomp_lvl = null", objectArray), "NOT_COMPRESSED_CLAUSE_OF_TABLE_QUERY");
                        while (aSResultSet2.getNextRow()) {
                            if ((aSResultSet2.getColumnInt(1) & 0x20000) != 131072) continue;
                            stringBuffer.append(" ").append("not compressed").append(" ");
                        }
                        aSResultSet2.close();
                    }
                }
                if (!aSResultSet.getColumnString(ATTR_COL_INLINE_RULE_ID).equals("0")) {
                    stringBuffer.append(" ");
                    objectArray = new String[]{this._dbName, aSResultSet.getColumnString(ATTR_COL_INLINE_RULE_ID)};
                    aSResultSet2.open(ASQueryParser.parseQuery("SELECT text FROM {0}.dbo.syscomments R,{0}.dbo.sysprocedures P WHERE R.id = {1} AND P.id = R.id AND P.sequence = 0 AND P.status & 4096 = 4096", objectArray), "INLINE_CHECKCONSTRAINT_OF_COLUMN");
                    while (aSResultSet2.getNextRow()) {
                        stringBuffer.append(aSResultSet2.getColumnString(1));
                    }
                    stringBuffer.append("\n");
                    aSResultSet2.close();
                }
                if (!aSResultSet.getColumnString(ATTR_COL_OFFLINE_RULE).equals("")) {
                    this._sBindings = this._sBindings + "\nsp_bindrule '" + aSResultSet.getColumnString(ATTR_COL_OFFLINE_RULE) + "', '" + this._tableName + "." + this.unEnQuoteToken(aSResultSet.getColumnString(ATTR_COL_NAME)) + "'\n" + "go " + "\n";
                }
                stringBuffer.append(",\n");
            }
            aSResultSet2 = null;
            object = this._ddlGlobalParameters.getFilters();
            if (!((ArrayList)object).contains("KC") && !((ArrayList)object).contains("%")) {
                String string = this.getPrimaryAndUniqueConstraints(aSConnection);
                stringBuffer.append(string);
            }
            objectArray = new String[]{this._dbName, this._tableID};
            aSResultSet.close();
            aSResultSet.open(ASQueryParser.parseQuery("SELECT a.constrid, b.text FROM {0}.dbo.sysconstraints a, {0}.dbo.syscomments b, {0}.dbo.sysprocedures p WHERE a.constrid=b.id AND p.id = b.id AND a.tableid = {1} AND p.sequence = 0 AND p.status & 4096 = 4096 AND a.status & 128 = 128 AND a.constrid not in (select domain from {0}.dbo.syscolumns where id = {1}) ORDER BY a.constrid", objectArray), "CHECKCONSTRAINTS_OF_TABLE_QUERY");
            int n7 = 0;
            while (aSResultSet.getNextRow()) {
                n = aSResultSet.getColumnInt(1);
                if (n7 == 0) {
                    n7 = n;
                }
                if (n != n7) {
                    stringBuffer.append(",\n");
                    stringBuffer.append("\t\t");
                    n7 = n;
                }
                stringBuffer.append(aSResultSet.getColumnString(2));
            }
            if (stringBuffer.charAt(stringBuffer.length() - 2) == ',') {
                stringBuffer.setCharAt(stringBuffer.length() - 2, ' ');
            }
            stringBuffer.append(")");
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U58", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U59", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    private String getCreateTableCommonDefinitionPart2(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this._independentKeys);
            if (aSConnection.getServerVersion().compareTo("15") < 0 && this._number_of_partitions > 0) {
                stringBuffer.append("alter").append(" ").append("table").append(" ").append(this.enQuoteToken(this._tableName)).append(" ").append("partition").append(" ").append(this._number_of_partitions).append("\n").append("go ").append("\n\n");
            }
            Object[] objectArray = new String[]{this._dbName, this._tableID};
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            aSResultSet.open(ASQueryParser.parseQuery("SELECT I.name,S.name FROM {0}..sysindexes I, {0}..syssegments S WHERE I.id = {1} AND I.segment = S.segment AND I.indid=255", objectArray), "PLACE_OBJECT_OF_TABLE_QUERY");
            while (aSResultSet.getNextRow()) {
                stringBuffer.append("sp_placeobject '");
                stringBuffer.append(aSResultSet.getColumnString(2));
                stringBuffer.append("', '");
                stringBuffer.append(this._ownerName);
                stringBuffer.append(".");
                stringBuffer.append(this.enQuoteToken(this._tableName));
                stringBuffer.append(".");
                stringBuffer.append(aSResultSet.getColumnString(1));
                stringBuffer.append("'\n").append("go ").append("\n\n");
            }
            aSResultSet.close();
            aSResultSet.open(ASQueryParser.parseQuery("SELECT char_value,object_type FROM {0}..sysattributes WHERE class=3 AND attribute=0 AND object= {1} AND object_info1 IN (null,255)", objectArray), "CACHE_BINDINGS_OF_TABLE_QUERY");
            while (aSResultSet.getNextRow()) {
                stringBuffer.append("sp_bindcache '");
                stringBuffer.append(aSResultSet.getColumnString(1));
                stringBuffer.append("', '");
                stringBuffer.append(this._dbName);
                stringBuffer.append("', '");
                stringBuffer.append(this.enQuoteToken(this._tableName));
                stringBuffer.append("'");
                stringBuffer.append(aSResultSet.getColumnString(2).equals("T") ? "" : ", 'text only'");
                stringBuffer.append("\n").append("go ").append("\n\n");
            }
            stringBuffer.append(Permission.getPermissions(this._dbName, this._ownerName, this.enQuoteToken(this._tableName), this._tableID, aSConnection));
            stringBuffer.append(this._sBindings);
            if (UserTableContainer.isPrefetchSet(this._indexStatus2)) {
                stringBuffer.append(UserTableContainer.getPrefetchDDL(this._dbName, this._ownerName, this._tableName, ""));
            }
            if (UserTableContainer.isMRUSet(this._indexStatus2)) {
                stringBuffer.append(UserTableContainer.getMRUDDL(this._dbName, this._ownerName, this._tableName, ""));
            }
            int n = 0;
            aSResultSet.open(ASQueryParser.parseQuery("SELECT status2 from {0}..sysindexes where id={1} and indid=255", objectArray), "CACHE_STRATEGY_TEXT_ONLY_QUERY");
            while (aSResultSet.getNextRow()) {
                n = aSResultSet.getColumnInt(1);
            }
            if (UserTableContainer.isPrefetchSet(n)) {
                stringBuffer.append(UserTableContainer.getPrefetchTextOnlyDDL(this._dbName, this._ownerName, this._tableName, ""));
            }
            if (UserTableContainer.isMRUSet(n)) {
                stringBuffer.append(UserTableContainer.getMRUTextOnlyDDL(this._dbName, this._ownerName, this._tableName, ""));
            }
            if (aSResultSet != null) {
                aSResultSet.close();
                aSResultSet = null;
            }
            stringBuffer.append(this._cacheStrategyConstraints);
            stringBuffer.append("\n").append("setuser").append("\n").append("go ").append("\n");
            stringBuffer.append(this._bIsQuotedIdentifierOn ? "set quoted_identifier off\ngo \n\n" : "");
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U60", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U61", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    private String formatToken(String string) {
        String string2 = string;
        for (int i = string.length(); i < 31; ++i) {
            string2 = string2 + " ";
        }
        return string2;
    }

    private String unEnQuoteToken(String string) {
        try {
            if (string.startsWith("\"") && string.endsWith("\"")) {
                return this.doubleQuotes(string.substring(1, string.length() - 1), '\'');
            }
            return string;
        }
        catch (Exception exception) {
            new DDLBaseException("U62", exception, "INTERNAL_ERROR", 1);
            return string;
        }
    }

    private String enQuoteToken(String string) {
        String string2 = string;
        if (string.startsWith("\"")) {
            this._bIsQuotedIdentifierOn = true;
            string = string.substring(1, string.length() - 1);
            string2 = "\"";
            int n = -1;
            while ((n = string.indexOf(34)) != -1) {
                string2 = string2 + string.substring(0, n + 1) + "\"";
                string = string.substring(n + 1);
            }
            string2 = string2 + string + "\"";
        }
        return string2;
    }

    private String enQuoteCol(String string) {
        String string2 = string;
        if (string.equals("SYB_IDENTITY_COL") || string.equals("OMNI_IDENTITY_COL")) {
            this._bIsQuotedIdentifierOn = true;
            string2 = "\"" + string + "\"";
        } else {
            string2 = this.enQuoteToken(string);
        }
        return string2;
    }

    private String doubleQuotes(String string, char c) {
        String string2 = "";
        int n = -1;
        try {
            while ((n = string.indexOf(c)) != -1) {
                string2 = string2 + string.substring(0, n) + c;
                string = string.substring(n + 1);
            }
            string2 = string2 + string;
        }
        catch (Exception exception) {
            new DDLBaseException("U63", exception, "INTERNAL_ERROR", 1);
        }
        return string2;
    }

    public void addTriggersToTable() {
        CompiledObjectContainer compiledObjectContainer = new CompiledObjectContainer(this, this._ddlGlobalParameters);
        compiledObjectContainer.setType("TR");
        compiledObjectContainer.load(((UserTableMetaContainer)this._parent)._threadPool);
        this._children.addElement(compiledObjectContainer);
    }

    public void addForeignKeyConstraintsToTable() {
        ReferentialIntegrityContainer referentialIntegrityContainer = new ReferentialIntegrityContainer(this, this._ddlGlobalParameters);
        referentialIntegrityContainer.setType("RI");
        referentialIntegrityContainer.load(((UserTableMetaContainer)this._parent)._threadPool);
        this._children.addElement(referentialIntegrityContainer);
    }

    public void addLogicalKeysToTable() {
        LogicalKeyContainer logicalKeyContainer = new LogicalKeyContainer(this, this._ddlGlobalParameters);
        logicalKeyContainer.setType("LK");
        logicalKeyContainer.load(((UserTableMetaContainer)this._parent)._threadPool);
        this._children.addElement(logicalKeyContainer);
    }

    public void addIndexesToTable() {
        IndexContainer indexContainer = new IndexContainer(this, this._ddlGlobalParameters);
        indexContainer.setType("I");
        indexContainer.load(((UserTableMetaContainer)this._parent)._threadPool);
        this._children.addElement(indexContainer);
    }

    public String getIndependentDDL(ASConnection aSConnection) {
        ArrayList arrayList = this._ddlGlobalParameters.getFilters();
        ArrayList arrayList2 = this._ddlGlobalParameters.getExtendedObjectTypes();
        if (!arrayList.contains("I") && !arrayList.contains("%")) {
            this.addIndexesToTable();
        }
        if (!arrayList.contains("TR") && !arrayList.contains("%") && this._hasTriggers) {
            this.addTriggersToTable();
        }
        if (!arrayList.contains("RI") && !arrayList.contains("%")) {
            this.addForeignKeyConstraintsToTable();
        }
        if (!arrayList.contains("LK") && !arrayList.contains("%")) {
            this.addLogicalKeysToTable();
        }
        if (aSConnection.isPartitionsApplicable()) {
            if ((arrayList.contains("PC") || arrayList.contains("%")) && arrayList2.contains("PN")) {
                new DDLBaseException("U79", "PARTITION_CONFICT_ARGUMENT_ERROR", 0);
            }
            if (arrayList2.contains("PN") && arrayList2.contains("OD")) {
                new DDLBaseException("U80", "INVALID_EXTENDEDOBJECTTYPE_PARTITION_NAME_WARNING", 4);
            }
            if ((this._status & 0x400) != 1024 && !arrayList.contains("PC") && !arrayList.contains("%")) {
                if (arrayList2.contains("PN")) {
                    this._includeSysDefinePartition = true;
                }
                this._includePartitionDefinition = true;
                this.setPartitionDefinition(aSConnection);
            }
        }
        return this.getCreateTableDDL(aSConnection);
    }

    public String getPrimaryAndUniqueConstraints(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        ASResultSet aSResultSet2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = new String[]{this._dbName, this._tableID, aSConnection.getValidNameString()};
        try {
            aSResultSet = new ASResultSet(aSConnection);
            aSResultSet2 = new ASResultSet(aSConnection);
            aSResultSet.open(ASQueryParser.parseQuery("SELECT COLUMNS_COUNT = i.keycnt, INDEX_NAME = CASE WHEN valid_name(i.name {2})=0 THEN ''\"'' + i.name + ''\"'' ELSE i.name END, INDEX_ID = i.indid, STATUS = i.status, STATUS2 = i.status2, FILL_FACTOR = isnull(i.fill_factor,0), MAXROWSPERPAGE = isnull(i.maxrowsperpage,0), RES_PAGE_GAP = isnull(i.res_page_gap,0), SEGMENT_NAME = s.name FROM {0}..sysindexes i, {0}..syssegments s WHERE i.segment = s.segment AND i.id = {1} AND i.indid > 0 AND i.status2 & 2 = 2", objectArray), "PRIMARY_AND_UNIQUE_CONSTRAINTS_OF_TABLE_QUERY");
            while (aSResultSet.getNextRow()) {
                boolean bl = true;
                if ((aSResultSet.getColumnInt(5) & 8) != 8) {
                    stringBuffer.append("\t\tCONSTRAINT ");
                    stringBuffer.append(this.enQuoteToken(aSResultSet.getColumnString(2)));
                    bl = false;
                }
                if ((aSResultSet.getColumnInt(4) & 0x800) == 2048) {
                    stringBuffer.append(" PRIMARY KEY");
                } else {
                    stringBuffer.append(" UNIQUE");
                }
                int n = 0;
                if (aSResultSet.getColumnInt(3) == 1) {
                    stringBuffer.append(" CLUSTERED");
                    n = aSResultSet.getColumnInt(1) + 1;
                } else if (aSResultSet.getColumnInt(3) > 1) {
                    n = aSResultSet.getColumnInt(1);
                    if ((aSResultSet.getColumnInt(5) & 0x200) == 512 || (aSResultSet.getColumnInt(4) & 0x10) == 16) {
                        stringBuffer.append(" CLUSTERED");
                    } else {
                        stringBuffer.append(" NONCLUSTERED");
                    }
                }
                stringBuffer.append(" ( ");
                for (int i = 1; i < n; ++i) {
                    objectArray = new String[]{this._dbName + "." + this._ownerName + "." + this._tableName, aSResultSet.getColumnString(3), String.valueOf(i), aSConnection.getValidNameString()};
                    aSResultSet2.open(this.getIndexColQuery((String[])objectArray), "INDEX_COL_PART1+2");
                    while (aSResultSet2.getNextRow()) {
                        stringBuffer.append(this.enQuoteCol(aSResultSet2.getColumnString(1)));
                        if (aSResultSet2.getColumnString(2).toLowerCase().equals("desc")) {
                            stringBuffer.append(" desc");
                        }
                        stringBuffer.append(", ");
                    }
                    if (aSResultSet2 == null) continue;
                    aSResultSet2.close();
                }
                stringBuffer.setCharAt(stringBuffer.length() - 2, ' ');
                stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
                stringBuffer.append(" ");
                stringBuffer.append(this.getAttributes(aSResultSet.getColumnInt(7), aSResultSet.getColumnInt(6), aSResultSet.getColumnInt(8), 0, true));
                stringBuffer.append(" on '");
                stringBuffer.append(aSResultSet.getColumnString(9));
                stringBuffer.append("',\n");
                if (!bl && UserTableContainer.isPrefetchSet(aSResultSet.getColumnInt(5))) {
                    this._cacheStrategyConstraints.append(UserTableContainer.getPrefetchDDL(this._dbName, this._ownerName, this._tableName, this.enQuoteToken(aSResultSet.getColumnString(2))));
                }
                if (bl || !UserTableContainer.isMRUSet(aSResultSet.getColumnInt(5))) continue;
                this._cacheStrategyConstraints.append(UserTableContainer.getMRUDDL(this._dbName, this._ownerName, this._tableName, this.enQuoteToken(aSResultSet.getColumnString(2))));
            }
            if (aSResultSet != null) {
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U68", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U69", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    @Override
    public void open(ASConnection aSConnection) {
        this.setStrings(aSConnection);
        this._ddlString = this.getIndependentDDL(aSConnection);
        if (this._ddlString == null) {
            new DDLBaseException("U70", "TABLE_NOTFOUND_ERROR", 2, this._name);
        }
        if (this._children.size() > 0) {
            this.generateDDLs();
        } else {
            this.setThreadPoolStatus();
        }
        this.writeProgressInfoToLog(this._tableType, this._name);
    }

    private void setStrings(ASConnection aSConnection) {
        USEDB = ASQueryParser.parseQuery("use {0}", new String[]{this._dbName});
        SETUSR = ASQueryParser.parseQuery("setuser ''{0}''", new String[]{this._ownerName});
        this.KEYS_OF_TABLE_QUERY = ASQueryParser.parseQuery("SELECT type, TABLE1_NAME = CASE WHEN valid_name(object_name(id,db_id(''{0}'')) {1})=0 THEN ''\"'' + object_name(id,db_id(''{0}'')) + ''\"'' ELSE object_name(id,db_id(''{0}'')) END, TABLE2_NAME = CASE WHEN valid_name(object_name(depid,db_id(''{0}'')) {1})=0 THEN ''\"'' + object_name(depid,db_id(''{0}'')) + ''\"'' ELSE object_name(depid,db_id(''{0}'')) END, COL1_NAME = col_name(id,key1,db_id(''{0}'')), COL2_NAME = col_name(id,key2,db_id(''{0}'')), COL3_NAME = col_name(id,key3,db_id(''{0}'')), COL4_NAME = col_name(id,key4,db_id(''{0}'')), ", new String[]{this._dbName, aSConnection.getValidNameString()});
        this.KEYS_OF_TABLE_QUERY = this.KEYS_OF_TABLE_QUERY + ASQueryParser.parseQuery("COL5_NAME = col_name(id,key5,db_id(''{0}'')), COL6_NAME = col_name(id,key6,db_id(''{0}'')), COL7_NAME = col_name(id,key7,db_id(''{0}'')), COL8_NAME = col_name(id,key8,db_id(''{0}'')), DEP1_NAME = col_name(depid,depkey1,db_id(''{0}'')), DEP2_NAME = col_name(depid,depkey2,db_id(''{0}'')), DEP3_NAME = col_name(depid,depkey3,db_id(''{0}'')), DEP4_NAME = col_name(depid,depkey4,db_id(''{0}'')), DEP5_NAME = col_name(depid,depkey5,db_id(''{0}'')), DEP6_NAME = col_name(depid,depkey6,db_id(''{0}'')), ", new String[]{this._dbName});
        this.KEYS_OF_TABLE_QUERY = this.KEYS_OF_TABLE_QUERY + ASQueryParser.parseQuery("DEP7_NAME = col_name(depid,depkey7,db_id(''{0}'')), DEP8_NAME = col_name(depid,depkey8,db_id(''{0}'')) FROM {0}..syskeys WHERE id={1}", new String[]{this._dbName, this._tableID});
    }

    private String getIndexColQuery(String[] stringArray) {
        String string = ASQueryParser.parseQuery("select COL_NAME = CASE WHEN valid_name(INDEX_COL(''{0}'', {1}, {2} ){3})=0 THEN ''\"'' + INDEX_COL(''{0}'', {1}, {2} ) + ''\"'' ELSE INDEX_COL(''{0}'', {1}, {2} ) END, ", stringArray);
        string = string + ASQueryParser.parseQuery("INDEX_COLORDER(''{0}'',{1},{2})", stringArray);
        return string;
    }

    public String getAttributes(int n, int n2, int n3, int n4, boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string = bl ? "fillfactor" : "exp_row_size";
        if (n != 0) {
            if (n2 != 0) {
                if (n3 != 0) {
                    if (n4 != 0) {
                        stringBuffer.append("with max_rows_per_page = " + n);
                        stringBuffer.append(", " + string + " = " + n2);
                        stringBuffer.append(", reservepagegap = " + n3);
                        stringBuffer.append(", identity_gap = " + n4);
                    } else {
                        stringBuffer.append("with max_rows_per_page = " + n);
                        stringBuffer.append(", " + string + " = " + n2);
                        stringBuffer.append(", reservepagegap = " + n3);
                    }
                } else if (n4 != 0) {
                    stringBuffer.append("with max_rows_per_page = " + n);
                    stringBuffer.append(", " + string + " = " + n2);
                    stringBuffer.append(", identity_gap = " + n4);
                } else {
                    stringBuffer.append("with max_rows_per_page = " + n);
                    stringBuffer.append(", " + string + " = " + n2);
                }
            } else if (n3 != 0) {
                if (n4 != 0) {
                    stringBuffer.append("with max_rows_per_page = " + n);
                    stringBuffer.append(", reservepagegap = " + n3);
                    stringBuffer.append(", identity_gap = " + n4);
                } else {
                    stringBuffer.append("with max_rows_per_page = " + n);
                    stringBuffer.append(", reservepagegap = " + n3);
                }
            } else if (n4 != 0) {
                stringBuffer.append("with max_rows_per_page = " + n);
                stringBuffer.append(", identity_gap = " + n4);
            } else {
                stringBuffer.append("with max_rows_per_page = " + n);
            }
        } else if (n2 != 0) {
            if (n3 != 0) {
                if (n4 != 0) {
                    stringBuffer.append("with " + string + " = " + n2);
                    stringBuffer.append(", reservepagegap = " + n3);
                    stringBuffer.append(", identity_gap = " + n4);
                } else {
                    stringBuffer.append("with " + string + " = " + n2);
                    stringBuffer.append(", reservepagegap = " + n3);
                }
            } else if (n4 != 0) {
                stringBuffer.append("with " + string + " = " + n2);
                stringBuffer.append(", identity_gap = " + n4);
            } else {
                stringBuffer.append("with " + string + " = " + n2);
            }
        } else if (n3 != 0) {
            if (n4 != 0) {
                stringBuffer.append("with reservepagegap = " + n3);
                stringBuffer.append(", identity_gap = " + n4);
            } else {
                stringBuffer.append("with reservepagegap = " + n3);
            }
        } else if (n4 != 0) {
            stringBuffer.append("with identity_gap = " + n4);
        }
        return stringBuffer.toString();
    }

    private String getITAttribute(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this._sysstat3 & 0x8000) == 32768) {
            if (string.toLowerCase().indexOf("with") != -1) {
                stringBuffer.append(", transfer table on");
            } else {
                stringBuffer.append("with transfer table on");
            }
        }
        return stringBuffer.toString();
    }

    private String getDMLLoggingAttribute(ASConnection aSConnection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.lastIndexOf(")");
        if (string.substring(n, string.length()).indexOf("with") != -1) {
            stringBuffer.append(", dml_logging = ");
        } else {
            stringBuffer.append("with dml_logging = ");
        }
        if ((this._sysstat3 & 1) == 1) {
            stringBuffer.append(FULL);
        } else if ((this._sysstat3 & 2) == 2) {
            stringBuffer.append(MINIMAL);
        } else {
            try {
                ASResultSet aSResultSet = new ASResultSet(aSConnection);
                Object[] objectArray = new String[]{this._name, DMLLOGGING};
                aSResultSet.open(ASQueryParser.parseQuery("select object_attr(''{0}'', ''{1}'')", objectArray), "TABLE_GET_DEFAULT_SETTING_FOR_DML_LOGGING");
                while (aSResultSet.getNextRow()) {
                    String string2 = aSResultSet.getColumnString(1).trim();
                    if (string2.toString().toLowerCase().equals(FULL)) {
                        stringBuffer.append(FULL);
                        continue;
                    }
                    stringBuffer.append(MINIMAL);
                }
            }
            catch (SQLException sQLException) {
                new DDLBaseException("U77", (Exception)sQLException, 2, this._name);
            }
            catch (Exception exception) {
                new DDLBaseException("U78", exception, "INTERNAL_ERROR", 1);
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getDataCompressionAttribute(ASConnection aSConnection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.lastIndexOf(")");
        if (string.substring(n, string.length()).indexOf("with") != -1) {
            stringBuffer.append(", ").append("compression").append(" = ");
        } else {
            stringBuffer.append("with").append(" ").append("compression").append(" = ");
        }
        if ((this._sysstat3 & 0x1000) == 4096) {
            stringBuffer.append("row");
        } else if ((this._sysstat3 & 0x2000) == 8192) {
            stringBuffer.append("page");
        } else {
            return new String("");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getLOBColumnCompressionAttribute(ASConnection aSConnection, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = new String("");
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableID};
            aSResultSet.open(ASQueryParser.parseQuery("select lobcomp_lvl from {0}.dbo.sysobjects where id = {1}", objectArray), "LOB_COMPRESSION_CLAUSE_OF_TABLE_QUERY");
            while (aSResultSet.getNextRow()) {
                string2 = aSResultSet.getColumnString(1).trim();
                if (string2.equals("0")) {
                    return stringBuffer.toString();
                }
                int n = string.lastIndexOf(")");
                if (string.substring(n, string.length()).indexOf("with") != -1) {
                    stringBuffer.append(", ").append("lob_compression").append(" = ");
                } else {
                    stringBuffer.append("with").append(" ").append("lob_compression").append(" = ");
                }
                stringBuffer.append(string2);
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U83", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U84", exception, "INTERNAL_ERROR", 1);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void setPartitionDefinition(ASConnection aSConnection) {
        this.setPartitionStrategy(aSConnection);
        if (!this._partitionStrategy.equals(ROUND_ROBIN)) {
            this.setPartitionColumns(aSConnection);
        }
        this.setPartitionSpec(aSConnection);
    }

    private void setPartitionStrategy(ASConnection aSConnection) {
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableID};
            aSResultSet.open(ASQueryParser.parseQuery("select number = (select count(*) from {0}.dbo.syspartitions p  where p.id = o.id and p.indid < 2 ), partition_type = isnull((select v.name from master.dbo.spt_values v where v.type = ''PN'' and v.number = i.partitiontype), ''roundrobin'') from {0}.dbo.sysobjects o, {0}.dbo.sysindexes i where  o.id = {1} and i.id = o.id and i.indid <2 ", objectArray), "PARTITION_NO_TYPE_INFO");
            if (aSResultSet.getNextRow()) {
                this._partitionStrategy = aSResultSet.getColumnString("partition_type");
                this._noPartitions = Integer.parseInt(aSResultSet.getColumnString("number"));
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U68", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U69", exception, "INTERNAL_ERROR", 1);
        }
    }

    private void setPartitionColumns(ASConnection aSConnection) {
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableID};
            aSResultSet.open(ASQueryParser.parseQuery("select distinct column_name = c.name, column_type = isnull(x.xtname, isnull(get_xtypename(c.xtype,c.xdbid), t.name)) from {0}.dbo.syscolumns c, {0}.dbo.sysxtypes x, {0}.dbo.systypes t, {0}.dbo.syspartitionkeys p where c.id = {1} and c.xtype *= x.xtid and c.usertype *= t.usertype and p.id = {1} and c.colid = p.colid order by p.position", objectArray), "PARTITION_COL_INFO");
            while (aSResultSet.getNextRow()) {
                this._partitionColumns.append(aSResultSet.getColumnString("column_name")).append(", ");
            }
            if (!this._partitionColumns.toString().equals("")) {
                this._partitionColumns = new StringBuffer("(" + this._partitionColumns.substring(0, this._partitionColumns.length() - 2) + ")");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U71", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U72", exception, "INTERNAL_ERROR", 1);
        }
    }

    private String getPartitionCompressDDL(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        if ((n & 0x10) == 16) {
            stringBuffer.append("with").append(" ").append("compression").append(" = ").append("row");
        } else if ((n & 0x20) == 32) {
            stringBuffer.append("with").append(" ").append("compression").append(" = ").append("page");
        } else if ((n & 0x80) == 128) {
            stringBuffer.append("with").append(" ").append("compression").append(" = ").append("none");
        }
        return stringBuffer.toString();
    }

    private void setPartitionSpec(ASConnection aSConnection) {
        if (this._partitionStrategy.equals(HASH) || this._partitionStrategy.equals(ROUND_ROBIN)) {
            this.setRoundHashSpec(aSConnection);
        } else {
            this.setRangeListSpec(aSConnection);
        }
    }

    private void setRoundHashSpec(ASConnection aSConnection) {
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableID};
            if (this._partitionStrategy.equals(HASH)) {
                aSResultSet.open(ASQueryParser.parseQuery("select partition_name = case when p.indid = 1 then p.cdataptnname else p.name end, segment = s.name, partition_id = isnull(p.partitionid,0), condition_id = i.conditionid, status = isnull(p.status,0) from {0}.dbo.syspartitions p, {0}.dbo.sysindexes i, {0}.dbo.syssegments s where i.id = p.id and i.id = {1} and p.indid < 2 and i.indid = 0 and s.segment = p.segment  and i.conditionid is not null and p.name like ''%'' order by p.partitionid", objectArray), "SELECT_HASH_PARTITIONS");
            } else {
                aSResultSet.open(ASQueryParser.parseQuery("select partition_name = case when p.indid = 1 then p.cdataptnname else p.name end, segment = s.name, partition_id = isnull(p.partitionid,0), condition_id = i.conditionid, status = isnull(p.status,0) from {0}.dbo.syspartitions p, {0}.dbo.sysindexes i, {0}.dbo.syssegments s where i.id = p.id and i.id = {1} and p.indid < 2 and i.indid < 2 and s.segment = p.segment  and i.conditionid is not null and p.name like ''%'' order by p.partitionid", objectArray), "SELECT_ROUND_PARTITIONS");
            }
            boolean bl = false;
            while (aSResultSet.getNextRow()) {
                String string = aSResultSet.getColumnString("partition_name");
                if (!bl) {
                    this._partitionUserDefined = this.isPartitionUserDefined(string, aSResultSet.getColumnString("partition_id"));
                    bl = true;
                }
                if (this._partitionUserDefined || this._includeSysDefinePartition) {
                    if (aSConnection.isDataCompressionApplicable()) {
                        this._partitionSpec.append(aSResultSet.getColumnString("partition_name")).append(" ").append(this.getPartitionCompressDDL(aSResultSet.getColumnInt(5))).append(" ").append("on").append(" ");
                    } else {
                        this._partitionSpec.append(aSResultSet.getColumnString("partition_name")).append(" ").append("on").append(" ");
                    }
                }
                this._partitionSpec.append("'").append(aSResultSet.getColumnString("segment")).append("', ");
            }
            if (!this._partitionSpec.toString().equals("")) {
                this._partitionSpec = new StringBuffer("(" + this._partitionSpec.substring(0, this._partitionSpec.length() - 2) + ")");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U73", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U74", exception, "INTERNAL_ERROR", 1);
        }
    }

    private void setRangeListSpec(ASConnection aSConnection) {
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableID};
            aSResultSet.open(ASQueryParser.parseQuery("select partition_name = case when p.indid = 1 then p.cdataptnname else p.name end, segment = s.name, condition = c.text, status = isnull(p.status,0), partition_id = isnull(p.partitionid,0) from {0}.dbo.syspartitions p, {0}.dbo.sysindexes i, {0}.dbo.syssegments s, {0}.dbo.syscomments c where c.partitionid = p.partitionid and c.id = i.conditionid and i.id = p.id and i.id = {1} and p.indid < 2 and s.segment = p.segment  and i.conditionid is not null and p.name like ''%'' order by c.number", objectArray), "SELECT_RANGE_LIST_PARTITIONS");
            String string = "";
            while (aSResultSet.getNextRow()) {
                string = aSResultSet.getColumnString("partition_name");
                if (this.isPartitionUserDefined(string, aSResultSet.getColumnString("partition_id")) || this._includeSysDefinePartition) {
                    this._partitionSpec.append("\t").append(string).append(" ");
                }
                if (aSConnection.isDataCompressionApplicable()) {
                    this._partitionSpec.append(aSResultSet.getColumnString("condition")).append(" ").append(this.getPartitionCompressDDL(aSResultSet.getColumnInt(4))).append(" ").append("on").append(" ");
                } else {
                    this._partitionSpec.append(aSResultSet.getColumnString("condition")).append(" ").append("on").append(" ");
                }
                this._partitionSpec.append("'").append(aSResultSet.getColumnString("segment")).append("', ").append("\n");
            }
            if (!this._partitionSpec.toString().equals("")) {
                this._partitionSpec = new StringBuffer("(").append("\n").append(this._partitionSpec.substring(0, this._partitionSpec.length() - 3)).append("\n").append(")");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("U75", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("U76", exception, "INTERNAL_ERROR", 1);
        }
    }

    private boolean isPartitionUserDefined(String string, String string2) {
        return string.indexOf(string2) == -1;
    }

    public static boolean isPrefetchSet(int n) {
        return (n & 0x10) == 16;
    }

    public static boolean isMRUSet(int n) {
        return (n & 0x20) == 32;
    }

    public static String getPrefetchTextOnlyDDL(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sp_cachestrategy").append(" ").append(string).append(", '").append(string2).append(".").append(string3).append("', ");
        if (string4.equals("")) {
            stringBuffer.append("'").append("text only").append("'");
        } else {
            stringBuffer.append(string4);
        }
        stringBuffer.append(", ").append("prefetch").append(", '").append("off").append("'");
        stringBuffer.append("\n").append("go ").append("\n\n");
        return stringBuffer.toString();
    }

    public static String getMRUTextOnlyDDL(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sp_cachestrategy").append(" ").append(string).append(", '").append(string2).append(".").append(string3).append("', ");
        if (string4.equals("")) {
            stringBuffer.append("'").append("text only").append("'");
        } else {
            stringBuffer.append(string4);
        }
        stringBuffer.append(", ").append("mru").append(", '").append("off").append("'");
        stringBuffer.append("\n").append("go ").append("\n\n");
        return stringBuffer.toString();
    }

    public static String getPrefetchDDL(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sp_cachestrategy").append(" ").append(string).append(", '").append(string2).append(".").append(string3).append("', ");
        if (string4.equals("")) {
            stringBuffer.append("'").append("table only").append("'");
        } else {
            stringBuffer.append(string4);
        }
        stringBuffer.append(", ").append("prefetch").append(", '").append("off").append("'");
        stringBuffer.append("\n").append("go ").append("\n\n");
        return stringBuffer.toString();
    }

    public static String getMRUDDL(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sp_cachestrategy").append(" ").append(string).append(", '").append(string2).append(".").append(string3).append("', ");
        if (string4.equals("")) {
            stringBuffer.append("'").append("table only").append("'");
        } else {
            stringBuffer.append(string4);
        }
        stringBuffer.append(", ").append("mru").append(", '").append("off").append("'");
        stringBuffer.append("\n").append("go ").append("\n\n");
        return stringBuffer.toString();
    }
}

