/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.io;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.Initializer;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class DDLFileWriter
extends FileWriter {
    private DDLGlobalParameters _ddlGlobalParameters;

    public DDLFileWriter(String string, DDLGlobalParameters dDLGlobalParameters, String[] stringArray) throws IOException {
        super(string);
        this._ddlGlobalParameters = dDLGlobalParameters;
        this.printStartingComment(stringArray);
    }

    public DDLFileWriter(String string, DDLGlobalParameters dDLGlobalParameters, String[] stringArray, boolean bl) throws IOException {
        this(string, dDLGlobalParameters, stringArray);
        this.printProgressLogHeader();
    }

    public DDLFileWriter(String string, boolean bl, String[] stringArray) throws IOException {
        super(string, bl);
        this.printStartingComment(stringArray);
    }

    public synchronized void writeLine(String string) {
        try {
            this.write(string);
            this.flush();
        }
        catch (IOException iOException) {
            new DDLBaseException("DFW1", "FILE_WRITING_ERROR", 4, this._ddlGlobalParameters);
            System.out.println(string);
            this._ddlGlobalParameters.setErrorWriter(null);
        }
    }

    public synchronized void writeProgressLogInfo(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCurrentTime()).append("\t|\t").append(this.format(string)).append("\t|\t").append(string2);
        this.writeLine(stringBuffer.toString() + "\n");
    }

    public String getCurrentTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy k:mm:ss z", Locale.getDefault());
        return simpleDateFormat.format(new Date());
    }

    private void printStartingComment(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("-- ");
        try {
            String string = Initializer.getVersionString();
            string = string.substring(1);
            stringBuffer.append(string).append("\n\n");
            StringTokenizer stringTokenizer = new StringTokenizer(Initializer.getCopyrightString(), "\n");
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("-- ").append(stringTokenizer.nextToken()).append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append("\n\n-- ").append(this._ddlGlobalParameters.getLocalisedMessage("DDLGEN_LOG_STARTING_COMMENT")).append("\n").append("-- ");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-P")) {
                if (stringArray[i].length() == 2 && stringArray[i + 1].toString().equals(this._ddlGlobalParameters.getPassword())) {
                    stringBuffer.append("-P***").append(" ");
                    ++i;
                    continue;
                }
                stringBuffer.append("-P***").append(" ");
                continue;
            }
            stringBuffer.append(stringArray[i]).append(" ");
        }
        stringBuffer.append("\n-- ").append(this._ddlGlobalParameters.getLocalisedMessage("DDLGEN_PROGRESS_LOG_SENT_AT")).append(" ").append(this.getCurrentTime()).append("\n\n\n");
        this.writeLine(stringBuffer.toString());
    }

    private void printEndingComment() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\n-- ").append(this._ddlGlobalParameters.getLocalisedMessage("DDLGEN_LOG_ENDING_COMMENT")).append("\n-- ").append(this._ddlGlobalParameters.getLocalisedMessage("DDLGEN_PROGRESS_LOG_SENT_AT")).append(" ").append(this.getCurrentTime());
        this.writeLine(stringBuffer.toString());
    }

    private void printProgressLogHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._ddlGlobalParameters.getLocalisedMessage("DDLGEN_PROGRESS_LOG_HDR_ENDTIME")).append("\t|\t").append(this._ddlGlobalParameters.getLocalisedMessage("DDLGEN_PROGRESS_LOG_HDR_TYPE")).append("\t\t\t|\t").append(this._ddlGlobalParameters.getLocalisedMessage("DDLGEN_PROGRESS_LOG_HDR_NAME"));
        this.writeLine(stringBuffer.toString() + "\n\n");
    }

    @Override
    public void close() throws IOException {
        this.printEndingComment();
        super.close();
    }

    private String format(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < 20 - string.length(); ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

