/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;

public class CacheItem
extends DDLBaseItem {
    private static final int CACHE_NAME = 0;
    private static final int STATUS = 1;
    private static final int CACHE_SIZE = 2;
    private static final int CACHE_PT = 3;
    private static final int CACHE_INSTANCENAME = 4;
    private static final int SY_CACHE_LOG = 4;
    private static final int SY_CACHE_IN_MEMORY = 196640;
    private static final int RELAXED = 256;
    private static final int STRICT = 512;
    private String _size = "";
    private String _status = "";
    private String _partition = "";
    private String _instanceName = "";
    private String _memSize;
    private String _memUsed;
    private String[] _columns;

    public CacheItem() {
    }

    public CacheItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
    }

    @Override
    public void open(ASConnection aSConnection) throws DDLBaseException {
        this.load(aSConnection);
        this._ddlString = this.generateDDL();
    }

    @Override
    public String[] getIfExistsParameters() {
        return new String[]{"master", null, ASQueryParser.parseQuery("SELECT 1 FROM master.dbo.sysconfigures WHERE name = ''{0}'' AND parent = 19", new String[]{this._name}), ASQueryParser.parseQuery("exec sp_cacheconfig ''{0}'', ''0''", new String[]{this._name})};
    }

    private void load(ASConnection aSConnection) throws DDLBaseException {
        this._name = this._columns[0];
        if (this._name.equals("")) {
            throw new DDLBaseException("C51", "CACHE_NAME_NULL_ERROR", 2);
        }
        this._status = this._columns[1];
        if (this._status.equals("")) {
            throw new DDLBaseException("C52", "CACHE_STATUS_NULL_ERROR", 2, this._name);
        }
        this._size = this._columns[2];
        if (this._size.equals("")) {
            throw new DDLBaseException("C53", "ERROR_OCCURED_IN_CACHE", 2, this._name);
        }
        this._partition = this._columns[3];
        if (this._columns.length > 4) {
            this._instanceName = this._columns[4];
        }
        this.setParameters(aSConnection);
    }

    private void setParameters(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT substring( a.comment, 1, charindex(''K'', a.comment) -1), b.memory_used FROM master.dbo.sysconfigures a, master.dbo.syscurconfigs b WHERE a.parent = 19 AND a.config != a.parent AND b.config = a.config and a.name = ''{0}'' AND b.comment = a.name", objectArray), "CACHE_OPEN_QUERY");
            }
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                this._memSize = stringArray[0];
                this._memUsed = stringArray[1];
            }
            if (aSResultSet != null) {
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("C54", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("C55", exception, "INTERNAL_ERROR", 1, this._name);
        }
    }

    private boolean isLogOnly() {
        return (Integer.parseInt(this._status) & 4) != 0;
    }

    public boolean isInMemoryStorage() {
        return (Integer.parseInt(this._status) & 0x30020) == 196640;
    }

    private String getReplacementPolicy() {
        if ((Integer.parseInt(this._status) & 0x100) == 256) {
            return "relaxed";
        }
        if ((Integer.parseInt(this._status) & 0x200) == 512) {
            return "strict";
        }
        return "";
    }

    @Override
    public String generateDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            n = Integer.parseInt(this._size);
        }
        catch (Exception exception) {
            new DDLBaseException("C56", exception, "INTERNAL_ERROR", 1, this._name);
        }
        if (n > 0) {
            String string;
            stringBuffer.append("exec ").append(" ").append("sp_cacheconfig ");
            stringBuffer.append(" '").append(this._name).append("' , '").append(this._size).append("K").append("' , ");
            if (this.isLogOnly()) {
                stringBuffer.append("logonly");
            } else if (this.isInMemoryStorage()) {
                stringBuffer.append("inmemory_storage");
            } else {
                stringBuffer.append("mixed");
            }
            if (this._instanceName != null && this._instanceName.length() > 0) {
                stringBuffer.append(" , '").append("instance").append(" ").append(this._instanceName).append("'");
            }
            if (!(string = this.getReplacementPolicy()).equals("")) {
                stringBuffer.append(", ").append(string);
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(this._partition);
            }
            catch (Exception exception) {
                new DDLBaseException("C57", exception, "INTERNAL_ERROR", 1, this._name);
            }
            if (n2 > 1) {
                stringBuffer.append(", '").append("cache_partition").append("=").append(n2).append("'");
            }
            stringBuffer.append("\n").append("go ").append("\n");
        }
        if (!this.isInMemoryStorage()) {
            stringBuffer.append("\n").append("exec ").append(" ").append("sp_poolconfig ").append(" '").append(this._name).append("'");
            if (this._memSize != null) {
                stringBuffer.append(" , '").append(this._memSize).append("K").append("'");
            }
            if (this._memUsed != null) {
                stringBuffer.append(" , '").append("wash").append("=").append(this._memUsed).append("K").append("'");
            }
            stringBuffer.append("\n").append("go ").append("\n");
        }
        return stringBuffer.toString();
    }
}

