/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;

public class DumpDeviceItem
extends DDLBaseItem {
    private static final int DEVICE_NAME = 0;
    private static final int PHYSICAL_NAME = 1;
    private static final int DEVICE_SIZE = 2;
    private static final int CNTRL_TYPE = 3;
    private String _physicalName = "";
    private String _size = "";
    private int _cntrlType;
    private String[] _columns;

    public DumpDeviceItem() {
    }

    public DumpDeviceItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
    }

    @Override
    public void open(ASConnection aSConnection) throws DDLBaseException {
        this.load();
        this._ddlString = this.generateDDL();
    }

    private void load() throws DDLBaseException {
        String string;
        this._name = this._columns[0];
        if (this._name.equals("")) {
            new DDLBaseException("DPD51", "DUMP_DEVICE_NAME_NULL_ERROR", 2);
        }
        this._physicalName = this._columns[1];
        if (this._physicalName.equals("")) {
            new DDLBaseException("DPD52", "DUMP_DEVICE_PHYNAME_NULL_ERROR", 2, this._name);
        }
        this._size = this._columns[2];
        if (this._size.equals("")) {
            new DDLBaseException("DPD53", "DUMP_DEVICE_SIZE_NULL", 2, this._name);
        }
        if (!(string = this._columns[3]).equals("")) {
            this._cntrlType = new Integer(string);
        }
    }

    @Override
    public String[] getIfExistsParameters() {
        return new String[]{"master", null, ASQueryParser.parseQuery("SELECT 1 FROM master.dbo.sysdevices WHERE name = ''{0}''", new String[]{this._name}), ASQueryParser.parseQuery("exec sp_dropdevice {0}", new String[]{this._name})};
    }

    @Override
    public String generateDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("exec ").append(" ").append("sp_addumpdevice ").append(" '");
        if (this._name.equals("tapedump1")) {
            stringBuffer.append("tape");
        } else if (this._cntrlType > 2) {
            stringBuffer.append("tape");
        } else if (this._cntrlType == 2) {
            stringBuffer.append("disk");
        } else {
            stringBuffer.append("archive database");
        }
        stringBuffer.append("'").append(" , '").append(this._name).append("' , '").append(this._physicalName).append("'");
        if (this._cntrlType > 2 || this._name.equals("tapedump1")) {
            stringBuffer.append(", ").append(this._size);
        }
        stringBuffer.append("\n").append("go ").append("\n");
        return stringBuffer.toString();
    }
}

