/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.container.EncryptedKeyContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import com.sybase.ddlgen.util.Permission;
import java.sql.SQLException;

public class EncryptedKeyItem
extends DDLBaseItem {
    private String[] _columns;
    private String _dbName;
    private static final int NAME = 0;
    private static final int OWNER = 1;
    private static final int LENGTH = 2;
    private static final int STATUS = 3;
    private static final int TYPE = 4;
    private static final int ID = 5;
    private static final int VALUE = 6;
    private static final int PASSWD = 7;
    private static final int KEY_STATUS_INIT_VECTOR = 1;
    private static final int KEY_STATUS_PAD_STATUS = 2;
    private static final int KEY_STATUS_DEFAULT_STATUS = 5;
    private static final int KEY_STATUS_SYSTEM_PASSWD = 32;
    private static final int KEY_STATUS_USER_PASSWD = 256;
    private static final int KEY_COPY_STATUS_LOGIN_ASSOCIATION = 32;
    private static final int KEY_STATUS_EK_MASTER_ENCR = 2048;
    private static final int KEY_STATUS_EK_DUALCONTROL = 4096;
    private static final int KEY_TYPE_RECOVERY_COPY = 64;
    private static final int KEY_TYPE_EK_MASTER = 128;
    private static final int KEY_TYPE_EK_DUAL_MASTER = 256;
    private static final int KEY_TYPE_EK_AUTO_STARTUP = 512;
    private static final String EK_USER_DESC = "-- The DDL is generated with a default password - 'password' as \n-- a password was specified when this key was created.\n\n";
    private static final String ATTR_ASSIGNEE = "keyuser";
    private static final String ATTR_PASSWD = "passwd";
    private static final String ATTR_KEYSTATUS = "keystatus";
    private static final String ATTR_KEYVALUE = "keyvalue";
    private static final String ATTR_KEYTYPE = "keytype";
    private String _owner = "";
    private String _length = "";
    private int _status;
    private int _type;
    private String _objectID = "";
    private String _value = "";
    private String _passwd = "";
    private boolean _isMasterKey = false;
    private boolean _isDualMasterKey = false;
    private boolean _isDualControlEncryptKeyApp = false;

    public EncryptedKeyItem() {
    }

    public EncryptedKeyItem(String[] stringArray, String string, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
        this._dbName = string;
    }

    @Override
    public void open(ASConnection aSConnection) throws DDLBaseException {
        this.load();
        this._isDualControlEncryptKeyApp = aSConnection.isDualControlEncryptKeyApp();
        this._isMasterKey = (this._type & 0x80) == 128;
        this._isDualMasterKey = (this._type & 0x100) == 256;
        String string = "";
        String string2 = "";
        String string3 = "";
        if (this._isMasterKey || this._isDualMasterKey) {
            string = this.generateMasterKeyDDL();
            string2 = ASQueryParser.parseQuery("setuser ''{0}''", new String[]{this._owner});
            string2 = string2 + "\ngo \n\n";
            string3 = "setuser\ngo \n";
        } else {
            string = this.generateDDL();
        }
        this._ddlString = string2 + string + this.getPermissions(aSConnection) + (((EncryptedKeyContainer)this._parent).isKeyCopyRequired() ? this.getKeyCopiesDDL(aSConnection) : "") + string3;
    }

    private void load() {
        try {
            this._name = this._columns[0];
            this._owner = this._columns[1];
            this._length = this._columns[2];
            this._status = Integer.parseInt(this._columns[3]);
            this._type = Integer.parseInt(this._columns[4]);
            this._objectID = this._columns[5];
            this._value = this._columns[6].substring(0, this._columns[6].lastIndexOf("1") + 1);
            this._passwd = this._columns[7];
        }
        catch (Exception exception) {
            new DDLBaseException("EK51", exception, "INTERNAL_ERROR", 1);
        }
    }

    private boolean getDefaultStatus() {
        return (this._type & 5) == 5;
    }

    private boolean getInitVectorStatus() {
        return (this._status & 1) == 1;
    }

    private boolean getPadStatus() {
        return (this._status & 2) == 2;
    }

    private boolean getDualControlStatus() {
        return (this._status & 0x1000) == 4096;
    }

    public boolean isEncryptedWithSystemPassword() {
        return (this._status & 0x20) == 32;
    }

    public boolean isEncryptedWithUserPassword() {
        return (this._status & 0x100) == 256;
    }

    public boolean isEncryptedWithMaster() {
        return (this._status & 0x800) == 2048;
    }

    private String getPermissions(ASConnection aSConnection) {
        String string = Permission.getPermissions(this._dbName, this._owner, this._name, this._objectID, aSConnection);
        if (!string.equals("")) {
            String string2 = ASQueryParser.parseQuery("use {0}", new String[]{this._dbName});
            string2 = string2 + "\n" + "go " + "\n\n";
            string = string2 + string;
        }
        return string;
    }

    @Override
    public String[] getIfExistsParameters() {
        if (this._isMasterKey) {
            return new String[]{this._dbName, null, this._parent.getParent() == null ? ASQueryParser.parseQuery("SELECT 1 FROM sysobjects o, sysusers u WHERE o.uid=u.uid AND o.name = ''{0}'' AND u.name = ''{1}'' AND o.type = ''{2}''", new String[]{this._name, this._owner, "EK"}) : null, ASQueryParser.parseQuery("drop encryption key {0}", new String[]{"master"})};
        }
        if (this._isDualMasterKey) {
            return new String[]{this._dbName, null, this._parent.getParent() == null ? ASQueryParser.parseQuery("SELECT 1 FROM sysobjects o, sysusers u WHERE o.uid=u.uid AND o.name = ''{0}'' AND u.name = ''{1}'' AND o.type = ''{2}''", new String[]{this._name, this._owner, "EK"}) : null, ASQueryParser.parseQuery("drop encryption key {0}", new String[]{"dual master"})};
        }
        return new String[]{this._dbName, null, this._parent.getParent() == null ? ASQueryParser.parseQuery("SELECT 1 FROM sysobjects o, sysusers u WHERE o.uid=u.uid AND o.name = ''{0}'' AND u.name = ''{1}'' AND o.type = ''{2}''", new String[]{this._name, this._owner, "EK"}) : null, ASQueryParser.parseQuery("drop encryption key {0}", new String[]{this._dbName + "." + this._owner + "." + this._name})};
    }

    private String getKeyCopiesDDL(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = ASQueryParser.parseQuery("select keystatus = status, passwd = eksalt, keyuser = user_name(uid), keyvalue = value, keytype = type from sysencryptkeys where id = {0} and (type & 16) = 16", new String[]{this._objectID});
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            aSResultSet.open(string, "ENCRYP_KEYS_COPIES");
            int n = 0;
            while (aSResultSet.getNextRow()) {
                String string2 = aSResultSet.getColumnString(ATTR_ASSIGNEE);
                String string3 = aSResultSet.getColumnString(ATTR_PASSWD);
                int n2 = new Integer(aSResultSet.getColumnString(ATTR_KEYSTATUS));
                String string4 = aSResultSet.getColumnString(ATTR_KEYVALUE);
                n = new Integer(aSResultSet.getColumnString(ATTR_KEYTYPE));
                stringBuffer.append("alter").append(" ").append("encryption").append(" ").append("key").append(" ");
                if (this._isMasterKey || this._isDualMasterKey) {
                    if (this._isDualMasterKey) {
                        stringBuffer.append("dual").append(" ");
                    }
                    stringBuffer.append("master").append(" ");
                } else {
                    stringBuffer.append(this._dbName).append(".").append(this._owner).append(".").append(this._name).append(" ");
                }
                if (!((EncryptedKeyContainer)this._parent).isValueRequired()) {
                    stringBuffer.append("with").append(" ").append(ATTR_PASSWD).append(" ").append("'").append("password").append("'").append("\n");
                }
                stringBuffer.append("add").append(" ").append("encryption").append(" ").append("\n");
                if ((n & 0x200) != 512) {
                    if (((EncryptedKeyContainer)this._parent).isValueRequired()) {
                        stringBuffer.append("with").append(" ").append(ATTR_KEYVALUE).append(" ").append("0x").append(string4).append(" \n").append(ATTR_PASSWD).append(" ").append("0x").append(string3).append(" \n").append(ATTR_KEYSTATUS).append(" ").append(n2).append(" \n");
                    } else if (!this.isKeyCopyForLoginAssociation(n2)) {
                        stringBuffer.append("with").append(" ").append(ATTR_PASSWD).append(" ").append("'").append("password").append("'").append(" \n");
                    }
                    stringBuffer.append("for").append(" ").append("user").append(" ").append("'").append(string2).append("'").append(" \n");
                    if (this.isKeyCopyForLoginAssociation(n2)) {
                        if (!((EncryptedKeyContainer)this._parent).isValueRequired()) {
                            stringBuffer.append("for").append(" ").append("login_association").append(" \n");
                        }
                        ((EncryptedKeyContainer)this._parent).setEncryptedWithSEPTrue();
                    } else if ((n & 0x40) == 64) {
                        stringBuffer.append("for").append(" ").append("recovery").append(" \n");
                    }
                } else {
                    if (((EncryptedKeyContainer)this._parent).isValueRequired()) {
                        stringBuffer.append("with").append(" ").append(ATTR_KEYVALUE).append(" ").append("0x").append(string4).append(" \n").append(ATTR_PASSWD).append(" ").append("0x").append(string3).append(" \n").append(ATTR_KEYSTATUS).append(" ").append(n2).append(" \n");
                    }
                    stringBuffer.append("for").append(" ").append("automatic_startup").append(" \n");
                }
                stringBuffer.append("go ").append("\n\n");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("EK52", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("EK53", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    private boolean isKeyCopyForLoginAssociation(int n) {
        return (n & 0x20) == 32;
    }

    @Override
    public String generateDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create").append(" ").append("encryption").append(" ").append("key").append(" ").append(this._dbName).append(".").append(this._owner).append(".").append(this._name).append(" ");
        if (this.getDefaultStatus()) {
            stringBuffer.append("as").append(" ").append("default").append(" ");
        }
        stringBuffer.append("for").append(" ").append("AES").append("\n");
        stringBuffer.append("with").append(" ").append("keylength").append(" ").append(this._length).append(" ").append("\n");
        if (((EncryptedKeyContainer)this._parent).isValueRequired()) {
            stringBuffer.append(ATTR_PASSWD).append(" ").append("0x").append(this._passwd).append("\n");
        } else if (!this._isDualControlEncryptKeyApp) {
            if (!this.isEncryptedWithSystemPassword()) {
                stringBuffer = new StringBuffer(EK_USER_DESC + stringBuffer);
                stringBuffer.append(ATTR_PASSWD).append(" ").append("'").append("password").append("'").append("\n");
            }
        } else if (this.isEncryptedWithUserPassword()) {
            stringBuffer = new StringBuffer(EK_USER_DESC + stringBuffer);
            stringBuffer.append(ATTR_PASSWD).append(" ").append("'").append("password").append("'").append("\n");
        } else if (this.isEncryptedWithSystemPassword()) {
            stringBuffer = new StringBuffer(EK_USER_DESC + stringBuffer);
            stringBuffer.append(ATTR_PASSWD).append(" ").append("system_encr_passwd").append("\n");
        } else if (this.isEncryptedWithMaster() && !this.getDualControlStatus()) {
            stringBuffer = new StringBuffer(EK_USER_DESC + stringBuffer);
            stringBuffer.append("master").append(" ").append("key").append("\n");
        }
        stringBuffer.append("init_vector").append(" ").append(this.getInitVectorStatus() ? "random" : "NULL").append(" ").append("\n");
        if (this.getPadStatus()) {
            stringBuffer.append("pad").append(" ").append("random").append(" ").append("\n");
        }
        if (((EncryptedKeyContainer)this._parent).isValueRequired()) {
            stringBuffer.append(ATTR_KEYVALUE).append(" ").append("0x").append(this._value).append(" ").append("\n").append(ATTR_KEYSTATUS).append(" ").append(this._status).append(" ").append("\n");
        }
        if (this.getDualControlStatus()) {
            stringBuffer.append("dual_control").append("\n");
        }
        stringBuffer.append("go ").append("\n\n");
        return stringBuffer.toString();
    }

    public String generateMasterKeyDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create").append(" ").append("encryption").append(" ").append("key");
        if (this._isDualMasterKey) {
            stringBuffer.append(" ").append("dual");
        }
        stringBuffer.append(" ").append("master").append(" ");
        stringBuffer.append("for").append(" ").append("AES").append("\n").append("with").append(" ");
        if (((EncryptedKeyContainer)this._parent).isValueRequired()) {
            stringBuffer.append(ATTR_PASSWD).append(" ").append("0x").append(this._passwd).append("\n");
        } else if (this.isEncryptedWithUserPassword()) {
            stringBuffer = new StringBuffer(EK_USER_DESC + stringBuffer);
            stringBuffer.append(ATTR_PASSWD).append(" ").append("'").append("password").append("'").append("\n");
        }
        if (((EncryptedKeyContainer)this._parent).isValueRequired()) {
            stringBuffer.append(ATTR_KEYVALUE).append(" ").append("0x").append(this._value).append(" ").append("\n").append(ATTR_KEYSTATUS).append(" ").append(this._status).append(" ").append("\n");
        }
        stringBuffer.append("go ").append("\n\n");
        return stringBuffer.toString();
    }
}

