/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.container.IndexContainer;
import com.sybase.ddlgen.container.UserTableContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class IndexItem
extends DDLBaseItem {
    private static final int DBNAME = 0;
    private static final int TABLE_NAME = 1;
    private static final int INDEX_NAME = 2;
    private static final int INDEX_ID = 3;
    private static final int STATUS = 4;
    private static final int OWNER_NAME = 5;
    private static final int KEY_COUNT = 6;
    private static final int MAX_ROWS_PER_PAGE = 7;
    private static final int FILL_FACTOR = 8;
    private static final int RES_PAGE_GAP = 9;
    private static final int SEGMENT = 10;
    private static final int STATUS2 = 11;
    private String _dbName = "";
    private String _tableName = "";
    private long _indexID = 0L;
    private String _tableOwner = "";
    private int _indexStatus = 0;
    private int _indexStatus2 = 0;
    private String[] _indexColumns;
    private String _cacheName = "";
    private int _colKeyCnt = 0;
    private int _maxRowsPerPage = 0;
    private int _reservePageGap = 0;
    private int _fillFactor = 0;
    private String _segment = "";
    private String[] _columns;
    private StringBuffer _partitionDefinition = new StringBuffer();
    private boolean _ignoreDuplicateKeys = false;
    private boolean _abortDuplicateRows = false;
    private boolean _isClustered = false;
    private boolean _isUnique = false;
    private boolean _allowDuplicateRows = false;
    private boolean _isSorted = false;
    private boolean _setQuotedIdentifierOn = false;
    private int IDX_STATUS_IGNORE_DUPKEYS = 1;
    private int IDX_STATUS_ABORT_DUPROWS = 4;
    private int IDX_STATUS_CLUSTERED = 16;
    private int IDX_STATUS_UNIQUE = 2;
    private int IDX_STATUS_ALLOW_DUPROWS = 64;
    private int IDX_STATUS_SORTED = 512;
    private int IDX_STATUS2_DATA_CLUSTERED = 512;
    private static final int COL_STATUS3_FUNC_EXPRESSION = 1;
    private static final int PT_LOCAL_STATUS = 8;
    private static final int PT_NAME_DEFINED = 4;
    private boolean _includePartitionDefinition = false;

    public IndexItem() {
    }

    public IndexItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
    }

    @Override
    public void open(ASConnection aSConnection) throws DDLBaseException {
        if (((IndexContainer)this._parent).getParentContainer() != null) {
            this.loadFromParent();
        } else {
            this.load();
        }
        this._indexColumns = this.setIndexColumns(aSConnection);
        this.setCache(aSConnection);
        ArrayList arrayList = ((IndexContainer)this._parent).getDDLGlobalParameters().getFilters();
        if (!arrayList.contains("PC") && !arrayList.contains("%")) {
            this._includePartitionDefinition = true;
        }
        if (this._includePartitionDefinition && aSConnection.isPartitionsApplicable()) {
            this.setPartitionDefinition(aSConnection);
        }
        if (this._setQuotedIdentifierOn && aSConnection.getServerVersion().compareTo("15.7") >= 0 && 0 == aSConnection.getSPConfigValue("quoted identifier enhancements")) {
            new DDLBaseException("I71", "ENABLE_QUOTED_IDENTIFIER_ENHANCEMENTS_WARNING", 1);
        }
        this._ddlString = this.generateDDL();
    }

    private void loadFromParent() throws DDLBaseException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        this._name = this._columns[2];
        if (this._name.equals("")) {
            new DDLBaseException("I51", "INDEX_NAME_NULL_ERROR", 2);
        }
        if (this._name.indexOf(34) != -1) {
            this._setQuotedIdentifierOn = true;
        }
        this._dbName = ((IndexContainer)this._parent).getParentContainer().getDBName();
        if (this._dbName.equals("")) {
            new DDLBaseException("I52", "INDEX_DB_NAME_NULL_ERROR", 2, this._name);
        }
        this._tableName = ((IndexContainer)this._parent).getParentContainer().getTableName();
        if (this._tableName.equals("")) {
            new DDLBaseException("I53", "INDEX_TABLE_NAME_NULL_ERROR", 2, this._dbName + "." + this._name);
        }
        if (this._tableName.indexOf(34) != -1) {
            this._setQuotedIdentifierOn = true;
        }
        this._indexID = new Long(this._columns[3].trim());
        if (this._indexID == 0L) {
            new DDLBaseException("I54", "INDEX_ID_NULL_ERROR", 2, this._dbName + "." + this._tableName + "." + this._name);
        }
        if (!(string6 = this._columns[4].trim()).equals("")) {
            this._indexStatus = new Integer(string6);
        }
        if (!(string5 = this._columns[11].trim()).equals("")) {
            this._indexStatus2 = new Integer(string5);
        }
        this._tableOwner = ((IndexContainer)this._parent).getParentContainer().getOwnerName();
        if (this._tableOwner.equals("")) {
            new DDLBaseException("I55", "INDEX_TABLE_OWNER_NAME_NULL_ERROR", 2, this._dbName + "." + this._tableName + "." + this._name);
        }
        if (!(string4 = this._columns[6].trim()).equals("")) {
            this._colKeyCnt = new Integer(string4);
        }
        if (!(string3 = this._columns[7].trim()).equals("")) {
            this._maxRowsPerPage = new Integer(string3);
        }
        if (!(string2 = this._columns[8].trim()).equals("")) {
            this._fillFactor = new Integer(string2);
        }
        if (!(string = this._columns[9].trim()).equals("")) {
            this._reservePageGap = new Integer(string);
        }
        this._segment = this._columns[10];
        this.ignoreDuplicateKeys();
        this.abortDuplicateRows();
        this.setClustered();
        this.setUnique();
        this.setSorted();
        this.allowDuplicateRows();
    }

    private void load() throws DDLBaseException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        this._name = this._columns[2];
        if (this._name.equals("")) {
            new DDLBaseException("I56", "INDEX_NAME_NULL_ERROR", 2);
        }
        if (this._name.indexOf(" ") != -1 || this._name.indexOf(34) != -1) {
            this._setQuotedIdentifierOn = true;
        }
        this._dbName = this._columns[0];
        if (this._dbName.equals("")) {
            new DDLBaseException("I57", "INDEX_DB_NAME_NULL_ERROR", 2, this._name);
        }
        if (this._dbName.indexOf(" ") != -1) {
            this._setQuotedIdentifierOn = true;
        }
        this._tableName = this._columns[1];
        if (this._tableName.equals("")) {
            new DDLBaseException("I58", "INDEX_TABLE_NAME_NULL_ERROR", 2, this._dbName + "." + this._name);
        }
        if (this._tableName.indexOf(" ") != -1 || this._tableName.indexOf(34) != -1) {
            this._setQuotedIdentifierOn = true;
        }
        this._indexID = new Long(this._columns[3].trim());
        if (this._indexID == 0L) {
            new DDLBaseException("I59", "INDEX_ID_NULL_ERROR", 2, this._dbName + "." + this._tableName + "." + this._name);
        }
        if (!(string6 = this._columns[4].trim()).equals("")) {
            this._indexStatus = new Integer(string6);
        }
        if (!(string5 = this._columns[11].trim()).equals("")) {
            this._indexStatus2 = new Integer(string5);
        }
        this._tableOwner = this._columns[5];
        if (this._tableOwner.equals("")) {
            new DDLBaseException("I60", "INDEX_TABLE_OWNER_NAME_NULL_ERROR", 2, this._dbName + "." + this._tableName + "." + this._name);
        }
        if (!(string4 = this._columns[6].trim()).equals("")) {
            this._colKeyCnt = new Integer(string4);
        }
        if (!(string3 = this._columns[7].trim()).equals("")) {
            this._maxRowsPerPage = new Integer(string3);
        }
        if (!(string2 = this._columns[8].trim()).equals("")) {
            this._fillFactor = new Integer(string2);
        }
        if (!(string = this._columns[9].trim()).equals("")) {
            this._reservePageGap = new Integer(string);
        }
        this._segment = this._columns[10];
        this.ignoreDuplicateKeys();
        this.abortDuplicateRows();
        this.setClustered();
        this.setUnique();
        this.setSorted();
        this.allowDuplicateRows();
    }

    private void ignoreDuplicateKeys() {
        if ((this._indexStatus & this.IDX_STATUS_IGNORE_DUPKEYS) != 0) {
            this._ignoreDuplicateKeys = true;
        }
    }

    private void abortDuplicateRows() {
        if ((this._indexStatus & this.IDX_STATUS_ABORT_DUPROWS) != 0) {
            this._abortDuplicateRows = true;
        }
    }

    private void allowDuplicateRows() {
        if ((this._indexStatus & this.IDX_STATUS_ALLOW_DUPROWS) != 0 || !this._isUnique && this._isClustered && this._indexID > 1L) {
            this._allowDuplicateRows = true;
        }
    }

    private void setClustered() {
        if ((this._indexStatus & this.IDX_STATUS_CLUSTERED) != 0 || (this._indexStatus2 & this.IDX_STATUS2_DATA_CLUSTERED) != 0) {
            this._isClustered = true;
        }
    }

    private void setUnique() {
        if ((this._indexStatus & this.IDX_STATUS_UNIQUE) != 0) {
            this._isUnique = true;
        }
    }

    private void setSorted() {
        if ((this._indexStatus & this.IDX_STATUS_SORTED) != 0) {
            this._isSorted = true;
        }
    }

    private void setCache(ASConnection aSConnection) {
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableName, String.valueOf(this._indexID), this._tableOwner};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select char_value FROM {0}..sysattributes b, {0}..sysobjects c WHERE c.id = b.object AND b.object_info1 = {2} AND c.id in (Select object_id(''{0}.{3}.{1}''))  AND object_type = ''I''", objectArray), "CACHE_QUERY");
                while (aSResultSet.getNextRow()) {
                    String[] stringArray = aSResultSet.getColumnsAsArray();
                    this._cacheName = stringArray[0];
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("I61", (Exception)sQLException, 2, this._dbName + "." + this._tableOwner + "." + this._tableName + "." + this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("I62", exception, "INTERNAL_ERROR", 1);
        }
    }

    private String[] setIndexColumns(ASConnection aSConnection) {
        if (this._indexID != 1L) {
            --this._colKeyCnt;
        }
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        String[] stringArray = new String[this._colKeyCnt];
        try {
            String string = null;
            String string2 = null;
            for (int i = 0; i < this._colKeyCnt; ++i) {
                Object[] objectArray = new String[]{this._dbName + "." + this._tableOwner + "." + this._tableName, String.valueOf(this._indexID), String.valueOf(i + 1), aSConnection.getValidNameString()};
                String string3 = ASQueryParser.parseQuery("select COL_NAME = CASE WHEN valid_name(INDEX_COL(''{0}'', {1}, {2} ){3})=0 THEN ''\"'' + INDEX_COL(''{0}'', {1}, {2} ) + ''\"'' ELSE INDEX_COL(''{0}'', {1}, {2} ) END, ", objectArray);
                string3 = string3 + ASQueryParser.parseQuery("INDEX_COLORDER(''{0}'',{1},{2})", objectArray);
                if (aSResultSet == null) continue;
                aSResultSet.open(string3, "INDEX_COL_PART1+2");
                while (aSResultSet.getNextRow()) {
                    String[] stringArray2 = aSResultSet.getColumnsAsArray();
                    string = stringArray2[1];
                    string2 = this.getColNameExpression(stringArray2[0], aSConnection);
                    stringArray[i] = string.equals("DESC") ? string2 + " " + string : string2;
                    if (stringArray2[0].indexOf(" ") == -1) continue;
                    this._setQuotedIdentifierOn = true;
                }
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("I63", (Exception)sQLException, 2, this._dbName + "." + this._tableOwner + "." + this._tableName + "." + this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("I64", exception, "INTERNAL_ERROR", 1);
        }
        if (aSResultSet != null) {
            aSResultSet = null;
        }
        return stringArray;
    }

    private String getColNameExpression(String string, ASConnection aSConnection) {
        try {
            if (aSConnection.getServerVersion().compareTo("15") < 0) {
                return string;
            }
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableOwner, this._tableName, string};
            String string2 = ASQueryParser.parseQuery("select isnull(status3,0),computedcol from {0}.dbo.syscolumns  where name = ''{3}'' and id = object_id(''{0}.{1}.{2}'')", objectArray);
            aSResultSet.open(string2, "INDEX_COL_STATUS3");
            int n = 0;
            boolean bl = false;
            String[] stringArray = null;
            while (aSResultSet.getNextRow()) {
                stringArray = aSResultSet.getColumnsAsArray();
                if (stringArray[0].equals("0") && stringArray[0].equals("") || ((n = new Integer(stringArray[0]).intValue()) & 1) <= 0) continue;
                bl = true;
            }
            if (bl) {
                return this.getFunctionalIndexExpression(aSConnection, stringArray[1]);
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("I65", (Exception)sQLException, 2, this._dbName + "." + this._tableOwner + "." + this._tableName + "." + this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("I66", exception, "INTERNAL_ERROR", 1);
        }
        return string;
    }

    private String getFunctionalIndexExpression(ASConnection aSConnection, String string) {
        String string2 = "";
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, string};
            String string3 = ASQueryParser.parseQuery("select text from {0}.dbo.syscomments where id = {1}", objectArray);
            aSResultSet.open(string3, "COL_EXPRESSION");
            int n = 0;
            while (aSResultSet.getNextRow()) {
                ++n;
                String string4 = aSResultSet.getColumnsAsArray()[0];
                if (!string4.equals("")) {
                    String string5;
                    int n2;
                    string4 = string4.trim();
                    if (n == 1) {
                        string4 = string4.substring(string4.indexOf("AS") + 2).trim();
                    }
                    if ((n2 = (string5 = string4.toUpperCase()).lastIndexOf("MATERIALIZED")) != -1) {
                        string4 = string4.substring(0, n2).trim();
                        n2 = string5.lastIndexOf("NOT");
                        if (n2 != -1) {
                            string4 = string4.substring(0, n2).trim();
                        }
                    }
                }
                string2 = string2 + string4;
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("I67", (Exception)sQLException, 2, this._dbName + "." + this._tableOwner + "." + this._tableName + "." + this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("I68", exception, "INTERNAL_ERROR", 1);
        }
        return string2;
    }

    private String enQuoteToken(String string) {
        String string2 = string;
        if (string.startsWith("\"")) {
            this._setQuotedIdentifierOn = true;
            string = string.substring(1, string.length() - 1);
            string2 = "\"";
            int n = -1;
            while ((n = string.indexOf(34)) != -1) {
                string2 = string2 + string.substring(0, n + 1) + "\"";
                string = string.substring(n + 1);
            }
            string2 = string2 + string + "\"";
        }
        return string2;
    }

    private void setPartitionDefinition(ASConnection aSConnection) {
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._tableOwner, this._tableName, this._name};
            String string = ASQueryParser.parseQuery("select partition_name = case when p.indid = 1 then p.cdataptnname else p.name end, segment = s.name,status3 = isnull(i.status3,0), status = isnull(p.status,0) from {0}.dbo.syspartitions p, {0}.dbo.sysindexes i, {0}.dbo.syssegments s where i.id = p.id and i.id = object_id(''{0}.{1}.{2}'') and p.indid >0 and i.indid< 255 and i.indid = p.indid and s.segment = p.segment  and i.conditionid is not null and p.name like ''%'' and i.name like ''{3}'' order by 1", objectArray);
            aSResultSet.open(string, "SELECT_INDEX_PARTITIONS");
            boolean bl = false;
            boolean bl2 = false;
            while (aSResultSet.getNextRow()) {
                bl = (Integer.parseInt(aSResultSet.getColumnString("status3")) & 8) != 0;
                if (!bl || !(bl2 = (Integer.parseInt(aSResultSet.getColumnString("status")) & 4) != 0)) continue;
                this._partitionDefinition.append(aSResultSet.getColumnString("partition_name")).append(" ").append("on").append(" '").append(aSResultSet.getColumnString("segment")).append("', ");
            }
            if (!this._partitionDefinition.toString().equals("")) {
                this._partitionDefinition = new StringBuffer(this._partitionDefinition.substring(0, this._partitionDefinition.length() - 2));
            }
            if (bl) {
                this._partitionDefinition = new StringBuffer("local index " + this._partitionDefinition.toString());
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("I69", (Exception)sQLException, 2, this._dbName + "." + this._tableOwner + "." + this._tableName + "." + this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("I70", exception, "INTERNAL_ERROR", 1);
        }
    }

    @Override
    public String[] getIfExistsParameters() {
        String string = "";
        if (this._tableName.startsWith("\"")) {
            string = this._tableName.substring(1, this._tableName.length() - 1);
        }
        String string2 = "";
        if (this._name.startsWith("\"")) {
            string2 = this._name.substring(1, this._name.length() - 1);
        }
        if (string2.length() != 0) {
            return new String[]{this._dbName, this._tableOwner, this._parent.getParent() == null ? ASQueryParser.parseQuery("SELECT 1 FROM sysindexes i, sysobjects o, sysusers u WHERE  o.id = i.id AND o.uid = u.uid AND i.name = ''{0}'' AND u.name = ''{1}'' AND o.name = ''{2}'' AND i.indid > 0", new String[]{string2, this._tableOwner, string.length() != 0 ? string : this._tableName}) : null, ASQueryParser.parseQuery("drop index {0}", new String[]{this._tableName + "." + this._name})};
        }
        return new String[]{this._dbName, this._tableOwner, this._parent.getParent() == null ? ASQueryParser.parseQuery("SELECT 1 FROM sysindexes i, sysobjects o, sysusers u WHERE  o.id = i.id AND o.uid = u.uid AND i.name = ''{0}'' AND u.name = ''{1}'' AND o.name = ''{2}'' AND i.indid > 0", new String[]{this._name, this._tableOwner, string.length() != 0 ? string : this._tableName}) : null, ASQueryParser.parseQuery("drop index {0}", new String[]{this._tableName + "." + this._name})};
    }

    @Override
    public String getIfExistsStatement() {
        String[] stringArray = this.getIfExistsParameters();
        if (stringArray == null || stringArray[2] == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray[0] != null && !this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
            stringBuffer.append("use " + stringArray[0]);
            stringBuffer.append("\ngo\n\n");
            this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
        }
        if (this._setQuotedIdentifierOn) {
            stringBuffer.append("set quoted_identifier on").append("\n").append("go ").append("\n\n");
        }
        stringBuffer.append("IF EXISTS (");
        stringBuffer.append(stringArray[2]).append(")\n");
        if (stringArray[1] != null) {
            stringBuffer.append("BEGIN").append("\n\tsetuser '").append(stringArray[1]).append("'\n");
        }
        if (stringArray[3] != null && stringArray[3].trim().length() != 0) {
            if (!stringArray[3].trim().startsWith("BEGIN")) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(stringArray[3]).append("\n\n");
        }
        if (stringArray[1] != null) {
            stringBuffer.append("END\n").append("go ").append("\n");
        }
        stringBuffer.append("\n");
        if (this._setQuotedIdentifierOn) {
            stringBuffer.append("set quoted_identifier off").append("\n").append("go ").append("\n\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String generateDDL() {
        int n;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._setQuotedIdentifierOn) {
            stringBuffer.append("set quoted_identifier on").append("\n").append("go ").append("\n\n");
        }
        stringBuffer.append("create ");
        if (this._isUnique) {
            stringBuffer.append("unique").append(" ");
        }
        if (this._isClustered) {
            stringBuffer.append("clustered").append(" ");
        } else {
            stringBuffer.append("nonclustered").append(" ");
        }
        stringBuffer.append("index").append(" ").append(this._name).append(" ");
        stringBuffer.append("\n");
        stringBuffer.append("on").append(" ");
        stringBuffer.append(this._dbName);
        stringBuffer.append(".");
        stringBuffer.append(this._tableOwner).append(".");
        stringBuffer.append(this.enQuoteToken(this._tableName));
        stringBuffer.append("(");
        for (n = 0; n < this._indexColumns.length; ++n) {
            stringBuffer.append(this.enQuoteToken(this._indexColumns[n]));
            if (n == this._indexColumns.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")\n");
        n = 0;
        if (this._ignoreDuplicateKeys || this._abortDuplicateRows || this._allowDuplicateRows || this._maxRowsPerPage != 0 || this._reservePageGap != 0) {
            stringBuffer.append("with ");
            n = 1;
        }
        boolean bl2 = false;
        if (this._fillFactor != 0) {
            bl = true;
        }
        if (this._maxRowsPerPage != 0) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("max_rows_per_page").append("=").append(this._maxRowsPerPage).append(" ");
            bl2 = true;
        }
        if (this._reservePageGap != 0) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("reservepagegap").append("=").append(this._reservePageGap).append(" ");
            bl2 = true;
        }
        if (this._ignoreDuplicateKeys) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("ignore_dup_key").append(" ");
            bl2 = true;
        }
        if (n != 0) {
            stringBuffer.append("\n");
        }
        n = 0;
        if (this._allowDuplicateRows) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("allow_dup_row").append(" ");
            bl2 = true;
            n = 1;
        } else if (this._abortDuplicateRows) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("ignore_dup_row").append(" ");
            bl2 = true;
            n = 1;
        }
        if (n != 0) {
            stringBuffer.append("\n");
            n = 0;
        }
        if (!this._segment.equals("default")) {
            stringBuffer.append("on").append(" '").append(this._segment).append("' ");
            n = 1;
        }
        if (n != 0) {
            stringBuffer.append("\n");
            n = 0;
        }
        if (!this._partitionDefinition.toString().equals("")) {
            stringBuffer.append(this._partitionDefinition.toString());
            n = 1;
        }
        if (n != 0) {
            stringBuffer.append("\n");
            n = 0;
        }
        stringBuffer.append("go ").append("\n\n");
        if (bl) {
            if (this._parent.getDDLGlobalParameters().excludeIfExistsDDL() && !this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
                stringBuffer.append("use").append(" ").append(this._dbName).append("\n");
                stringBuffer.append("go ").append("\n\n");
                this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
            }
            stringBuffer.append("sp_chgattribute").append("  ").append("'").append(this._tableName).append(".").append(this._name).append("' , '").append("fillfactor").append("' , ").append(this._fillFactor);
            stringBuffer.append("\n").append("go ").append("\n");
            n = 1;
        }
        if (n != 0) {
            stringBuffer.append("\n");
        }
        if (!this._cacheName.equals("default data cache") && !this._cacheName.equals("")) {
            stringBuffer.append("sp_bindcache ").append(" '").append(this._cacheName).append("', '").append(this._dbName).append("', '").append(this._tableOwner).append(".").append(this._tableName).append("', '").append(this._name).append("' ");
            stringBuffer.append("\n").append("go ").append("\n\n");
        }
        if (UserTableContainer.isPrefetchSet(this._indexStatus2)) {
            if (this._parent.getDDLGlobalParameters().excludeIfExistsDDL() && !this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
                stringBuffer.append("use").append(" ").append(this._dbName).append("\n");
                stringBuffer.append("go ").append("\n\n");
                this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
            }
            stringBuffer.append(UserTableContainer.getPrefetchDDL(this._dbName, this._tableOwner, this._tableName, this._name));
        }
        if (UserTableContainer.isMRUSet(this._indexStatus2)) {
            if (this._parent.getDDLGlobalParameters().excludeIfExistsDDL() && !this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
                stringBuffer.append("use").append(" ").append(this._dbName).append("\n");
                stringBuffer.append("go ").append("\n\n");
                this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
            }
            stringBuffer.append(UserTableContainer.getMRUDDL(this._dbName, this._tableOwner, this._tableName, this._name));
        }
        if (this._setQuotedIdentifierOn) {
            stringBuffer.append("set quoted_identifier off").append("\n").append("go ").append("\n\n");
        }
        return stringBuffer.toString();
    }
}

