/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.container.KeyConstraintContainer;
import com.sybase.ddlgen.container.UserTableContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;

public class KeyConstraintItem
extends DDLBaseItem {
    private String _dbName;
    private String _sOwnerName;
    private String _sTableName;
    private String _sKeyColList;
    private String _sConstraintName;
    private String _sConstraintType;
    private String _sConstraintKeyType;
    private String _sConstraintAttributes;
    private String _sConstraintSegmentName;
    private boolean _blnIsQuotedIdentifier;
    private boolean _blnIsSystemGenerated;
    private int _indexStatus2;

    public KeyConstraintItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._dbName = stringArray[0];
        this._sKeyColList = stringArray[6];
        this._blnIsQuotedIdentifier = this._sKeyColList.indexOf(34) != -1;
        this._sTableName = stringArray[2];
        this._blnIsQuotedIdentifier = this._blnIsQuotedIdentifier ? true : this._sTableName.indexOf(34) != -1;
        this._sOwnerName = stringArray[1];
        this._sConstraintType = stringArray[5];
        this._sConstraintName = stringArray[3];
        this._blnIsQuotedIdentifier = this._blnIsQuotedIdentifier ? true : this._sConstraintName.indexOf(34) != -1;
        this._sConstraintKeyType = stringArray[4];
        this._sConstraintAttributes = stringArray[7];
        this._sConstraintSegmentName = stringArray[8];
        this._blnIsSystemGenerated = stringArray[9].equals("true");
        this._indexStatus2 = Integer.parseInt(stringArray[10]);
    }

    @Override
    public void open(ASConnection aSConnection) {
        ((KeyConstraintContainer)this._parent).setDependentDDL(this.generateDDL());
        this._ddlString = "";
    }

    @Override
    public String[] getIfExistsParameters() {
        return new String[]{null, null, this._parent.getParent() == null ? ASQueryParser.parseQuery("SELECT 1 FROM sysindexes i, sysobjects o, sysusers u WHERE  o.id = i.id AND o.uid = u.uid AND i.name = ''{0}'' AND u.name = ''{1}'' AND o.name = ''{2}'' AND i.indid > 0", new String[]{this._dbName, this._name}) : null, ASQueryParser.parseQuery("alter table {0} drop constraint {1}", new String[]{this._dbName + "." + this._sOwnerName + "." + this._sTableName, this._sConstraintName})};
    }

    @Override
    public String generateDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._blnIsQuotedIdentifier) {
            stringBuffer.append("set quoted_identifier on").append("\ngo\n\n");
        }
        stringBuffer.append("alter table ").append(this._dbName).append(".").append(this._sOwnerName).append(".").append(this._sTableName).append("\n");
        stringBuffer.append("add ");
        if (!this._blnIsSystemGenerated) {
            stringBuffer.append("constraint ").append(this._sConstraintName).append(" ");
        }
        stringBuffer.append(this._sConstraintKeyType).append(" ").append(this._sConstraintType).append(" (");
        stringBuffer.append(this._sKeyColList).append(")");
        stringBuffer.append(this._sConstraintAttributes.equals("") ? "" : "\n\t " + this._sConstraintAttributes);
        stringBuffer.append("\n\t on '").append(this._sConstraintSegmentName);
        stringBuffer.append("'\ngo\n\n");
        if (!this._blnIsSystemGenerated && UserTableContainer.isPrefetchSet(this._indexStatus2)) {
            if (!this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
                stringBuffer.append("use").append(" ").append(this._dbName).append("\n");
                stringBuffer.append("go ").append("\n\n");
                this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
            }
            stringBuffer.append(UserTableContainer.getPrefetchDDL(this._dbName, this._sOwnerName, this._sTableName, this._sConstraintName));
        }
        if (!this._blnIsSystemGenerated && UserTableContainer.isMRUSet(this._indexStatus2)) {
            if (!this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
                stringBuffer.append("use").append(" ").append(this._dbName).append("\n");
                stringBuffer.append("go ").append("\n\n");
                this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
            }
            stringBuffer.append(UserTableContainer.getMRUDDL(this._dbName, this._sOwnerName, this._sTableName, this._sConstraintName));
        }
        if (this._blnIsQuotedIdentifier) {
            stringBuffer.append("set quoted_identifier off").append("\ngo\n\n");
        }
        return stringBuffer.toString();
    }
}

