/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class LoginItem
extends DDLBaseItem {
    private static final int DBNAME = 0;
    private static final int LANGUAGE = 1;
    private static final int FULLNAME = 2;
    private static final int SUID = 3;
    private static final int STATUS = 4;
    private static final int NAME = 5;
    private static final int AUDITFLAG = 6;
    private static final int LOGINPROFILEID = 7;
    private static final int PROCID = 8;
    private static final int PASSWORDEXPIRY = 0;
    private static final int MINPASSWORDLEN = 1;
    private static final int MAXFAILEDLOGINS = 2;
    public static final int SY_LOGIN_ACCOUNT = 2;
    public static final int SY_EXEMPT_INACTIVE_LOCK = 8;
    private static final int SY_LOGIN_AUTH_ASE = 32;
    private static final int SY_LOGIN_AUTH_LDAP = 64;
    private static final int SY_LOGIN_AUTH_PAM = 128;
    private static final int SY_LOGIN_AUTH_KERBEROS = 256;
    private static final int SY_LOGIN_AUTH_ANY_FOR_1253 = 224;
    private static final int SY_LOGIN_AUTH_ANY = 480;
    private static final int COMPILED_OBJECT_TEXT_HIDDEN = 1;
    public static final String ANY = "ANY";
    private static final String ASE = "ASE";
    private static final String LDAP = "LDAP";
    private static final String PAM = "PAM";
    private static final String KERBEROS = "KERBEROS";
    private static final String PREFIX_AUTN = ", @auth_mech = '";
    private boolean _hasPredidColumn;
    private String _suid;
    private String _locked;
    private String _password;
    private String _loginProfileName = "";
    private String _loginProfileID;
    private int _auditFlag;
    private String _fullName;
    private String _defaultDatabase;
    private String _defaultLanguage;
    private String _auth = "";
    private String _procid;
    private String _loginscript = "";
    private String _exemptInactiveLock = "";
    private Vector _mappedClients = new Vector();
    private String[] _columns;
    private String[] _passwordParams = new String[3];
    private Vector roles = new Vector();
    private Vector autoActivatedRoles = new Vector();
    private boolean _isLoginProfileApp;
    private String _roleWithPredPrivilege = "";
    private String _auditSetting = "";
    private String _resourceLimit = "";
    private static final String AT_ALL_TIMES = "at all times";
    private static final String USER_DESC = "-- The DDL is generated with a default password - 'password'\n-- when this login was created.\n\n";

    public LoginItem() {
    }

    public LoginItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
    }

    private void load() {
        if (this._isLoginProfileApp) {
            this._password = "password 'password'";
            this._defaultDatabase = "\tdefault database '" + this._columns[0] + "'" + "\n";
            this._defaultLanguage = this._columns[1].equals("") ? "" : "\t" + "default language '" + this._columns[1] + "'" + "\n";
            this._fullName = this._columns[2].equals("") ? "" : "\t" + "fullname '" + this._columns[2] + "'" + "\n";
            this._exemptInactiveLock = (Integer.parseInt(this._columns[4]) & 8) == 8 ? "\texempt inactive lock true\n" : "\texempt inactive lock false\n";
            this._procid = this._columns[8];
        } else {
            this._password = ", 'password'";
            this._defaultDatabase = ", @defdb='" + this._columns[0] + "'";
            this._defaultLanguage = this._columns[1].equals("") ? "" : ", @deflanguage='" + this._columns[1] + "'";
            this._fullName = this._columns[2].equals("") ? "" : ", @fullname='" + this._columns[2] + "'";
            this._procid = this._columns[7];
        }
        this._suid = this._columns[3];
        try {
            this._locked = (Integer.parseInt(this._columns[4]) & 2) == 2 ? "lock" : "unlock";
        }
        catch (Exception exception) {
            new DDLBaseException("L51", exception, "INTERNAL_ERROR", 1);
        }
        this._name = this._columns[5];
        this._auditFlag = Integer.parseInt(this._columns[6]);
        if (this._isLoginProfileApp) {
            this._loginProfileID = this._columns[7];
        }
    }

    private void setPasswordParameters(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        for (int i = 0; i < 3; ++i) {
            Object[] objectArray = new String[]{this._suid, i + ""};
            try {
                aSResultSet = new ASResultSet(aSConnection);
                aSResultSet.open(ASQueryParser.parseQuery("SELECT int_value FROM master.dbo.sysattributes WHERE object={0} and object_type=''PS'' and object_cinfo=''login'' and attribute={1}", objectArray), "LOGIN_PASSWORD_QUERY");
                if (aSResultSet.getNextRow()) {
                    this._passwordParams[i] = aSResultSet.getColumnInt(1) + "";
                }
                if (aSResultSet == null) continue;
                aSResultSet.close();
                aSResultSet = null;
                continue;
            }
            catch (SQLException sQLException) {
                new DDLBaseException("L52", (Exception)sQLException, 2, this._name);
                continue;
            }
            catch (Exception exception) {
                new DDLBaseException("L53", exception, "INTERNAL_ERROR", 1);
            }
        }
        if (this._isLoginProfileApp) {
            this._passwordParams[0] = this._passwordParams[0] == null ? "" : "\tpassword expiration " + this._passwordParams[0] + "\n";
            this._passwordParams[1] = this._passwordParams[1] == null ? "" : "\tmin password length " + this._passwordParams[1] + "\n";
            this._passwordParams[2] = this._passwordParams[2] == null ? "" : "\tmax failed attempts " + this._passwordParams[2] + "\n";
        } else {
            this._passwordParams[0] = this._passwordParams[0] == null ? "" : ", @passwdexp=" + this._passwordParams[0];
            this._passwordParams[1] = this._passwordParams[1] == null ? "" : ", @minpwdlen=" + this._passwordParams[1];
            this._passwordParams[2] = this._passwordParams[2] == null ? "" : ", @maxfailedlogins=" + this._passwordParams[2];
        }
    }

    @Override
    public void open(ASConnection aSConnection) {
        this._isLoginProfileApp = aSConnection.isLoginProfileApplicable();
        this._hasPredidColumn = aSConnection.isPredidApplicable();
        this.load();
        if (this._loginProfileID != null && this._loginProfileID.length() > 0) {
            this.setLoginProfileName(aSConnection);
        }
        this.setPasswordParameters(aSConnection);
        this.setPAMAttributes(aSConnection);
        this.setRoles(aSConnection);
        this.setAutoActivatedRoles(aSConnection);
        this.setTextForRoleWithPredPrivilege(aSConnection);
        this.setTextForResouceLimit(aSConnection);
        if (this._auditFlag > 0) {
            this.setTextForAuditSetting();
        }
        if (this._procid != null && this._procid.length() > 0) {
            this.setLoginScript(aSConnection);
        }
        this._ddlString = this.generateDDL();
        if (this._name.equals("sa") && aSConnection.getServerVersion().equals("12.5.0.3") || aSConnection.getServerVersion().compareTo("12.5.0.3") > 0) {
            this._ddlString = this._ddlString + this.getLoginTempDBBinding(aSConnection);
        }
    }

    private void setTextForAuditSetting() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this._auditFlag & 1) == 1 || (this._auditFlag & 2) == 2) {
            stringBuffer.append("exec ").append(" ").append("sp_audit ").append("'").append("table_access").append("', '").append(this._name).append("', '").append("all").append("', '");
            if ((this._auditFlag & 3) == 3) {
                stringBuffer.append("on").append("'");
            } else if ((this._auditFlag & 1) == 1) {
                stringBuffer.append("pass").append("'");
            } else if ((this._auditFlag & 2) == 2) {
                stringBuffer.append("fail").append("'");
            }
            stringBuffer.append("\n");
        }
        if ((this._auditFlag & 4) == 4 || (this._auditFlag & 8) == 8) {
            stringBuffer.append("exec ").append(" ").append("sp_audit ").append("'").append("view_access").append("', '").append(this._name).append("', '").append("all").append("', '");
            if ((this._auditFlag & 0xC) == 12) {
                stringBuffer.append("on").append("'");
            } else if ((this._auditFlag & 4) == 4) {
                stringBuffer.append("pass").append("'");
            } else if ((this._auditFlag & 8) == 8) {
                stringBuffer.append("fail").append("'");
            }
            stringBuffer.append("\n");
        }
        if ((this._auditFlag & 0x30) == 48) {
            stringBuffer.append("exec ").append(" ").append("sp_audit ").append("'").append("cmdtext").append("', '").append(this._name).append("', '").append("all").append("', '").append("on").append("'");
            stringBuffer.append("\n");
        }
        if ((this._auditFlag & 0x40) == 64 || (this._auditFlag & 0x80) == 128) {
            stringBuffer.append("exec ").append(" ").append("sp_audit ").append("'").append("all").append("', '").append(this._name).append("', '").append("all").append("', '");
            if ((this._auditFlag & 0xC0) == 192) {
                stringBuffer.append("on").append("'");
            } else if ((this._auditFlag & 0x40) == 64) {
                stringBuffer.append("pass").append("'");
            } else if ((this._auditFlag & 0x80) == 128) {
                stringBuffer.append("fail").append("'");
            }
            stringBuffer.append("\n");
        }
        this._auditSetting = stringBuffer.toString();
    }

    private void setTextForResouceLimit(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select l.name, l.appname, range_name = r.name, limit_type_name = s.name, l.limitvalue, l.enforced, l.action, l.scope from master.dbo.sysresourcelimits l, master.dbo.systimeranges r, master.dbo.spt_limit_types s where l.rangeid = r.id and l.name = ''{0}'' and l.limitid = s.id order by l.appname", objectArray), "LOGIN_RESOURCE_LIMIT");
                while (aSResultSet.getNextRow()) {
                    String[] stringArray = new String[8];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = aSResultSet.getColumnsAsArray()[i];
                    }
                    if (stringArray[1].length() == 0) {
                        stringArray[1] = "null".toUpperCase();
                    }
                    if (stringArray[2].toLowerCase().equals(AT_ALL_TIMES)) {
                        stringArray[2] = "'at all times'";
                    }
                    stringBuffer.append("exec ").append(" ").append("sp_add_resource_limit ").append(this._name).append(", ").append(stringArray[1]).append(", ").append(stringArray[2]).append(", ").append(stringArray[3]).append(", ").append(stringArray[4]).append(", ").append(stringArray[5]).append(", ").append(stringArray[6]).append(", ").append(stringArray[7]);
                    stringBuffer.append("\n");
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L67", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("L68", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
        this._resourceLimit = stringBuffer.toString();
    }

    private void setTextForRoleWithPredPrivilege(ASConnection aSConnection) {
        if (!this._isLoginProfileApp || !this._hasPredidColumn) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT lr.predid from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid AND l.name = ''{0}'' AND lr.predid != null ORDER BY 1", objectArray), "LOGIN_ROLE_WITH_PREDICATED_PRIVILEGES");
                while (aSResultSet.getNextRow()) {
                    vector.addElement(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
            for (int i = 0; i < vector.size(); ++i) {
                if (this.textIsHidden(aSConnection, (String)vector.elementAt(i))) {
                    stringBuffer.append("\n--Source text is hidden for one predicated privilege on the object: " + this._name + "\n");
                    continue;
                }
                String string = this.getText(aSConnection, (String)vector.elementAt(i)).toString();
                stringBuffer.append(string);
                if (string.lastIndexOf("\n") != string.length() - 1) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append("go\n\n");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L63", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("L64", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
        this._roleWithPredPrivilege = stringBuffer.toString();
    }

    private boolean textIsHidden(ASConnection aSConnection, String string) {
        ASResultSet aSResultSet = null;
        boolean bl = false;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{"master", string};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select status & 1 from {0}.dbo.syscomments where id = {1} ", objectArray), "COMPILED_OBJECT_TEXT_HIDDEN_QUERY");
                while (aSResultSet.getNextRow()) {
                    String string2 = aSResultSet.getColumnsAsArray()[0];
                    if ((Integer.parseInt(string2) & 1) == 1) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            new DDLBaseException("L65", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
        return bl;
    }

    private StringBuffer getText(ASConnection aSConnection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        Object[] objectArray = new String[]{"master", string};
        try {
            aSResultSet.open(ASQueryParser.parseQuery("select text = text  from {0}.dbo.syscomments  where id = {1} order by colid2, colid", objectArray), "COMPILED_OBJECT_TEXT_QUERY");
            while (aSResultSet.getNextRow()) {
                stringBuffer.append(aSResultSet.getColumnString("text"));
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            new DDLBaseException("L66", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer;
    }

    private void setRoles(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                if (this._isLoginProfileApp && this._hasPredidColumn) {
                    aSResultSet.open(ASQueryParser.parseQuery("SELECT role_name(lr.srid) from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid AND l.name = ''{0}'' and lr.predid = null ORDER BY 1", objectArray), "LOGIN_INIT_ROLE_157");
                } else {
                    aSResultSet.open(ASQueryParser.parseQuery("SELECT role_name(lr.srid) from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid AND l.name = ''{0}'' ORDER BY 1", objectArray), "LOGIN_INIT_ROLE");
                }
                while (aSResultSet.getNextRow()) {
                    this.roles.addElement(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L54", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("L55", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
    }

    public boolean isPAMSupportApplicable(ASConnection aSConnection) {
        return aSConnection.getServerVersion().compareTo("12.5.2") >= 0;
    }

    private void setPAMAttributes(ASConnection aSConnection) {
        boolean bl;
        if (!this.isPAMSupportApplicable(aSConnection)) {
            return;
        }
        int n = Integer.parseInt(this._columns[4]);
        boolean bl2 = bl = aSConnection.getServerVersion().compareTo("12.5.3") > 0;
        if (bl && (n == 0 || (n & 0x1E0) == 480)) {
            this._auth = ", @auth_mech = 'ANY'";
        } else if (!(bl || n != 0 && (n & 0xE0) != 224)) {
            this._auth = ", @auth_mech = 'ANY'";
        } else if ((n & 0x20) == 32) {
            this._auth = ", @auth_mech = 'ASE'";
        } else if ((n & 0x40) == 64) {
            this._auth = ", @auth_mech = 'LDAP'";
        } else if ((n & 0x80) == 128) {
            this._auth = ", @auth_mech = 'PAM'";
        } else if ((n & 0x100) == 256) {
            this._auth = ", @auth_mech = 'KERBEROS'";
        }
        if (this._isLoginProfileApp && this._auth.length() > 0) {
            this._auth = "\tauthenticate with '" + this._auth.substring(PREFIX_AUTN.length(), this._auth.length() - 1) + "'" + "\n";
        }
        try {
            this._mappedClients = this.getClientMappings(aSConnection);
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L58", (Exception)sQLException, 2, this._name);
        }
    }

    private void setLoginProfileName(ASConnection aSConnection) {
        if (!aSConnection.isLoginProfileApplicable()) {
            return;
        }
        if (this._loginProfileID.equals("-1")) {
            this._loginProfileName = "\tlogin profile ignore\n";
            return;
        }
        ASResultSet aSResultSet = null;
        Object[] objectArray = new String[]{this._loginProfileID};
        try {
            aSResultSet = new ASResultSet(aSConnection);
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select name from master.dbo.syslogins where suid = {0}", objectArray), "LOGIN_PROFILE_NAME_QUERY");
                if (aSResultSet.getNextRow()) {
                    this._loginProfileName = aSResultSet.getColumnString(1);
                    if (this._loginProfileName != null) {
                        this._loginProfileName = "\tlogin profile '" + this._loginProfileName + "'" + "\n";
                    }
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L59", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("L60", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
    }

    private void setAutoActivatedRoles(ASConnection aSConnection) {
        if (!aSConnection.isLoginProfileApplicable()) {
            return;
        }
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT role_name(lr.srid) from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid AND l.name = ''{0}'' and (lr.status & 1) = 1 ORDER BY 1", objectArray), "LOGIN_INIT_AUTO_ACTIVATED_ROLE");
                while (aSResultSet.getNextRow()) {
                    this.autoActivatedRoles.addElement(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L61", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("L62", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
    }

    private void setLoginScript(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._procid, this._columns[0]};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select procname = object_name({0}, db_id(''{1}''))", objectArray), "LOGIN_SCRIPT_QUERY");
                if (aSResultSet.getNextRow()) {
                    this._loginscript = this._columns[0] + ".." + aSResultSet.getColumnString(1);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L69", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("L70", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
    }

    public Vector getClientMappings(ASConnection aSConnection) throws SQLException {
        Vector vector = new Vector();
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        Object[] objectArray = new String[]{this._name};
        aSResultSet.open(ASQueryParser.parseQuery("select convert(char(14), isnull(s.name, ''ANY'')) as authentication, case object_cinfo when ''*'' then convert(char(20),''ANY'') else convert(char(20), object_cinfo) end as ClientName from master.dbo.sysattributes, master.dbo.spt_values s where class = 20 and attribute = 0 and (object_info1 = s.low) and (s.type = ''ua'') and (suser_name(object) = ''{0}'' ) and s.name != ''AUTH_MASK'' and s.name != ''AUTH_DEFAULT'' order by 1,2", objectArray), "SELECT_CLIENT_MAPPINGS");
        while (aSResultSet.getNextRow()) {
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement(aSResultSet.getColumnString(1).trim());
            vector2.addElement(aSResultSet.getColumnString(2).trim());
            vector.addElement(vector2);
        }
        aSResultSet.close();
        aSResultSet = null;
        return vector;
    }

    private String getLoginTempDBBinding(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            aSResultSet.open(ASQueryParser.parseQuery("select char_value from master.dbo.sysattributes a,  master.dbo.syslogins b  where  class = 16  and a.object_type = ''LG''  and a.object = b.suid  and b.name = ''{0}''", new String[]{this._name}), "TEMP_DB_LOGIN_BINDING");
            while (aSResultSet.getNextRow()) {
                stringBuffer.append("\n").append("sp_tempdb ").append("'").append("bind").append("', ");
                stringBuffer.append("'").append("lg").append("', ");
                stringBuffer.append(" '").append(this._name).append("', ");
                if (aSResultSet.getColumnString(1).equals("default")) {
                    stringBuffer.append(" '").append("GR").append("'").append(", ");
                } else {
                    stringBuffer.append(" '").append("DB").append("'").append(", ");
                }
                stringBuffer.append(" '").append(aSResultSet.getColumnString(1)).append("'");
                stringBuffer.append("\ngo\n\n");
            }
            if (aSResultSet != null) {
                aSResultSet.close();
                aSResultSet = null;
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L56", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("L57", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    @Override
    public String[] getIfExistsParameters() {
        if (this._name.equals("sa") || this._name.equals("probe")) {
            return null;
        }
        if (this._isLoginProfileApp) {
            return new String[]{null, null, ASQueryParser.parseQuery("SELECT 1 FROM master.dbo.syslogins WHERE name = ''{0}''", new String[]{this._name}), ASQueryParser.parseQuery("drop login ''{0}''\ngo ", new String[]{this._name})};
        }
        return new String[]{null, null, ASQueryParser.parseQuery("SELECT 1 FROM master.dbo.syslogins WHERE name = ''{0}''", new String[]{this._name}), ASQueryParser.parseQuery("exec sp_droplogin ''{0}''", new String[]{this._name})};
    }

    @Override
    public String generateDDL() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (!this._name.equals("sa") && !this._name.equals("probe")) {
            stringBuffer.append(USER_DESC);
            if (this._isLoginProfileApp) {
                stringBuffer.append("create ").append("login ").append(this._name).append(" with ").append(this._password).append("\n");
                if (this._loginProfileName.length() > 0) {
                    stringBuffer.append(this._loginProfileName);
                }
            } else {
                stringBuffer.append("exec ").append(" ").append("sp_addlogin ").append(" '").append(this._name).append("'").append(this._password);
            }
            stringBuffer.append(this._fullName).append(this._defaultDatabase).append(this._defaultLanguage).append(this._passwordParams[0]).append(this._passwordParams[1]).append(this._passwordParams[2]).append(this._auth).append(this._exemptInactiveLock);
            if (this._isLoginProfileApp) {
                stringBuffer.append("go");
            }
            stringBuffer.append("\n\n");
        }
        if (this._isLoginProfileApp && this._loginscript.length() > 0) {
            stringBuffer.append("alter ").append("login ").append(this._name).append(" ").append("modify ").append("login script ").append("'").append(this._loginscript).append("'").append("\n");
            stringBuffer.append("go").append("\n\n");
        } else if (!this._isLoginProfileApp && this._loginscript.length() > 0) {
            stringBuffer.append("exec ").append(" ").append("sp_modifylogin ").append(this._name).append(", ").append("'login script'").append(", ").append("'").append(this._loginscript).append("'").append("\n");
            stringBuffer.append("\n");
        }
        stringBuffer.append("exec ").append(" ").append("sp_locklogin ").append(" '").append(this._name).append("', '").append(this._locked).append("'");
        stringBuffer.append("\n\n");
        for (n = 0; n < this.roles.size(); ++n) {
            stringBuffer.append("exec ").append(" ").append("sp_role ").append("'").append("grant").append("', '").append((String)this.roles.elementAt(n)).append("', '").append(this._name).append("'").append("\n").append("go ").append("\n\n");
        }
        if (this._roleWithPredPrivilege.length() > 0) {
            stringBuffer.append(this._roleWithPredPrivilege);
        }
        if (this.autoActivatedRoles.size() > 0) {
            stringBuffer.append("alter ").append("login ").append(this._name).append(" add auto activated roles ");
            for (n = 0; n < this.autoActivatedRoles.size(); ++n) {
                stringBuffer.append((String)this.autoActivatedRoles.elementAt(n)).append(", ");
            }
            stringBuffer.setCharAt(stringBuffer.length() - 2, ' ');
            stringBuffer.append("\n").append("go ");
        }
        stringBuffer.append("\n");
        if (this._auditSetting.length() > 0) {
            stringBuffer.append(this._auditSetting);
        }
        if (this._resourceLimit.length() > 0) {
            stringBuffer.append(this._resourceLimit);
        }
        for (n = 0; n < this._mappedClients.size(); ++n) {
            Vector vector = (Vector)this._mappedClients.elementAt(n);
            String string = (String)vector.elementAt(0);
            String string2 = (String)vector.elementAt(1);
            stringBuffer.append("exec ").append(" ").append("sp_maplogin ").append("'").append(string).append("', '").append(string2).append("', '").append(this._name).append("'\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("go ");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

