/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class LoginProfileItem
extends DDLBaseItem {
    private static final int DBNAME = 0;
    private static final int LANGUAGE = 1;
    private static final int SUID = 2;
    private static final int STATUS = 3;
    private static final int NAME = 4;
    private static final int TRACKLASTLOGIN = 1;
    private static final int STALEPERIOD = 2;
    private static final int LOGINSCRIPT = 3;
    private static final int SY_INDICATE_LOGIN_PROFILE = 512;
    private static final int DEFAULT_LOGIN_PROFILE = 1536;
    private static final int SY_SPECIFY_AUTH_MECHA = 2048;
    private static final int SY_LOGIN_AUTH_ANY = 2560;
    private static final int SY_LOGIN_AUTH_ASE = 2592;
    private static final int SY_LOGIN_AUTH_LDAP = 2624;
    private static final int SY_LOGIN_AUTH_PAM = 2688;
    private static final int SY_LOGIN_AUTH_KERBEROS = 2816;
    private static final int COMPILED_OBJECT_TEXT_HIDDEN = 1;
    public static final String ANY = "ANY";
    private static final String ASE = "ASE";
    private static final String LDAP = "LDAP";
    private static final String PAM = "PAM";
    private static final String KERBEROS = "KERBEROS";
    private boolean _hasPredidColumn;
    private String _suid;
    private int _status;
    private String _defaultDatabase;
    private String _defaultLanguage;
    private String _auth = "";
    private String[] _columns;
    private String[] _profileAttributes = new String[4];
    private Vector roles = new Vector();
    private Vector autoActivatedRoles = new Vector();
    private String _roleWithPredPrivilege = "";

    public LoginProfileItem() {
    }

    public LoginProfileItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
    }

    private void load() {
        this._defaultDatabase = this._columns[0].equals("") ? "" : "\tdefault database '" + this._columns[0] + "'" + "\n";
        this._defaultLanguage = this._columns[1].equals("") ? "" : "\t" + "default language '" + this._columns[1] + "'" + "\n";
        this._suid = this._columns[2];
        this._status = Integer.parseInt(this._columns[3]);
        this._name = this._columns[4];
    }

    private void setProfileAttr(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        for (int i = 1; i < 4; ++i) {
            Object[] objectArray = new String[]{this._suid, i + ""};
            try {
                aSResultSet = new ASResultSet(aSConnection);
                if (i == 1) {
                    aSResultSet.open(ASQueryParser.parseQuery("SELECT int_value FROM master.dbo.sysattributes WHERE object={0} and object_type=''LR'' and class = 39 and attribute={1}", objectArray), "LOGIN_PROFILE_ATTR_QUERY");
                } else {
                    aSResultSet.open(ASQueryParser.parseQuery("SELECT char_value FROM master.dbo.sysattributes WHERE object={0} and object_type=''LR'' and class = 39 and attribute={1}", objectArray), "LOGIN_PROFILE_ATTR_QUERY");
                }
                if (aSResultSet.getNextRow()) {
                    this._profileAttributes[i] = aSResultSet.getColumnString(1);
                }
                if (aSResultSet == null) continue;
                aSResultSet.close();
                aSResultSet = null;
                continue;
            }
            catch (SQLException sQLException) {
                new DDLBaseException("LP41", (Exception)sQLException, 2, this._name);
                continue;
            }
            catch (Exception exception) {
                new DDLBaseException("LP42", exception, "INTERNAL_ERROR", 1);
            }
        }
        this._profileAttributes[1] = this._profileAttributes[1] == null ? "" : (this._profileAttributes[1].equals("1") ? "\ttrack lastlogin 'true'\n" : "\ttrack lastlogin 'false'\n");
        this._profileAttributes[2] = this._profileAttributes[2] == null ? "" : "\tstale period '" + this._profileAttributes[2] + "'" + "\n";
        this._profileAttributes[3] = this._profileAttributes[3] == null ? "" : "\tlogin script '" + this._profileAttributes[3] + "'" + "\n";
    }

    @Override
    public void open(ASConnection aSConnection) {
        this.load();
        this._hasPredidColumn = aSConnection.isPredidApplicable();
        this.setProfileAttr(aSConnection);
        this.setauthAttributes(aSConnection);
        this.setRoles(aSConnection);
        this.setAutoActivatedRoles(aSConnection);
        this.setTextForRoleWithPredPrivilege(aSConnection);
        this._ddlString = this.generateDDL();
    }

    private void setTextForRoleWithPredPrivilege(ASConnection aSConnection) {
        if (!aSConnection.isLoginProfileApplicable() || !this._hasPredidColumn) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT lr.predid from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid AND l.name = ''{0}'' AND lr.predid != null ORDER BY 1", objectArray), "LOGIN_ROLE_WITH_PREDICATED_PRIVILEGES");
                while (aSResultSet.getNextRow()) {
                    vector.addElement(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
            for (int i = 0; i < vector.size(); ++i) {
                if (this.textIsHidden(aSConnection, (String)vector.elementAt(i))) {
                    stringBuffer.append("\n--Source text is hidden for one predicated privilege on the object: " + this._name + "\n");
                    continue;
                }
                String string = this.getText(aSConnection, (String)vector.elementAt(i)).toString();
                stringBuffer.append(string);
                if (string.lastIndexOf("\n") != string.length() - 1) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append("go\n\n");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("LP43", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("LP44", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
        this._roleWithPredPrivilege = stringBuffer.toString();
    }

    private boolean textIsHidden(ASConnection aSConnection, String string) {
        ASResultSet aSResultSet = null;
        boolean bl = false;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{"master", string};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select status & 1 from {0}.dbo.syscomments where id = {1} ", objectArray), "COMPILED_OBJECT_TEXT_HIDDEN_QUERY");
                while (aSResultSet.getNextRow()) {
                    String string2 = aSResultSet.getColumnsAsArray()[0];
                    if ((Integer.parseInt(string2) & 1) == 1) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            new DDLBaseException("LP45", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
        return bl;
    }

    private StringBuffer getText(ASConnection aSConnection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        Object[] objectArray = new String[]{"master", string};
        try {
            aSResultSet.open(ASQueryParser.parseQuery("select text = text  from {0}.dbo.syscomments  where id = {1} order by colid2, colid", objectArray), "COMPILED_OBJECT_TEXT_QUERY");
            while (aSResultSet.getNextRow()) {
                stringBuffer.append(aSResultSet.getColumnString("text"));
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            new DDLBaseException("LP46", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer;
    }

    private void setRoles(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                if (this._hasPredidColumn) {
                    aSResultSet.open(ASQueryParser.parseQuery("SELECT role_name(lr.srid) from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid AND l.name = ''{0}'' and lr.predid = null ORDER BY 1", objectArray), "LOGIN_INIT_ROLE_157");
                } else {
                    aSResultSet.open(ASQueryParser.parseQuery("SELECT role_name(lr.srid) from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid AND l.name = ''{0}'' ORDER BY 1", objectArray), "LOGIN_INIT_ROLE");
                }
                while (aSResultSet.getNextRow()) {
                    this.roles.addElement(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("LP47", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("LP48", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
    }

    public boolean isPAMSupportApplicable(ASConnection aSConnection) {
        return aSConnection.getServerVersion().compareTo("12.5.2") >= 0;
    }

    private void setauthAttributes(ASConnection aSConnection) {
        if (!this.isPAMSupportApplicable(aSConnection)) {
            return;
        }
        int n = Integer.parseInt(this._columns[3]);
        if ((n & 0x800) != 2048) {
            return;
        }
        if ((n & 0xA20) == 2592) {
            this._auth = "'ASE'";
        } else if ((n & 0xA40) == 2624) {
            this._auth = "'LDAP'";
        } else if ((n & 0xA80) == 2688) {
            this._auth = "'PAM'";
        } else if ((n & 0xB00) == 2816) {
            this._auth = "'KERBEROS'";
        } else if ((n & 0xA00) == 2560) {
            this._auth = "'ANY'";
        }
        this._auth = this._auth.length() == 0 ? "" : "\tauthenticate with " + this._auth + "\n";
    }

    private void setAutoActivatedRoles(ASConnection aSConnection) {
        if (!aSConnection.isLoginProfileApplicable()) {
            return;
        }
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT role_name(lr.srid) from master.dbo.sysloginroles lr, master.dbo.syslogins l where lr.suid = l.suid AND l.name = ''{0}'' and (lr.status & 1) = 1 ORDER BY 1", objectArray), "LOGIN_INIT_AUTO_ACTIVATED_ROLE");
                while (aSResultSet.getNextRow()) {
                    this.autoActivatedRoles.addElement(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("LP49", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("LP50", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
    }

    @Override
    public String[] getIfExistsParameters() {
        return new String[]{null, null, ASQueryParser.parseQuery("SELECT 1 FROM master.dbo.syslogins WHERE name = ''{0}''", new String[]{this._name}), ASQueryParser.parseQuery("drop login profile ''{0}''\ngo ", new String[]{this._name})};
    }

    @Override
    public String generateDDL() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create ").append("login profile ").append(this._name);
        if ((this._status & 0x600) == 1536) {
            stringBuffer.append(" ").append("as default");
        }
        if (this._defaultDatabase.length() > 0 || this._defaultLanguage.length() > 0 || this._profileAttributes[3].length() > 0 || this._profileAttributes[1].length() > 0 || this._profileAttributes[2].length() > 0 || this._auth.length() > 0) {
            stringBuffer.append(" with").append("\n");
        }
        stringBuffer.append(this._defaultDatabase).append(this._defaultLanguage).append(this._profileAttributes[3]).append(this._profileAttributes[1]).append(this._profileAttributes[2]).append(this._auth);
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
            stringBuffer.append("\n");
        }
        stringBuffer.append("go");
        stringBuffer.append("\n\n");
        for (n = 0; n < this.roles.size(); ++n) {
            stringBuffer.append("exec ").append(" ").append("sp_role ").append("'").append("grant").append("', '").append((String)this.roles.elementAt(n)).append("', '").append(this._name).append("'").append("\n").append("go ").append("\n\n");
        }
        if (this._roleWithPredPrivilege.length() > 0) {
            stringBuffer.append(this._roleWithPredPrivilege);
        }
        if (this.autoActivatedRoles.size() > 0) {
            stringBuffer.append("alter ").append("login profile ").append(this._name).append(" add auto activated roles ");
            for (n = 0; n < this.autoActivatedRoles.size(); ++n) {
                stringBuffer.append((String)this.autoActivatedRoles.elementAt(n)).append(", ");
            }
            stringBuffer.setCharAt(stringBuffer.length() - 2, ' ');
            stringBuffer.append("\n").append("go ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

