/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class RemoteServerItem
extends DDLBaseItem {
    private static final int SERVER_NAME = 0;
    private static final int REMOTE_NAME = 1;
    private static final int STATUS = 2;
    private static final int CLASS = 3;
    private String _remoteName = "";
    private String _class = "";
    private int _status;
    private String[] _columns;
    private StringBuffer _serverParameters = new StringBuffer();

    public RemoteServerItem() {
    }

    public RemoteServerItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
    }

    @Override
    public void open(ASConnection aSConnection) throws DDLBaseException {
        this.load();
        this.setServerParameters(aSConnection);
        this._ddlString = this.generateDDL() + this.getRemoteLoginDDL(aSConnection) + this.getCISLoginDDL(aSConnection);
    }

    private void load() throws DDLBaseException {
        this._name = this._columns[0];
        if (this._name.equals("")) {
            throw new DDLBaseException("RS51", "REMOTE_SERVER_NAME_NULL_ERROR", 2);
        }
        this._remoteName = this._columns[1];
        if (this._remoteName.equals("")) {
            throw new DDLBaseException("RS52", "REMOTE_SERVER_RNAME_NULL_ERROR", 2, this._name);
        }
        this._class = this._columns[3];
        if (this._class.equals("")) {
            throw new DDLBaseException("RS53", "REMOTE_SERVER_CLASS_NULL_ERROR", 2, this._name);
        }
        String string = this._columns[2];
        if (string.equals("")) {
            throw new DDLBaseException("RS54", "REMOTE_SERVER_STATUS_NULL_ERROR", 2, this._name);
        }
        this._status = new Integer(string);
    }

    private void setServerParameters(ASConnection aSConnection) {
        if (this._class.equals("local") || this._class.equals("ASEJB")) {
            return;
        }
        ASResultSet aSResultSet = null;
        Vector<String> vector = new Vector<String>();
        try {
            aSResultSet = new ASResultSet(aSConnection);
            aSResultSet.open("exec sp_serveroption", "SP_SERVEROPTION");
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                vector.addElement(stringArray[0]);
            }
            aSResultSet.close();
        }
        catch (SQLException sQLException) {
            new DDLBaseException("RS59", sQLException, 2);
        }
        try {
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                aSResultSet.open(ASQueryParser.parseQuery("select number from master.dbo.spt_values where type = ''A'' and name = ''{0}''", new String[]{string}), "REMOTE_SERVER_OPTION_STATUS_KEY");
                if (aSResultSet.getNextRow()) {
                    String[] stringArray = aSResultSet.getColumnsAsArray();
                    String string2 = stringArray[0];
                    if (string.equals("timeouts")) {
                        bl = (this._status & 1) == 0;
                    } else {
                        boolean bl2 = bl = (this._status & Integer.parseInt(string2)) != 0;
                    }
                    if (bl) {
                        this._serverParameters.append("exec ").append(" ").append("sp_serveroption ").append(" ").append(this._name).append(", ").append("'").append(string).append("', ").append("true").append("\n");
                    }
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("RS60", sQLException, 2);
        }
    }

    @Override
    public String[] getIfExistsParameters() {
        return new String[]{null, null, ASQueryParser.parseQuery("SELECT 1 FROM master.dbo.sysservers WHERE srvname = ''{0}''", new String[]{this._name}), ASQueryParser.parseQuery("exec sp_dropserver ''{0}''", new String[]{this._name})};
    }

    @Override
    public String generateDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("exec ").append(" ").append("sp_addserver ").append(" ");
        stringBuffer.append(this._name).append(", ");
        stringBuffer.append(this._class).append(", ");
        stringBuffer.append(this._remoteName).append("\n\n");
        stringBuffer.append(this._serverParameters.toString());
        stringBuffer.append("\n").append("go ").append("\n");
        return stringBuffer.toString();
    }

    public String getRemoteLoginDDL(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT r.remoteusername, suser_name( r.suid ), r.status from master.dbo.sysservers s, master.dbo.sysremotelogins r where s.srvid = r.remoteserverid and r.remoteusername is not null and s.srvid > 0 and s.srvname like ''{0}'' order by 1", objectArray), "REMOTE_SERVER_LOGIN_MAP");
            }
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                stringBuffer.append("exec ").append(" ");
                stringBuffer.append("sp_addremotelogin").append(" ");
                stringBuffer.append(this._name).append(", ");
                stringBuffer.append(stringArray[1]).append(", ");
                stringBuffer.append(stringArray[0]).append("\n");
                if (stringArray[2].equals("1")) {
                    stringBuffer.append("exec ").append(" ");
                    stringBuffer.append("sp_remoteoption").append(" ");
                    stringBuffer.append(this._name).append(", ");
                    stringBuffer.append(stringArray[1]).append(", ");
                    stringBuffer.append(stringArray[0]).append(", ");
                    stringBuffer.append("trusted").append(", ");
                    stringBuffer.append("true").append("\n");
                }
                stringBuffer.append("go ").append("\n");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("RS55", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("RS56", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    public String getCISLoginDDL(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT  object_cinfo, suser_name(object) FROM master.dbo.sysattributes a, master.dbo.sysservers s WHERE a.class = 9 AND a.object_type = ''EL'' AND a.object_info1 = s.srvid AND s.srvname LIKE ''{0}'' order by object_cinfo", objectArray), "REMOTE_SERVER_CIS_LOGIN_MAP");
            }
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                stringBuffer.append("exec ").append(" ");
                stringBuffer.append("sp_addexternlogin").append(" ");
                stringBuffer.append(this._name).append(", ");
                stringBuffer.append(stringArray[1]).append(", ");
                stringBuffer.append(stringArray[0]).append("\n");
                stringBuffer.append("go ").append("\n");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("RS57", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("RS58", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }
}

