/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;

public class ThreadPoolItem
extends DDLBaseItem {
    private static final int NAME = 0;
    private static final int THREAD_COUNT = 1;
    private static final int DESCRIPTION = 2;
    private static final int IDLETIMEOUT = 3;
    private String _threadCount;
    private String _description = "";
    private String _idletimeout = "";
    private String[] _columns;

    public ThreadPoolItem() {
    }

    public ThreadPoolItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
    }

    private void load() {
        this._name = this._columns[0];
        this._threadCount = this._columns[1];
        if (this._columns[2] != null) {
            this._description = this._columns[2];
        }
        this._idletimeout = this._columns[3];
    }

    @Override
    public void open(ASConnection aSConnection) {
        this.load();
        this._ddlString = this.generateDDL();
    }

    @Override
    public String[] getIfExistsParameters() {
        if (!this._name.startsWith("syb")) {
            return new String[]{"master", null, ASQueryParser.parseQuery("SELECT 1 FROM master.dbo.monThreadPool WHERE ThreadPoolName = ''{0}''", new String[]{this._name}), ASQueryParser.parseQuery("drop thread pool {0}\ngo ", new String[]{this._name})};
        }
        return null;
    }

    @Override
    public String generateDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this._name.startsWith("syb")) {
            stringBuffer.append("create").append(" ").append("thread pool ").append(this._name).append(" ").append("with").append(" ").append("thread count ").append("= ").append(this._threadCount);
            if (this._description.length() > 0) {
                stringBuffer.append(", ").append("pool description ").append("= ").append("'").append(this._description).append("'");
            }
            stringBuffer.append(", ").append("idle timeout ").append("= ").append(this._idletimeout);
            stringBuffer.append("\n").append("go").append("\n");
        } else {
            stringBuffer.append("-- Do not generate 'create thread pool' ddls for system thread pool(s).").append("\n\n");
        }
        return stringBuffer.toString();
    }
}

