/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.sql;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.sql.ASMessageHandler;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import com.sybase.jdbc4.jdbc.SybDataSource;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import com.sybase.jdbcx.SybStatement;
import com.sybase.util.ds.Settings;
import com.sybase.util.ds.ssl.SSLSocketFactoryASE;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;

public class ASConnection {
    public static final String VERSION_1192 = "11.9.2";
    public static final String VERSION_120 = "12.0";
    public static final String VERSION_125 = "12.5";
    public static final String VERSION_12501 = "12.5.0.1";
    public static final String VERSION_12503 = "12.5.0.3";
    public static final String VERSION_1251 = "12.5.1";
    public static final String VERSION_1252 = "12.5.2";
    public static final String VERSION_1253 = "12.5.3";
    public static final String VERSION_1254 = "12.5.4";
    public static final String VERSION_15 = "15";
    public static final String VERSION_1502 = "15.0.2";
    public static final String VERSION_1503 = "15.0.3";
    public static final String VERSION_155 = "15.5";
    public static final String VERSION_157 = "15.7";
    private static final String ASE = "Adaptive Server Enterprise";
    static final int CONNECTION_CLOSED = 0;
    static final int CONNECTION_OPENED = 1;
    public static final int USE_JCONNECT_DRIVER = 0;
    public static final int USE_JDBC_ODBC_DRIVER = 1;
    public static final int SP_CONFIGURE_RUN_VALUE = 5;
    private DDLGlobalParameters _ddlGlobalParameters;
    public static final String VERSION_1511 = "15.1.1";
    private String _clusterMode;
    private static final String CLUSTERMODE_SDC = "shared disk cluster";
    private Boolean _isAutoExpansionApplicable;
    private Boolean _isComputedColApplicable;
    private Boolean _isUDWSApplicable;
    private Boolean _isEncryptionKeyApplicable;
    private Boolean _isArchiveDBApplicable;
    private Boolean _isIncrementalTransferApplicable;
    private Boolean _isEncryptedPassword;
    private Boolean _isScalarFunctionApplicable;
    private static InetAddress _localHost = null;
    private static String _localHostName = null;
    private Boolean _isDMLLoggingApplicable;
    private Boolean _isThreadPoolApplicable;
    private Boolean _isDataCompressionApplicable;
    private Boolean _isLoginProfileApplicable;
    private Boolean _isDualControlEncryptKeyApp;
    private Boolean _isPredidApplicable;
    private static final String PREDID = "predid";
    private static final String SYSLOGINROLES = "master.dbo.sysloginroles";
    private Boolean _isInRowLOBApplicable;
    private Connection _conn;
    private int _connectionStatus;
    private Properties _props;
    private String _machine;
    private String _portNum;
    private String _databaseName = "";
    private String _databaseVersion;
    private int _driver;
    private String _serverName;
    private String _odbcDataSource;
    private String _engineVersionStr;
    private String _currentUser = "";
    private String _serverVersion = "";
    public static final int ATTR_COL_NAME = 1;
    public static final int ATTR_COL_VER = 2;
    public static final int ATTR_COL_CURRENT_USER = 3;
    private final String TYPE_UNSIGNED_INT = "unsigned int";
    private final String TYPE_UNSIGNED_BIGINT = "unsigned bigint";
    private final String TYPE_UNSIGNED_SMALLINT = "unsigned smallint";
    private final String ASE_UNSIGNED_INT = "uint";
    private final String ASE_UNSIGNED_BIGINT = "ubigint";
    private final String ASE_UNSIGNED_SMALLINT = "usmallint";

    public ASConnection() {
        this._connectionStatus = 0;
    }

    public ASConnection(String string, String string2, int n, String string3, String string4, String string5, boolean bl, boolean bl2, String string6, String string7, DDLGlobalParameters dDLGlobalParameters) throws Exception {
        this._props = new Properties();
        this._props.put("user", string);
        this._props.put("password", this.encryptPassword(string2));
        this._props.put("JCONNECT_VERSION", Integer.toString(0));
        if (string7 != null) {
            this._props.put("CHARSET", string7);
        }
        this._props.put("LANGUAGE", "us_english");
        this._props.put("APPLICATIONNAME", "DDLGen");
        this._props.put("HOSTNAME", ASConnection.getLocalHostName());
        if (bl) {
            this._props.put("SYBSOCKET_FACTORY", SSLSocketFactoryASE.class.getName());
        }
        this._driver = n;
        this._machine = string4;
        this._portNum = string5;
        this._odbcDataSource = string6;
        this._serverName = string3;
        this._ddlGlobalParameters = dDLGlobalParameters;
        this._isEncryptedPassword = bl2;
        this.open();
    }

    public synchronized void open() throws Exception {
        try {
            if (this._connectionStatus == 1) {
                this._conn.close();
            }
            if (this._isEncryptedPassword.booleanValue()) {
                this._props.put("ENCRYPT_PASSWORD", "true");
                this._props.put("JCE_PROVIDER_CLASS", "com.certicom.ecc.jcae.Certicom");
            }
            Properties properties = null;
            properties = (Properties)this._props.clone();
            properties.put("password", this.getPassword());
            SybDataSource sybDataSource = new SybDataSource();
            sybDataSource.setConnectionProperties(properties);
            sybDataSource.setServerName(this._machine);
            sybDataSource.setPortNumber(Integer.valueOf(this._portNum).intValue());
            if (this._databaseName != null && this._databaseName.length() > 0) {
                sybDataSource.setDatabaseName(this._databaseName);
            }
            if (Settings.getEnableLoginTimeout()) {
                int n = Settings.getLoginTimeout();
                sybDataSource.setLoginTimeout(n);
            }
            this._conn = sybDataSource.getConnection();
            properties = null;
            this.printSQLWarnings();
            this.printDriverInfo();
            this._connectionStatus = 1;
            this.setAttributes();
        }
        catch (SQLException sQLException) {
            this._connectionStatus = 0;
            new DDLBaseException("AC1", sQLException, "CONNECTION_ERROR", 2, this._machine + ":" + this._portNum, this._ddlGlobalParameters);
        }
        catch (Exception exception) {
            this._connectionStatus = 0;
            new DDLBaseException("AC2", exception, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
        }
    }

    public String encryptPassword(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + (char)(string.charAt(i) + i);
        }
        return string2;
    }

    public String decryptPassword(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + (char)(string.charAt(i) - i);
        }
        return string2;
    }

    public final String getPassword() {
        return this.decryptPassword((String)this._props.get("password"));
    }

    public static String getLocalHostName() {
        if (_localHost == null) {
            try {
                _localHost = InetAddress.getLocalHost();
                _localHostName = _localHost.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                _localHostName = "";
            }
        }
        return _localHostName;
    }

    public boolean hasRole(String string) throws SQLException {
        ASResultSet aSResultSet = new ASResultSet(this);
        String string2 = ASQueryParser.parseQuery("select proc_role(''{0}'')", new String[]{string});
        aSResultSet.open(string2, "PROC_ROLE");
        aSResultSet.getNextRow();
        boolean bl = aSResultSet.getColumnBool(1);
        aSResultSet.close();
        return bl;
    }

    private boolean isSprocDDLGenInstalled() {
        try {
            ASResultSet aSResultSet = new ASResultSet(this);
            aSResultSet.open("select 1 from sybsystemprocs.dbo.sysobjects where name='sp_ddlgen' and type ='P'", "SELECT_SP_DDLGEN");
            return aSResultSet.getNextRow();
        }
        catch (SQLException sQLException) {
            new DDLBaseException("AC12", "SP_DDLGEN_CHECK_ERROR", 4, this._ddlGlobalParameters);
            return false;
        }
    }

    public String executeSP_DDLGen(String string, String string2) {
        block9: {
            SybStatement sybStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                if (this.isSprocDDLGenInstalled()) {
                    this._conn.createStatement().execute(ASQueryParser.parseQuery("set flushmessage on", null));
                    sybStatement = (SybStatement)this._conn.createStatement();
                    sybStatement.setSybMessageHandler((SybMessageHandler)new ASMessageHandler(stringBuffer));
                    sybStatement.execute(ASQueryParser.parseQuery("exec sybsystemprocs.dbo.sp_ddlgen ''{0}'', ''{1}''", new String[]{string, string2}));
                    while (sybStatement.getMoreResults() || sybStatement.getUpdateCount() != -1) {
                    }
                } else {
                    if (this.installDDLGenStoredProcedure()) {
                        return this.executeSP_DDLGen(string, string2);
                    }
                    return null;
                }
                ((SybConnection)this._conn).setSybMessageHandler(null);
                this._conn.createStatement().execute("set flushmessage off");
                return stringBuffer.toString();
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 207) break block9;
                try {
                    ((SybConnection)this._conn).setSybMessageHandler(null);
                    this._conn.createStatement().execute("set flushmessage off");
                    stringBuffer = new StringBuffer();
                    this._conn.createStatement().execute(ASQueryParser.parseQuery("set flushmessage on", null));
                    sybStatement = (SybStatement)this._conn.createStatement();
                    sybStatement.setSybMessageHandler((SybMessageHandler)new ASMessageHandler(stringBuffer));
                    sybStatement.execute(ASQueryParser.parseQuery("exec sybsystemprocs.dbo.sp_ddlgen ''{0}'', ''{1}''", new String[]{string, string2}));
                    while (sybStatement.getMoreResults() || sybStatement.getUpdateCount() != -1) {
                    }
                    ((SybConnection)this._conn).setSybMessageHandler(null);
                    this._conn.createStatement().execute("set flushmessage off");
                    return stringBuffer.toString();
                }
                catch (SQLException sQLException2) {
                    return null;
                }
            }
        }
        return null;
    }

    public boolean installDDLGenStoredProcedure() {
        try {
            this._conn.createStatement().execute("set quoted_identifier off");
            this.executeScript();
            this._conn.createStatement().execute("set quoted_identifier on");
            return true;
        }
        catch (Exception exception) {
            new DDLBaseException("AC13", "INSTALL_DDLGEN_ERROR", 4, this._ddlGlobalParameters);
            return false;
        }
    }

    private void executeScript() throws Exception {
        Class<?> clazz = Class.forName("com.sybase.ddlgen.DDLGenerator");
        URL uRL = clazz.getResource(this.getServerVersion().compareTo(VERSION_15) < 0 ? "installddlgen" : "installddlgen15x");
        if (uRL != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string = "";
            String string2 = "";
            Statement statement = this._conn.createStatement();
            statement.setEscapeProcessing(false);
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.toLowerCase().trim().equals("go")) {
                    string2 = string2 + string + "\n";
                    continue;
                }
                statement.clearBatch();
                statement.addBatch(string2);
                statement.executeBatch();
                string2 = "";
            }
            statement.setEscapeProcessing(true);
            statement.close();
            statement = null;
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public synchronized void close() throws SQLException {
        if (this._connectionStatus == 1) {
            this._conn.close();
        }
        this._connectionStatus = 0;
    }

    public synchronized int executeCommand(String string, String string2) throws SQLException {
        int n = 0;
        long l = new Date().getTime();
        if (string.toLowerCase().indexOf("select") >= 0 || string.toLowerCase().indexOf("update") >= 0 || string.toLowerCase().indexOf("delete") >= 0) {
            return n;
        }
        PreparedStatement preparedStatement = this._conn.prepareStatement(string);
        n = preparedStatement.executeUpdate();
        long l2 = new Date().getTime();
        this._ddlGlobalParameters.writeDebugInfo(l, l2, string2);
        preparedStatement.close();
        return n;
    }

    public boolean setUser(String string) throws SQLException {
        if (this.hasRole("sa_role") || string.equals("dbo")) {
            String string2 = ASQueryParser.parseQuery("setuser ''{0}''", new String[]{string});
            this.executeCommand(string2, "SETUSER");
            return true;
        }
        return false;
    }

    public boolean unSetUser(String string) throws SQLException {
        if (this.hasRole("sa_role") || string.equals("dbo")) {
            this.executeCommand("setuser", "SETUSER_WITHOUT_ARG");
            return true;
        }
        return false;
    }

    public int getConnectionStatus() {
        return this._connectionStatus;
    }

    public boolean isConnectionOpen() {
        return this._connectionStatus == 1;
    }

    public String getServerName() {
        return this._serverName;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public String getDatabaseVersion() {
        return this._databaseVersion;
    }

    public String getEngineVersionString() {
        return this._engineVersionStr;
    }

    public String getOdbcDataSource() {
        return this._odbcDataSource;
    }

    public String getURL() {
        String string = "";
        if (this._driver == 1) {
            string = "jdbc:odbc:" + this._odbcDataSource;
        } else {
            if (this._machine == null || this._portNum == null) {
                new DDLBaseException("AC3", "INVALID_HOSTNAME_PORTNO_ERROR", 2, this._ddlGlobalParameters);
            }
            string = "jdbc:sybase:Tds:" + this._machine + ":" + this._portNum;
            if (this._databaseName.length() > 0) {
                string = string + "/" + this._databaseName;
            }
        }
        return string;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public String getCurrentUser() {
        return this._currentUser;
    }

    protected void setAttributes() throws SQLException {
        ASResultSet aSResultSet = new ASResultSet(this);
        aSResultSet.open("SELECT db_name(), @@version, suser_name()", "DbAttr");
        aSResultSet.getNextRow();
        this._databaseName = aSResultSet.getColumnString(1);
        this._engineVersionStr = aSResultSet.getColumnString(2);
        this._currentUser = aSResultSet.getColumnString(3).trim();
        aSResultSet.close();
        this._databaseVersion = this._engineVersionStr;
    }

    public void printDriverInfo() {
        try {
            this._conn.getMetaData();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean printSQLWarnings() throws SQLException {
        boolean bl = false;
        for (SQLWarning sQLWarning = this._conn.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
            bl = true;
        }
        this._conn.clearWarnings();
        return bl;
    }

    public boolean areStringsEqual(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    protected void finalize() {
        try {
            if (this._connectionStatus == 1 && !this._conn.isClosed()) {
                this._conn.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("AC4", (Exception)sQLException, 2, this._ddlGlobalParameters);
        }
        catch (Exception exception) {
            new DDLBaseException("AC5", exception, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
        }
    }

    public long getConnectionID() throws Exception {
        String string = "";
        ASResultSet aSResultSet = new ASResultSet(this);
        aSResultSet.open("SELECT connection_property('Number')", "CONNECTION_PROPERTY");
        if (!aSResultSet.getNextRow()) {
            return 0L;
        }
        string = aSResultSet.getColumnString(1);
        aSResultSet.close();
        try {
            Long l = new Long(string);
            return l;
        }
        catch (Exception exception) {
            new DDLBaseException("AC6", exception, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
            return 0L;
        }
    }

    public int isClosed() {
        return this._connectionStatus;
    }

    public String getServerVersion() {
        if (this._serverVersion.length() == 0) {
            try {
                int n = -1;
                int n2 = 0;
                int n3 = -1;
                ASResultSet aSResultSet = new ASResultSet(this);
                aSResultSet.open("select @@version", "SQL_SERVER_VERSION");
                aSResultSet.getNextRow();
                int n4 = 1;
                String string = aSResultSet.getColumnString(n4++);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                int n5 = stringTokenizer.countTokens();
                String[] stringArray = new String[n5];
                int n6 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals(ASE)) {
                        n3 = n6;
                    }
                    int n7 = n6;
                    n6 = (short)(n6 + 1);
                    stringArray[n7] = string2;
                }
                if (n == -1) {
                    n = 0;
                    n2 = 1;
                    this._serverVersion = stringArray[n3 + n2];
                }
                aSResultSet.close();
            }
            catch (SQLException sQLException) {
                new DDLBaseException("AC8", (Exception)sQLException, 2, this._ddlGlobalParameters);
            }
            catch (Exception exception) {
                new DDLBaseException("AC9", exception, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
            }
        }
        return this._serverVersion;
    }

    public DDLGlobalParameters getDDLGlobalParameter() {
        return this._ddlGlobalParameters;
    }

    public boolean isAutoExpansionApplicable() {
        if (this._isAutoExpansionApplicable != null) {
            return this._isAutoExpansionApplicable;
        }
        if (this.getServerVersion().compareTo(VERSION_1251) < 0) {
            this._isAutoExpansionApplicable = new Boolean(false);
            return false;
        }
        if (this.isExpansionProcedureInstalled()) {
            this._isAutoExpansionApplicable = new Boolean(true);
            return true;
        }
        this._isAutoExpansionApplicable = new Boolean(false);
        return false;
    }

    public boolean isUDWSApplicable() {
        if (this._isUDWSApplicable != null) {
            return this._isUDWSApplicable;
        }
        if (this.getServerVersion().compareTo(VERSION_15) < 0) {
            this._isUDWSApplicable = new Boolean(false);
            return false;
        }
        int n = this.getSPConfigValue("enable webservices");
        if (n == 0) {
            this._isUDWSApplicable = new Boolean(false);
            return false;
        }
        if (this.isWebServicesProcedureInstalled()) {
            this._isUDWSApplicable = new Boolean(true);
            return true;
        }
        this._isUDWSApplicable = new Boolean(false);
        return false;
    }

    private boolean isExpansionProcedureInstalled() {
        try {
            String string = "select 'yes' from sybsystemprocs.dbo.sysobjects where type = 'P' and name = 'sp_dbextend' ";
            ASResultSet aSResultSet = new ASResultSet(this);
            aSResultSet.open(string, "SQL_EXPANSION_APPLICABLE");
            if (aSResultSet.getNextRow()) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("AC10", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("AC11", exception, "INTERNAL_ERROR", 1);
        }
        return false;
    }

    public boolean isPredidApplicable() {
        if (this._isPredidApplicable == null) {
            this._isPredidApplicable = this.hasColumn(PREDID, SYSLOGINROLES) ? new Boolean(true) : new Boolean(false);
        }
        return this._isPredidApplicable;
    }

    public boolean hasColumn(String string, String string2) {
        int n = 0;
        try {
            String string3 = ASQueryParser.parseQuery("select count({0}) from {1}", new String[]{string, string2});
            ASResultSet aSResultSet = new ASResultSet(this);
            aSResultSet.open(string3, "HAS_COLUMN_IN_TABLE_QUERY");
            aSResultSet.getNextRow();
            n = aSResultSet.getColumnInt(1);
            aSResultSet.close();
        }
        catch (SQLException sQLException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        return n >= 0;
    }

    private boolean isWebServicesProcedureInstalled() {
        try {
            String string = "select 'yes' from sybsystemprocs.dbo.sysobjects where type = 'P' and name = 'sp_webservices' ";
            ASResultSet aSResultSet = new ASResultSet(this);
            aSResultSet.open(string, "SQL_WEBSERVICES_PROC_INSTALLED");
            if (aSResultSet.getNextRow()) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("AC12", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("AC13", exception, "INTERNAL_ERROR", 1);
        }
        return false;
    }

    public boolean isComputedColApplicable() {
        if (this._isComputedColApplicable == null) {
            this._isComputedColApplicable = this.getServerVersion().compareTo(VERSION_15) >= 0 ? new Boolean(true) : new Boolean(false);
        }
        return this._isComputedColApplicable;
    }

    public boolean isPartitionsApplicable() {
        return this.getServerVersion().compareTo(VERSION_15) >= 0;
    }

    public boolean isScalarFunctionApplicable() {
        if (this._isScalarFunctionApplicable != null) {
            return this._isScalarFunctionApplicable;
        }
        this._isScalarFunctionApplicable = this.getServerVersion().compareTo(VERSION_1502) < 0 ? new Boolean(false) : new Boolean(true);
        return this._isScalarFunctionApplicable;
    }

    public boolean isEncryptionKeyApplicable() {
        int n;
        if (this._isEncryptionKeyApplicable != null) {
            return this._isEncryptionKeyApplicable;
        }
        if (this.getServerVersion().compareTo(VERSION_1253) >= 0 && (n = this.getSPConfigValue("enable encrypted columns")) == 1) {
            this._isEncryptionKeyApplicable = new Boolean(true);
            return true;
        }
        this._isEncryptionKeyApplicable = new Boolean(false);
        return false;
    }

    public boolean isIncrementalTransferApplicable() {
        if (this._isIncrementalTransferApplicable != null) {
            return this._isIncrementalTransferApplicable;
        }
        if (this.getServerVersion().compareTo(VERSION_15) >= 0 && !this.isCluster()) {
            try {
                ASResultSet aSResultSet = new ASResultSet(this);
                aSResultSet.open("select name from master..sysobjects where name = 'monTableTransfer'", "FEATURE_INCREMENTAL_TRANSFER");
                this._isIncrementalTransferApplicable = aSResultSet.getNextRow() ? new Boolean(aSResultSet.getColumnString(1).equals("monTableTransfer")) : new Boolean(false);
            }
            catch (SQLException sQLException) {
                this._isIncrementalTransferApplicable = new Boolean(false);
            }
            return this._isIncrementalTransferApplicable;
        }
        this._isIncrementalTransferApplicable = new Boolean(false);
        return false;
    }

    public boolean isDMLLoggingApplicable() {
        if (this._isDMLLoggingApplicable != null) {
            return this._isDMLLoggingApplicable;
        }
        String string = this.getServerVersion();
        this._isDMLLoggingApplicable = string.compareTo(VERSION_1503) > 0 && !this.isCluster() ? new Boolean(true) : new Boolean(false);
        return this._isDMLLoggingApplicable;
    }

    public boolean isDataCompressionApplicable() {
        if (this._isDataCompressionApplicable != null) {
            return this._isDataCompressionApplicable;
        }
        String string = this.getServerVersion();
        this._isDataCompressionApplicable = string.compareTo(VERSION_155) > 0 ? new Boolean(true) : new Boolean(false);
        return this._isDataCompressionApplicable;
    }

    public boolean isThreadPoolApplicable() {
        if (this._isThreadPoolApplicable == null) {
            this._isThreadPoolApplicable = this.getServerVersion().compareTo(VERSION_157) >= 0 ? new Boolean(true) : new Boolean(false);
        }
        return this._isThreadPoolApplicable;
    }

    public boolean isLoginProfileApplicable() {
        if (this._isLoginProfileApplicable == null) {
            this._isLoginProfileApplicable = this.getServerVersion().compareTo(VERSION_155) > 0 ? new Boolean(true) : new Boolean(false);
        }
        return this._isLoginProfileApplicable;
    }

    public boolean isDualControlEncryptKeyApp() {
        if (this._isDualControlEncryptKeyApp == null) {
            this._isDualControlEncryptKeyApp = this.getServerVersion().compareTo(VERSION_155) > 0 ? new Boolean(true) : new Boolean(false);
        }
        return this._isDualControlEncryptKeyApp;
    }

    public boolean isInRowLOBApplicable() {
        if (this._isInRowLOBApplicable != null) {
            return this._isInRowLOBApplicable;
        }
        String string = this.getServerVersion();
        this._isInRowLOBApplicable = string.compareTo(VERSION_157) >= 0 ? new Boolean(true) : new Boolean(false);
        return this._isInRowLOBApplicable;
    }

    public String getUnsignedIntType(String string) {
        if (string.equals("uint")) {
            return "unsigned int";
        }
        if (string.equals("ubigint")) {
            return "unsigned bigint";
        }
        if (string.equals("usmallint")) {
            return "unsigned smallint";
        }
        return string;
    }

    public boolean isPwdComplexityApplicable() {
        return this.getServerVersion().compareTo(VERSION_1254) >= 0 && this.getServerVersion().compareTo(VERSION_15) < 0 || this.getServerVersion().compareTo(VERSION_1502) >= 0;
    }

    public boolean isArchiveDBApplicable() {
        if (this._isArchiveDBApplicable != null) {
            return this._isArchiveDBApplicable;
        }
        if (this.getServerVersion().compareTo(VERSION_1254) >= 0 && this.getServerVersion().compareTo(VERSION_15) < 0 || this.getServerVersion().compareTo(VERSION_1502) >= 0) {
            this._isArchiveDBApplicable = new Boolean(true);
            return true;
        }
        this._isArchiveDBApplicable = new Boolean(false);
        return false;
    }

    public int getSPConfigValue(String string) {
        int n = 0;
        try {
            String string2 = ASQueryParser.parseQuery("sp_configure ''{0}''", new String[]{string});
            ASResultSet aSResultSet = new ASResultSet(this);
            aSResultSet.open(string2, "SP_CONFIGURE");
            aSResultSet.getNextRow();
            n = aSResultSet.getColumnInt(5);
            aSResultSet.close();
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public String getValidNameString() {
        if (this.getServerVersion().compareTo(VERSION_15) < 0) {
            return "";
        }
        return ",255";
    }

    public boolean isCluster() {
        if (this._clusterMode == null) {
            try {
                ASResultSet aSResultSet = new ASResultSet(this);
                aSResultSet.open("select @@clustermode", "SDC_CLUSTERMODE");
                if (aSResultSet.getNextRow()) {
                    this._clusterMode = aSResultSet.getColumnString(1);
                }
            }
            catch (Exception exception) {
                this._clusterMode = "";
            }
        }
        return this._clusterMode.toLowerCase().indexOf(CLUSTERMODE_SDC) > -1;
    }

    public boolean verifyDBName(String string) {
        try {
            ASResultSet aSResultSet = new ASResultSet(this);
            if (aSResultSet != null) {
                Object[] objectArray = new String[]{string};
                String string2 = ASQueryParser.parseQuery("select name from master.dbo.sysdatabases where name = ''{0}''", objectArray);
                aSResultSet.open(string2, "VERIFY_DB_NAME");
                if (!aSResultSet.getNextRow()) {
                    new DDLBaseException("AC14", "DATABASE_NOT_FOUND_ERROR", 2, string);
                }
            }
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }
}

