/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.sql;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.sql.ASConnection;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;

public class ASResultSet {
    private ASConnection _asConn;
    private ResultSet _rSet;
    private int _rsetCount;
    private PreparedStatement _sqlStatement;
    private int _nColumns;
    private boolean _isClosed;
    private boolean _moreResults;
    private boolean _isResultSet;
    private boolean _firstTime;
    private ResultSetMetaData _metaData;
    static final int DB_BASE_ERR = 11;

    public ASResultSet(ASConnection aSConnection) {
        this._asConn = aSConnection;
        this._isClosed = true;
        this._rsetCount = 0;
        this._rSet = null;
        this._metaData = null;
    }

    public synchronized ResultSet open(String string, String string2) throws SQLException {
        Connection connection = this._asConn.getConnection();
        if (connection != null) {
            long l = new Date().getTime();
            this._sqlStatement = connection.prepareStatement(string);
            this._rSet = this._sqlStatement.executeQuery();
            long l2 = new Date().getTime();
            this._asConn.getDDLGlobalParameter().writeDebugInfo(l, l2, string2);
            this._metaData = this._rSet.getMetaData();
            this._nColumns = this._metaData.getColumnCount();
            this._firstTime = false;
            this._isClosed = false;
        }
        return this._rSet;
    }

    public void close() {
        try {
            if (this._rSet != null) {
                this._rSet.close();
                this._metaData = null;
            }
            if (this._sqlStatement != null) {
                this._sqlStatement.close();
            }
            this._isClosed = true;
        }
        catch (SQLException sQLException) {
            new DDLBaseException("ASR1", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("ASR2", exception, "INTERNAL_ERROR", 1);
        }
    }

    public boolean getNextRow() throws SQLException {
        if (this._firstTime) {
            this.getNextResultSet(true);
        }
        if (this._rSet != null) {
            return this._rSet.next();
        }
        return false;
    }

    public ResultSetMetaData getResultSetMetaData() throws SQLException {
        if (this._firstTime) {
            this.getNextResultSet(true);
        }
        return this._metaData;
    }

    private boolean getNextResultSet(boolean bl) throws SQLException {
        if (this._isClosed) {
            return false;
        }
        if (this._firstTime) {
            this._firstTime = false;
        } else {
            this._isResultSet = this._sqlStatement.getMoreResults();
        }
        if (!this.getResultsAndMetadata() && bl) {
            this._isResultSet = this._sqlStatement.getMoreResults();
            this.getResultsAndMetadata();
        }
        return this._moreResults;
    }

    public String[] getColumnsAsArray() throws SQLException {
        String[] stringArray = new String[this._nColumns];
        for (int i = 0; i < this._nColumns; ++i) {
            stringArray[i] = this.getColumnString(i + 1);
        }
        return stringArray;
    }

    public String getColumnString(String string) throws SQLException {
        int n = this._metaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            String string2 = this._metaData.getColumnLabel(i);
            if (!string2.equals(string)) continue;
            return this.getColumnString(i);
        }
        return "";
    }

    public String getColumnString(int n) throws SQLException {
        String string = this._rSet.getString(n);
        if (!this._rSet.wasNull()) {
            switch (this._metaData.getColumnType(n)) {
                case 1: {
                    string = string.trim();
                    break;
                }
                case 93: {
                    Timestamp timestamp = this._rSet.getTimestamp(n);
                    string = DateFormat.getDateTimeInstance(2, 3).format(timestamp);
                    break;
                }
                case 91: {
                    java.sql.Date date = this._rSet.getDate(n);
                    string = DateFormat.getDateInstance(2).format(date);
                    break;
                }
                case 92: {
                    java.sql.Date date = this._rSet.getDate(n);
                    string = DateFormat.getTimeInstance(3).format(date);
                    break;
                }
            }
        } else {
            string = "";
        }
        return string;
    }

    public int getColumnInt(int n) throws SQLException {
        return this._rSet.getInt(n);
    }

    public int getColumnInt(String string) throws SQLException {
        return this._rSet.getInt(string);
    }

    public long getColumnLong(int n) throws SQLException {
        return this._rSet.getLong(n);
    }

    public boolean getColumnBool(int n) throws SQLException {
        return this._rSet.getBoolean(n);
    }

    public Date getColumnDate(int n) throws SQLException {
        return this._rSet.getTimestamp(n);
    }

    public byte[] getColumnBytes(int n) throws SQLException {
        return this._rSet.getBytes(n);
    }

    public long getColumnBigIntAsLong(int n) throws SQLException {
        BigDecimal bigDecimal = this._rSet.getBigDecimal(n);
        if (this._rSet.wasNull()) {
            return 0L;
        }
        return bigDecimal.longValue();
    }

    public static boolean isColumnYes(String string) {
        return string.equalsIgnoreCase("y") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
    }

    public boolean isColumnYes(int n) throws SQLException {
        String string = this.getColumnString(n);
        return ASResultSet.isColumnYes(string);
    }

    private boolean getResultsAndMetadata() throws SQLException {
        this._metaData = null;
        this._moreResults = false;
        if (this._isResultSet) {
            this._rSet = this._sqlStatement.getResultSet();
            if (this._rSet != null) {
                this._metaData = this._rSet.getMetaData();
                this._nColumns = this._metaData.getColumnCount();
                this._moreResults = true;
            }
        } else {
            int n = this._sqlStatement.getUpdateCount();
            if (n != -1) {
                this._moreResults = true;
                return false;
            }
        }
        return true;
    }

    public ResultSet getJavaResultSet() {
        return this._rSet;
    }
}

