/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.rsa.RSADP;
import com.certicom.ecc.rsa.RSAEP;
import com.certicom.ecc.rsa.RSAException;
import com.certicom.ecc.rsa.RSAPrimitive;
import com.certicom.ecc.rsa.RSAPrivateKey;
import com.certicom.ecc.rsa.RSAPublicKey;
import com.certicom.ecc.rsa.outputSizeSelectable;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.Conversion;
import com.certicom.ecc.util.ConversionException;
import java.math.BigInteger;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class RSA
extends CryptoTransform {
    private RSAPrimitive cp;
    private CryptoTransform cn;
    private int co;
    private byte[] cr;
    private boolean cq;

    public RSA() {
        super("RSA");
    }

    public void reset() {
        super.reset();
        if (this.cp != null) {
            this.cp.reset();
        }
        if (this.cn != null) {
            this.cn.reset();
        }
        this.co = 0;
        this.cr = null;
        this.cq = false;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        super.init(n2, objectArray, random);
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            this.reset();
            throw new IllegalArgumentException("wrong mode");
        }
        if (objectArray != null && objectArray.length >= 2) {
            String string = (String)objectArray[1];
            if (string.equals("RawExpRsa")) {
                this.cq = true;
            }
            if (this.cq && (n2 == 1 || n2 == 2)) {
                this.reset();
                throw new IllegalArgumentException("rawExpRsa supports only encrypt/decrypt");
            }
            boolean bl = objectArray[0] instanceof RSAPublicKey;
            if (n2 == 1 && bl) {
                this.reset();
                throw new IllegalArgumentException("wrong key for sign.");
            }
            if (n2 == 2 && !bl) {
                this.reset();
                throw new IllegalArgumentException("wrong key for verify.");
            }
            if (bl) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)objectArray[0];
                if (!(this.cp instanceof RSAEP)) {
                    this.cp = new RSAEP(rSAPublicKey);
                } else {
                    this.cp.setKey(rSAPublicKey);
                }
                this.co = rSAPublicKey.n().bitLength() + 7 >>> 3;
            } else {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)objectArray[0];
                if (!(this.cp instanceof RSADP)) {
                    this.cp = new RSADP(rSAPrivateKey);
                } else {
                    this.cp.setKey(rSAPrivateKey);
                }
                this.co = rSAPrivateKey.hasExponents() ? rSAPrivateKey.n().bitLength() + 7 >>> 3 : rSAPrivateKey.p().multiply(rSAPrivateKey.q()).bitLength() + 7 >>> 3;
            }
            if (this.cq) {
                return;
            }
            if (this.cn == null || !this.cn.getAlgorithm().equals(string)) {
                this.cn = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, (String)objectArray[1]);
            }
            Object[] objectArray2 = null;
            if (objectArray.length >= 3) {
                objectArray2 = (Object[])objectArray[2];
            }
            this.cn.init(5, objectArray2, random);
        }
    }

    public int inputSize() {
        if (this.for == 3 || this.for == 4) {
            if (this.cq) {
                return this.co;
            }
            if (this.cn instanceof outputSizeSelectable) {
                return ((outputSizeSelectable)((Object)this.cn)).maxIn(this.co - 1);
            }
            return this.co;
        }
        if (this.for == 1 || this.for == 2) {
            return 0;
        }
        throw new IllegalStateException("wrong mode.");
    }

    public int outputSize(int n2, boolean bl) {
        if (this.for == 3 || this.for == 1 && bl) {
            return this.co;
        }
        if (this.for == 4) {
            if (this.cq) {
                return this.co;
            }
            return this.cn.outputSize(this.co - 1, true);
        }
        if (this.for == 2 || this.for == 1 && !bl) {
            return 0;
        }
        throw new IllegalStateException("wrong mode");
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.for == 3 || this.for == 4 || this.for == 1 || this.for == 2) {
            int n5;
            if (this.cq) {
                if (byArray == null || n3 != this.co) {
                    throw new IllegalArgumentException("in size != modulus size.");
                }
                if (byArray2 == null || byArray2.length - n4 != this.co) {
                    throw new IllegalArgumentException("out size != modulus size");
                }
                byte[] byArray3 = new byte[this.co];
                System.arraycopy(byArray, n2, byArray3, 0, this.co);
                try {
                    byArray3 = this.case(byArray3, this.co);
                }
                catch (ConversionException conversionException) {
                    throw new IllegalArgumentException(conversionException.getMessage());
                }
                catch (RSAException rSAException) {
                    throw new IllegalArgumentException(rSAException.getMessage());
                }
                System.arraycopy(byArray3, 0, byArray2, n4, this.co);
                return this.co;
            }
            byte[] byArray4 = null;
            if (!(bl || this.for != 3 && this.for != 4)) {
                throw new IllegalArgumentException("ENC/DEC not incremental");
            }
            if (this.for != 4) {
                if (bl) {
                    byArray4 = new byte[this.co - 1];
                }
                try {
                    this.cn.transform(byArray, n2, n3, byArray4, 0, bl);
                    if (this.for == 2 && bl) {
                        this.cr = byArray4;
                        return 0;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.for != 2) {
                        throw illegalArgumentException;
                    }
                    return 0;
                }
                if (!bl) {
                    return 0;
                }
                n5 = this.co;
            } else {
                byArray4 = new byte[n3];
                System.arraycopy(byArray, n2, byArray4, 0, byArray4.length);
                n5 = this.co - 1;
            }
            try {
                byArray4 = this.case(byArray4, n5);
            }
            catch (ConversionException conversionException) {
                throw new IllegalArgumentException(conversionException.getMessage());
            }
            catch (RSAException rSAException) {
                throw new IllegalArgumentException(rSAException.getMessage());
            }
            if (this.for == 4) {
                byArray4 = this.cn.transform(byArray4, 0, byArray4.length, true);
            }
            System.arraycopy(byArray4, 0, byArray2, n4, byArray4.length);
            return byArray4.length;
        }
        throw new IllegalStateException("wrong mode");
    }

    public boolean verify(byte[] byArray, int n2, int n3) {
        try {
            int n4;
            if (this.for != 2) {
                throw new IllegalStateException("wrong mode");
            }
            if (n3 != this.co || this.cr == null) {
                return false;
            }
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            byte[] byArray3 = this.case(byArray2, this.co - 1);
            if (this.cr.length != byArray3.length) {
                return false;
            }
            for (n4 = 0; n4 < this.cr.length && this.cr[n4] == byArray3[n4]; ++n4) {
            }
            return n4 == this.cr.length;
        }
        catch (ConversionException conversionException) {
            return false;
        }
        catch (RSAException rSAException) {
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private byte[] case(byte[] byArray, int n2) throws ConversionException, RSAException {
        BigInteger bigInteger = Conversion.OS2IP(byArray);
        BigInteger bigInteger2 = this.cp.calc(bigInteger);
        return Conversion.I2OSP(bigInteger2, n2);
    }
}

