/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.codec.CryptoCodec;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.IDLCKeyGen;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import java.math.BigInteger;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DSA
extends CryptoTransform {
    private BigInteger Y;
    private BigInteger W;
    private CryptoTransform V;
    private byte[] X;
    private byte[][] S = new byte[4][];
    private CryptoCodec U;
    private int T;
    private int Z;

    public DSA() {
        super("DSA");
        this.setHashMode(this.getHashMode());
        this.T = SystemConfig.getConfig().getFormat();
        this.Z = SystemConfig.getConfig().getConformance();
        this.V = (CryptoTransform)CryptoManager.getInstance(TYPE, "SHA-1");
        this.U = CryptoCodec.getInstance("DSA", this.T);
    }

    public void reset() {
        int n2;
        super.reset();
        this.V.reset();
        if (this.X != null) {
            n2 = 0;
            while (n2 < this.X.length) {
                this.X[n2++] = 0;
            }
            this.X = null;
        }
        for (n2 = 0; n2 < this.S.length; ++n2) {
            if (this.S[n2] == null) continue;
            this.S[n2] = null;
        }
        this.Y = null;
        this.W = null;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        boolean bl = false;
        this.reset();
        super.init(n2, objectArray, random);
        if (objectArray != null && (n2 == 1 && random != null || n2 == 2)) {
            bl = true;
        }
        if (!bl) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
        this.V.init(5, null, random);
        this.S[0] = (byte[])objectArray[0];
        this.S[1] = (byte[])objectArray[1];
        this.S[2] = (byte[])objectArray[2];
        this.S[3] = (byte[])objectArray[3];
        try {
            this.Y = new BigInteger(1, this.S[0]);
            this.W = new BigInteger(1, this.S[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("cannot calculate signature.");
        }
    }

    public boolean isVerifiable() {
        return true;
    }

    public int outputSize(int n2, boolean bl) throws IllegalStateException {
        if (this.for != 1 && this.for != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (!bl || bl && this.for == 2) {
            return 0;
        }
        if (this.T == 10) {
            return 40;
        }
        if (this.T == 11) {
            return 49;
        }
        return 0;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.for != 1 && this.for != 2) {
            throw new IllegalStateException("wrong mode");
        }
        if (byArray != null) {
            if (this.getHashMode() == 1) {
                this.X = new byte[n3];
                System.arraycopy(byArray, n2, this.X, 0, n3);
            } else {
                this.V.transform(byArray, n2, n3, false);
            }
        }
        if (!bl || bl && this.for == 2) {
            return 0;
        }
        BigInteger bigInteger = new BigInteger(1, this.new()).mod(this.W);
        IDLCKeyGen iDLCKeyGen = new IDLCKeyGen();
        ((CryptoTransform)iDLCKeyGen).init(5, new Object[]{this.S[0], this.S[1], this.S[2]}, this.do);
        Object[] objectArray = (Object[])((CryptoTransform)iDLCKeyGen).transformToObject(null, 0, 0, true);
        BigInteger bigInteger2 = new BigInteger(1, (byte[])objectArray[0]).mod(this.W);
        BigInteger bigInteger3 = new BigInteger(1, (byte[])objectArray[1]).mod(this.Y).mod(this.W);
        BigInteger bigInteger4 = new BigInteger(1, this.S[3]).mod(this.W);
        BigInteger bigInteger5 = bigInteger2.modInverse(this.W).multiply(bigInteger4.multiply(bigInteger3).add(bigInteger)).mod(this.W);
        byte[] byArray3 = bigInteger3.toByteArray();
        byte[] byArray4 = new byte[20];
        if (21 == byArray3.length) {
            System.arraycopy(byArray3, 1, byArray4, 0, 20);
        } else if (20 > byArray3.length) {
            System.arraycopy(byArray3, 0, byArray4, 20 - byArray3.length, byArray3.length);
        } else if (20 == byArray3.length) {
            byArray4 = byArray3;
        }
        byte[] byArray5 = bigInteger5.toByteArray();
        byte[] byArray6 = new byte[20];
        if (21 == byArray5.length) {
            System.arraycopy(byArray5, 1, byArray6, 0, 20);
        } else if (20 > byArray5.length) {
            System.arraycopy(byArray5, 0, byArray6, 20 - byArray5.length, byArray5.length);
        } else if (20 == byArray5.length) {
            byArray6 = byArray5;
        }
        this.U.init(1, null);
        this.U.codecToObject(byArray4, 0, byArray4.length, false);
        Object[] objectArray2 = this.U.codecToObject(byArray6, 0, byArray6.length, true);
        byte[] byArray7 = (byte[])objectArray2[1];
        if (byArray2.length - n4 < byArray7.length) {
            throw new IllegalArgumentException("output buffer too short.");
        }
        System.arraycopy(byArray7, 0, byArray2, n4, byArray7.length);
        return byArray7.length;
    }

    public boolean verify(byte[] byArray, int n2, int n3) {
        if (this.for != 2) {
            throw new IllegalStateException("wrong mode.");
        }
        try {
            this.U.init(2, null);
            Object[] objectArray = this.U.codecToObject(byArray, n2, byArray.length, true);
            BigInteger bigInteger = new BigInteger(1, this.new()).mod(this.W);
            BigInteger bigInteger2 = new BigInteger(1, (byte[])objectArray[1]).mod(this.W);
            BigInteger bigInteger3 = new BigInteger(1, (byte[])objectArray[2]).mod(this.W);
            BigInteger bigInteger4 = bigInteger3.modInverse(this.W);
            BigInteger bigInteger5 = bigInteger.multiply(bigInteger4);
            BigInteger bigInteger6 = bigInteger2.multiply(bigInteger4);
            BigInteger bigInteger7 = new BigInteger(1, this.S[2]).mod(this.Y).modPow(bigInteger5, this.Y).multiply(new BigInteger(1, this.S[3]).mod(this.Y).modPow(bigInteger6, this.Y)).mod(this.Y);
            BigInteger bigInteger8 = bigInteger7.mod(this.W);
            return bigInteger8.equals(bigInteger2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private byte[] new() {
        if (this.getHashMode() == 2) {
            this.X = this.V.transform(null, 0, 0, true);
        }
        return this.X;
    }

    private static int new(byte[] byArray) {
        int n2;
        if (byArray == null) {
            throw new IllegalArgumentException("array is null");
        }
        for (n2 = 0; n2 < byArray.length && byArray[n2] == 0; ++n2) {
        }
        if (n2 == byArray.length) {
            return 0;
        }
        int n3 = (byArray.length - n2 - 1) * 8;
        int n4 = 7;
        do {
            if ((byArray[n2] >>> n4 & 1) != 1) continue;
            n3 += n4 + 1;
            break;
        } while (--n4 >= 0);
        return n3;
    }
}

