/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.spec;

import com.certicom.ecc.asn1der.asn1.ab;
import com.certicom.ecc.codec.CryptoCodec;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.scheme.CurveList;
import com.certicom.ecc.spec.F2mParameterSpec;
import com.certicom.ecc.spec.FFParameterSpec;
import com.certicom.ecc.spec.FpParameterSpec;
import com.certicom.ecc.util.Conversion;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;

public class ECPrivateKeySpec
implements ECPrivateKey,
Zeroizeable,
Serializable {
    private byte[] exp;
    private ECParams curve;
    private int f;
    private transient CryptoCodec dJ = null;
    private boolean zeroized = false;

    public ECPrivateKeySpec() {
    }

    public ECPrivateKeySpec(int n2, BigInteger bigInteger, ECParams eCParams) {
        int n3;
        this.f = n2;
        this.curve = eCParams;
        byte[] byArray = bigInteger.toByteArray();
        for (n3 = 0; n3 < byArray.length && byArray[n3] == 0; ++n3) {
        }
        this.exp = new byte[eCParams.getPointOrder().length];
        int n4 = this.exp.length - (byArray.length - n3);
        System.arraycopy(byArray, n3, this.exp, n4, byArray.length - n3);
    }

    public ECPrivateKeySpec(int n2, ECParams eCParams, byte[] byArray, int n3, int n4) {
        this.init(n2, eCParams, byArray, n3, n4);
    }

    public void init(int n2, ECParams eCParams, byte[] byArray, int n3, int n4) {
        Object[] objectArray;
        this.f = n2;
        this.curve = eCParams;
        String string = null;
        if (this.curve != null) {
            string = this.curve.getOID();
        }
        CryptoCodec cryptoCodec = this.codec();
        if (string == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
        }
        cryptoCodec.init(2, objectArray);
        Object[] objectArray3 = this.codec().codecToObject(byArray, n3, n4, true);
        this.exp = objectArray3[2] instanceof ab ? ((ab)objectArray3[2]).int() : (byte[])objectArray3[2];
        String string2 = objectArray3[1].toString();
        if (string2.equals("ECParameters")) {
            throw new IllegalArgumentException("cannot decode full params");
        }
        if (string2.equals("ImplicitlyCA") || string == null || !string2.equals(string)) {
            this.curve = CurveList.byName(string2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new Integer(this.f));
        ECParams eCParams = this.getECParams();
        objectOutputStream.writeObject(new Integer(eCParams.getCofactor()));
        objectOutputStream.writeObject(eCParams.getA());
        objectOutputStream.writeObject(eCParams.getB());
        objectOutputStream.writeObject(eCParams.getPoint().getX());
        objectOutputStream.writeObject(eCParams.getPoint().getY());
        objectOutputStream.writeObject(eCParams.getPointOrder());
        objectOutputStream.writeObject(eCParams.getOID());
        if (eCParams.getSeed() != null) {
            objectOutputStream.writeObject(new Boolean(true));
            objectOutputStream.writeObject(eCParams.getSeed());
        } else {
            objectOutputStream.writeObject(new Boolean(false));
        }
        if (eCParams instanceof F2mParameterSpec) {
            objectOutputStream.writeObject("F2m");
            objectOutputStream.writeObject(new Integer(eCParams.getSize()));
            objectOutputStream.writeObject(((F2mParameterSpec)eCParams).getName());
            objectOutputStream.writeObject(((F2mParameterSpec)eCParams).getBasis());
        } else {
            objectOutputStream.writeObject("Fp");
            objectOutputStream.writeObject(((FpParameterSpec)eCParams).getPrime());
            objectOutputStream.writeObject(((FpParameterSpec)eCParams).getName());
        }
        objectOutputStream.writeObject(this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        String string;
        int n2 = (Integer)objectInputStream.readObject();
        FFParameterSpec fFParameterSpec = null;
        int n3 = (Integer)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        byte[] byArray2 = (byte[])objectInputStream.readObject();
        byte[] byArray3 = (byte[])objectInputStream.readObject();
        byte[] byArray4 = (byte[])objectInputStream.readObject();
        byte[] byArray5 = (byte[])objectInputStream.readObject();
        String string2 = (String)objectInputStream.readObject();
        boolean bl = (Boolean)objectInputStream.readObject();
        byte[] byArray6 = null;
        if (bl) {
            byArray6 = (byte[])objectInputStream.readObject();
        }
        if ((string = (String)objectInputStream.readObject()).equals("F2m")) {
            int n4 = (Integer)objectInputStream.readObject();
            String string3 = (String)objectInputStream.readObject();
            int[] nArray = (int[])objectInputStream.readObject();
            fFParameterSpec = new F2mParameterSpec(byArray, byArray2, byArray6, byArray3, byArray4, byArray5, n3, n4, nArray, string3, string2);
        } else if (string.equals("Fp")) {
            byte[] byArray7 = (byte[])objectInputStream.readObject();
            String string4 = (String)objectInputStream.readObject();
            fFParameterSpec = new FpParameterSpec(byArray, byArray2, byArray6, byArray3, byArray4, byArray5, n3, byArray7, string4, string2);
        }
        byte[] byArray8 = (byte[])objectInputStream.readObject();
        this.init(n2, fFParameterSpec, byArray8, 0, byArray8.length);
    }

    public String getAlgorithm() {
        return new String("ECC");
    }

    public byte[] getEncoded() {
        Object[] objectArray;
        String string = null;
        if (this.curve != null) {
            string = this.curve.getOID();
        }
        CryptoCodec cryptoCodec = this.codec();
        if (string == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
        }
        cryptoCodec.init(1, objectArray);
        Object[] objectArray3 = this.codec().codecToObject(this.exp, 0, this.exp.length, true);
        return (byte[])objectArray3[1];
    }

    public String getFormat() {
        return this.codec().getFormat();
    }

    public ECParams getECParams() {
        if (this.curve == null) {
            this.curve = CurveList.byName("ImplicitlyCA");
        }
        return this.curve;
    }

    public byte[] getExp() {
        byte[] byArray = new byte[this.exp.length];
        System.arraycopy(this.exp, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public String toString() {
        if (this.curve == null) {
            return "[ key: " + Conversion.OS2Hex(this.exp, 2) + " curve: 0 ]";
        }
        return "[ key: " + Conversion.OS2Hex(this.exp, 2) + " curve: " + this.curve.toString() + " ] ";
    }

    public boolean equals(Object object) {
        ECPrivateKeySpec eCPrivateKeySpec;
        boolean bl;
        if (object instanceof ECPrivateKeySpec && (bl = this.curve.equals((eCPrivateKeySpec = (ECPrivateKeySpec)object).getECParams()))) {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.exp.length && this.exp[n3] == 0; ++n3) {
            }
            for (n2 = 0; n2 < eCPrivateKeySpec.exp.length && eCPrivateKeySpec.exp[n2] == 0; ++n2) {
            }
            if (this.exp.length - n3 != eCPrivateKeySpec.exp.length - n2) {
                return false;
            }
            n3 = this.exp.length - n3;
            n2 = 0;
            while (n3-- > 0) {
                if (this.exp[this.exp.length - ++n2] == eCPrivateKeySpec.exp[eCPrivateKeySpec.exp.length - n2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public CryptoCodec codec() {
        if (this.dJ == null) {
            this.dJ = CryptoCodec.getInstance("ECPrivateKey", this.f);
        }
        return this.dJ;
    }

    public boolean isZeroized() {
        return this.zeroized;
    }

    public boolean testZeroizationState() {
        return this.zeroized;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.exp, (byte)0);
        this.curve = null;
        this.zeroized = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }
}

