/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.spec;

import com.certicom.ecc.codec.CryptoCodec;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.interfaces.PointParams;
import com.certicom.ecc.scheme.CurveList;
import com.certicom.ecc.spec.F2mParameterSpec;
import com.certicom.ecc.spec.FFParameterSpec;
import com.certicom.ecc.spec.FpParameterSpec;
import com.certicom.ecc.spec.PointSpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ECPublicKeySpec
implements ECPublicKey,
Zeroizeable,
Serializable {
    private PointParams pt = null;
    private ECParams curve = null;
    private int f;
    private int ct;
    private transient CryptoCodec dI = null;
    private boolean zeroized = false;

    public ECPublicKeySpec(int n2, int n3, PointParams pointParams, ECParams eCParams) {
        this.f = n2;
        this.ct = n3;
        if (pointParams == null) {
            throw new IllegalArgumentException("parameters cannot be null.");
        }
        this.pt = pointParams;
        this.curve = eCParams;
    }

    public ECPublicKeySpec(int n2, int n3, ECParams eCParams, byte[] byArray, int n4, int n5) {
        this.init(n2, n3, eCParams, byArray, n4, n5);
    }

    public void init(int n2, int n3, ECParams eCParams, byte[] byArray, int n4, int n5) {
        Object[] objectArray;
        this.f = n2;
        this.ct = n3;
        this.curve = eCParams;
        String string = null;
        if (this.curve != null) {
            string = this.curve.getOID();
        }
        CryptoCodec cryptoCodec = this.codec();
        if (string == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
        }
        cryptoCodec.init(2, objectArray);
        Object[] objectArray3 = this.codec().codecToObject(byArray, n4, n5, true);
        String string2 = objectArray3[1].toString();
        if (string2.equals("ECParameters")) {
            throw new IllegalArgumentException("cannot decode full params");
        }
        if (string2.equals("ImplicitlyCA") || string == null || !string2.equals(string)) {
            this.curve = CurveList.byName(string2);
        }
        byte[] byArray2 = (byte[])objectArray3[2];
        this.pt = new PointSpec(byArray2, 0, byArray2.length, this.curve);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new Integer(this.f));
        objectOutputStream.writeObject(new Integer(this.ct));
        ECParams eCParams = this.getECParams();
        objectOutputStream.writeObject(new Integer(eCParams.getCofactor()));
        objectOutputStream.writeObject(eCParams.getA());
        objectOutputStream.writeObject(eCParams.getB());
        objectOutputStream.writeObject(eCParams.getPoint().getX());
        objectOutputStream.writeObject(eCParams.getPoint().getY());
        objectOutputStream.writeObject(eCParams.getPointOrder());
        objectOutputStream.writeObject(eCParams.getOID());
        if (eCParams.getSeed() != null) {
            objectOutputStream.writeObject(new Boolean(true));
            objectOutputStream.writeObject(eCParams.getSeed());
        } else {
            objectOutputStream.writeObject(new Boolean(false));
        }
        if (eCParams instanceof F2mParameterSpec) {
            objectOutputStream.writeObject("F2m");
            objectOutputStream.writeObject(new Integer(((F2mParameterSpec)eCParams).getSize()));
            objectOutputStream.writeObject(((F2mParameterSpec)eCParams).getName());
            objectOutputStream.writeObject(((F2mParameterSpec)eCParams).getBasis());
        } else {
            objectOutputStream.writeObject("Fp");
            objectOutputStream.writeObject(((FpParameterSpec)eCParams).getPrime());
            objectOutputStream.writeObject(((FpParameterSpec)eCParams).getName());
        }
        objectOutputStream.writeObject(this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        String string;
        int n2 = (Integer)objectInputStream.readObject();
        int n3 = (Integer)objectInputStream.readObject();
        FFParameterSpec fFParameterSpec = null;
        int n4 = (Integer)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        byte[] byArray2 = (byte[])objectInputStream.readObject();
        byte[] byArray3 = (byte[])objectInputStream.readObject();
        byte[] byArray4 = (byte[])objectInputStream.readObject();
        byte[] byArray5 = (byte[])objectInputStream.readObject();
        String string2 = (String)objectInputStream.readObject();
        boolean bl = (Boolean)objectInputStream.readObject();
        byte[] byArray6 = null;
        if (bl) {
            byArray6 = (byte[])objectInputStream.readObject();
        }
        if ((string = (String)objectInputStream.readObject()).equals("F2m")) {
            int n5 = (Integer)objectInputStream.readObject();
            String string3 = (String)objectInputStream.readObject();
            int[] nArray = (int[])objectInputStream.readObject();
            fFParameterSpec = new F2mParameterSpec(byArray, byArray2, byArray6, byArray3, byArray4, byArray5, n4, n5, nArray, string3, string2);
        } else if (string.equals("Fp")) {
            byte[] byArray7 = (byte[])objectInputStream.readObject();
            String string4 = (String)objectInputStream.readObject();
            fFParameterSpec = new FpParameterSpec(byArray, byArray2, byArray6, byArray3, byArray4, byArray5, n4, byArray7, string4, string2);
        }
        byte[] byArray8 = (byte[])objectInputStream.readObject();
        this.init(n2, n3, fFParameterSpec, byArray8, 0, byArray8.length);
    }

    public String getAlgorithm() {
        return new String("ECC");
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.ct);
    }

    public byte[] getEncoded(int n2) {
        Object[] objectArray;
        byte[] byArray = this.pt.getEncoded(n2);
        String string = null;
        if (this.curve != null) {
            string = this.curve.getOID();
        }
        CryptoCodec cryptoCodec = this.codec();
        if (string == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
        }
        cryptoCodec.init(1, objectArray);
        Object[] objectArray3 = this.codec().codecToObject(byArray, 0, byArray.length, true);
        return (byte[])objectArray3[1];
    }

    public String getFormat() {
        return this.codec().getFormat();
    }

    public ECParams getECParams() {
        return this.curve;
    }

    public byte[] getX() {
        return this.pt.getX();
    }

    public byte[] getY() {
        return this.pt.getY();
    }

    public PointParams getPoint() {
        return this.pt;
    }

    public String toString() {
        if (this.pt == null && this.curve == null) {
            return "[ key: 0 params: 0 ]";
        }
        return "[ key: " + this.pt.toString() + " params: " + this.curve.toString() + " ] ";
    }

    public boolean equals(Object object) {
        if (object instanceof ECPublicKeySpec) {
            ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)object;
            return this.pt.equals(eCPublicKeySpec.getPoint()) && this.curve.equals(eCPublicKeySpec.getECParams());
        }
        return false;
    }

    public CryptoCodec codec() {
        if (this.dI == null) {
            this.dI = CryptoCodec.getInstance("ECPublicKey", this.f);
        }
        return this.dI;
    }

    public boolean isZeroized() {
        return this.zeroized;
    }

    public boolean testZeroizationState() {
        return this.zeroized;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.pt = null;
        this.curve = null;
        this.zeroized = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }
}

