/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SystemConfig
extends Hashtable {
    public static final int RAW = 10;
    public static final int ASN1 = 11;
    public static final int UNCOMPRESSED = 4;
    public static final int COMPRESSED = 2;
    public static final int HYBRID = 6;
    public static final int SB = 16;
    public static final int ANSI = 32;
    public static final int EXPAND = 1;
    public static final int HASH = 17;
    public static final int NOHASH = 18;
    public static final String ECDSA = "ECDSA";
    public static final String ECDH = "ECDH";
    public static final String ECMQV = "ECMQV";
    private static final String int = "format";
    private static final String if = "conformance";
    private static final String for = "curve";
    private static final String new = "compression";
    private static final String a = "hash";
    private static SystemConfig do = new SystemConfig();

    private SystemConfig() {
        this.put("format.global", new Integer(11));
        this.put("conformance.global", new Integer(16));
        this.put("compression.global", new Integer(2));
        this.put("hash.global", new Integer(17));
        this.put("curve.global", "sect163k1");
    }

    public static SystemConfig getConfig() {
        return do;
    }

    public static SystemConfig getConfig(InputStream inputStream) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object object = null;
        try {
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        if (!(object instanceof SystemConfig)) {
            throw new IOException("not a system config file.");
        }
        do = (SystemConfig)object;
        return do;
    }

    public void store(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
    }

    public int getFormat() {
        Object v2 = this.get("format.global");
        if (v2 != null) {
            return (Integer)v2;
        }
        throw new IllegalStateException("no global format.");
    }

    public int getPtCompression() {
        Object v2 = this.get("compression.global");
        if (v2 != null) {
            return (Integer)v2;
        }
        throw new IllegalStateException("no global compression.");
    }

    public int getConformance() {
        Object v2 = this.get("conformance.global");
        if (v2 != null) {
            return (Integer)v2;
        }
        throw new IllegalStateException("no global conformance.");
    }

    public int getHashType() {
        Object v2 = this.get("hash.global");
        if (v2 != null) {
            return (Integer)v2;
        }
        throw new IllegalStateException("no global hash-type.");
    }

    public String getCurve() {
        Object v2 = this.get("curve.global");
        if (v2 != null) {
            return new String((String)v2);
        }
        throw new IllegalStateException("no global curve.");
    }

    public int getFormat(String string) {
        Object v2 = this.get(int + string);
        if (v2 != null) {
            return (Integer)v2;
        }
        return this.getFormat();
    }

    public int getPtCompression(String string) {
        Object v2 = this.get(new + string);
        if (v2 != null) {
            return (Integer)v2;
        }
        return this.getPtCompression();
    }

    public int getConformance(String string) {
        Object v2 = this.get(if + string);
        if (v2 != null) {
            return (Integer)v2;
        }
        return this.getConformance();
    }

    public String getCurve(String string) {
        Object v2 = this.get(for + string);
        if (v2 != null) {
            return new String((String)v2);
        }
        return this.getCurve();
    }

    public void setFormat(int n2) {
        switch (n2) {
            case 10: 
            case 11: {
                this.put(int + ".global", new Integer(n2));
                break;
            }
            default: {
                throw new IllegalStateException("format unknown.");
            }
        }
    }

    public void setPtCompression(int n2) {
        switch (n2) {
            case 2: 
            case 4: 
            case 6: {
                this.put("compression.global", new Integer(n2));
                break;
            }
            default: {
                throw new IllegalStateException("compression unknown.");
            }
        }
    }

    public void setConformance(int n2) {
        switch (n2) {
            case 16: 
            case 32: {
                this.put("conformance.global", new Integer(n2));
                break;
            }
            default: {
                throw new IllegalStateException("conformance unknown.");
            }
        }
    }

    public void setHashType(int n2) {
        switch (n2) {
            case 17: 
            case 18: {
                this.put("hash.global", new Integer(n2));
                break;
            }
            default: {
                throw new IllegalStateException("conformance unknown.");
            }
        }
    }

    public void setCurve(String string) {
        if (string == null) {
            throw new IllegalArgumentException("curve is null.");
        }
        this.put("curve.global", new String(string));
    }
}

