/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.sql.ASConnection;
import java.sql.SQLException;
import java.util.Vector;

public class ConnectionPool {
    private Vector _connections = new Vector();
    private DDLGlobalParameters _ddlGlobalParameters;

    public ConnectionPool(DDLGlobalParameters dDLGlobalParameters) {
        this._ddlGlobalParameters = dDLGlobalParameters;
    }

    private void openConnection() {
        try {
            ASConnection aSConnection = new ASConnection(this._ddlGlobalParameters.getUserName(), this._ddlGlobalParameters.getPassword(), 0, null, this._ddlGlobalParameters.getHostName(), new Integer(this._ddlGlobalParameters.getPortNumber()).toString(), this._ddlGlobalParameters.isSSL(), this._ddlGlobalParameters.isEncryptedPassword(), null, this._ddlGlobalParameters.getCharacterSet(), this._ddlGlobalParameters);
            if (aSConnection.getServerVersion().compareTo("11.9.2") < 0) {
                throw new DDLBaseException("CP6", "MSG_SERVER_NOT_SUPPORTED", 1, this._ddlGlobalParameters);
            }
            this._connections.addElement(aSConnection);
        }
        catch (SQLException sQLException) {
            new DDLBaseException("CP1", sQLException, "CONNECTION_ERROR", 2, "'" + this._ddlGlobalParameters.getHostName() + "' at port no. :" + this._ddlGlobalParameters.getPortNumber(), this._ddlGlobalParameters);
        }
        catch (Exception exception) {
            new DDLBaseException("CP2", exception, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
        }
    }

    public synchronized ASConnection getConnection() throws DDLBaseException {
        if (this._connections.size() < DDLGlobalParameters.getMaxConnections()) {
            this.openConnection();
        } else if (!this._ddlGlobalParameters.isPersistent()) {
            new DDLBaseException("CP3", "MAX_CONNECTION_REACHED_ERROR", 2, this._ddlGlobalParameters);
        }
        return (ASConnection)this._connections.lastElement();
    }

    public void clean() {
        for (int i = 0; i < this._connections.size(); ++i) {
            try {
                ((ASConnection)this._connections.elementAt(i)).close();
                this._connections.setElementAt(null, i);
                continue;
            }
            catch (SQLException sQLException) {
                new DDLBaseException("CP4", (Exception)sQLException, "CONNECTION_FAILED_ERROR", 2, this._ddlGlobalParameters);
                continue;
            }
            catch (Exception exception) {
                new DDLBaseException("CP5", exception, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
            }
        }
        if (this._connections != null) {
            this._connections.removeAllElements();
            this._connections = null;
        }
    }
}

