/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen;

import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.DDLThread;
import com.sybase.ddlgen.io.DDLFileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class DDLBaseException
extends Exception {
    private String _externalErrMsg;
    private String _exceptionErrMsg;
    private String _name;
    private int _type;
    private boolean _printFlag = true;
    private DDLGlobalParameters _ddlGlobalParameters;
    private String _errorCode;
    private String _error;

    public DDLBaseException(String string, String string2, int n, String string3) {
        this.setDDLGlobalParameters();
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this._externalErrMsg = string2;
        this._name = string3;
        this._type = n;
        this._errorCode = string;
        this.assignException(n);
    }

    public DDLBaseException(String string, String string2, String string3, int n, DDLGlobalParameters dDLGlobalParameters) {
        this._ddlGlobalParameters = dDLGlobalParameters;
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this._externalErrMsg = string2;
        this._errorCode = string;
        this._name = string3;
        this._type = n;
        this.assignException(n);
    }

    public DDLBaseException(String string, String string2, int n) {
        this.setDDLGlobalParameters();
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this._externalErrMsg = string2;
        this._errorCode = string;
        this._type = n;
        this.assignException(n);
    }

    public DDLBaseException(String string, String string2, String string3, boolean bl, int n, DDLGlobalParameters dDLGlobalParameters) {
        super(string3);
        this._errorCode = string;
        this._ddlGlobalParameters = dDLGlobalParameters;
        this._externalErrMsg = string2;
        this._exceptionErrMsg = string3;
        this._type = n;
        this._printFlag = bl;
        this.assignException(n);
    }

    public DDLBaseException(String string, String string2, int n, DDLGlobalParameters dDLGlobalParameters) {
        this._errorCode = string;
        this._ddlGlobalParameters = dDLGlobalParameters;
        this._externalErrMsg = string2;
        this._type = n;
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this.assignException(n);
    }

    public DDLBaseException(String string, Exception exception, String string2, int n) {
        super(exception.toString());
        this.setDDLGlobalParameters();
        this._externalErrMsg = string2;
        this._type = n;
        this._errorCode = string;
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this.assignException(n);
    }

    public DDLBaseException(String string, Exception exception, String string2, int n, DDLGlobalParameters dDLGlobalParameters) {
        super(exception.toString());
        this._ddlGlobalParameters = dDLGlobalParameters;
        this._externalErrMsg = string2;
        this._type = n;
        this._errorCode = string;
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this.assignException(n);
    }

    public DDLBaseException(String string, Exception exception, String string2, int n, String string3, DDLGlobalParameters dDLGlobalParameters) {
        super(exception.toString());
        this._ddlGlobalParameters = dDLGlobalParameters;
        this._externalErrMsg = string2;
        this._type = n;
        this._name = string3;
        this._errorCode = string;
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this.assignException(n);
    }

    public DDLBaseException(String string, Exception exception, String string2, int n, String string3) {
        super(exception.toString());
        this.setDDLGlobalParameters();
        this._externalErrMsg = string2;
        this._type = n;
        this._errorCode = string;
        this._name = string3;
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this.assignException(n);
    }

    public DDLBaseException(String string, Exception exception, int n) {
        super(exception.toString());
        this.setDDLGlobalParameters();
        this._type = n;
        this._errorCode = string;
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this.assignException(n);
    }

    public DDLBaseException(String string, Exception exception, int n, DDLGlobalParameters dDLGlobalParameters) {
        super(exception.toString());
        this._ddlGlobalParameters = dDLGlobalParameters;
        this._type = n;
        this._errorCode = string;
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this.assignException(n);
    }

    public DDLBaseException(String string, Exception exception, int n, String string2) {
        super(exception.toString());
        this.setDDLGlobalParameters();
        this._type = n;
        this._errorCode = string;
        this._name = string2;
        if (this._ddlGlobalParameters.getApplicationMode()) {
            this._printFlag = false;
        }
        this.assignException(n);
    }

    private void setDDLGlobalParameters() {
        if (Thread.currentThread() instanceof DDLThread) {
            try {
                this._ddlGlobalParameters = ((DDLThread)Thread.currentThread()).getParent().getDDLGlobalParameters();
            }
            catch (Exception exception) {
                new DDLBaseException("DBE1", exception, "INTERNAL_ERROR", 1, this._ddlGlobalParameters);
            }
        }
    }

    private void assignException(int n) {
        if (this._externalErrMsg != null) {
            this._error = this.getErrorMessage(this._externalErrMsg);
            this._ddlGlobalParameters.setDDLErrorCode(this._externalErrMsg);
        } else {
            this._error = super.getMessage();
        }
        if (this._name != null) {
            this._error = this._error + ": " + this._name;
        }
        if (n != 4) {
            this._ddlGlobalParameters.setDDLErrorString(this._error);
            this._ddlGlobalParameters.setException(this);
        }
        if (this._errorCode != null) {
            this._error = this._errorCode + ": " + this._error;
        }
        switch (n) {
            case 0: {
                StringBuffer stringBuffer = new StringBuffer("\nUsage: ddlgen [Option1][Option2][Option3].... where options are.. \n");
                stringBuffer.append("_____________________________________________________________________________\n\n").append("Option   Parameter             Required   Default        Description         \n").append("_____________________________________________________________________________\n\n").append("  -U     <user name>             Yes      NA             User Name           \n\n").append("  -P     <password>              Yes      NA             Password for Server \n\n").append("  -S     <Server Name |          Yes      NA             Server Name OR      \n").append("          [ssl]:hostName:port >                          [ssl]:<hostName>:<port>\n").append("  -T     <object type>            No      DB             Type of the object  \n").append("                                                         Refer Docs for this \n\n").append("  -N     <object name>            No      Default DB     Object Name         \n\n").append("  -D     <database name>          No      Default DB     Database in which   \n").append("                                          for the login  the object specified\n").append("                                                         in -N option exist  \n\n").append("  -X     <extended object type>   No      NA             Used in conjunction \n").append("                                                         with some -T option \n").append("                                                         Refer Docs for this \n\n").append("  -F     <filter object type>     No      None           Used in conjunction \n").append("                                                         with some -T option \n").append("                                                         Refer Docs for this \n\n").append("  -J     <client charset name>    No      Server's       Character set used  \n").append("                                          character set  by the ddlgen client\n\n").append("  -I     <interfaces file name>   No      Default        Interfaces File to  \n").append("                                                         be used for decoding\n").append("                                                         the Server's Host   \n").append("                                                         Name and Port Number\n\n").append("  -O     <output file name>       No      stdout         File to be used for \n").append("                                                         writing the         \n").append("                                                         DDL Output          \n\n").append("  -E     <error file name>        No      stdout         File to be used for \n").append("                                                         logging the errors  \n\n").append("  -L     <progress log file name> No      No Logging     File to be used for \n").append("                                                         logging the progress\n\n").append("  -V     <version no.>            No      NA             Prints the Version  \n").append("                                                         of the DDLGenerator \n\n").append("_____________________________________________________________________________\n");
                this.handleError(this._error + "\n" + stringBuffer.toString());
                break;
            }
            case 1: {
                this.handleError(this._error);
                break;
            }
            case 2: {
                this.handleError(this._error);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                System.out.println("-- " + this._error + "\n");
                break;
            }
        }
    }

    public String getErrorMessage(String string) {
        return this._ddlGlobalParameters.getLocalisedMessage(string);
    }

    private void handleError(String string) {
        DDLFileWriter dDLFileWriter = this._ddlGlobalParameters.getErrorWriter();
        if (dDLFileWriter == null) {
            if (this._printFlag) {
                System.err.println(string);
            }
        } else {
            try {
                PrintWriter printWriter = new PrintWriter((Writer)dDLFileWriter, true);
                if (this._type != 0) {
                    this.printStackTrace(printWriter);
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                new DDLBaseException("DBE2", exception, "FILE_WRITING_ERROR", 4, this._ddlGlobalParameters);
                System.err.println(string);
            }
        }
        this._ddlGlobalParameters.setDDLStatus((byte)2);
        if (!this._ddlGlobalParameters.getApplicationMode()) {
            this.closeFileWriters();
            System.exit(0);
        }
    }

    public String getName() {
        return this._name;
    }

    public int getType() {
        return this._type;
    }

    public String getError() {
        return this._error;
    }

    public void closeFileWriters() {
        String string = this.getErrorMessage("REFER_ERROR_CONSOLE");
        DDLFileWriter dDLFileWriter = this._ddlGlobalParameters.getErrorWriter();
        if (dDLFileWriter != null) {
            string = this.getErrorMessage("REFER_ERROR_FILE") + this._ddlGlobalParameters.getErrorLogFileName();
        }
        if ((dDLFileWriter = this._ddlGlobalParameters.getOutputWriter()) != null) {
            try {
                dDLFileWriter.writeLine(string);
                dDLFileWriter.close();
            }
            catch (IOException iOException) {
                new DDLBaseException("DBE3", iOException, "FILE_CLOSING_ERROR", 4, this._ddlGlobalParameters.getOutputFileName(), this._ddlGlobalParameters);
            }
        }
        if ((dDLFileWriter = this._ddlGlobalParameters.getProgressLogWriter()) != null) {
            try {
                dDLFileWriter.writeLine(string);
                dDLFileWriter.close();
            }
            catch (IOException iOException) {
                new DDLBaseException("DBE4", iOException, "FILE_CLOSING_ERROR", 4, this._ddlGlobalParameters.getOutputFileName(), this._ddlGlobalParameters);
            }
        }
        if ((dDLFileWriter = this._ddlGlobalParameters.getDebugWriter()) != null) {
            try {
                dDLFileWriter.writeLine(string);
                dDLFileWriter.close();
            }
            catch (IOException iOException) {
                new DDLBaseException("DBE5", iOException, "FILE_CLOSING_ERROR", 4, this._ddlGlobalParameters.getOutputFileName(), this._ddlGlobalParameters);
            }
        }
    }

    @Override
    public String getMessage() {
        return this.getError();
    }

    @Override
    public String toString() {
        return this.getError();
    }
}

