/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.io.DDLFileWriter;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.LibctlDriver;
import com.sybase.util.ds.ldap.SyASEServer;
import com.sybase.util.ds.ldap.SyLDAPServer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class DDLGlobalParameters {
    private int _iVersion;
    private String _charSet;
    private int _iPortNumber;
    private boolean _isSSL;
    private byte _status = 0;
    private String _sComments;
    private String _sPassword;
    private String _sUserName;
    private String _sHostName;
    private String _sObjectName;
    private boolean _bencryptedPassword = false;
    private char _cParameterType;
    private String _sDatabaseName;
    private ArrayList _alFilters = new ArrayList();
    private String _sOutputFileName;
    private boolean _blnUseDBInUse = false;
    public static final byte DDL_ERROR = 2;
    private String _sObjectType = "DB";
    private String _ddlString = null;
    private String _sErrorLogFileName;
    private String _sProgressLogFileName;
    private String _sDebugLogFileName;
    private static int _iMAX_CONNECTIONS = 1;
    public static final byte DDL_COMPLETE = 1;
    private ArrayList _alExtendedObjectTypes = new ArrayList();
    private String _sInterfacesFileName;
    public static final byte DDL_INPROGRESS = 0;
    public static final boolean EXTERNAL = true;
    private String _ddlErrorString = null;
    public static final boolean STAND_ALONE = false;
    private static boolean _applicationMode = true;
    private static String _ddlErrorCode = "INTERNAL_ERROR";
    private static Hashtable _dbObjectClassNames = new Hashtable(30);
    private DDLBaseException _ddlBaseException;
    private long _debugWaitStartTime = new Date().getTime();
    public static ResourceBundle _res;
    public String _sName;
    private DDLFileWriter _errorFileWriter;
    private DDLFileWriter _outputFileWriter;
    private DDLFileWriter _progressLogFileWriter;
    private DDLFileWriter _debugLogFileWriter;
    private boolean _isPersistent = false;
    private ArrayList _alConnProps = new ArrayList();

    public String getObjectClassName(String string) {
        return _dbObjectClassNames.get(string).toString();
    }

    public void setParameterType(char c) {
        this._cParameterType = c;
    }

    public char getParameterType() {
        return this._cParameterType;
    }

    public String getObjectType() {
        return this._sObjectType;
    }

    public void setObjectType(String string) {
        if (_dbObjectClassNames.containsKey(string)) {
            this._sObjectType = string;
        } else {
            new DDLBaseException("DGP1", "INVALID_OBJECTTYPE_ERROR", string, 1, this);
        }
        if (this._alExtendedObjectTypes.size() > 0) {
            String string2 = "";
            if (this._sObjectType.equals("DB")) {
                string2 = this.warnUsageOfInvalidDatabaseExtendedType(string2);
            } else if (this._sObjectType.equals("U")) {
                string2 = this.warnUsageOfInvalidTableExtendedType(string2);
            } else if (this._sObjectType.equals("I")) {
                string2 = this.warnUsageOfInvalidIndexExtendedType(string2);
            } else if (this._sObjectType.equals("P")) {
                string2 = this.warnUsageOfInvalidStoreProcedureExtendedType(string2);
            } else if (this._sObjectType.equals("F")) {
                string2 = this.warnUsageOfInvalidFunctionExtendedType(string2);
            } else if (this._sObjectType.equals("DBD")) {
                string2 = this.warnUsageOfInvalidDatabaseDeviceExtendedType(string2);
            } else if (this._sObjectType.equals("C")) {
                string2 = this.warnUsageOfInvalidCacheExtendedType(string2);
            } else if (this._sObjectType.equals("EK")) {
                string2 = this.warnUsageOfInvalidEncryptedKeyExtendedType(string2);
            }
            if (!string2.equals("")) {
                string2 = string2.substring(0, string2.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    this._alExtendedObjectTypes.remove(string3);
                }
                new DDLBaseException("DGP2", "INVALID_EXTENDEDOBJECTTYPE_ERROR", string2, 4, this);
            }
        }
    }

    public ArrayList getExtendedObjectTypes() {
        return this._alExtendedObjectTypes;
    }

    public void resetExtendedObjectTypes() {
        this._alExtendedObjectTypes.clear();
    }

    public void setExtendedObjectTypes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        this.resetExtendedObjectTypes();
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if ((string2.equals("OD") || string2.equals("OU") || string2.equals("OA") || string2.equals("OI") || string2.equals("OIT") || string2.equals("PN")) && (this._sObjectType == null || this._sObjectType.equals("U") || this._sObjectType.equals("P") || this._sObjectType.equals("DB") || this._sObjectType.equals("DBD") || this._sObjectType.equals("C") || this._sObjectType.equals("EK") || this._sObjectType.equals("F") || this._sObjectType.equals("I"))) {
                this._alExtendedObjectTypes.add(string2);
                continue;
            }
            string3 = string3 + string2 + ",";
        }
        if (this._sObjectType != null) {
            if (this._sObjectType.equals("DB")) {
                string3 = this.warnUsageOfInvalidDatabaseExtendedType(string3);
            } else if (this._sObjectType.equals("U")) {
                string3 = this.warnUsageOfInvalidTableExtendedType(string3);
            } else if (this._sObjectType.equals("I")) {
                string3 = this.warnUsageOfInvalidIndexExtendedType(string3);
            } else if (this._sObjectType.equals("P")) {
                string3 = this.warnUsageOfInvalidStoreProcedureExtendedType(string3);
            } else if (this._sObjectType.equals("F")) {
                string3 = this.warnUsageOfInvalidFunctionExtendedType(string3);
            } else if (this._sObjectType.equals("DBD")) {
                string3 = this.warnUsageOfInvalidDatabaseDeviceExtendedType(string3);
            } else if (this._sObjectType.equals("C")) {
                string3 = this.warnUsageOfInvalidCacheExtendedType(string3);
            } else if (this._sObjectType.equals("EK")) {
                string3 = this.warnUsageOfInvalidEncryptedKeyExtendedType(string3);
            }
        }
        if (!string3.equals("")) {
            string3 = string3.substring(0, string3.length() - 1);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
            String string4 = "";
            while (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
                this._alExtendedObjectTypes.remove(string4);
            }
            new DDLBaseException("DGP3", "INVALID_EXTENDEDOBJECTTYPE_ERROR", string3, 4, this);
        }
    }

    private String warnUsageOfInvalidDatabaseExtendedType(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alExtendedObjectTypes.size(); ++i) {
            string3 = (String)this._alExtendedObjectTypes.get(i);
            if (string3.equals("OD") || string3.equals("OU") || string3.equals("OA") || string3.equals("OI") || string3.equals("OIT") || string3.equals("PN")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    private String warnUsageOfInvalidTableExtendedType(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alExtendedObjectTypes.size(); ++i) {
            string3 = (String)this._alExtendedObjectTypes.get(i);
            if (string3.equals("OD") || string3.equals("OU") || string3.equals("PN")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    private String warnUsageOfInvalidIndexExtendedType(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alExtendedObjectTypes.size(); ++i) {
            string3 = (String)this._alExtendedObjectTypes.get(i);
            if (string3.equals("PN")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    private String warnUsageOfInvalidStoreProcedureExtendedType(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alExtendedObjectTypes.size(); ++i) {
            string3 = (String)this._alExtendedObjectTypes.get(i);
            if (string3.equals("OD") || string3.equals("OU")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    private String warnUsageOfInvalidFunctionExtendedType(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alExtendedObjectTypes.size(); ++i) {
            string3 = (String)this._alExtendedObjectTypes.get(i);
            if (string3.equals("OD") || string3.equals("OU")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    private String warnUsageOfInvalidDatabaseDeviceExtendedType(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alExtendedObjectTypes.size(); ++i) {
            string3 = (String)this._alExtendedObjectTypes.get(i);
            if (string3.equals("OD") || string3.equals("OU") || string3.equals("OI")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    private String warnUsageOfInvalidCacheExtendedType(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alExtendedObjectTypes.size(); ++i) {
            string3 = (String)this._alExtendedObjectTypes.get(i);
            if (string3.equals("OI") || string3.equals("OU") || string3.equals("OD")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    private String warnUsageOfInvalidEncryptedKeyExtendedType(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alExtendedObjectTypes.size(); ++i) {
            string3 = (String)this._alExtendedObjectTypes.get(i);
            if (string3.equals("OD")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    public String getComments() {
        return this._sComments;
    }

    public void setComments(String string) {
        this._sComments = string;
    }

    public String getPassword() {
        return this._sPassword;
    }

    public void setPassword(String string) {
        this._sPassword = string;
    }

    public String getDatabaseName() {
        return this._sDatabaseName;
    }

    public void setDatabaseName(String string) {
        this._sDatabaseName = string;
    }

    public boolean getIsUseDBAlreadyInUse() {
        return this._blnUseDBInUse;
    }

    public void setIsUseDBAlreadyUsed(boolean bl) {
        this._blnUseDBInUse = bl;
    }

    public String getUserName() {
        return this._sUserName;
    }

    public void setUserName(String string) {
        this._sUserName = string;
    }

    public String getObjectName() {
        if (!this._sObjectType.equals("DB")) {
            if (this._sObjectName == null) {
                new DDLBaseException("DGP4", "OBJECTNAME_UNSPECIFIED", 1, this);
            }
        } else if (this._sObjectName == null) {
            return this._sDatabaseName;
        }
        return this._sObjectName;
    }

    public void setObjectName(String string) {
        this._sObjectName = string;
    }

    public String getHostName() {
        return this._sHostName;
    }

    public void setHostName(String string) {
        this._sHostName = string;
    }

    public ArrayList getConnProps() {
        return this._alConnProps;
    }

    public void resetConnProps() {
        this._alConnProps.clear();
    }

    public void setConnectionProperties(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        this.resetConnProps();
        String string3 = "";
        String string4 = null;
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
            int n = stringTokenizer2.countTokens();
            if (n != 2) {
                string3 = string3 + string2 + ",";
                continue;
            }
            string4 = stringTokenizer2.nextToken();
            string5 = stringTokenizer2.nextToken();
            if ((string4.equals("ENCRYPT_PASSWORD") || string4.toUpperCase().equals("ENCRYPT_PASSWORD")) && (string5.toLowerCase().equals("true") || string5.toLowerCase().equals("false"))) {
                this._alConnProps.add(string2);
                if (!string5.toLowerCase().equals("true")) continue;
                this.setEncryptedPassword();
                continue;
            }
            string3 = string3 + string2 + ",";
        }
        if (!string3.equals("")) {
            string3 = string3.substring(0, string3.length() - 1);
            new DDLBaseException("DGP13", "INVALID_CONNECTION_PROPERTIES", string3, 4, this);
        }
    }

    public void setEncryptedPassword() {
        this._bencryptedPassword = true;
    }

    public boolean isEncryptedPassword() {
        return this._bencryptedPassword;
    }

    public static int getMaxConnections() {
        return _iMAX_CONNECTIONS;
    }

    public void setMaxConnections(int n) {
        _iMAX_CONNECTIONS = n;
    }

    public String getOutputFileName() {
        return this._sOutputFileName;
    }

    public void setOutputFileName(String string) {
        this._sOutputFileName = string;
    }

    public String getErrorLogFileName() {
        return this._sErrorLogFileName;
    }

    public void setErrorLogFileName(String string) {
        this._sErrorLogFileName = string;
    }

    public String getProgressLogFileName() {
        return this._sProgressLogFileName;
    }

    public void setProgressLogFileName(String string) {
        this._sProgressLogFileName = string;
    }

    public String getDebugLogFileName() {
        return this._sDebugLogFileName;
    }

    public void setDebugLogFileName(String string) {
        this._sDebugLogFileName = string;
    }

    public String getInterfacesFileName() {
        return this._sInterfacesFileName;
    }

    public void setInterfacesFileName(String string) {
        this._sInterfacesFileName = string;
    }

    public int getPortNumber() {
        return this._iPortNumber;
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    public void setSSL(boolean bl) {
        this._isSSL = bl;
    }

    public void setPortNumber(int n) {
        this._iPortNumber = n;
    }

    public void setDDLString(String string) {
        this._ddlString = string;
    }

    public String getDDLErrorString() {
        return this._ddlErrorString;
    }

    public void setDDLErrorString(String string) {
        this._ddlErrorString = string;
    }

    public String getDDLErrorCode() {
        return _ddlErrorCode;
    }

    public void setDDLErrorCode(String string) {
        _ddlErrorCode = string;
    }

    public String getDDLString() {
        return this._ddlString;
    }

    public void setDDLStatus(byte by) {
        this._status = by;
    }

    public byte getDDLStatus() {
        return this._status;
    }

    public void setApplicationMode(boolean bl) {
        _applicationMode = bl;
    }

    public boolean getApplicationMode() {
        return _applicationMode;
    }

    public void setServerName(String string) {
        this._sName = string;
    }

    public String getServerName() {
        return this._sName;
    }

    public void setErrorWriter(DDLFileWriter dDLFileWriter) {
        this._errorFileWriter = dDLFileWriter;
    }

    public void setOutputWriter(DDLFileWriter dDLFileWriter) {
        this._outputFileWriter = dDLFileWriter;
    }

    public DDLFileWriter getErrorWriter() {
        return this._errorFileWriter;
    }

    public void setPersistence(boolean bl) {
        this._isPersistent = bl;
    }

    public boolean isPersistent() {
        return this._isPersistent;
    }

    public void setProgressLogWriter(DDLFileWriter dDLFileWriter) {
        this._progressLogFileWriter = dDLFileWriter;
    }

    public DDLFileWriter getProgressLogWriter() {
        return this._progressLogFileWriter;
    }

    public void setDebugLogWriter(DDLFileWriter dDLFileWriter) {
        this._debugLogFileWriter = dDLFileWriter;
    }

    public DDLFileWriter getDebugWriter() {
        return this._debugLogFileWriter;
    }

    public DDLFileWriter getOutputWriter() {
        return this._outputFileWriter;
    }

    public void setCharacterSet(String string) {
        this._charSet = string;
    }

    public String getCharacterSet() {
        return this._charSet;
    }

    public boolean getHostNamePortNumber() {
        if (this._sHostName != null && this._iPortNumber != 0) {
            return true;
        }
        if (this._sName == null) {
            return false;
        }
        try {
            SyInterfacesDriver syInterfacesDriver = null;
            if (this._sInterfacesFileName == null) {
                boolean bl = false;
                if (System.getProperty("interfaces.file") == null) {
                    LibctlDriver libctlDriver = null;
                    try {
                        libctlDriver = new LibctlDriver();
                    }
                    catch (Exception exception) {
                        new DDLBaseException("DGP5", exception, 4, this);
                        bl = true;
                    }
                    Vector vector = null;
                    int n = 0;
                    if (libctlDriver != null) {
                        vector = libctlDriver.getLDAPServers();
                        n = vector.size();
                    }
                    if (!bl && n > 0) {
                        for (int i = 0; i < n; ++i) {
                            SyLDAPServer syLDAPServer = (SyLDAPServer)vector.elementAt(i);
                            try {
                                syLDAPServer.connectLDAP();
                                syLDAPServer.initASEEntries();
                                Vector vector2 = syLDAPServer.getASEServers();
                                if (vector2 == null) continue;
                                for (int j = 0; j < vector2.size(); ++j) {
                                    SyASEServer syASEServer = (SyASEServer)vector2.elementAt(j);
                                    if (!syASEServer.getServerName().equals(this._sName)) continue;
                                    this._sHostName = syASEServer.getHost();
                                    this._iPortNumber = new Integer(syASEServer.getPort());
                                    return true;
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        new DDLBaseException("DGP6", "REQUESTED_SERVER_NOT_FOUND", this._sName, 1, this);
                        return false;
                    }
                    syInterfacesDriver = new SyInterfacesDriver();
                    syInterfacesDriver.open();
                } else {
                    syInterfacesDriver = new SyInterfacesDriver();
                    syInterfacesDriver.open();
                }
            } else {
                syInterfacesDriver = new SyInterfacesDriver(this._sInterfacesFileName);
            }
            SyInterfacesEntry syInterfacesEntry = syInterfacesDriver.getEntry(this._sName);
            if (syInterfacesEntry != null) {
                this._sHostName = syInterfacesEntry.getHost();
                this._iPortNumber = new Integer(syInterfacesEntry.getPort());
                this._isSSL = syInterfacesEntry.isSSL();
            } else {
                new DDLBaseException("DGP7", "REQUESTED_SERVER_NOT_FOUND", this._sName, 1, this);
            }
        }
        catch (InterfacesException interfacesException) {
            new DDLBaseException("DGP8", (Exception)((Object)interfacesException), "INTERFACE_DRIVER_ERROR", 1, this._sName, this);
            return false;
        }
        catch (Exception exception) {
            new DDLBaseException("DGP9", exception, "REQUESTED_SERVER_NOT_FOUND", 1, this._sName, this);
            return false;
        }
        return true;
    }

    public ArrayList getFilters() {
        return this._alFilters;
    }

    public void resetFilters() {
        this._alFilters.clear();
    }

    public void setFilters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        this.resetFilters();
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("%")) {
                this._alFilters.clear();
                this._alFilters.add("%");
                break;
            }
            if (_dbObjectClassNames.containsKey(string2) || string2.equals("PC") || string2.equals("IE") || string2.equals("EKC") || string2.equals("SEP")) {
                this._alFilters.add(string2);
                continue;
            }
            string3 = string3 + string2 + ",";
        }
        if (this._sObjectType.equals("DB")) {
            string3 = this.warnUsageOfInvalidDatabaseFilters(string3);
        } else if (this._sObjectType.equals("U")) {
            string3 = this.warnUsageOfInvalidTableFilters(string3);
        } else if (this._sObjectType.equals("I")) {
            string3 = this.warnUsageOfInvalidIndexFilters(string3);
        } else {
            for (int i = 0; i < this._alFilters.size(); ++i) {
                String string4 = (String)this._alFilters.get(i);
                if (string4.equals("IE") || string4.equals("%") || string4.equals("EKC") || string4.equals("SEP")) continue;
                string3 = string3 + (String)this._alFilters.get(i) + ",";
            }
        }
        if (!string3.equals("")) {
            string3 = string3.substring(0, string3.length() - 1);
            new DDLBaseException("DGP10", "INVALID_FILTER_WARNING", string3, 4, this);
        }
    }

    private String warnUsageOfInvalidDatabaseFilters(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alFilters.size(); ++i) {
            string3 = (String)this._alFilters.get(i);
            if (string3.equals("SGM") || string3.equals("GRP") || string3.equals("USR") || string3.equals("R") || string3.equals("D") || string3.equals("UDD") || string3.equals("U") || string3.equals("V") || string3.equals("P") || string3.equals("XP") || string3.equals("EK") || string3.equals("KC") || string3.equals("RI") || string3.equals("I") || string3.equals("TR") || string3.equals("PC") || string3.equals("LK") || string3.equals("IE") || string3.equals("%")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    private String warnUsageOfInvalidTableFilters(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alFilters.size(); ++i) {
            string3 = (String)this._alFilters.get(i);
            if (string3.equals("KC") || string3.equals("RI") || string3.equals("I") || string3.equals("TR") || string3.equals("PC") || string3.equals("LK") || string3.equals("IE") || string3.equals("%")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    private String warnUsageOfInvalidIndexFilters(String string) {
        String string2 = string;
        String string3 = "";
        for (int i = 0; i < this._alFilters.size(); ++i) {
            string3 = (String)this._alFilters.get(i);
            if (string3.equals("PC") || string3.equals("%") || string3.equals("IE")) continue;
            string2 = string2 + string3 + ",";
        }
        return string2;
    }

    protected void setException(DDLBaseException dDLBaseException) {
        this._ddlBaseException = dDLBaseException;
    }

    protected DDLBaseException getException() {
        return this._ddlBaseException;
    }

    public String getLocalisedMessage(String string) {
        if (_res == null) {
            try {
                _res = ResourceBundle.getBundle("com.sybase.ddlgen.res.ErrorResourceBundle", Locale.getDefault());
            }
            catch (NullPointerException nullPointerException) {
                _res = null;
            }
            catch (MissingResourceException missingResourceException) {
                _res = null;
            }
            catch (Exception exception) {
                new DDLBaseException("DGP11", exception, "INTERNAL_ERROR", 1, this);
            }
            if (_res == null) {
                try {
                    _res = (ListResourceBundle)Class.forName("com.sybase.ddlgen.lang.en.ErrorResourceBundle").newInstance();
                }
                catch (Exception exception) {
                    new DDLBaseException("DGP12", exception, "INTERNAL_ERROR", 1, this);
                }
            }
        }
        return _res.getString(string);
    }

    public void writeDebugInfo(long l, long l2, String string) {
        String string2 = ",";
        if (this._debugLogFileWriter != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into debug values(").append(l - this._debugWaitStartTime).append(string2).append("'").append(string).append("'").append(string2).append(l2 - l).append(")\ngo\n");
            this._debugLogFileWriter.writeLine(stringBuffer.toString());
            this._debugWaitStartTime = l2;
        }
    }

    public boolean excludeIfExistsDDL() {
        return this.getFilters() != null && (this.getFilters().contains("IE") || this.getFilters().contains("%"));
    }

    static {
        _dbObjectClassNames.put("L", "Login");
        _dbObjectClassNames.put("TP", "ThreadPool");
        _dbObjectClassNames.put("LDP", "LoadProfile");
        _dbObjectClassNames.put("TDBG", "TemporaryDatabaseGroup");
        _dbObjectClassNames.put("LP", "LoginProfile");
        _dbObjectClassNames.put("I", "Index");
        _dbObjectClassNames.put("USR", "User");
        _dbObjectClassNames.put("RO", "Role");
        _dbObjectClassNames.put("C", "Cache");
        _dbObjectClassNames.put("GRP", "Group");
        _dbObjectClassNames.put("SVR", "Server");
        _dbObjectClassNames.put("DB", "DatabaseMeta");
        _dbObjectClassNames.put("U", "UserTableMeta");
        _dbObjectClassNames.put("RI", "ReferentialIntegrity");
        _dbObjectClassNames.put("KC", "KeyConstraint");
        _dbObjectClassNames.put("SGM", "Segment");
        _dbObjectClassNames.put("DPD", "DumpDevice");
        _dbObjectClassNames.put("EG", "EngineGroup");
        _dbObjectClassNames.put("RS", "RemoteServer");
        _dbObjectClassNames.put("DBD", "DatabaseDevice");
        _dbObjectClassNames.put("EC", "ExecutionClass");
        _dbObjectClassNames.put("UDD", "UserDefinedDatatype");
        _dbObjectClassNames.put("WSC", "WebServicesConsumer");
        _dbObjectClassNames.put("WS", "CompiledObject");
        _dbObjectClassNames.put("LK", "LogicalKey");
        _dbObjectClassNames.put("EK", "EncryptedKey");
        _dbObjectClassNames.put("LC", "LogicalCluster");
        _dbObjectClassNames.put("TR", "CompiledObject");
        _dbObjectClassNames.put("D", "CompiledObject");
        _dbObjectClassNames.put("P", "CompiledObject");
        _dbObjectClassNames.put("XP", "CompiledObject");
        _dbObjectClassNames.put("V", "CompiledObject");
        _dbObjectClassNames.put("R", "CompiledObject");
        _dbObjectClassNames.put("F", "CompiledObject");
    }
}

