/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.ThreadPool;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;

public class DDLThread
extends Thread {
    private ThreadPool _threadPoolRef;
    private ASConnection _con;
    private DDLBaseContainer _container;
    private DDLBaseItem _item;
    private Object obj = new Object();

    public DDLThread(ThreadPool threadPool) {
        this._threadPoolRef = threadPool;
        try {
            this._con = threadPool.getConnectionPool().getConnection();
        }
        catch (DDLBaseException dDLBaseException) {
            new DDLBaseException("DT1", (Exception)dDLBaseException, "CONNECTION_FAILED_ERROR", 2, threadPool.getDDLGlobalParameters());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(DDLBaseContainer dDLBaseContainer) {
        this._container = dDLBaseContainer;
        Object object = this.obj;
        synchronized (object) {
            this.obj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(DDLBaseItem dDLBaseItem) {
        this._item = dDLBaseItem;
        Object object = this.obj;
        synchronized (object) {
            this.obj.notifyAll();
        }
    }

    @Override
    public void run() {
        while (this._threadPoolRef.getStatus()) {
            if (this._container != null) {
                this._container.open(this._con);
                this._container = null;
                this._threadPoolRef.depositFreeThread(this);
            }
            if (this._item != null) {
                try {
                    this._item.open(this._con);
                }
                catch (DDLBaseException dDLBaseException) {
                    new DDLBaseException("DT2", (Exception)dDLBaseException, "INTERNAL_ERROR", 1, this._threadPoolRef.getDDLGlobalParameters());
                }
                this._item = null;
                this._threadPoolRef.depositFreeThread(this);
            }
            this.waitForContainerItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForContainerItem() {
        Object object = this.obj;
        synchronized (object) {
            try {
                while (this._container == null && this._item == null && this._threadPoolRef.getStatus()) {
                    this.obj.wait();
                }
            }
            catch (Exception exception) {
                new DDLBaseException("DT3", exception, "INTERNAL_ERROR", 1, this._threadPoolRef.getDDLGlobalParameters());
            }
        }
    }

    public ASConnection getConnection() {
        return this._con;
    }

    protected ThreadPool getParent() {
        return this._threadPoolRef;
    }
}

