/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.container;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.DDLThread;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.container.UserTableContainer;
import com.sybase.ddlgen.item.CompiledObjectItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import com.sybase.ddlgen.util.Utility;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class CompiledObjectContainer
extends DDLBaseContainer {
    private final int DB = 0;
    private final int OWNER = 1;
    private final int COMPILEDOBJECT = 2;
    private String _webServiceAliases = "";
    private boolean _isForTriggers;
    private String _triggerName = "%";

    public CompiledObjectContainer(DDLBaseContainer dDLBaseContainer, DDLGlobalParameters dDLGlobalParameters) {
        this();
        this._parent = dDLBaseContainer;
        this.setDDLGlobalParameters(dDLGlobalParameters);
    }

    public CompiledObjectContainer() {
    }

    @Override
    public void open(ASConnection aSConnection) {
        String string = this._ddlGlobalParameters.getObjectName();
        Vector vector = null;
        if (this._parent == null) {
            StringTokenizer stringTokenizer;
            if (this._type.equals("TR") && (stringTokenizer = new StringTokenizer(string, ".")).countTokens() == 4) {
                this._triggerName = string.substring(string.lastIndexOf(46) + 1, string.length());
                string = string.substring(0, string.lastIndexOf(46));
                this._isForTriggers = true;
            }
            vector = this.parseCompiledObjectName(string, aSConnection);
        } else {
            try {
                if (this._type.equals("TR")) {
                    this._isForTriggers = true;
                    vector = this.parseCompiledObjectName(this._parent._name.substring(0, this._parent._name.indexOf(46)) + ".%.%", aSConnection);
                } else {
                    vector = this.parseCompiledObjectName(this._parent._name + ".%.%", aSConnection);
                }
            }
            catch (Exception exception) {
                new DDLBaseException("CO1", "INVALID_OBJECTNAME_ERROR", 2);
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = (String[])vector.elementAt(i);
            CompiledObjectItem compiledObjectItem = new CompiledObjectItem(stringArray, this);
            DDLThread dDLThread = this._threadPool.getFreeThread();
            if (dDLThread != null) {
                dDLThread.setItem(compiledObjectItem);
            } else {
                compiledObjectItem.open(aSConnection);
            }
            this._children.addElement(compiledObjectItem);
        }
        if (this._children.size() > 0) {
            if (!this._webServiceAliases.equals("")) {
                this._ddlString = this._webServiceAliases;
            }
            this.generateDDLs();
        } else if (this._children.size() == 0 && this._parent == null) {
            this._ddlString = "";
            this.setThreadPoolStatus();
            this._ddlGlobalParameters.setDDLStatus((byte)1);
        } else {
            this._ddlString = "";
        }
    }

    public Vector parseCompiledObjectName(String string, ASConnection aSConnection) {
        String[] stringArray = new String[3];
        Vector<String[]> vector = new Vector<String[]>();
        String string2 = string;
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        stringArray[1] = "%";
        stringArray[2] = "%";
        try {
            int n = string2.indexOf(34);
            if (n != -1) {
                stringArray[2] = string2.substring(n);
                stringArray[2] = stringArray[2].substring(1, stringArray[2].length() - 1);
                stringArray[2] = Utility.doubleSingleQuotes(stringArray[2]);
                stringArray[2] = Utility.halveDoubleQuotes(stringArray[2]);
                if (n != 0) {
                    if ((n = (string2 = string2.substring(0, n - 1)).indexOf(46)) != -1) {
                        stringArray[0] = string2.substring(0, n);
                        stringArray[1] = string2.substring(n + 1);
                    } else {
                        stringArray[1] = string2;
                    }
                }
            } else if (string2.indexOf(46) != -1) {
                stringArray[2] = string2.substring(string2.lastIndexOf(46) + 1);
                if ((string2 = string2.substring(0, string2.lastIndexOf(46))).indexOf(46) != -1) {
                    stringArray[0] = string2.substring(0, string2.indexOf(46));
                    stringArray[1] = string2.substring(string2.indexOf(46) + 1);
                } else {
                    stringArray[1] = string2;
                }
            } else {
                stringArray[2] = string;
                stringArray[1] = "%";
            }
        }
        catch (Exception exception) {
            new DDLBaseException("CO2", "INVALID_OBJECTNAME_ERROR", 2, stringArray[2]);
        }
        if (stringArray[0] != null && !stringArray[0].equals("%")) {
            if (this._ddlGlobalParameters.getDatabaseName() != null && !stringArray[0].equals(this._ddlGlobalParameters.getDatabaseName())) {
                new DDLBaseException("CO3", "PARAMETER_CONFLICT", 2);
            }
        } else {
            stringArray[0] = this._ddlGlobalParameters.getDatabaseName();
            if (stringArray[0] == null) {
                stringArray[0] = super.getDefaultDatabaseName(aSConnection);
            }
        }
        aSConnection.verifyDBName(stringArray[0]);
        Object[] objectArray = new String[]{stringArray[0], stringArray[1], stringArray[2], this._type};
        if (stringArray[1].indexOf(37) != -1 || stringArray[2].indexOf(37) != -1 || this._isForTriggers) {
            Object object;
            if (this._isForTriggers) {
                if (this._parent != null) {
                    objectArray = new String[]{stringArray[0], CompiledObjectContainer.ignorePatternCharacters(stringArray[1]), CompiledObjectContainer.ignorePatternCharacters(stringArray[2]), this._type, ((UserTableContainer)this._parent).getTableID()};
                    try {
                        aSResultSet.open(ASQueryParser.parseQuery("SELECT ''{0}'',u.name,o.name, o.sysstat2, o.id  FROM {0}..sysusers u,{0}..sysobjects o WHERE u.uid=o.uid and u.name like ''{1}'' and o.name like ''{2}'' and o.type=''{3}'' and o.deltrig = {4} order by o.name", objectArray), "TRIGGERS_OF_TABLE_QUERY");
                    }
                    catch (SQLException sQLException) {
                        new DDLBaseException("CO4", sQLException, 2);
                    }
                    catch (Exception exception) {
                        new DDLBaseException("CO5", exception, "INTERNAL_ERROR", 1);
                    }
                } else {
                    objectArray = new String[]{stringArray[0], CompiledObjectContainer.ignorePatternCharacters(stringArray[1]), this._triggerName, CompiledObjectContainer.ignorePatternCharacters(stringArray[2]), this._type};
                    try {
                        aSResultSet.open(ASQueryParser.parseQuery("SELECT ''{0}'',u.name,o.name, o.sysstat2, o.id  FROM {0}..sysusers u,{0}..sysobjects o WHERE u.uid=o.uid and u.name like ''{1}'' and o.name like ''{2}'' and o.type=''{4}'' and o.deltrig in (SELECT o.id FROM {0}..sysusers u,{0}..sysobjects o WHERE u.uid=o.uid and u.name like ''{1}'' and o.name like ''{3}'' and o.type=''U'') order by o.name", objectArray), "ONLY_TRIGGERS_OF_TABLE_QUERY");
                    }
                    catch (SQLException sQLException) {
                        new DDLBaseException("CO13", sQLException, 2);
                    }
                    catch (Exception exception) {
                        new DDLBaseException("CO14", exception, "INTERNAL_ERROR", 1);
                    }
                }
            } else {
                objectArray = new String[]{stringArray[0], CompiledObjectContainer.ignorePatternCharacters(stringArray[1]), CompiledObjectContainer.ignorePatternCharacters(stringArray[2]), this._type};
                try {
                    object = "SELECT distinct ''{0}'', U.name, O.name ,  O.sysstat2, O.id FROM {0}..sysusers U,{0}..sysobjects O,{0}..sysprocedures P WHERE U.uid=O.uid and P.id = O.id and P.sequence =0 AND P.status & 4096 != 4096 AND U.name like ''{1}'' and O.name like ''{2}'' and O.type=''{3}''";
                    String string3 = "CO_OWNER_OBJECT_QUERY";
                    ArrayList arrayList = this._ddlGlobalParameters.getExtendedObjectTypes();
                    if (aSConnection.isScalarFunctionApplicable() && this.getType().equals("F")) {
                        if (arrayList.size() > 0 && arrayList.contains("OU")) {
                            objectArray[3] = "SF";
                        } else if (arrayList.size() == 0) {
                            object = "SELECT distinct ''{0}'', U.name, O.name ,  O.sysstat2, O.id FROM {0}..sysusers U,{0}..sysobjects O,{0}..sysprocedures P WHERE U.uid=O.uid and P.id = O.id and P.sequence =0 AND P.status & 4096 != 4096 AND U.name like ''{1}'' and O.name like ''{2}'' and (O.type = ''SF'' or O.type = ''F'')";
                            string3 = "CO_OWNER_OBJECT_QUERY_ALL_FUNCTION";
                        }
                    }
                    if (this.getType().equals("P")) {
                        if (arrayList.size() > 0 && arrayList.contains("OU")) {
                            object = (String)object + " and O.sysstat2 & 33554432 != 33554432";
                            string3 = string3 + "+SQLJ_FILTER";
                        } else if (arrayList.size() > 0 && arrayList.contains("OD")) {
                            object = (String)object + " and O.sysstat2 & 33554432 = 33554432";
                            string3 = string3 + "+SQLJ_ONLY";
                        }
                    }
                    object = (String)object + " order by O.name";
                    aSResultSet.open(ASQueryParser.parseQuery((String)object, objectArray), string3);
                }
                catch (SQLException sQLException) {
                    new DDLBaseException("CO6", (Exception)sQLException, 2, (String)objectArray[2]);
                }
                catch (Exception exception) {
                    new DDLBaseException("CO7", exception, "INTERNAL_ERROR", 1);
                }
            }
            try {
                while (aSResultSet.getNextRow()) {
                    object = aSResultSet.getColumnsAsArray();
                    object[2] = Utility.doubleSingleQuotes(object[2]);
                    vector.addElement((String[])object);
                }
            }
            catch (SQLException sQLException) {
                new DDLBaseException("CO8", sQLException, 2);
            }
            catch (Exception exception) {
                new DDLBaseException("CO9", exception, "INTERNAL_ERROR", 1);
            }
        } else {
            try {
                String string4 = "";
                if (this._type.equals("P") && stringArray[2].lastIndexOf(";") != -1) {
                    int n = stringArray[2].lastIndexOf(";");
                    string4 = stringArray[2].substring(0, n);
                }
                String[] stringArray2 = new String[2];
                if (string4.equals("")) {
                    String string5 = "SELECT  O.sysstat2, O.id FROM {0}..sysusers U,{0}..sysobjects O WHERE U.uid=O.uid AND U.name = ''{1}'' and O.name = ''{2}'' and O.type=''{3}''";
                    String string6 = "CO_OBJECT_ATTR_QUERY";
                    if (aSConnection.isScalarFunctionApplicable() && this.getType().equals("F")) {
                        string5 = "SELECT  O.sysstat2, O.id FROM {0}..sysusers U,{0}..sysobjects O WHERE U.uid=O.uid AND U.name = ''{1}'' and O.name = ''{2}'' and (O.type = ''SF'' or O.type = ''F'')";
                        string6 = "FUNCTION_ATTR_QUERY";
                    }
                    aSResultSet.open(ASQueryParser.parseQuery(string5, objectArray), string6);
                    while (aSResultSet.getNextRow()) {
                        stringArray2 = aSResultSet.getColumnsAsArray();
                    }
                } else {
                    Object[] objectArray2 = new String[]{stringArray[0], stringArray[1], string4, this._type};
                    aSResultSet.open(ASQueryParser.parseQuery("SELECT  O.sysstat2, O.id FROM {0}..sysusers U,{0}..sysobjects O WHERE U.uid=O.uid AND U.name = ''{1}'' and O.name = ''{2}'' and O.type=''{3}''", objectArray2), "CO_OBJECT_ATTR_QUERY");
                    while (aSResultSet.getNextRow()) {
                        stringArray2 = aSResultSet.getColumnsAsArray();
                    }
                }
                vector.addElement(new String[]{stringArray[0], stringArray[1], stringArray[2], stringArray2[0], stringArray2[1]});
            }
            catch (SQLException sQLException) {
                new DDLBaseException("CO10", sQLException, 2);
            }
            catch (Exception exception) {
                new DDLBaseException("CO11", exception, "INTERNAL_ERROR", 1);
            }
        }
        if (vector.size() == 0 && this._parent == null) {
            new DDLBaseException("CO12", "COMPILEDOBJECT_NOTFOUND_ERROR", 2, string);
        }
        if (this._type.equals("WS") && stringArray[2].equals("%")) {
            this._webServiceAliases = this.getWebServiceAliases(aSConnection, stringArray[0]);
        }
        return vector;
    }

    private String getWebServiceAliases(ASConnection aSConnection, String string) {
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            aSConnection.executeCommand(ASQueryParser.parseQuery("use {0}", new String[]{string}), "SQL_USE_DB");
        }
        catch (SQLException sQLException) {
            new DDLBaseException("CO13", (Exception)sQLException, 2, string);
        }
        try {
            aSResultSet.open("sp_webservices 'listalias'", "SP_WEBSERVICE_LIST_ALIAS");
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                stringBuffer.append(this.getHeader(stringArray[0], "AL"));
                stringBuffer.append("sp_webservices 'addalias'").append(", '").append(stringArray[0]).append("', '").append(stringArray[1]).append("'");
                stringBuffer.append("\n").append("go ").append("\n\n");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("CO14", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("CO15", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }
}

