/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.container;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.DDLThread;
import com.sybase.ddlgen.ThreadPool;
import com.sybase.ddlgen.io.DDLFileWriter;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.Vector;

public abstract class DDLBaseContainer {
    protected String _name;
    protected String _type;
    protected String _ddlString = null;
    protected String _ddlDepString = null;
    protected DDLBaseContainer _parent = null;
    protected Vector _children = new Vector();
    protected ThreadPool _threadPool;
    public static final char[] cIgnorePatternCharacters = new char[]{'_', '[', ']'};
    protected DDLGlobalParameters _ddlGlobalParameters;

    public abstract void open(ASConnection var1);

    public final void load(ThreadPool threadPool) {
        try {
            this._threadPool = threadPool;
            DDLThread dDLThread = threadPool.getFreeThread();
            if (dDLThread == null) {
                this.open(((DDLThread)Thread.currentThread()).getConnection());
            } else {
                dDLThread.setContainer(this);
            }
        }
        catch (Exception exception) {
            new DDLBaseException("DDB1", exception, "INTERNAL_ERROR", 1);
        }
    }

    public final String toString() {
        return this._name;
    }

    public final void setObjectName(String string) {
        this._name = string;
    }

    public final String getObjectName(String string) {
        if (string != null) {
            String string2 = null;
            if (string.equals("V")) {
                return "View";
            }
            if (string.equals("P")) {
                return "Stored Procedure";
            }
            if (string.equals("XP")) {
                return "Extended Stored Procedure";
            }
            if (string.equals("R")) {
                return "Rule";
            }
            if (string.equals("D")) {
                return "Default";
            }
            if (string.equals("TR")) {
                return "Trigger";
            }
            if (string.equals("F")) {
                return "Function";
            }
            if (string.equals("WS")) {
                return "User Defined Web Service";
            }
            if (string.equals("LK")) {
                return "Logical Keys of Table";
            }
            if (string.equals("AL")) {
                return "Alias";
            }
            try {
                string2 = this._ddlGlobalParameters.getObjectClassName(string);
            }
            catch (NullPointerException nullPointerException) {
                return ":" + string + ":";
            }
            return string2;
        }
        return null;
    }

    public final void setType(String string) {
        this._type = string;
    }

    public final String getType() {
        return this._type;
    }

    protected final String getHeader(String string, String string2) {
        return "\n-----------------------------------------------------------------------------\n-- DDL for " + this.getObjectName(string2) + " '" + string + "'\n-----------------------------------------------------------------------------\n\n" + "print '<<<<< CREATING " + this.getObjectName(string2) + " - " + "\"" + string + "\" >>>>>'\n" + "go " + "\n\n";
    }

    protected final String getError(String string, String string2) {
        return "IF (@@error != 0)\nBEGIN\n\tPRINT 'Error CREATING " + this.getObjectName(string2) + " " + string + "'\n" + "\tSELECT syb_quit()\n" + "END\ngo\n\n";
    }

    private final String getFooter() {
        return this._ddlDepString.equals("") || this._ddlDepString == null ? "" : "\n-----------------------------------------------------------------------------\n-- Dependent DDL for Object(s)\n-----------------------------------------------------------------------------\n";
    }

    public final String getDefaultDatabaseName(ASConnection aSConnection) {
        String string = "";
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            String string2 = this._ddlGlobalParameters.getUserName();
            if (string2 == null) {
                new DDLBaseException("DDB2", "USER_NAME_NULL_ERROR", 2);
            }
            Object[] objectArray = new String[]{string2};
            aSResultSet.open(ASQueryParser.parseQuery("SELECT dbname FROM master.dbo.syslogins WHERE name = ''{0}''", objectArray), "SQL_DATABASE_NAME");
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                string = stringArray[0];
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("DDB3", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("DDB4", exception, "INTERNAL_ERROR", 1);
        }
        if (string.equals("")) {
            new DDLBaseException("DDB5", "DEFAULT_DATABASE_NULL_ERROR", 2);
        }
        this._ddlGlobalParameters.setDatabaseName(string);
        return string;
    }

    protected final void generateDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._children.size(); ++i) {
            try {
                String string;
                Class<?> clazz = Class.forName("com.sybase.ddlgen.container.DDLBaseContainer");
                if (clazz.isInstance(this._children.elementAt(i))) {
                    while ((string = ((DDLBaseContainer)this._children.elementAt(i)).getDDL()) == null) {
                    }
                } else {
                    String string2;
                    while ((string = ((DDLBaseItem)this._children.elementAt(i)).getDDL()) == null) {
                    }
                    this._name = ((DDLBaseItem)this._children.elementAt(i)).getName();
                    stringBuffer.append(this.getHeader(this._name, this._type));
                    if (!(this._ddlGlobalParameters.getFilters().contains("IE") || this._ddlGlobalParameters.getFilters().contains("%") || (string2 = ((DDLBaseItem)this._children.elementAt(i)).getIfExistsStatement()) == null || string2.equals(""))) {
                        stringBuffer.append(string2);
                        stringBuffer.append(this.getError(this._name, this._type));
                    }
                    this.writeProgressInfoToLog(this.getObjectName(this._type), this._name);
                }
                stringBuffer.append(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                new DDLBaseException("DDB6", "CLASS_NOT_FOUND_ERROR", 1);
            }
        }
        this._ddlString = stringBuffer.toString();
        if (this._parent == null) {
            this._threadPool.setStatusComplete();
            this._ddlGlobalParameters.setDDLString(this._ddlString);
            this._ddlGlobalParameters.setDDLStatus((byte)1);
        }
    }

    protected final void generateDDLs() {
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        String[] stringArray = new String[2];
        for (int i = 0; i < this._children.size(); ++i) {
            try {
                Class<?> clazz = Class.forName("com.sybase.ddlgen.container.DDLBaseContainer");
                if (clazz.isInstance(this._children.elementAt(i))) {
                    while ((stringArray[0] = ((DDLBaseContainer)this._children.elementAt(i)).getDDLs()[0]) == null) {
                    }
                    stringArray[1] = ((DDLBaseContainer)this._children.elementAt(i)).getDDLs()[1];
                    if (stringArray[1] != null) {
                        stringBufferArray[1].append(stringArray[1]);
                    }
                } else {
                    while ((stringArray[0] = ((DDLBaseItem)this._children.elementAt(i)).getDDL()) == null) {
                    }
                    if (!stringArray[0].equals("")) {
                        String string;
                        this._name = ((DDLBaseItem)this._children.elementAt(i)).getName();
                        stringBufferArray[0].append(this.getHeader(this._name, this._type));
                        if (!(this._ddlGlobalParameters.getFilters().contains("IE") || this._ddlGlobalParameters.getFilters().contains("%") || (string = ((DDLBaseItem)this._children.elementAt(i)).getIfExistsStatement()) == null || string.equals(""))) {
                            stringBufferArray[0].append(string);
                            stringBufferArray[0].append(this.getError(this._name, this._type));
                        }
                        this.writeProgressInfoToLog(this.getObjectName(this._type), this._name);
                    }
                }
                if (stringArray[0] == null) continue;
                stringBufferArray[0].append(stringArray[0]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                new DDLBaseException("DDB7", "CLASS_NOT_FOUND_ERROR", 1);
            }
        }
        this._ddlDepString = this._ddlDepString == null ? stringBufferArray[1].toString() : this._ddlDepString + stringBufferArray[1].toString();
        String string = this._ddlString = this._ddlString == null ? stringBufferArray[0].toString() : this._ddlString + stringBufferArray[0].toString();
        if (this._parent == null) {
            this._threadPool.setStatusComplete();
            this._ddlGlobalParameters.setDDLString(this._ddlString + this.getFooter() + this._ddlDepString);
            this._ddlGlobalParameters.setDDLStatus((byte)1);
        }
    }

    public final String[] getDDLs() {
        return new String[]{this._ddlString, this._ddlDepString};
    }

    public final String getDDL() {
        return this._ddlString;
    }

    private final void setDDL(String string) {
        this._ddlString = string;
        this._ddlDepString = string;
    }

    private String getName() {
        return this._name;
    }

    public void setDDLGlobalParameters(DDLGlobalParameters dDLGlobalParameters) {
        this._ddlGlobalParameters = dDLGlobalParameters;
    }

    public DDLGlobalParameters getDDLGlobalParameters() {
        return this._ddlGlobalParameters;
    }

    protected void setThreadPoolStatus() {
        if (this._parent == null) {
            this._threadPool.setStatusComplete();
        }
    }

    public static String ignorePatternCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            bl = false;
            for (int j = 0; j < cIgnorePatternCharacters.length; ++j) {
                if (string.charAt(i) != cIgnorePatternCharacters[j]) continue;
                stringBuffer.append("[").append(cIgnorePatternCharacters[j]).append("]");
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public DDLBaseContainer getParent() {
        return this._parent;
    }

    public void writeProgressInfoToLog(String string, String string2) {
        DDLFileWriter dDLFileWriter = this._ddlGlobalParameters.getProgressLogWriter();
        if (dDLFileWriter != null) {
            dDLFileWriter.writeProgressLogInfo(string, string2);
        }
    }
}

