/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.container;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.item.DatabaseDeviceItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class DatabaseDeviceContainer
extends DDLBaseContainer {
    private static final int ALL_DEVICES = 0;
    private static final int GLOBAL_DEVICE = 1;
    private static final int IM_DEVICES = 2;
    private static final int GLOBAL_DEVICES = 3;
    private static final int LOCAL_DEVICES = 4;
    private static final int LOCAL_DEVICE = 5;
    private static final int DEVICE_COLUMN = 1;
    private static final int INSTANCE_COLUMN = 7;
    private static final String WILDCARD = "%";

    public DatabaseDeviceContainer(DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
    }

    public DatabaseDeviceContainer() {
    }

    private String getInstanceName(String string) {
        String string2 = "";
        int n = string.indexOf(".");
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private String getDeviceName(String string) {
        String string2 = string;
        int n = string.indexOf(".");
        if (n > -1) {
            string2 = string.substring(n + 1, string.length());
        }
        return string2;
    }

    private int getDeviceType() {
        int n = -1;
        ArrayList arrayList = this._ddlGlobalParameters.getExtendedObjectTypes();
        String string = this._ddlGlobalParameters.getObjectName();
        String string2 = this.getDeviceName(string);
        String string3 = this.getInstanceName(string);
        if (arrayList.size() > 0) {
            if (arrayList.contains("OI") && string2.indexOf(WILDCARD) != -1) {
                n = 2;
            } else if (arrayList.contains("OU") && string3.length() == 0 && string2.indexOf(WILDCARD) != -1) {
                n = 3;
            } else if (arrayList.contains("OD") && string3.length() > 0 && (string2.indexOf(WILDCARD) != -1 || string3.equals(WILDCARD))) {
                n = 4;
            }
        } else if (string3.length() > 0 && (string2.indexOf(WILDCARD) != -1 || string3.equals(WILDCARD))) {
            n = 4;
        } else if (string3.length() > 0 && !string3.equals(WILDCARD)) {
            n = 5;
        } else if (string2.length() > 0 && !string2.equals(WILDCARD)) {
            n = 1;
        } else if (string2.equals(WILDCARD) && string3.length() == 0) {
            n = 0;
        }
        return n;
    }

    @Override
    public void open(ASConnection aSConnection) {
        Object[] objectArray;
        Object object;
        int n;
        ASResultSet aSResultSet = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            aSResultSet = new ASResultSet(aSConnection);
            if (this._parent != null) {
                string3 = WILDCARD;
            } else {
                string = this._ddlGlobalParameters.getObjectName();
                string2 = DatabaseDeviceContainer.ignorePatternCharacters(this.getInstanceName(string));
                string3 = DatabaseDeviceContainer.ignorePatternCharacters(this.getDeviceName(string));
            }
            if (aSResultSet != null) {
                n = this.getDeviceType();
                object = Integer.toString(7) + "," + Integer.toString(1);
                objectArray = new String[]{string3, string2, object};
                switch (n) {
                    case 2: {
                        aSResultSet.open(ASQueryParser.parseQuery("SELECT name, phyname, mirrorname,(high-low +1)/512, status, status2 FROM master.dbo.sysdevices WHERE status2&8=8 and name like ''{0}''group by name", objectArray), "IM_DATABASE_DEVICE_QUERY");
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (aSConnection.isCluster()) {
                            aSResultSet.open(ASQueryParser.parseQuery("SELECT d.name, d.phyname, d.mirrorname,(d.high-d.low +1)/512, d.status, d.status2, c.name FROM master.dbo.sysdevices d, master.dbo.sysinstances c WHERE (d.cntrltype = 0) and  (d.status2 & 2) = 2 and (d.name like ''{0}'') and d.instanceid = c.id and c.name like ''{1}''  order by ''{2}'' ", objectArray), "DEVICE_SDC_LOCAL_QUERY");
                            break;
                        }
                        new DDLBaseException("DBD9", "INVALID_COMMAND_FOR_SDC", 1, this._ddlGlobalParameters.getHostName() + ":" + this._ddlGlobalParameters.getPortNumber());
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (aSConnection.isCluster()) {
                            aSResultSet.open(ASQueryParser.parseQuery("SELECT name, phyname, mirrorname,(high-low +1)/512, status, status2 FROM master.dbo.sysdevices  WHERE (cntrltype = 0) and (name like ''{0}'') and instanceid = null group by name", objectArray), "DEVICE_SDC_GLOBAL_QUERY");
                            break;
                        }
                        aSResultSet.open(ASQueryParser.parseQuery("SELECT name, phyname, mirrorname,(high-low +1)/512, status, status2 FROM master.dbo.sysdevices WHERE (cntrltype = 0) and (name like ''{0}'') group by name", objectArray), "DEVICE_NO_SDC_GLOBAL_QUERY");
                        break;
                    }
                    case 0: {
                        if (aSConnection.getServerVersion().compareTo("15") >= 0) {
                            if (aSConnection.isCluster()) {
                                aSResultSet.open(ASQueryParser.parseQuery("SELECT name, phyname, mirrorname,(high-low +1)/512, status, status2, null FROM master.dbo.sysdevices WHERE (cntrltype = 0) and instanceid = null union SELECT d.name, d.phyname, d.mirrorname,(d.high-d.low +1)/512, d.status, d.status2, c.name FROM master.dbo.sysdevices d, master.dbo.sysinstances c WHERE (d.cntrltype = 0) and  (d.status2 & 2) = 2 and d.instanceid = c.id", objectArray), "DATABASE_DEVICE_SDC_QUERY");
                                break;
                            }
                            aSResultSet.open(ASQueryParser.parseQuery("SELECT name, phyname, mirrorname,(high-low +1)/512, status, status2 FROM master.dbo.sysdevices WHERE (cntrltype = 0) and (name like ''{0}'') group by name", objectArray), "DATABASE_DEVICE_QUERY");
                            break;
                        }
                        aSResultSet.open(ASQueryParser.parseQuery("SELECT name, phyname, mirrorname,(high-low +1)/512, status FROM master.dbo.sysdevices WHERE (cntrltype = 0) and (name like ''{0}'') group by name", objectArray), "DATABASE_DEVICE_QUERY");
                        break;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("DBD1", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("DBD2", exception, "INTERNAL_ERROR", 1);
        }
        n = 0;
        try {
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                object = new DatabaseDeviceItem(stringArray, this);
                ++n;
                objectArray = this._threadPool.getFreeThread();
                if (objectArray != null) {
                    objectArray.setItem((DDLBaseItem)object);
                } else {
                    ((DatabaseDeviceItem)object).open(aSConnection);
                }
                this._children.addElement(object);
            }
            if (aSResultSet != null) {
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("DBD3", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("DBD4", exception, "INTERNAL_ERROR", 1);
        }
        if (n == 0 && this._parent == null) {
            new DDLBaseException("DBD5", "DATABASE_DEVICE_NOT_FOUND_ERROR", 2, string3);
        }
        if (n > 0) {
            this.generateDDL();
        } else {
            this._ddlString = "";
            this.setThreadPoolStatus();
        }
    }

    private String getPageSize(ASConnection aSConnection) {
        String string = null;
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            if (aSResultSet != null) {
                aSResultSet.open("SELECT low FROM master..spt_values WHERE number = 1 AND type = 'E'", "PAGE_SIZE_QUERY");
            }
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                string = stringArray[0];
                if (string != null) continue;
                new DDLBaseException("DBD6", "DATABASE_DEVICE_PAGE_SIZE_ERROR", 2);
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("DBD7", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("DBD8", exception, "INTERNAL_ERROR", 1);
        }
        return string;
    }
}

