/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.container;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.DDLThread;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.item.EncryptedKeyItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class EncryptedKeyContainer
extends DDLBaseContainer {
    private boolean _isValueRequired;
    private boolean _isKeyCopyRequired;
    private boolean _isSystemPwdRequired;
    private boolean _isEncryptedWithSystemPassword;
    private static final int DDLGEN_APP_SYSTEM_PWD_CONSTANT = 2;
    private final String MASTER_KEY = "master";
    private final String DUAL_MASTER_KEY = "dualmaster";
    private final String MASTER_KEY_INTER_NAME = "sybencrmasterkey";
    private final String DUAL_MASTER_KEY_INTER_NAME = "sybencrdualmasterkey";

    public EncryptedKeyContainer(DDLBaseContainer dDLBaseContainer, DDLGlobalParameters dDLGlobalParameters) {
        this._parent = dDLBaseContainer;
        this.setDDLGlobalParameters(dDLGlobalParameters);
    }

    public EncryptedKeyContainer() {
    }

    @Override
    public void open(ASConnection aSConnection) {
        Object object;
        Object object2;
        Object[] objectArray;
        ASResultSet aSResultSet = null;
        Object object3 = "";
        String string = null;
        String string2 = "%";
        String[] stringArray = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            if (this._parent != null) {
                object3 = this._parent._name;
                string = "%";
            } else {
                if (!aSConnection.isEncryptionKeyApplicable()) {
                    new DDLBaseException("EK1", "ENCRYPTED_KEY_NOT_APPLICABLE_ERROR", 1);
                }
                objectArray = new Vector();
                object2 = this._ddlGlobalParameters.getObjectName();
                while (((String)object2).length() > 0) {
                    if (((String)object2).indexOf(46) != -1) {
                        object = ((String)object2).substring(0, ((String)object2).indexOf(46));
                        object2 = ((String)object2).substring(((String)object).length() + 1);
                        objectArray.addElement(object);
                        continue;
                    }
                    objectArray.addElement(object2);
                    break;
                }
                if (objectArray.size() == 3) {
                    object3 = (String)objectArray.elementAt(0);
                    string2 = (String)objectArray.elementAt(1);
                    string = (String)objectArray.elementAt(2);
                } else if (objectArray.size() == 2) {
                    boolean bl;
                    object3 = this._ddlGlobalParameters.getDatabaseName();
                    if (object3 != null) {
                        aSConnection.verifyDBName((String)object3);
                    }
                    object = (String)objectArray.elementAt(0);
                    if (object3 == null) {
                        object3 = this.getDefaultDatabaseName(aSConnection);
                        bl = this.checkValidity((String)object3, (String)object, aSResultSet);
                        if (bl || ((String)object).indexOf("%") != -1) {
                            string2 = (String)objectArray.elementAt(0);
                        } else {
                            object3 = (String)objectArray.elementAt(0);
                        }
                    } else if (((String)object).equals(object3)) {
                        bl = this.checkValidity((String)object3, (String)object, aSResultSet);
                        if (bl) {
                            new DDLBaseException("EK2", "DATABASE_TABLE_NAME_ERROR", 2);
                        } else {
                            object3 = object;
                        }
                    } else {
                        bl = this.checkValidity((String)object3, (String)object, aSResultSet);
                        if (bl || ((String)object).indexOf("%") != -1) {
                            string2 = (String)objectArray.elementAt(0);
                        } else {
                            object3 = object;
                        }
                    }
                }
                string = EncryptedKeyContainer.ignorePatternCharacters((String)objectArray.elementAt(objectArray.size() - 1));
                if (((String)object3).equals("") && (object3 = this._ddlGlobalParameters.getDatabaseName()) == null) {
                    object3 = this.getDefaultDatabaseName(aSConnection);
                }
            }
        }
        catch (Exception exception) {
            new DDLBaseException("EK3", exception, "INTERNAL_ERROR", 1);
        }
        aSConnection.verifyDBName((String)object3);
        if (aSConnection.isDualControlEncryptKeyApp()) {
            if (string.toLowerCase().equals("master")) {
                string = "sybencrmasterkey";
            } else if (string.toLowerCase().equals("dualmaster")) {
                string = "sybencrdualmasterkey";
            }
        }
        if (string2.equals("")) {
            string2 = "%";
        }
        try {
            if (aSResultSet != null) {
                objectArray = new String[]{object3, string2, string};
                object2 = ASQueryParser.parseQuery("select o.name, u.name, isnull(k.eklen,128), isnull(k.status,0), isnull(k.type,0), o.id, k.value, k.eksalt from {0}.dbo.sysencryptkeys k, {0}.dbo.sysobjects o, {0}.dbo.sysusers u where k.id = o.id and u.uid = o.uid and o.type=''EK'' and u.name like ''{1}'' and o.name like ''{2}''", objectArray);
                if (aSConnection.getServerVersion().compareTo("15.0.2") >= 0) {
                    object2 = (String)object2 + " and k.type & 16 != 16";
                }
                object2 = (String)object2 + " order by o.crdate";
                aSResultSet.open((String)object2, "SELECT_ENCRYP_KEYS_QUERY");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("EK4", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("EK5", exception, "INTERNAL_ERROR", 1);
        }
        if (this._ddlGlobalParameters.getExtendedObjectTypes().size() > 0 && this._ddlGlobalParameters.getExtendedObjectTypes().contains("OD")) {
            this._isValueRequired = true;
        }
        if (aSConnection.getServerVersion().compareTo("15.0.2") >= 0) {
            if (this._ddlGlobalParameters.getFilters() != null && !this._ddlGlobalParameters.getFilters().contains("EKC") && !this._ddlGlobalParameters.getFilters().contains("%")) {
                this._isKeyCopyRequired = true;
            }
            if (this._ddlGlobalParameters.getFilters() != null && !this._ddlGlobalParameters.getFilters().contains("SEP") && !this._ddlGlobalParameters.getFilters().contains("%")) {
                this._isSystemPwdRequired = true;
            }
        }
        int n = 0;
        try {
            while (aSResultSet.getNextRow()) {
                stringArray = aSResultSet.getColumnsAsArray();
                object2 = new EncryptedKeyItem(stringArray, (String)object3, this);
                ++n;
                object = this._threadPool.getFreeThread();
                if (object != null) {
                    ((DDLThread)object).setItem((DDLBaseItem)object2);
                } else {
                    ((EncryptedKeyItem)object2).open(aSConnection);
                }
                this._children.addElement(object2);
                if (this._isEncryptedWithSystemPassword || !((EncryptedKeyItem)object2).isEncryptedWithSystemPassword()) continue;
                this._isEncryptedWithSystemPassword = true;
            }
            if (aSResultSet != null) {
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("EK6", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("EK7", exception, "INTERNAL_ERROR", 1);
        }
        if (n == 0 && this._parent == null) {
            if (aSConnection.isDualControlEncryptKeyApp()) {
                if (string.toLowerCase().equals("sybencrmasterkey")) {
                    string = "master key on database " + (String)object3;
                } else if (string.toLowerCase().equals("sybencrdualmasterkey")) {
                    string = "dualmaster key on database " + (String)object3;
                }
                new DDLBaseException("EK13", "ENCRYPTED_KEY_NOT_FOUND_ERROR", 2, string);
            } else {
                new DDLBaseException("EK8", "ENCRYPTED_KEY_NOT_FOUND_ERROR", 2, (String)object3 + "." + string2 + "." + string);
            }
        }
        if (aSResultSet != null) {
            aSResultSet = null;
        }
        if (n > 0) {
            if (this.isValueRequired() && this._isSystemPwdRequired && this._isEncryptedWithSystemPassword) {
                this._ddlString = this.getSystemPasswordDDL(aSConnection, (String)object3);
            }
            this.generateDDLs();
        } else if (n == 0 && this._parent == null) {
            this._ddlString = "";
            this.setThreadPoolStatus();
            this._ddlGlobalParameters.setDDLStatus((byte)1);
        } else {
            this._ddlString = "";
        }
    }

    public boolean isValueRequired() {
        return this._isValueRequired;
    }

    public boolean isKeyCopyRequired() {
        return this._isKeyCopyRequired;
    }

    private boolean checkValidity(String string, String string2, ASResultSet aSResultSet) {
        Object[] objectArray = new String[]{string, string2};
        int n = 0;
        try {
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT name FROM {0}..sysusers WHERE name = ''{1}''", objectArray), "VERIFY_USERNAME");
            }
            while (aSResultSet.getNextRow()) {
                ++n;
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("EK9", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("EK10", exception, "INTERNAL_ERROR", 1);
        }
        return n == 1;
    }

    private String getSystemPasswordDDL(ASConnection aSConnection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{string};
            aSResultSet.open(ASQueryParser.parseQuery("select passwd = char_value, value = object_info1 from {0}.dbo.sysattributes where class=25 and attribute = 0 and object_type = ''EC'' ", objectArray), "SYSTEM_ENCRYP_PASSWORD");
            if (aSResultSet.getNextRow()) {
                stringBuffer.append("-- ").append("System Encryption Password").append("\n\n");
                if (!this.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
                    String string2 = ASQueryParser.parseQuery("use {0}", new String[]{string});
                    string2 = string2 + "\n" + "go " + "\n\n";
                    stringBuffer.append(string2);
                    this.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
                }
                stringBuffer.append("sp_encryption 'system_encr_passwd'").append(",").append(" ").append("'").append(aSResultSet.getColumnString("passwd")).append("',").append(" ").append("NULL").append(",").append(" ").append(2).append(",").append(" ").append(aSResultSet.getColumnString("value")).append("\n");
                stringBuffer.append("go ").append("\n\n");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("EK11", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("EK12", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    public void setEncryptedWithSEPTrue() {
        this._isEncryptedWithSystemPassword = true;
    }
}

