/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.container;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.DDLThread;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.container.UserTableContainer;
import com.sybase.ddlgen.item.KeyConstraintItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class KeyConstraintContainer
extends DDLBaseContainer {
    public static final int DB_NAME = 0;
    public static final int COL_LIST = 6;
    public static final int TABLE_NAME = 2;
    public static final int TABLE_OWNER = 1;
    public static final int CONSTRAINT_NAME = 3;
    public static final int CONSTRAINT_TYPE = 5;
    public static final int CONSTRAINT_KEY_TYPE = 4;
    public static final int CONSTRAINT_ATTRIBUTES = 7;
    public static final int CONSTRAINT_SEGMENT_NAME = 8;
    public static final int CONSTRAINT_SYSTEM_GENERATED = 9;
    public static final int CONSTRAINT_STATUS2 = 10;
    public static final int COLUMNS_COUNT = 1;
    public static final int CONSTR_NAME = 2;
    public static final int INDEX_ID = 3;
    public static final int STATUS = 4;
    public static final int STATUS2 = 5;
    public static final int FILL_FACTOR = 6;
    public static final int MAX_ROWS_PER_PAGE = 7;
    public static final int RESERVEPAGEGAP = 8;
    public static final int SEGMENT_NAME = 9;
    public static final int TBL_OWNER = 10;
    public static final int TBL_NAME = 11;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_SORTORDER = 2;

    public KeyConstraintContainer(DDLBaseContainer dDLBaseContainer, DDLGlobalParameters dDLGlobalParameters) {
        this();
        this._parent = dDLBaseContainer;
        this.setDDLGlobalParameters(dDLGlobalParameters);
    }

    public KeyConstraintContainer() {
        this._ddlDepString = "";
    }

    @Override
    public void open(ASConnection aSConnection) {
        Vector vector = null;
        if (this._parent == null) {
            vector = this.getPrimaryAndUniqueConstraintListOfDB(aSConnection);
            if (vector.size() == 0) {
                new DDLBaseException("KC1", "KEYCONSTRAINTS_NOTFOUND_ERROR", 2);
            }
        } else {
            vector = this.getPrimaryAndUniqueConstraintListOfTable(aSConnection);
        }
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = (String[])vector.elementAt(i);
            KeyConstraintItem keyConstraintItem = new KeyConstraintItem(stringArray, this);
            DDLThread dDLThread = this._threadPool.getFreeThread();
            if (dDLThread != null) {
                dDLThread.setItem(keyConstraintItem);
            } else {
                keyConstraintItem.open(aSConnection);
            }
            this._children.addElement(keyConstraintItem);
        }
        if (this._children.size() > 0) {
            this.generateDDLs();
        } else if (this._children.size() == 0 && this._parent == null) {
            this._ddlString = "";
            this.setThreadPoolStatus();
            this._ddlGlobalParameters.setDDLStatus((byte)1);
        } else {
            this._ddlString = "";
        }
    }

    public void setDependentDDL(String string) {
        this._ddlDepString = this._ddlDepString + string;
    }

    public String[] parseConstraintKeyName(ASConnection aSConnection) {
        String string = this._ddlGlobalParameters.getObjectName();
        String[] stringArray = new String[]{"%", "%", "%", "%"};
        if (string.indexOf(46) != -1) {
            try {
                stringArray[3] = KeyConstraintContainer.ignorePatternCharacters(string.substring(string.lastIndexOf(46) + 1));
                if (stringArray[3].startsWith("\"") && stringArray[3].endsWith("\"")) {
                    stringArray[3] = stringArray[3].substring(1, stringArray[3].length() - 1);
                }
                string = string.substring(0, string.lastIndexOf(46));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                new DDLBaseException("KC2", "KEYCONSTRAINTS_NAME_ERROR", 2, string);
            }
            if (string.indexOf(46) != -1) {
                try {
                    stringArray[2] = KeyConstraintContainer.ignorePatternCharacters(string.substring(string.lastIndexOf(46) + 1));
                    string = string.substring(0, string.lastIndexOf(46));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    new DDLBaseException("KC3", "KEYCONSTRAINTS_NAME_ERROR", 2, string);
                }
                if (string.indexOf(46) != -1) {
                    try {
                        stringArray[1] = KeyConstraintContainer.ignorePatternCharacters(string.substring(string.lastIndexOf(46) + 1));
                        stringArray[0] = string = string.substring(0, string.lastIndexOf(46));
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        new DDLBaseException("KC4", "KEYCONSTRAINTS_NAME_ERROR", 2, string);
                    }
                } else {
                    stringArray[1] = KeyConstraintContainer.ignorePatternCharacters(string);
                }
            } else {
                stringArray[2] = KeyConstraintContainer.ignorePatternCharacters(string);
            }
        } else {
            stringArray[3] = KeyConstraintContainer.ignorePatternCharacters(string);
        }
        if (stringArray[0] != null && !stringArray[0].equals("%")) {
            if (this._ddlGlobalParameters.getDatabaseName() != null && !stringArray[0].equals(this._ddlGlobalParameters.getDatabaseName())) {
                new DDLBaseException("KC5", "PARAMETER_CONFLICT_ERROR", 2);
            }
        } else {
            stringArray[0] = this._ddlGlobalParameters.getDatabaseName();
            if (stringArray[0] == null) {
                stringArray[0] = super.getDefaultDatabaseName(aSConnection);
            }
        }
        aSConnection.verifyDBName(stringArray[0]);
        return stringArray;
    }

    public Vector getPrimaryAndUniqueConstraintListOfDB(ASConnection aSConnection) {
        String[] stringArray = new String[11];
        Vector<Object> vector = new Vector<Object>();
        ASResultSet aSResultSet = null;
        ASResultSet aSResultSet2 = null;
        String[] stringArray2 = this.parseConstraintKeyName(aSConnection);
        Object[] objectArray = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3], aSConnection.getValidNameString()};
        stringArray[0] = stringArray2[0];
        try {
            aSResultSet = new ASResultSet(aSConnection);
            aSResultSet2 = new ASResultSet(aSConnection);
            aSResultSet.open(ASQueryParser.parseQuery("SELECT COLUMNS_COUNT = i.keycnt, INDEX_NAME = CASE WHEN valid_name(i.name {4})=0 THEN ''\"'' + i.name + ''\"'' ELSE i.name END, INDEX_ID = i.indid, STATUS = i.status, STATUS2 = i.status2, FILL_FACTOR = isnull(i.fill_factor,0), MAXROWSPERPAGE = isnull(i.maxrowsperpage,0), RES_PAGE_GAP = isnull(i.res_page_gap,0), SEGMENT_NAME = s.name, OWNER_NAME = u.name, TABLE_NAME = CASE WHEN valid_name(o.name {4})=0 THEN ''\"'' + o.name + ''\"'' ELSE o.name END FROM {0}..sysindexes i, {0}..syssegments s,{0}..sysobjects o,{0}..sysusers u WHERE i.segment = s.segment AND i.name like ''{3}'' AND i.indid > 0 AND i.status2 & 2 = 2 AND o.name like ''{2}'' AND u.name like ''{1}'' AND u.uid = o.uid AND i.id=o.id", objectArray), "PRIMARY_AND_UNIQUE_CONSTRAINTS_OF_DB_QUERY");
            while (aSResultSet.getNextRow()) {
                stringArray[3] = aSResultSet.getColumnString(2);
                stringArray[1] = aSResultSet.getColumnString(10);
                stringArray[2] = aSResultSet.getColumnString(11);
                stringArray[4] = (aSResultSet.getColumnInt(4) & 0x800) == 2048 ? "PRIMARY KEY" : "UNIQUE";
                stringArray[9] = (aSResultSet.getColumnInt(5) & 8) == 8 ? "true" : "false";
                int n = 0;
                if (aSResultSet.getColumnInt(3) == 1) {
                    stringArray[5] = "CLUSTERED";
                    n = aSResultSet.getColumnInt(1) + 1;
                } else if (aSResultSet.getColumnInt(3) > 1) {
                    n = aSResultSet.getColumnInt(1);
                    stringArray[5] = (aSResultSet.getColumnInt(5) & 0x200) == 512 || (aSResultSet.getColumnInt(4) & 0x10) == 16 ? "CLUSTERED" : "NONCLUSTERED";
                }
                String string = "";
                for (int i = 1; i < n; ++i) {
                    objectArray = new String[]{stringArray[0] + "." + stringArray[1] + "." + stringArray[2], aSResultSet.getColumnString(3), String.valueOf(i), aSConnection.getValidNameString()};
                    aSResultSet2.open(this.getIndexColQuery((String[])objectArray), "INDEX_COL_PART1+2");
                    while (aSResultSet2.getNextRow()) {
                        string = string + aSResultSet2.getColumnString(1);
                        if (aSResultSet2.getColumnString(2).toLowerCase().equals("desc")) {
                            string = string + " desc";
                        }
                        string = string + ", ";
                    }
                    if (aSResultSet2 == null) continue;
                    aSResultSet2.close();
                }
                stringArray[6] = string = string.substring(0, string.length() - 2);
                stringArray[7] = this.getAttributes(aSResultSet.getColumnInt(7), aSResultSet.getColumnInt(6), aSResultSet.getColumnInt(8), 0, true);
                stringArray[8] = aSResultSet.getColumnString(9);
                stringArray[10] = aSResultSet.getColumnString(5);
                vector.addElement(stringArray.clone());
            }
            if (aSResultSet != null) {
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("KC6", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("KC7", exception, "INTERNAL_ERROR", 1);
        }
        return vector;
    }

    public Vector getPrimaryAndUniqueConstraintListOfTable(ASConnection aSConnection) {
        String[] stringArray = new String[9];
        Vector<Object> vector = new Vector<Object>();
        ASResultSet aSResultSet = null;
        ASResultSet aSResultSet2 = null;
        stringArray[0] = ((UserTableContainer)this._parent).getDBName();
        stringArray[1] = ((UserTableContainer)this._parent).getOwnerName();
        stringArray[2] = ((UserTableContainer)this._parent).getTableName();
        Object[] objectArray = new String[]{stringArray[0], ((UserTableContainer)this._parent).getTableID(), aSConnection.getValidNameString()};
        try {
            aSResultSet = new ASResultSet(aSConnection);
            aSResultSet2 = new ASResultSet(aSConnection);
            aSResultSet.open(ASQueryParser.parseQuery("SELECT COLUMNS_COUNT = i.keycnt, INDEX_NAME = CASE WHEN valid_name(i.name {2})=0 THEN ''\"'' + i.name + ''\"'' ELSE i.name END, INDEX_ID = i.indid, STATUS = i.status, STATUS2 = i.status2, FILL_FACTOR = isnull(i.fill_factor,0), MAXROWSPERPAGE = isnull(i.maxrowsperpage,0), RES_PAGE_GAP = isnull(i.res_page_gap,0), SEGMENT_NAME = s.name FROM {0}..sysindexes i, {0}..syssegments s WHERE i.segment = s.segment AND i.id = {1} AND i.indid > 0 AND i.status2 & 2 = 2", objectArray), "PRIMARY_AND_UNIQUE_CONSTRAINTS_OF_TABLE_QUERY");
            while (aSResultSet.getNextRow()) {
                stringArray[3] = aSResultSet.getColumnString(2);
                stringArray[4] = (aSResultSet.getColumnInt(4) & 0x800) == 2048 ? "PRIMARY KEY" : "UNIQUE";
                int n = 0;
                if (aSResultSet.getColumnInt(3) == 1) {
                    stringArray[5] = "CLUSTERED";
                    n = aSResultSet.getColumnInt(1) + 1;
                } else if (aSResultSet.getColumnInt(3) > 1) {
                    n = aSResultSet.getColumnInt(1);
                    stringArray[5] = (aSResultSet.getColumnInt(5) & 0x200) == 512 || (aSResultSet.getColumnInt(4) & 0x10) == 16 ? "CLUSTERED" : "NONCLUSTERED";
                }
                String string = "";
                for (int i = 1; i < n; ++i) {
                    objectArray = new String[]{stringArray[0] + "." + stringArray[1] + "." + stringArray[2], aSResultSet.getColumnString(3), String.valueOf(i), aSConnection.getValidNameString()};
                    aSResultSet2.open(this.getIndexColQuery((String[])objectArray), "INDEX_COL_PART1+2");
                    while (aSResultSet2.getNextRow()) {
                        string = string + aSResultSet2.getColumnString(1);
                        if (aSResultSet2.getColumnString(2).toLowerCase().equals("desc")) {
                            string = string + " desc";
                        }
                        string = string + ", ";
                    }
                    if (aSResultSet2 == null) continue;
                    aSResultSet2.close();
                }
                stringArray[6] = string = string.substring(0, string.length() - 2);
                stringArray[7] = this.getAttributes(aSResultSet.getColumnInt(7), aSResultSet.getColumnInt(6), aSResultSet.getColumnInt(8), 0, true);
                stringArray[8] = aSResultSet.getColumnString(9);
                stringArray[10] = aSResultSet.getColumnString(5);
                vector.addElement(stringArray.clone());
            }
            if (aSResultSet != null) {
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("KC8", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("KC9", exception, "INTERNAL_ERROR", 1);
        }
        return vector;
    }

    private String getIndexColQuery(String[] stringArray) {
        String string = ASQueryParser.parseQuery("select COL_NAME = CASE WHEN valid_name(INDEX_COL(''{0}'', {1}, {2} ){3})=0 THEN ''\"'' + INDEX_COL(''{0}'', {1}, {2} ) + ''\"'' ELSE INDEX_COL(''{0}'', {1}, {2} ) END, ", stringArray);
        string = string + ASQueryParser.parseQuery("INDEX_COLORDER(''{0}'',{1},{2})", stringArray);
        return string;
    }

    public String getAttributes(int n, int n2, int n3, int n4, boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string = bl ? "fillfactor" : "exp_row_size";
        if (n != 0) {
            if (n2 != 0) {
                if (n3 != 0) {
                    if (n4 != 0) {
                        stringBuffer.append("with max_rows_per_page = " + n);
                        stringBuffer.append(", " + string + " = " + n2);
                        stringBuffer.append(", reservepagegap = " + n3);
                        stringBuffer.append(", identity_gap = " + n4);
                    } else {
                        stringBuffer.append("with max_rows_per_page = " + n);
                        stringBuffer.append(", " + string + " = " + n2);
                        stringBuffer.append(", reservepagegap = " + n3);
                    }
                } else if (n4 != 0) {
                    stringBuffer.append("with max_rows_per_page = " + n);
                    stringBuffer.append(", " + string + " = " + n2);
                    stringBuffer.append(", identity_gap = " + n4);
                } else {
                    stringBuffer.append("with max_rows_per_page = " + n);
                    stringBuffer.append(", " + string + " = " + n2);
                }
            } else if (n3 != 0) {
                if (n4 != 0) {
                    stringBuffer.append("with max_rows_per_page = " + n);
                    stringBuffer.append(", reservepagegap = " + n3);
                    stringBuffer.append(", identity_gap = " + n4);
                } else {
                    stringBuffer.append("with max_rows_per_page = " + n);
                    stringBuffer.append(", reservepagegap = " + n3);
                }
            } else if (n4 != 0) {
                stringBuffer.append("with max_rows_per_page = " + n);
                stringBuffer.append(", identity_gap = " + n4);
            } else {
                stringBuffer.append("with max_rows_per_page = " + n);
            }
        } else if (n2 != 0) {
            if (n3 != 0) {
                if (n4 != 0) {
                    stringBuffer.append("with " + string + " = " + n2);
                    stringBuffer.append(", reservepagegap = " + n3);
                    stringBuffer.append(", identity_gap = " + n4);
                } else {
                    stringBuffer.append("with " + string + " = " + n2);
                    stringBuffer.append(", reservepagegap = " + n3);
                }
            } else if (n4 != 0) {
                stringBuffer.append("with " + string + " = " + n2);
                stringBuffer.append(", identity_gap = " + n4);
            } else {
                stringBuffer.append("with " + string + " = " + n2);
            }
        } else if (n3 != 0) {
            if (n4 != 0) {
                stringBuffer.append("with reservepagegap = " + n3);
                stringBuffer.append(", identity_gap = " + n4);
            } else {
                stringBuffer.append("with reservepagegap = " + n3);
            }
        } else if (n4 != 0) {
            stringBuffer.append("with identity_gap = " + n4);
        }
        return stringBuffer.toString();
    }
}

