/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.container;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLThread;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.LoginItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;

public class LoginContainer
extends DDLBaseContainer {
    private final int LOGIN_NAME = 5;
    private final String ATTR_POLICY_OPTION = "Policy_option";
    private final String ATTR_POLICY_VALUE = "Curr_value";

    public LoginContainer(DDLBaseContainer dDLBaseContainer) {
        this();
        this._parent = dDLBaseContainer;
    }

    public LoginContainer() {
    }

    @Override
    public void open(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        aSResultSet = new ASResultSet(aSConnection);
        Object[] objectArray = new String[]{this._parent == null ? LoginContainer.ignorePatternCharacters(this._ddlGlobalParameters.getObjectName()) : "%"};
        try {
            if (aSConnection.isLoginProfileApplicable()) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT dbname, language, fullname, suid, status, name, audflags, lpid, procid FROM master.dbo.syslogins WHERE name like ''{0}'' and (status & 512) != 512", objectArray), "LOGIN_QUERY_157");
            } else {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT dbname, language, fullname, suid, status, name, audflags, procid FROM master.dbo.syslogins WHERE name like ''{0}''", objectArray), "LOGIN_QUERY");
            }
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                LoginItem loginItem = new LoginItem(stringArray, this);
                DDLThread dDLThread = this._threadPool.getFreeThread();
                if (dDLThread != null) {
                    dDLThread.setItem(loginItem);
                } else {
                    loginItem.open(aSConnection);
                }
                this._children.addElement(loginItem);
            }
            if (aSResultSet != null) {
                aSResultSet.close();
                aSResultSet = null;
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L1", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("L2", exception, "INTERNAL_ERROR", 1);
        }
        if (this._children.size() == 0 && this._parent == null) {
            new DDLBaseException("L3", "LOGIN_NOTFOUND_ERROR", 2, (String)objectArray[0]);
        }
        try {
            if (aSConnection.isPwdComplexityApplicable() && aSConnection.hasRole("sso_role")) {
                this._ddlDepString = this.getPasswordComplexityOptions(aSConnection);
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L4", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("L5", exception, "INTERNAL_ERROR", 1);
        }
        if (this._children.size() > 0) {
            this.generateDDLs();
        } else if (this._children.size() == 0 && this._parent == null) {
            this._ddlString = "";
            this.setThreadPoolStatus();
            this._ddlGlobalParameters.setDDLStatus((byte)1);
        } else {
            this._ddlString = "";
        }
    }

    private String getPasswordComplexityOptions(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = "sp_passwordpolicy 'list'";
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            aSResultSet.open(string, "SP_LOGIN_PWD_OPTIONS_LIST");
            while (aSResultSet.getNextRow()) {
                String string2 = aSResultSet.getColumnString("Policy_option");
                String string3 = aSResultSet.getColumnString("Curr_value");
                stringBuffer.append("sp_passwordpolicy ").append("'set', '").append(string2).append("', ");
                if (aSConnection.isLoginProfileApplicable()) {
                    stringBuffer.append("'").append(string3).append("'");
                } else {
                    stringBuffer.append(string3);
                }
                stringBuffer.append("\ngo\n");
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("L6", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("L7", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }
}

