/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.io;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import com.sybase.ddlgen.io.StreamMasker;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Arrays;

public class PasswordConsole {
    public static final char[] readConsoleSecure(DDLGlobalParameters dDLGlobalParameters) throws DDLBaseException {
        char[] cArray = null;
        System.out.println();
        String string = dDLGlobalParameters.getLocalisedMessage("ENTER_PASSWORD");
        try {
            StreamMasker streamMasker = new StreamMasker(System.out, string, dDLGlobalParameters);
            Thread thread = new Thread(streamMasker);
            thread.start();
            PushbackInputStream pushbackInputStream = new PushbackInputStream(System.in);
            int n = pushbackInputStream.read();
            streamMasker.stop();
            thread.join(1L);
            if (n == -1) {
                throw new DDLBaseException("PC1", "EOF_SYSTEM_IN_ERROR", 1, dDLGlobalParameters);
            }
            if (System.out.checkError()) {
                throw new DDLBaseException("PC2", "IO_SYSTEM_OUT_ERROR", 1, dDLGlobalParameters);
            }
            pushbackInputStream.unread(n);
            cArray = PasswordConsole.readLineSecure(pushbackInputStream, dDLGlobalParameters);
        }
        catch (IOException iOException) {
            new DDLBaseException("PC3", (Exception)iOException, 1, dDLGlobalParameters);
        }
        catch (InterruptedException interruptedException) {
            new DDLBaseException("PC4", (Exception)interruptedException, 1, dDLGlobalParameters);
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final char[] readLineSecure(PushbackInputStream pushbackInputStream, DDLGlobalParameters dDLGlobalParameters) throws DDLBaseException {
        if (pushbackInputStream == null) {
            throw new DDLBaseException("PC5", "INPUT_STREAM_NULL_ERROR", 1, dDLGlobalParameters);
        }
        char[] cArray = null;
        char[] cArray2 = null;
        try {
            cArray = new char[128];
            int n = 0;
            block9: while (true) {
                int n2 = pushbackInputStream.read();
                switch (n2) {
                    case -1: 
                    case 10: {
                        break block9;
                    }
                    case 13: {
                        int n3 = pushbackInputStream.read();
                        if (n3 == 10 || n3 == -1) break block9;
                        pushbackInputStream.unread(n3);
                        break block9;
                    }
                    default: {
                        cArray = PasswordConsole.checkBuffer(cArray, n, dDLGlobalParameters);
                        cArray[n++] = (char)n2;
                        continue block9;
                    }
                }
                break;
            }
            cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, n);
        }
        catch (IOException iOException) {
            new DDLBaseException("PC6", (Exception)iOException, 1, dDLGlobalParameters);
        }
        finally {
            PasswordConsole.eraseChars(cArray);
        }
        return cArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final char[] checkBuffer(char[] cArray, int n, DDLGlobalParameters dDLGlobalParameters) throws DDLBaseException {
        if (cArray == null) {
            throw new DDLBaseException("PC7", "BUFFER_NULL_ERROR", 1, dDLGlobalParameters);
        }
        if (n < 0) {
            throw new DDLBaseException("PC8", "OFFSET_ERROR", 1, dDLGlobalParameters);
        }
        if (n < cArray.length) {
            return cArray;
        }
        try {
            char[] cArray2 = new char[n + 128];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            char[] cArray3 = cArray2;
            return cArray3;
        }
        finally {
            PasswordConsole.eraseChars(cArray);
        }
    }

    private static final void eraseChars(char[] cArray) {
        if (cArray != null) {
            Arrays.fill(cArray, ' ');
        }
    }
}

