/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.io;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.DDLGlobalParameters;
import java.io.PrintStream;

class StreamMasker
implements Runnable {
    private static final String TEN_BLANKS = "          ";
    private final PrintStream _out;
    private final String _promptOverwrite;
    private volatile boolean _doMasking;
    private DDLGlobalParameters _ddlGlobalParameters;
    private int _sleepTime = 1;

    public StreamMasker(PrintStream printStream, String string, DDLGlobalParameters dDLGlobalParameters) throws DDLBaseException {
        if (printStream == null) {
            throw new DDLBaseException("PC9", "OUTPUT_STREAM_NULL_ERROR", 1, dDLGlobalParameters);
        }
        if (string == null) {
            throw new DDLBaseException("PC10", "PROMPT_NULL_ERROR", 1, dDLGlobalParameters);
        }
        this._ddlGlobalParameters = dDLGlobalParameters;
        this._out = printStream;
        if (this._ddlGlobalParameters.getPassword() == null) {
            this._promptOverwrite = "\r" + string + TEN_BLANKS + "\r" + string;
        } else {
            this._promptOverwrite = "";
            this._sleepTime = 1000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        try {
            this._doMasking = true;
            while (this._doMasking) {
                this._out.print(this._promptOverwrite);
                this._out.flush();
                try {
                    Thread.currentThread();
                    Thread.sleep(this._sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            this._out.print('\r');
            for (int i = 0; i < this._promptOverwrite.length(); ++i) {
                this._out.print(' ');
            }
            this._out.print('\r');
        }
        finally {
            Thread.currentThread().setPriority(n);
        }
    }

    public void stop() {
        this._doMasking = false;
    }
}

