/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import com.sybase.ddlgen.util.Permission;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class CompiledObjectItem
extends DDLBaseItem {
    private String strDDL;
    private String _proxModeDDL = "";
    private String _triggerInfoDDL = "";
    private String _dbName;
    private String _ownerName;
    private String _objectName;
    private String _objectSPName;
    private String _objectID;
    private boolean _blnIsSourceCodeHidden;
    private boolean _blnIsQuotedIdentifier;
    private int _firstProcedureNumber;
    private int _procNumber = -1;
    private String _status2;
    public static String SETUSR;
    public static String USEDB;
    private final int NAME = 2;
    private final int OWNER = 1;
    private final int DBNAME = 0;
    private final int SYSSTAT2 = 3;
    private final int ID = 4;
    private final int ATTR_PARAM_NAME = 1;
    private final int ATTR_PARAM_TYPE = 2;
    private final int ATTR_PARAM_LENGTH = 3;
    private final int ATTR_PARAM_SCALE = 5;
    private final int ATTR_PARAM_STATUS = 6;
    private final int ATTR_PARAM_PRECISION = 4;
    private final int ATTR_PARAM_USERTYPE_ID = 7;
    private boolean _blnCanSetUser;
    private static final int CHAINED = 16;
    private static final int ANYMODE = 32;
    private static final int COMPILED_OBJECT_TEXT_HIDDEN = 1;

    public CompiledObjectItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._dbName = stringArray[0];
        this._ownerName = stringArray[1];
        this._objectName = stringArray[2];
        this._status2 = stringArray[3];
        this._objectID = stringArray[4];
        this._objectSPName = this._objectName;
        this._name = this._dbName + "." + this._ownerName + "." + this._objectName;
    }

    @Override
    public void open(ASConnection aSConnection) {
        String string;
        Object[] objectArray;
        ASResultSet aSResultSet;
        try {
            USEDB = ASQueryParser.parseQuery("use {0}", new String[]{this._dbName});
            aSConnection.executeCommand(USEDB, "SQL_USE_DB");
            SETUSR = ASQueryParser.parseQuery("setuser ''{0}''", new String[]{this._ownerName});
        }
        catch (SQLException sQLException) {
            new DDLBaseException("CO51", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("CO52", exception, "INTERNAL_ERROR", 1);
        }
        try {
            aSResultSet = new ASResultSet(aSConnection);
            objectArray = new String[]{this._dbName, this._objectID};
            aSResultSet.open(ASQueryParser.parseQuery("select status & 1 from {0}.dbo.syscomments where id = {1} ", objectArray), "COMPILED_OBJECT_TEXT_HIDDEN_QUERY");
            while (aSResultSet.getNextRow()) {
                string = aSResultSet.getColumnsAsArray()[0];
                if ((Integer.parseInt(string) & 1) != 1) continue;
                this._ddlString = "--" + this._parent.getDDLGlobalParameters().getLocalisedMessage("COMPILED_OBJECT_TEXT_HIDDEN") + ":" + this._name + "\n\n";
                this._blnIsSourceCodeHidden = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this._blnIsQuotedIdentifier) {
            try {
                aSResultSet = new ASResultSet(aSConnection);
                objectArray = new String[]{this._dbName, this._ownerName, this._objectName, this._parent.getType()};
                aSResultSet.open(ASQueryParser.parseQuery("SELECT status & 4 from {0}.dbo.syscomments WHERE id=(SELECT id FROM {0}.dbo.sysobjects WHERE name=''{2}'' AND type=''{3}'' AND uid = (SELECT uid FROM {0}.dbo.sysusers WHERE name=''{1}''))", objectArray), "QUOTED_DEFINITION_QUERY");
                if (aSResultSet.getNextRow()) {
                    boolean bl = this._blnIsQuotedIdentifier = aSResultSet.getColumnInt(1) == 4;
                    if (this._blnIsQuotedIdentifier) {
                        this._objectSPName = "\"" + this._objectName + "\"";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = false;
        if (this._parent.getType().equals("P")) {
            if (this._objectName.lastIndexOf(";") == -1) {
                bl = this.isProcedureGroup(aSConnection);
                if (bl) {
                    this.strDDL = this.getTextProcedureGroup(aSConnection);
                }
            } else {
                int n = this._objectName.lastIndexOf(";");
                try {
                    if (this._objectName.endsWith("\"")) {
                        string = this._objectName.substring(n + 1);
                        this._procNumber = new Integer(string.substring(0, string.indexOf("\"")));
                    } else {
                        this._procNumber = new Integer(this._objectName.substring(n + 1));
                    }
                }
                catch (Exception exception) {
                    new DDLBaseException("CO53", exception, "INTERNAL_ERROR", 1);
                }
                if (this._procNumber < 0) {
                    new DDLBaseException("CO54", "COMPILEDOBJECT_NOTFOUND_ERROR", 2, this._dbName + "." + this._ownerName + "." + this._objectName);
                } else {
                    this._objectName = this._objectName.substring(0, n);
                    this._objectSPName = this._blnIsQuotedIdentifier ? "\"" + this._objectName + "\"" : this._objectName;
                }
            }
        }
        if (!bl) {
            this.strDDL = this.getCompiledObjectText(aSConnection);
        }
        if (this._parent.getType().equals("XP")) {
            if (this.strDDL != null && !this._blnIsSourceCodeHidden) {
                this.strDDL = this.getESPDDL(aSConnection);
            } else {
                this._ddlString = this.strDDL;
                return;
            }
        }
        if (this._parent.getType().equals("XP") || this._parent.getType().equals("P")) {
            this.setProcxModeDDL(aSConnection);
        }
        if (this._parent.getType().equals("TR")) {
            this.setTriggerInfoDDL(aSConnection);
        }
        if (this.strDDL == null && this._parent != null) {
            new DDLBaseException("CO55", "COMPILEDOBJECT_NOTFOUND_ERROR", 2, this._dbName + "." + this._ownerName + "." + this._objectName);
        } else {
            this.strDDL = this.strDDL + Permission.getPermissions(this._dbName, this._ownerName, this._objectName, this._objectID, aSConnection);
        }
        this._ddlString = this.generateDDL();
    }

    @Override
    public String[] getIfExistsParameters() {
        if (this._blnIsSourceCodeHidden || this._parent.getType().equals("V") && this._objectName.equals("sysquerymetrics")) {
            return null;
        }
        String string = this._parent.getObjectName(this._parent.getType()).toLowerCase();
        if (string.indexOf("procedure") != -1) {
            string = "procedure";
        } else if (string.indexOf("function") != -1) {
            string = "function";
        }
        String string2 = "SELECT 1 FROM sysobjects o, sysusers u WHERE o.uid=u.uid AND o.name = ''{0}'' AND u.name = ''{1}'' AND o.type = ''{2}''";
        if (this._parent.getType().equalsIgnoreCase("F")) {
            string2 = "SELECT 1 FROM sysobjects o, sysusers u WHERE o.uid=u.uid AND o.name = ''{0}'' AND u.name = ''{1}'' AND (o.type = ''F'' or o.type = ''SF'')";
        }
        return new String[]{this._dbName, this._ownerName, this._parent.getParent() == null ? ASQueryParser.parseQuery(string2, new String[]{this._objectName, this._ownerName, this._parent.getType()}) : null, ASQueryParser.parseQuery("drop {0} {1}", new String[]{string, this._objectName})};
    }

    @Override
    public String generateDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._parent.getType().equals("V") && this._objectName.equals("sysquerymetrics")) {
            stringBuffer.append(this.strDDL);
            return stringBuffer.toString();
        }
        if (this._parent.getDDLGlobalParameters().excludeIfExistsDDL() && !this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
            stringBuffer.append("use " + this._dbName + "\ngo\n\n");
            this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
        }
        stringBuffer.append(SETUSR + "\n").append("go ").append("\n\n");
        if (this._blnIsQuotedIdentifier) {
            stringBuffer.append("set quoted_identifier on").append("\n").append("go ").append("\n\n").append(this.strDDL).append(this._proxModeDDL).append(this._triggerInfoDDL).append("set quoted_identifier off").append("\n").append("go ").append("\n\n");
        } else {
            stringBuffer.append(this.strDDL).append(this._proxModeDDL).append(this._triggerInfoDDL);
        }
        stringBuffer.append("setuser").append("\n").append("go ").append("\n");
        return stringBuffer.toString();
    }

    private String getCompiledObjectText(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        Object var3_3 = null;
        Object var4_4 = null;
        boolean bl = false;
        Connection connection = aSConnection.getConnection();
        String string = this._parent.getDDLGlobalParameters().getObjectName();
        if (this._parent.getDDLGlobalParameters().getObjectType().equals("V")) {
            if (string.equals("sysquerymetrics") || string.indexOf(".") >= 0 && string.substring(string.lastIndexOf(".") + 1, string.length()).equals("sysquerymetrics")) {
                stringBuffer.append("-- Cannot Generate DDL for system view(s).").append("\n\n");
                return stringBuffer.toString();
            }
            if ((string.equals("%") || string.indexOf(".") >= 0 && string.substring(string.lastIndexOf(".") + 1, string.length()).equals("%")) && this._objectName.equals("sysquerymetrics")) {
                if (this.isOnlyOneViewInCurrentDB(aSConnection)) {
                    stringBuffer.append("-- Cannot Generate DDL for system view(s).").append("\n\n");
                    return stringBuffer.toString();
                }
                return stringBuffer.toString();
            }
        } else if (this._parent.getType().equals("V") && this._objectName.equals("sysquerymetrics")) {
            return stringBuffer.toString();
        }
        try {
            Object[] objectArray;
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            if (this._procNumber == -1) {
                objectArray = new String[]{this._dbName, this._objectID};
                aSResultSet.open(ASQueryParser.parseQuery("select text = text  from {0}.dbo.syscomments  where id = {1} order by colid2, colid", objectArray), "COMPILED_OBJECT_TEXT_QUERY");
            } else {
                objectArray = new String[]{this._dbName, this._objectID, this._procNumber + ""};
                aSResultSet.open(ASQueryParser.parseQuery("select text = text  from {0}.dbo.syscomments  where id = {1} and number = {2} order by colid2, colid", objectArray), "PROCEDURE_NUMBER_TEXT_QUERY");
            }
            while (aSResultSet.getNextRow()) {
                stringBuffer.append(aSResultSet.getColumnString("text"));
            }
            if (this._parent.getType().equals("D") && stringBuffer.toString().toLowerCase().trim().startsWith("default")) {
                new DDLBaseException("CO56", "SYSTEM_GENERATED_DEFAULT_ERROR", 2, this._objectName);
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("CO57", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("CO58", exception, "INTERNAL_ERROR", 1);
        }
        if (var4_4 != null) {
            var4_4 = null;
        }
        if (var3_3 != null) {
            var3_3 = null;
        }
        if (!stringBuffer.toString().equals("") && !this._parent.getType().equals("XP")) {
            stringBuffer.append("\n").append("go ").append("\n\n");
        }
        return stringBuffer.toString();
    }

    private boolean isOnlyOneViewInCurrentDB(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select name from {0}.dbo.sysobjects where type = ''V''", objectArray), "VIEW_NAME_QUERY");
                int n = 0;
                while (aSResultSet.getNextRow()) {
                    ++n;
                    if (!aSResultSet.getColumnString(1).equals("sysquerymetrics")) continue;
                    bl2 = true;
                }
                aSResultSet.close();
                if (n == 1 && bl2) {
                    bl = true;
                }
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            new DDLBaseException("CO70", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
        return bl;
    }

    private String getESPDDL(ASConnection aSConnection) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("CREATE PROCEDURE " + this._ownerName + "." + this._objectName + "\n");
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._objectID};
            if (aSConnection.getServerVersion().compareTo("12.0") >= 0) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT C.name, isnull(X.xtname, isnull(get_xtypename(C.xtype,C.xdbid), T.name)), C.length, C.prec, C.scale, C.status, T.usertype FROM {0}.dbo.syscolumns C, {0}.dbo.systypes T, {0}.dbo.sysxtypes X, {0}.dbo.sysobjects O WHERE C.usertype *= T.usertype AND C.xtype *= X.xtid AND C.id = O.id AND O.id = {1} AND O.type = ''XP'' ORDER BY C.colid", objectArray), "ESP_QUERY");
            } else {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT C.name, T.name, C.length, C.prec, C.scale, C.status, T.usertype FROM {0}.dbo.syscolumns C, {0}.dbo.systypes T, {0}.dbo.sysobjects O WHERE C.usertype *= T.usertype AND C.id = O.id AND O.id = {1} AND O.type = ''XP'' ORDER BY C.colid", objectArray), "ESP_QUERY_1192");
            }
            while (aSResultSet.getNextRow()) {
                bl = true;
                stringBuffer.append("\t");
                stringBuffer.append(aSResultSet.getColumnString(1));
                stringBuffer.append(" ");
                String string = aSResultSet.getColumnString(2);
                if (string.equals("binary") || string.equals("char") || string.equals("nchar") || string.equals("nvarchar") || string.equals("unichar") || string.equals("univarchar") || string.equals("varbinary") || string.equals("varchar")) {
                    string = string + "(" + aSResultSet.getColumnString(3) + ")";
                }
                if (string.equals("float")) {
                    int n = new Integer(aSResultSet.getColumnString(3));
                    string = string + "(" + n * 2 + ")";
                }
                if (!aSResultSet.getColumnString(4).equals("") && !aSResultSet.getColumnString(5).equals("") && aSResultSet.getColumnInt(7) <= 100) {
                    string = string + "(" + aSResultSet.getColumnString(4) + "," + aSResultSet.getColumnString(5) + ") ";
                }
                stringBuffer.append(string);
                stringBuffer.append(",\n");
            }
            if (aSResultSet != null) {
                aSResultSet = null;
            }
            if (bl) {
                stringBuffer.setCharAt(stringBuffer.length() - 2, ' ');
            }
            stringBuffer.append("AS EXTERNAL NAME '");
            stringBuffer.append(this.strDDL);
            stringBuffer.append("'\ngo\n\n");
            stringBuffer.append(this._proxModeDDL);
        }
        catch (SQLException sQLException) {
            new DDLBaseException("CO59", (Exception)sQLException, 2, this._objectName);
        }
        catch (Exception exception) {
            new DDLBaseException("CO60", exception, "INTERNAL_ERROR", 1);
        }
        return stringBuffer.toString();
    }

    private boolean isProcedureGroup(ASConnection aSConnection) {
        int n = 1;
        Object[] objectArray = new String[]{this._dbName, this._name};
        ASResultSet aSResultSet = new ASResultSet(aSConnection);
        try {
            aSResultSet.open(ASQueryParser.parseQuery("select count(distinct number),min(number) from {0}.dbo.syscomments where id = object_id(''{1}'')", objectArray), "PROC_GROUP_QUERY");
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                n = new Integer(stringArray[0]);
                if (stringArray[1].equals("")) continue;
                this._firstProcedureNumber = new Integer(stringArray[1]);
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("CO61", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("CO62", exception, "INTERNAL_ERROR", 1);
        }
        return n > 1;
    }

    private String getTextProcedureGroup(ASConnection aSConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        Object var3_3 = null;
        Object var4_4 = null;
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._objectID};
            aSResultSet.open(ASQueryParser.parseQuery("select text = text  from {0}.dbo.syscomments  where id = {1} order by colid2, colid", objectArray), "COMPILED_OBJECT_TEXT_QUERY");
            Vector vector = this.getProcedureRowCount(aSConnection);
            int n = 0;
            int n2 = (Integer)vector.elementAt(n);
            int n3 = 0;
            while (aSResultSet.getNextRow()) {
                if (n2 == n3) {
                    stringBuffer.append("\n").append("go ").append("\n\n");
                    n3 = 0;
                    n2 = (Integer)vector.elementAt(++n);
                }
                stringBuffer.append(aSResultSet.getColumnString("text"));
                ++n3;
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("CO63", (Exception)sQLException, 2, this._objectName);
        }
        catch (Exception exception) {
            new DDLBaseException("CO64", exception, "INTERNAL_ERROR", 1);
        }
        if (var4_4 != null) {
            var4_4 = null;
        }
        if (var3_3 != null) {
            var3_3 = null;
        }
        return stringBuffer.append("\n").append("go ").append("\n\n").toString();
    }

    private void setProcxModeDDL(ASConnection aSConnection) {
        try {
            if (this._status2 != null) {
                int n = Integer.parseInt(this._status2);
                this._proxModeDDL = "\nsp_procxmode '" + this._objectSPName + "', ";
                this._proxModeDDL = (n & 0x10) == 16 ? this._proxModeDDL + "chained" : ((n & 0x20) == 32 ? this._proxModeDDL + "anymode" : this._proxModeDDL + "unchained");
                this._proxModeDDL = this._proxModeDDL + "\ngo \n\n";
            }
        }
        catch (Exception exception) {
            new DDLBaseException("CO65", exception, "INTERNAL_ERROR", 1);
        }
    }

    private void setTriggerInfoDDL(ASConnection aSConnection) {
        try {
            boolean bl = false;
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._objectID};
            aSResultSet.open(ASQueryParser.parseQuery("SELECT 1 FROM {0}.dbo.sysobjects trig, {0}.dbo.sysobjects tab WHERE trig.id = {1} AND trig.deltrig = tab.id AND ((trig.id = tab.deltrig and tab.sysstat2 & 2097152 <> 0) OR (trig.id = tab.updtrig and tab.sysstat2 & 4194304 <> 0) OR (trig.id = tab.instrig and tab.sysstat2 & 1048576 <> 0))", objectArray), "TRIGGER_ENABLED_ATTR");
            if (aSResultSet.getNextRow()) {
                bl = true;
            }
            if (!bl) {
                return;
            }
            String string = "";
            String string2 = "";
            StringBuffer stringBuffer = new StringBuffer();
            aSResultSet.open(ASQueryParser.parseQuery("SELECT o.name, u.name from {0}.dbo.sysobjects o, {0}.dbo.sysusers u  where u.uid = o.uid and (deltrig = {1} OR instrig = {1} OR updtrig = {1})", objectArray), "TRIGGER_TABLE_NAME");
            while (aSResultSet.getNextRow()) {
                String[] stringArray = aSResultSet.getColumnsAsArray();
                string = stringArray[0];
                string2 = stringArray[1];
            }
            stringBuffer.append("\n\n").append("alter").append(" ");
            stringBuffer.append("table").append(" ");
            stringBuffer.append(string2).append(".").append(string).append(" ");
            stringBuffer.append("disable").append(" ").append("trigger");
            stringBuffer.append(" ").append(this._ownerName).append(".").append(this._objectName);
            stringBuffer.append("\n").append("go ").append("\n\n");
            this._triggerInfoDDL = stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            new DDLBaseException("CO66", (Exception)sQLException, 2, this._objectName);
        }
        catch (Exception exception) {
            new DDLBaseException("CO67", exception, "INTERNAL_ERROR", 1);
        }
    }

    private Vector getProcedureRowCount(ASConnection aSConnection) {
        Vector<Integer> vector = new Vector<Integer>();
        try {
            ASResultSet aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._dbName, this._objectID};
            aSResultSet.open(ASQueryParser.parseQuery("select procrows = count(text) from {0}.dbo.syscomments where id = {1} group by number", objectArray), "PROC_GROUP_ROW_NUM");
            while (aSResultSet.getNextRow()) {
                vector.addElement(new Integer(aSResultSet.getColumnInt(1)));
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("CO68", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("CO69", exception, "INTERNAL_ERROR", 1);
        }
        return vector;
    }
}

