/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;

public class DatabaseDeviceItem
extends DDLBaseItem {
    private static final int DEVICE_NAME = 0;
    private static final int PHYSICAL_NAME = 1;
    private static final int MIRROR_NAME = 2;
    private static final int DEVICE_SIZE = 3;
    private static final int STATUS = 4;
    private static final int STATUS2 = 5;
    private static final int DEVICE_INSTANCENAME = 6;
    private String _physicalName = "";
    private String _mirrorName;
    private String _size = "";
    private String _instanceName = "";
    private String _expansionPolicy;
    private int _status;
    private int _status2;
    private String[] _columns;
    private boolean _isSerialWrites = false;
    private boolean _isSkipAllocApplicable = false;
    private final int STATUS_SERIAL_WRITES = 32;
    private final int DSYNC_FLAG = 16384;
    private final int DIRECTIO_FLAG = 1;
    private static final int STATUS_IN_MEMORY_DEV = 8;

    public DatabaseDeviceItem() {
    }

    public DatabaseDeviceItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
    }

    @Override
    public void open(ASConnection aSConnection) throws DDLBaseException {
        this.load();
        this._expansionPolicy = this.getExpansionPolicy(aSConnection);
        this._isSkipAllocApplicable = aSConnection.getServerVersion().compareTo("15.0.2") >= 0;
        this._ddlString = this.generateDDL();
    }

    private void load() throws DDLBaseException {
        String string;
        this._name = this._columns[0];
        if (this._name.equals("")) {
            throw new DDLBaseException("DBD51", "DATABASE_DEVICE_NAME_NULL_ERROR", 2);
        }
        this._physicalName = this._columns[1];
        if (this._physicalName.equals("")) {
            throw new DDLBaseException("DBD52", "DATABASE_DEVICE_PHYNAME_NULL_ERROR", 2, this._name);
        }
        this._mirrorName = this._columns[2];
        this._size = this._columns[3];
        if (this._size.equals("")) {
            throw new DDLBaseException("DBD53", "DATABASE_DEVICE_SIZE_NULL_ERROR", 2, this._name);
        }
        String string2 = this._columns[4];
        if (!string2.equals("")) {
            this._status = new Integer(string2);
        }
        if (this._columns.length > 5 && !(string = this._columns[5]).equals("")) {
            this._status2 = new Integer(string);
        }
        if (!this._mirrorName.equals("")) {
            this.setWriteOption();
        }
        if (this._columns.length > 6) {
            this._instanceName = this._columns[6];
        }
    }

    @Override
    public String[] getIfExistsParameters() {
        return new String[]{"master", null, ASQueryParser.parseQuery("SELECT 1 FROM master.dbo.sysdevices WHERE name = ''{0}''", new String[]{this._name}), ASQueryParser.parseQuery("exec sp_dropdevice {0}", new String[]{this._name})};
    }

    private String getExpansionPolicy(ASConnection aSConnection) {
        try {
            if (aSConnection.isAutoExpansionApplicable()) {
                String string = "";
                String string2 = "";
                String string3 = "";
                StringBuffer stringBuffer = new StringBuffer();
                String string4 = ASQueryParser.parseQuery("sp_dbextend ''list'', ''device'', ''{0}'' ", new String[]{this._name});
                ASResultSet aSResultSet = new ASResultSet(aSConnection);
                aSResultSet.open(string4, "SP_EXTEND_DEV_POLICIES");
                while (aSResultSet.getNextRow()) {
                    if (!aSResultSet.getColumnString("name").equals(this.getName())) continue;
                    if (aSResultSet.getColumnString("item").equals("growby")) {
                        string = aSResultSet.getColumnString("value");
                    }
                    if (!aSResultSet.getColumnString("item").equals("maxsize")) continue;
                    string2 = aSResultSet.getColumnString("value");
                }
                if (!string2.equals("") || !string.equals("")) {
                    string3 = string.equals("") ? "null ,'" + string2 + "'" : (string2.equals("") ? "'" + string + "'" : "'" + string + "'" + ",'" + string2 + "'");
                }
                if (!string3.equals("")) {
                    stringBuffer.append("sp_dbextend 'set', 'device'").append(", '").append(this._name).append("', ").append(string3).append("\n").append("go ").append("\n");
                    return stringBuffer.toString();
                }
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("DBD55", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("DBD56", exception, "INTERNAL_ERROR", 1);
        }
        return "";
    }

    private void setWriteOption() {
        if ((this._status & 0x20) != 0) {
            this._isSerialWrites = true;
        }
    }

    private boolean isDirectIoOn() {
        return (this._status2 & 1) != 0;
    }

    private boolean isDsyncOn() {
        return (this._status & 0x4000) != 0;
    }

    private boolean isInMemoryDataBaseDev() {
        return (this._status2 & 8) != 0;
    }

    @Override
    public String generateDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._parent.getDDLGlobalParameters().excludeIfExistsDDL() && !this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
            stringBuffer.append("use master").append("\n").append("go ").append("\n\n");
            this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
        }
        stringBuffer.append("disk").append(" ").append("init ");
        stringBuffer.append(" ").append("name ").append(" = ").append("'").append(this._name).append("',\n");
        stringBuffer.append("physname ").append(" = ").append("'").append(this._physicalName).append("',\n");
        stringBuffer.append("size ").append(" = '").append(this._size).append("M'");
        if (this.isInMemoryDataBaseDev()) {
            stringBuffer.append(", ").append("type").append(" = ").append("'").append("inmemory").append("'");
            stringBuffer.append("\n").append("go ").append("\n");
        } else {
            if (!this._name.equals("master") && !this._name.equals("master_companion")) {
                if (this.isDsyncOn()) {
                    stringBuffer.append(", ").append("dsync").append(" = ").append("true");
                } else if (this.isDirectIoOn()) {
                    stringBuffer.append(", ").append("directio").append(" = ").append("true");
                } else {
                    stringBuffer.append(", ").append("dsync").append(" = ").append("false");
                }
            }
            if (this._isSkipAllocApplicable) {
                stringBuffer.append(", ").append("skip_alloc").append(" = ").append("true");
            }
            if (this._instanceName != null && this._instanceName.length() > 0) {
                stringBuffer.append(", ").append("instance").append(" = '").append(this._instanceName).append("'");
            }
            stringBuffer.append("\n").append("go ").append("\n\n");
            if (!this._mirrorName.equals("")) {
                stringBuffer.append("disk").append(" ").append("mirror ");
                stringBuffer.append("  ").append("name ").append(" = ").append("'").append(this._name).append("' ,");
                stringBuffer.append("  ").append("mirror ").append(" = ").append("'").append(this._mirrorName).append("',\n");
                String string = "serial";
                if (!this._isSerialWrites) {
                    string = "noserial";
                }
                stringBuffer.append("writes").append(" = ").append(string).append("\n");
                stringBuffer.append("go ").append("\n\n");
            }
            if (!this._expansionPolicy.equals("")) {
                stringBuffer.append(this._expansionPolicy);
            }
        }
        return stringBuffer.toString();
    }
}

