/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class LogicalClusterItem
extends DDLBaseItem {
    private static final int NAME = 0;
    private static final int LOADPROFILE = 1;
    private static final int SYSTEM_VIEW = 2;
    private static final int STARTUP_MODE = 3;
    private static final int FAILOVER_MODE = 4;
    private static final int DOWNROUTING_MODE = 5;
    private static final int ROLES = 6;
    private static final int LOGIN_DISTRIBUTION = 7;
    private String[] _columns;
    private Vector _baseInstances = new Vector();
    private Vector _failoverInstances = new Vector();
    private Vector _routes = new Vector();
    private String _failoverMode = "";
    private boolean _isFailtoAny = false;
    private boolean _hasOpenRole = false;

    public LogicalClusterItem() {
    }

    public LogicalClusterItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
    }

    @Override
    public String generateDDL() {
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._parent.getDDLGlobalParameters().excludeIfExistsDDL() && !this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
            this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
        }
        Object[] objectArray3 = new String[]{this._name};
        String string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''create'', ''{0}''", objectArray3);
        stringBuffer.append(string).append("\n\n");
        Object[] objectArray4 = new String[]{this._name, this._columns[1]};
        string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''set'', ''{0}'', ''load_profile'', ''{1}''", objectArray4);
        stringBuffer.append(string).append("\n\n");
        for (n = 0; n < this._baseInstances.size(); ++n) {
            objectArray2 = (Object[])this._baseInstances.get(n);
            objectArray = new String[]{this._name, objectArray2};
            string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''add'', ''{0}'', ''instance'', ''{1}''", objectArray);
            stringBuffer.append(string).append("\n");
        }
        if (this._baseInstances.size() > 0) {
            stringBuffer.append("\n");
        }
        for (n = 0; n < this._failoverInstances.size(); ++n) {
            objectArray2 = (String[])this._failoverInstances.get(n);
            objectArray = new String[]{this._name, objectArray2[0], objectArray2[1]};
            string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''add'', ''{0}'', ''instance'', ''{1}''", objectArray);
            stringBuffer.append(string).append("\n");
        }
        if (this._failoverInstances.size() > 0) {
            stringBuffer.append("\n");
        }
        for (n = 0; n < this._routes.size(); ++n) {
            objectArray2 = (String[])this._routes.get(n);
            objectArray = new String[]{this._name, objectArray2[1], objectArray2[0]};
            string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''add'', ''{0}'', ''route'', ''{1}'', ''{2}''", objectArray);
            stringBuffer.append(string).append("\n");
        }
        if (this._routes.size() > 0) {
            stringBuffer.append("\n");
        }
        Object[] objectArray5 = new String[]{this._name, "system_view", this._columns[2]};
        string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", objectArray5);
        stringBuffer.append(string).append("\n\n");
        objectArray2 = new String[]{this._name, "startup", this._columns[3]};
        string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", objectArray2);
        stringBuffer.append(string).append("\n\n");
        objectArray = new String[]{this._name, "failover", this._failoverMode};
        string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", objectArray);
        stringBuffer.append(string).append("\n\n");
        Object[] objectArray6 = new String[]{this._name, "fail_to_any", Boolean.toString(this._isFailtoAny)};
        string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", objectArray6);
        stringBuffer.append(string).append("\n\n");
        Object[] objectArray7 = new String[]{this._name, "down_routing", this._columns[5]};
        string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", objectArray7);
        stringBuffer.append(string).append("\n\n");
        Object[] objectArray8 = new String[]{this._name, "login_distribution", this._columns[7]};
        string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}'', ''{2}''", objectArray8);
        stringBuffer.append(string).append("\n\n");
        if (this._hasOpenRole) {
            Object[] objectArray9 = new String[]{this._name, "open"};
            string = ASQueryParser.parseQuery("exec sp_cluster ''logical'', ''set'', ''{0}'', ''{1}''", objectArray9);
            stringBuffer.append(string).append("\n\n");
        }
        stringBuffer.append("go ");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void load() {
        this._name = this._columns[0];
        String string = this._columns[4];
        if (string.endsWith("with fail_to_any")) {
            this._isFailtoAny = true;
            this._failoverMode = string.substring(0, string.indexOf("with fail_to_any")).trim();
        } else {
            this._isFailtoAny = false;
            this._failoverMode = string;
        }
        String string2 = this._columns[6];
        if (string2 == null) {
            this._hasOpenRole = false;
        } else if (string2.equals("open")) {
            this._hasOpenRole = true;
        }
    }

    private void setBaseInstances(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select InstanceName from monLogicalClusterInstance where LogicalClusterName like ''{0}'' and Type = ''base''", objectArray), "LOGICAL_CLUSTER_INIT_BASE_INSTANCES");
                while (aSResultSet.getNextRow()) {
                    this._baseInstances.addElement(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("LC51", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("LC52", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
    }

    private void setFailoverInstances(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select InstanceName, FailoverGroup from monLogicalClusterInstance where LogicalClusterName like ''{0}'' and Type = ''failover''", objectArray), "LOGICAL_CLUSTER_INIT_FAILOVER_INSTANCES");
                while (aSResultSet.getNextRow()) {
                    String[] stringArray = new String[]{aSResultSet.getColumnsAsArray()[0], aSResultSet.getColumnsAsArray()[1]};
                    this._failoverInstances.addElement(stringArray);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("LC53", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("LC54", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
    }

    private void setRoutess(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select RouteKey, RouteType from monLogicalClusterRoute where LogicalClusterName like ''{0}''", objectArray), "LOGICAL_CLUSTER_INIT_ROUTES");
                while (aSResultSet.getNextRow()) {
                    String[] stringArray = new String[]{aSResultSet.getColumnsAsArray()[0], aSResultSet.getColumnsAsArray()[1]};
                    this._routes.addElement(stringArray);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("LC55", (Exception)sQLException, 2, this._name);
        }
        catch (Exception exception) {
            new DDLBaseException("LC56", exception, "INTERNAL_ERROR", 1);
        }
        aSResultSet = null;
    }

    @Override
    public void open(ASConnection aSConnection) throws DDLBaseException {
        this.load();
        this.setBaseInstances(aSConnection);
        this.setFailoverInstances(aSConnection);
        this.setRoutess(aSConnection);
        this._ddlString = this.generateDDL();
    }

    @Override
    public String[] getIfExistsParameters() {
        return new String[]{null, null, ASQueryParser.parseQuery("SELECT 1 FROM monLogicalCluster where Name = ''{0}''", new String[]{this._name}), ASQueryParser.parseQuery("exec sp_cluster 'logical', 'drop', ''{0}'', 'cluster'", new String[]{this._name})};
    }
}

