/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.container.RoleContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;
import com.sybase.ddlgen.sql.ASResultSet;
import com.sybase.ddlgen.util.Permission;
import java.sql.SQLException;
import java.util.Vector;

public class RoleItem
extends DDLBaseItem {
    private static final int ROLE_NAME = 0;
    private static final int ROLE_PASSWORD = 1;
    private StringBuffer _permissions = new StringBuffer();
    private String[] _columns;
    private Vector logins = new Vector();
    private Vector exclusiveRoles = new Vector();
    private Vector activatedRoles = new Vector();
    private Vector hierarchyRoles = new Vector();
    private int passwordExpiration;
    private boolean hasPassword;
    private int maxFailedLogins;
    private int minPasswordLength;

    public RoleItem() {
    }

    public RoleItem(String[] stringArray, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
    }

    @Override
    public void open(ASConnection aSConnection) throws DDLBaseException {
        this.load();
        this.setRolesAssigned(aSConnection);
        this.setLogins(aSConnection);
        this.setExclusiveActivationRoles(aSConnection);
        this.setPasswordParameters(aSConnection);
        this.setPermissions(aSConnection);
        this._ddlString = this.generateDDL();
    }

    private void load() throws DDLBaseException {
        this._name = this._columns[0];
        boolean bl = this.hasPassword = this._columns[1] != null && this._columns[1].length() > 0;
        if (this._name.equals("")) {
            new DDLBaseException("RO51", "ROLE_NAME_NULL_ERROR", 2);
        }
    }

    private void setRolesAssigned(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT role_name(a.object_info1) FROM master.dbo.sysattributes a, master.dbo.syssrvroles r WHERE a.class = 8 and a.object = r.srid and r.name = ''{0}'' and a.attribute = 2 order by 1", objectArray), "ROLES_HIERARCHY");
                while (aSResultSet.getNextRow()) {
                    this.hierarchyRoles.addElement(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("RO52", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("RO53", exception, "INTERNAL_ERROR", 1);
        }
        if (aSResultSet != null) {
            aSResultSet = null;
        }
    }

    private void setLogins(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("SELECT l.name FROM master.dbo.syslogins l, master.dbo.sysloginroles lr WHERE lr.srid = role_id(''{0}'') and l.suid = lr.suid  order by 1", objectArray), "ROLE_LOGINS");
                while (aSResultSet.getNextRow()) {
                    this.logins.addElement(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("RO54", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("RO55", exception, "INTERNAL_ERROR", 1);
        }
        if (aSResultSet != null) {
            aSResultSet = null;
        }
    }

    private void setExclusiveActivationRoles(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery("select role_name(object), ''membership'' from master.dbo.sysattributes where class = 8 and object_info1 = role_id(''{0}'') and attribute = 0 union select role_name(object), ''activation'' from master.dbo.sysattributes where class = 8 and object_info1 = role_id(''{0}'') and attribute = 1 union select role_name(object_info1), ''membership'' from master.dbo.sysattributes where class = 8 and object = role_id(''{0}'') and attribute = 0 union select role_name(object_info1), ''activation'' from master.dbo.sysattributes where class = 8 and object = role_id(''{0}'') and attribute = 1 order by 1", objectArray), "ROLES_EXCLUSIVE_ACTIVATION");
                while (aSResultSet.getNextRow()) {
                    if (aSResultSet.getColumnsAsArray()[1].equals("membership")) {
                        this.exclusiveRoles.addElement(aSResultSet.getColumnsAsArray()[0]);
                        continue;
                    }
                    this.activatedRoles.addElement(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("RO56", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("RO57", exception, "INTERNAL_ERROR", 1);
        }
        if (aSResultSet != null) {
            aSResultSet = null;
        }
    }

    private void setPasswordParameters(ASConnection aSConnection) {
        ASResultSet aSResultSet = null;
        try {
            aSResultSet = new ASResultSet(aSConnection);
            Object[] objectArray = new String[]{this._name};
            if (aSResultSet != null) {
                aSResultSet.open(ASQueryParser.parseQuery(" select int_value, attribute from master.dbo.sysattributes where object_cinfo =''role'' and  class = 14 and object = role_id(''{0}'')", objectArray), "ROLES_PASSWORD_PARAMETERS");
                while (aSResultSet.getNextRow()) {
                    if (aSResultSet.getColumnsAsArray()[1].equals("0")) {
                        this.passwordExpiration = Integer.parseInt(aSResultSet.getColumnsAsArray()[0]);
                        continue;
                    }
                    if (aSResultSet.getColumnsAsArray()[1].equals("1")) {
                        this.minPasswordLength = Integer.parseInt(aSResultSet.getColumnsAsArray()[0]);
                        continue;
                    }
                    this.maxFailedLogins = Integer.parseInt(aSResultSet.getColumnsAsArray()[0]);
                }
                aSResultSet.close();
            }
        }
        catch (SQLException sQLException) {
            new DDLBaseException("RO58", sQLException, 2);
        }
        catch (Exception exception) {
            new DDLBaseException("RO59", exception, "INTERNAL_ERROR", 1);
        }
        if (aSResultSet != null) {
            aSResultSet = null;
        }
    }

    private void setPermissions(ASConnection aSConnection) {
        Vector vector = ((RoleContainer)this._parent).getDatabases();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                String string2 = Permission.getPermissions(string, this._name, aSConnection);
                if (string2.equals("")) continue;
                this._permissions.append("use").append(" ").append(string).append("\n").append("go ").append("\n");
                this._permissions.append(string2);
            }
        }
    }

    @Override
    public String[] getIfExistsParameters() {
        return new String[]{"master", null, ASQueryParser.parseQuery("SELECT 1 FROM master.dbo.syssrvroles where name = ''{0}''", new String[]{this._name}), ASQueryParser.parseQuery("DROP ROLE ''{0}'' with override", new String[]{this._name})};
    }

    @Override
    public String generateDDL() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this._parent.getDDLGlobalParameters().excludeIfExistsDDL() && !this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
            stringBuffer.append("use master").append("\n").append("go ").append("\n\n");
            this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
        }
        stringBuffer.append("create ").append("role ").append(this._name);
        if (this.hasPassword) {
            stringBuffer.append(" ").append("with").append(" ").append("passwd ").append("'").append("password").append("'");
        }
        stringBuffer.append("\n");
        if (this.passwordExpiration > 0) {
            stringBuffer.append(", ").append("passwd expiration ").append(this.passwordExpiration).append("\n");
            stringBuffer.append("go ").append("\n\n");
            bl = true;
        }
        if (this.minPasswordLength > 0) {
            if (bl) {
                stringBuffer.append("alter ").append(" ").append("role ").append(this._name).append(" set ");
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append("min passwd length ").append(this.minPasswordLength).append("\n");
            stringBuffer.append("go ").append("\n\n");
            bl = true;
        }
        if (this.maxFailedLogins > 0) {
            if (bl) {
                stringBuffer.append("alter ").append(" ").append("role ").append(this._name).append(" set ");
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append("max failed_logins ").append(this.maxFailedLogins).append("\n");
            stringBuffer.append("go ").append("\n\n");
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("go ").append("\n\n");
        }
        for (n = 0; n < this.hierarchyRoles.size(); ++n) {
            stringBuffer.append("grant").append(" ").append("role ").append((String)this.hierarchyRoles.elementAt(n)).append(" ").append("to ").append(" ").append(this._name).append("\n").append("go ").append("\n\n");
        }
        for (n = 0; n < this.exclusiveRoles.size(); ++n) {
            stringBuffer.append("alter ").append("role ").append(this._name).append(" ").append("add exclusive membership ").append((String)this.exclusiveRoles.elementAt(n)).append("\n").append("go ").append("\n\n");
        }
        for (n = 0; n < this.activatedRoles.size(); ++n) {
            stringBuffer.append("alter ").append("role ").append(this._name).append(" ").append("add exclusive activation ").append((String)this.activatedRoles.elementAt(n)).append("\n").append("go ").append("\n\n");
        }
        for (n = 0; n < this.logins.size(); ++n) {
            stringBuffer.append("grant").append(" ").append("role ").append(this._name).append(" ").append("to ").append((String)this.logins.elementAt(n)).append("\n").append("go ").append("\n\n");
        }
        stringBuffer.append(this._permissions.toString());
        return stringBuffer.toString();
    }
}

