/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.item;

import com.sybase.ddlgen.DDLBaseException;
import com.sybase.ddlgen.container.DDLBaseContainer;
import com.sybase.ddlgen.item.DDLBaseItem;
import com.sybase.ddlgen.sql.ASConnection;
import com.sybase.ddlgen.sql.ASQueryParser;

public class UserDefinedDatatypeItem
extends DDLBaseItem {
    private static final int UDT_OWNER_NAME = 0;
    private static final int UDT_NAME = 1;
    private static final int UDT_SYSTEM_TYPE_NAME = 2;
    private static final int UDT_LENGTH = 3;
    private static final int UDT_PRECISION = 4;
    private static final int UDT_SCALE = 5;
    private static final int UDT_ALLOW_NULLS = 6;
    private static final int UDT_IS_IDENTITY = 7;
    private static final int UDT_BINDED_DEFAULT_NAME = 8;
    private static final int UDT_BINDED_RULE_NAME = 9;
    private static final int CONST_UNICHARSIZE = 2;
    private static final String ONE = "1";
    private static final String ZERO = "0";
    private String[] _columns;
    private String _dbName = null;

    public UserDefinedDatatypeItem() {
    }

    public UserDefinedDatatypeItem(String[] stringArray, String string, DDLBaseContainer dDLBaseContainer) {
        this._parent = dDLBaseContainer;
        this._columns = stringArray;
        this._dbName = string;
        if (this._columns != null) {
            this._name = this._dbName + "." + this._columns[1];
        }
    }

    @Override
    public void open(ASConnection aSConnection) {
        this.load();
        this._columns[2] = aSConnection.getUnsignedIntType(this._columns[2]);
        this._ddlString = this.generateDDL();
    }

    private void load() {
    }

    @Override
    public String[] getIfExistsParameters() {
        return new String[]{this._dbName, this._columns[0], this._parent.getParent() == null ? ASQueryParser.parseQuery("SELECT 1 FROM {0}.dbo.systypes WHERE name = ''{1}''", new String[]{this._dbName, this._columns[1]}) : null, ASQueryParser.parseQuery("exec sp_droptype ''{0}''", new String[]{this._columns[1]})};
    }

    @Override
    public String generateDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._columns != null || this._columns.length == 10) {
            if (this._parent.getDDLGlobalParameters().excludeIfExistsDDL() && !this._parent.getDDLGlobalParameters().getIsUseDBAlreadyInUse()) {
                stringBuffer.append("use ").append(this._dbName).append("\ngo\n\n");
                this._parent.getDDLGlobalParameters().setIsUseDBAlreadyUsed(true);
            }
            stringBuffer.append("SETUSER '").append(this._columns[0]).append("'\ngo\n\n");
            stringBuffer.append("exec ").append(" ").append("sp_addtype");
            stringBuffer.append(" '").append(this._columns[1]).append("' ,");
            stringBuffer.append(" '").append(this._columns[2]);
            if (this._columns[2].equals("binary") || this._columns[2].equals("char") || this._columns[2].equals("nchar") || this._columns[2].equals("nvarchar") || this._columns[2].equals("varbinary") || this._columns[2].equals("varchar")) {
                stringBuffer.append("(");
                stringBuffer.append(this._columns[3]);
                stringBuffer.append(")");
            } else if (this._columns[2].equals("unichar") || this._columns[2].equals("univarchar")) {
                int n = Integer.parseInt(this._columns[3]);
                stringBuffer.append("(").append(n / 2).append(")");
            } else if (this._columns[2].equals("float")) {
                stringBuffer.append("(");
                try {
                    int n = new Integer(this._columns[3]);
                    stringBuffer.append(n * 2);
                    stringBuffer.append(")");
                }
                catch (Exception exception) {
                    new DDLBaseException("UDD51", exception, "INTERNAL_ERROR", 1);
                }
            } else if (this._columns[2].equals("decimal") || this._columns[2].equals("numeric")) {
                stringBuffer.append("(");
                stringBuffer.append(this._columns[4]).append(",").append(this._columns[5]);
                stringBuffer.append(")");
            }
            stringBuffer.append("' ");
            if (this._columns[7].equals(ONE)) {
                stringBuffer.append(", '").append("identity").append("'");
            } else if (this._columns[7].equals(ZERO)) {
                if (this._columns[6].equals(ZERO)) {
                    stringBuffer.append(", ").append("nonull");
                } else if (this._columns[6].equals(ONE)) {
                    stringBuffer.append(", ").append("null");
                }
            }
            stringBuffer.append("\n").append("go ").append("\n\n");
            if (!this._columns[8].equals("")) {
                stringBuffer.append("sp_bindefault '").append(this._columns[8]);
                stringBuffer.append("', '").append(this._columns[1]).append("'\ngo\n\n");
            }
            if (!this._columns[9].equals("")) {
                stringBuffer.append("sp_bindrule '").append(this._columns[9]).append("', '");
                stringBuffer.append(this._columns[1]).append("'\ngo\n\n");
            }
            stringBuffer.append("SETUSER").append("\ngo\n\n");
            return stringBuffer.toString();
        }
        return "\n";
    }
}

